/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.dsl.processor.Log;
import com.oracle.truffle.dsl.processor.TruffleProcessor;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeMirror;
import com.oracle.truffle.dsl.processor.model.Template;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;

public class ProcessorContext {
    private final ProcessingEnvironment environment;
    private final Map<String, Template> models = new HashMap<String, Template>();
    private final ProcessCallback callback;
    private final Log log;
    private TruffleTypes types;
    private final Map<String, TypeElement> typeLookupCache = new HashMap<String, TypeElement>();
    private static final ThreadLocal<ProcessorContext> instance = new ThreadLocal();
    private final Map<Class<?>, Map<?, ?>> caches = new HashMap();

    public ProcessorContext(ProcessingEnvironment env, ProcessCallback callback) {
        this.environment = env;
        this.callback = callback;
        boolean emitWarnings = !Boolean.parseBoolean(System.getProperty("truffle.dsl.ignoreCompilerWarnings", "false"));
        this.log = new Log(this.environment, emitWarnings);
    }

    public TruffleTypes getTypes() {
        return this.types;
    }

    public Log getLog() {
        return this.log;
    }

    public ProcessingEnvironment getEnvironment() {
        return this.environment;
    }

    public boolean containsTemplate(TypeElement element) {
        return this.models.containsKey(ElementUtils.getQualifiedName(element));
    }

    public void registerTemplate(TypeElement element, Template model) {
        this.models.put(ElementUtils.getQualifiedName(element), model);
    }

    public Template getTemplate(TypeMirror templateTypeMirror, boolean invokeCallback) {
        String qualifiedName = ElementUtils.getQualifiedName(templateTypeMirror);
        Template model = this.models.get(qualifiedName);
        if (model == null && invokeCallback) {
            this.callback.callback(ElementUtils.fromTypeMirror(templateTypeMirror));
            model = this.models.get(qualifiedName);
        }
        return model;
    }

    public DeclaredType getDeclaredType(Class<?> element) {
        return (DeclaredType)this.getType(element);
    }

    public DeclaredType getDeclaredTypeOptional(String element) {
        TypeElement type = this.getTypeElement(element);
        if (type == null) {
            return null;
        }
        return (DeclaredType)type.asType();
    }

    public TypeElement getTypeElement(CharSequence typeName) {
        String typeNameString = typeName.toString();
        TypeElement type = this.typeLookupCache.get(typeNameString);
        if (type == null && (type = this.environment.getElementUtils().getTypeElement(typeName)) != null) {
            this.typeLookupCache.put(typeNameString, type);
        }
        return type;
    }

    public TypeMirror getType(Class<?> element) {
        if (element.isArray()) {
            return this.environment.getTypeUtils().getArrayType(this.getType(element.getComponentType()));
        }
        if (element.isPrimitive()) {
            TypeKind typeKind;
            if (element == Void.TYPE) {
                return this.environment.getTypeUtils().getNoType(TypeKind.VOID);
            }
            if (element == Boolean.TYPE) {
                typeKind = TypeKind.BOOLEAN;
            } else if (element == Byte.TYPE) {
                typeKind = TypeKind.BYTE;
            } else if (element == Short.TYPE) {
                typeKind = TypeKind.SHORT;
            } else if (element == Character.TYPE) {
                typeKind = TypeKind.CHAR;
            } else if (element == Integer.TYPE) {
                typeKind = TypeKind.INT;
            } else if (element == Long.TYPE) {
                typeKind = TypeKind.LONG;
            } else if (element == Float.TYPE) {
                typeKind = TypeKind.FLOAT;
            } else if (element == Double.TYPE) {
                typeKind = TypeKind.DOUBLE;
            } else {
                assert (false);
                return null;
            }
            return this.environment.getTypeUtils().getPrimitiveType(typeKind);
        }
        TypeElement typeElement = this.getTypeElement(element.getCanonicalName());
        if (typeElement == null) {
            return null;
        }
        return this.environment.getTypeUtils().erasure(typeElement.asType());
    }

    public DeclaredType getDeclaredType(String element) {
        TypeElement type = this.getTypeElement(element);
        if (type == null) {
            throw new IllegalArgumentException("Processor requested type " + element + " but was not on the classpath.");
        }
        return (DeclaredType)type.asType();
    }

    public boolean isType(TypeMirror type, Class<?> clazz) {
        return ElementUtils.typeEquals(type, this.getType(clazz));
    }

    public TypeElement getTypeElement(Class<?> element) {
        DeclaredType type = this.getDeclaredType(element);
        return (TypeElement)type.asElement();
    }

    public TypeElement getTypeElement(DeclaredType element) {
        return (TypeElement)element.asElement();
    }

    public TypeMirror reloadTypeElement(TypeElement type) {
        return type.asType();
    }

    public TypeMirror reloadType(TypeMirror type) {
        if (type instanceof CodeTypeMirror) {
            return type;
        }
        if (type.getKind().isPrimitive()) {
            return type;
        }
        Types typesUtils = this.getEnvironment().getTypeUtils();
        switch (type.getKind()) {
            case ARRAY: {
                return typesUtils.getArrayType(this.reloadType(((ArrayType)type).getComponentType()));
            }
            case WILDCARD: {
                return typesUtils.getWildcardType(((WildcardType)type).getExtendsBound(), ((WildcardType)type).getSuperBound());
            }
            case DECLARED: {
                return this.reloadTypeElement((TypeElement)((DeclaredType)type).asElement());
            }
        }
        return type;
    }

    public static ProcessorContext enter(ProcessingEnvironment environment, ProcessCallback callback) {
        ProcessorContext context = new ProcessorContext(environment, callback);
        ProcessorContext.setThreadLocalInstance(context);
        return context;
    }

    public static ProcessorContext enter(ProcessingEnvironment environment) {
        return ProcessorContext.enter(environment, null);
    }

    public static void leave() {
        instance.set(null);
    }

    private static void setThreadLocalInstance(ProcessorContext context) {
        instance.set(context);
        if (context != null && context.types == null) {
            try {
                context.types = new TruffleTypes();
            }
            catch (IllegalArgumentException e) {
                TruffleProcessor.handleThrowable(null, e, null);
                throw e;
            }
        }
    }

    public static ProcessorContext getInstance() {
        return instance.get();
    }

    public List<TypeMirror> getFrameTypes() {
        return Arrays.asList(this.types.VirtualFrame, this.types.MaterializedFrame, this.types.Frame);
    }

    public <K, V> Map<K, V> getCacheMap(Class<?> key) {
        Map<?, ?> cacheMap = this.caches.get(key);
        if (cacheMap == null) {
            cacheMap = new HashMap();
            this.caches.put(key, cacheMap);
        }
        return cacheMap;
    }

    public static interface ProcessCallback {
        public void callback(TypeElement var1);
    }
}

