/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.model;

import com.oracle.truffle.dsl.processor.model.NodeChildData;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class NodeExecutionData {
    private final NodeChildData child;
    private final String name;
    private final int index;
    private final int childArrayIndex;
    private final List<TypeMirror> typeRestrictions = new ArrayList<TypeMirror>();

    public NodeExecutionData(NodeChildData child, int index, int childArrayIndex) {
        this.child = child;
        this.index = index;
        this.childArrayIndex = childArrayIndex;
        this.name = this.createName();
    }

    private String createName() {
        return this.child != null ? NodeExecutionData.createName(this.child.getName(), this.childArrayIndex) : "arg" + this.index;
    }

    public int getIndex() {
        return this.index;
    }

    public List<TypeMirror> getTypeRestrictions() {
        return this.typeRestrictions;
    }

    public TypeMirror getNodeType() {
        if (this.child == null) {
            return null;
        }
        TypeMirror type = this.child.getCardinality() == NodeChildData.Cardinality.MANY && this.child.getNodeType().getKind() == TypeKind.ARRAY ? ((ArrayType)this.child.getNodeType()).getComponentType() : this.child.getNodeType();
        return type;
    }

    public String getName() {
        return this.name;
    }

    public NodeChildData getChild() {
        return this.child;
    }

    public int getChildArrayIndex() {
        return this.childArrayIndex;
    }

    public boolean hasChildArrayIndex() {
        return this.childArrayIndex > -1;
    }

    public String getIndexedName() {
        return NodeExecutionData.createIndexedName(this.child, this.childArrayIndex);
    }

    public static String createIndexedName(NodeChildData child, int varArgsIndex) {
        Object shortCircuitName = child.getName();
        if (child.getCardinality().isMany()) {
            shortCircuitName = (String)shortCircuitName + "[" + varArgsIndex + "]";
        }
        return shortCircuitName;
    }

    public static String createName(String childName, int index) {
        if (index > -1) {
            return childName + index;
        }
        return childName;
    }
}

