/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.parser;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.model.CachedParameterSpec;
import com.oracle.truffle.dsl.processor.model.MethodSpec;
import com.oracle.truffle.dsl.processor.model.NodeData;
import com.oracle.truffle.dsl.processor.model.SpecializationData;
import com.oracle.truffle.dsl.processor.model.SpecializationThrowsData;
import com.oracle.truffle.dsl.processor.model.TemplateMethod;
import com.oracle.truffle.dsl.processor.parser.NodeMethodParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class SpecializationMethodParser
extends NodeMethodParser<SpecializationData> {
    private final boolean ignoreUnexpectedResult;

    public SpecializationMethodParser(ProcessorContext context, NodeData operation, boolean ignoreUnexpectedResult) {
        super(context, operation);
        this.ignoreUnexpectedResult = ignoreUnexpectedResult;
    }

    @Override
    public MethodSpec createSpecification(ExecutableElement method, AnnotationMirror mirror) {
        MethodSpec spec = this.createDefaultMethodSpec(method, mirror, true, null);
        spec.getAnnotations().add(new CachedParameterSpec(this.types.Cached));
        spec.getAnnotations().add(new CachedParameterSpec(this.types.CachedLibrary));
        spec.getAnnotations().add(new CachedParameterSpec(this.types.Bind));
        return spec;
    }

    @Override
    public SpecializationData create(TemplateMethod method, boolean invalid) {
        return this.parseSpecialization(method);
    }

    @Override
    public DeclaredType getAnnotationType() {
        return this.types.Specialization;
    }

    private SpecializationData parseSpecialization(TemplateMethod method) {
        ArrayList<SpecializationThrowsData> exceptionData = new ArrayList<SpecializationThrowsData>();
        boolean unexpectedResultRewrite = false;
        boolean reportPolymorphism = false;
        boolean reportMegamorphism = false;
        if (method.getMethod() != null) {
            AnnotationValue rewriteValue = ElementUtils.getAnnotationValue(method.getMarkerAnnotation(), "rewriteOn");
            List<TypeMirror> exceptionTypes = ElementUtils.getAnnotationValueList(TypeMirror.class, method.getMarkerAnnotation(), "rewriteOn");
            ArrayList<TypeMirror> rewriteOnTypes = new ArrayList<TypeMirror>();
            for (TypeMirror exceptionType : exceptionTypes) {
                SpecializationThrowsData throwsData = new SpecializationThrowsData(method.getMessageElement(), method.getMarkerAnnotation(), rewriteValue, exceptionType);
                if (!ElementUtils.canThrowType(method.getMethod().getThrownTypes(), exceptionType)) {
                    method.addError("A rewriteOn checked exception was specified but not thrown in the method's throws clause. The @%s method must specify a throws clause with the exception type '%s'.", this.types.Specialization.asElement().getSimpleName().toString(), ElementUtils.getQualifiedName(exceptionType));
                }
                if (!this.ignoreUnexpectedResult && ElementUtils.typeEquals(exceptionType, this.types.UnexpectedResultException)) {
                    if (ElementUtils.typeEquals(method.getMethod().getReturnType(), this.getContext().getType(Object.class))) {
                        method.addError("A specialization with return type 'Object' cannot throw UnexpectedResultException.", new Object[0]);
                    }
                    unexpectedResultRewrite = true;
                }
                rewriteOnTypes.add(throwsData.getJavaClass());
                exceptionData.add(throwsData);
            }
            Collections.sort(exceptionData, new Comparator<SpecializationThrowsData>(){

                @Override
                public int compare(SpecializationThrowsData o1, SpecializationThrowsData o2) {
                    return ElementUtils.compareByTypeHierarchy(o1.getJavaClass(), o2.getJavaClass());
                }
            });
            reportPolymorphism = !this.isAnnotatedWithReportPolymorphismExclude(method);
            reportMegamorphism = this.isAnnotatedWithReportPolymorphismMegamorphic(method);
        }
        SpecializationData specialization = new SpecializationData(this.getNode(), method, SpecializationData.SpecializationKind.SPECIALIZED, exceptionData, unexpectedResultRewrite, reportPolymorphism, reportMegamorphism);
        if (method.getMethod() != null) {
            String insertBeforeName = ElementUtils.getAnnotationValue(String.class, method.getMarkerAnnotation(), "insertBefore");
            if (!insertBeforeName.equals("")) {
                specialization.setInsertBeforeName(insertBeforeName);
            }
            ArrayList<String> replacesDefs = new ArrayList<String>();
            replacesDefs.addAll(ElementUtils.getAnnotationValueList(String.class, specialization.getMarkerAnnotation(), "replaces"));
            Set<String> containsNames = specialization.getReplacesNames();
            containsNames.clear();
            if (replacesDefs != null) {
                for (String include : replacesDefs) {
                    if (!containsNames.contains(include)) {
                        specialization.getReplacesNames().add(include);
                        continue;
                    }
                    AnnotationValue value = ElementUtils.getAnnotationValue(specialization.getMarkerAnnotation(), "replaces");
                    specialization.addError(value, "Duplicate replace declaration '%s'.", include);
                }
            }
        }
        return specialization;
    }

    private boolean isAnnotatedWithReportPolymorphismExclude(TemplateMethod method) {
        assert (method.getMethod() != null);
        return ElementUtils.findAnnotationMirror((Element)method.getMethod(), (TypeMirror)this.types.ReportPolymorphism_Exclude) != null;
    }

    private boolean isAnnotatedWithReportPolymorphismMegamorphic(TemplateMethod method) {
        assert (method.getMethod() != null);
        return ElementUtils.findAnnotationMirror((Element)method.getMethod(), (TypeMirror)this.types.ReportPolymorphism_Megamorphic) != null;
    }
}

