/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.dsl.processor.TruffleSuppressedWarnings;
import com.oracle.truffle.dsl.processor.java.model.GeneratedElement;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

public class Log {
    private final ProcessingEnvironment processingEnv;
    private final boolean emitWarnings;
    private final Set<String> suppressWarnings;

    public static boolean isDebug() {
        return false;
    }

    public Log(ProcessingEnvironment env, boolean emitWarnings, String[] suppressWarnings) {
        this.processingEnv = env;
        this.emitWarnings = emitWarnings;
        this.suppressWarnings = suppressWarnings != null ? Set.of(suppressWarnings) : null;
    }

    public void message(Diagnostic.Kind kind, Element element, AnnotationMirror mirror, AnnotationValue value, String format, Object ... args) {
        AnnotationMirror usedMirror = mirror;
        Element usedElement = element;
        AnnotationValue usedValue = value;
        String message = String.format(format, args);
        if (element instanceof GeneratedElement) {
            usedMirror = ((GeneratedElement)((Object)element)).getGeneratorAnnotationMirror();
            usedElement = ((GeneratedElement)((Object)element)).getGeneratorElement();
            usedValue = null;
            if (usedElement != null) {
                message = String.format("Element %s: %s", element, message);
            }
        }
        if (this.isSuppressed(kind, null, usedElement)) {
            return;
        }
        if (kind != Diagnostic.Kind.WARNING || this.emitWarnings) {
            this.processingEnv.getMessager().printMessage(kind, message, usedElement, usedMirror, usedValue);
        }
    }

    public boolean isSuppressed(Diagnostic.Kind kind, String suppressionKey, Element usedElement, boolean useOptions) {
        if (kind == Diagnostic.Kind.WARNING) {
            if (!this.emitWarnings && useOptions) {
                return true;
            }
            if (suppressionKey != null) {
                if (TruffleSuppressedWarnings.isSuppressed(usedElement, suppressionKey)) {
                    return true;
                }
                if (this.suppressWarnings != null && useOptions && this.suppressWarnings.contains(suppressionKey)) {
                    return true;
                }
            } else if (TruffleSuppressedWarnings.isSuppressed(usedElement, new String[0])) {
                return true;
            }
        }
        return false;
    }

    public boolean isSuppressed(Diagnostic.Kind kind, String suppressionKey, Element usedElement) {
        return this.isSuppressed(kind, suppressionKey, usedElement, true);
    }
}

