/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.model.NodeData;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class TruffleProcessorOptions {
    private static final String OptionsPrefix = "truffle.dsl.";
    private static final String GenerateSpecializationStatisticsOptionName = "GenerateSpecializationStatistics";
    private static final String GenerateSlowPathOnlyOptionName = "GenerateSlowPathOnly";
    private static final String GenerateSlowPathOnlyFilterOptionName = "GenerateSlowPathOnlyFilter";
    private static final String SuppressAllWarnings = "SuppressAllWarnings";
    private static final String SuppressWarnings = "SuppressWarnings";
    private static final String CacheSharingWarningsEnabledOptionName = "cacheSharingWarningsEnabled";
    private static final String StateBitWidth = "StateBitWidth";
    private static final String PrintTimings = "PrintTimings";

    private static String getOption(ProcessingEnvironment env, String key) {
        String value = env.getOptions().get(key);
        if (value != null) {
            return value;
        }
        return System.getProperty(key);
    }

    public static Boolean generateSpecializationStatistics(ProcessingEnvironment env) {
        String value = TruffleProcessorOptions.getOption(env, "truffle.dsl.GenerateSpecializationStatistics");
        return value == null ? null : Boolean.valueOf(Boolean.parseBoolean(value));
    }

    public static boolean generateSlowPathOnly(ProcessingEnvironment env) {
        return Boolean.parseBoolean(TruffleProcessorOptions.getOption(env, "truffle.dsl.GenerateSlowPathOnly"));
    }

    public static boolean printTimings(ProcessingEnvironment env) {
        return Boolean.parseBoolean(TruffleProcessorOptions.getOption(env, "truffle.dsl.PrintTimings"));
    }

    public static String generateSlowPathOnlyFilter(ProcessingEnvironment env) {
        return TruffleProcessorOptions.getOption(env, "truffle.dsl.GenerateSlowPathOnlyFilter");
    }

    public static boolean suppressAllWarnings(ProcessingEnvironment env) {
        Set<String> warningsSet;
        String v = TruffleProcessorOptions.getOption(env, "truffle.dsl.SuppressAllWarnings");
        boolean suppress = Boolean.parseBoolean(v);
        if (suppress) {
            return suppress;
        }
        String[] warnings = TruffleProcessorOptions.suppressDSLWarnings(env);
        return warnings != null && ((warningsSet = Set.of(warnings)).contains("all") || warningsSet.contains("truffle"));
    }

    public static String[] suppressDSLWarnings(ProcessingEnvironment env) {
        String v = TruffleProcessorOptions.getOption(env, "truffle.dsl.SuppressWarnings");
        if (v != null) {
            return v.split(",");
        }
        return null;
    }

    public static boolean cacheSharingWarningsEnabled(ProcessingEnvironment env) {
        String s = TruffleProcessorOptions.getOption(env, "truffle.dsl.cacheSharingWarningsEnabled");
        if (s == null) {
            return !TruffleProcessorOptions.generateSlowPathOnly(env);
        }
        return Boolean.parseBoolean(s);
    }

    public static int stateBitWidth(NodeData node) {
        String value;
        ProcessorContext context = ProcessorContext.getInstance();
        DeclaredType disableStateWidth = context.getTypes().DisableStateBitWidthModification;
        if (disableStateWidth != null) {
            for (Element element = node.getTemplateType(); element != null; element = element.getEnclosingElement()) {
                if (ElementUtils.findAnnotationMirror(element, (TypeMirror)disableStateWidth) == null) continue;
                return 32;
            }
        }
        if ((value = TruffleProcessorOptions.getOption(context.getEnvironment(), "truffle.dsl.StateBitWidth")) == null) {
            return 32;
        }
        return Integer.parseInt(value);
    }

    public static Set<String> getSupportedOptions() {
        HashSet<String> result = new HashSet<String>();
        result.add("truffle.dsl.GenerateSpecializationStatistics");
        result.add("truffle.dsl.GenerateSlowPathOnly");
        result.add("truffle.dsl.GenerateSlowPathOnlyFilter");
        result.add("truffle.dsl.cacheSharingWarningsEnabled");
        result.add("truffle.dsl.StateBitWidth");
        result.add("truffle.dsl.SuppressAllWarnings");
        result.add("truffle.dsl.SuppressWarnings");
        result.add("truffle.dsl.PrintTimings");
        return result;
    }
}

