/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.generator;

import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

public final class StaticConstants {
    public final Map<String, CodeVariableElement> libraries = new LinkedHashMap<String, CodeVariableElement>();
    public final Map<String, CodeVariableElement> contextReferences = new LinkedHashMap<String, CodeVariableElement>();
    public final Map<String, CodeVariableElement> languageReferences = new LinkedHashMap<String, CodeVariableElement>();
    public final Map<String, CodeVariableElement> enumValues = new LinkedHashMap<String, CodeVariableElement>();
    public final Map<String, CodeExecutableElement> decodeConstants = new LinkedHashMap<String, CodeExecutableElement>();
    public final Map<String, CodeExecutableElement> encodeConstants = new LinkedHashMap<String, CodeExecutableElement>();
    public final Map<String, TypeMirror> reservedSymbols = new LinkedHashMap<String, TypeMirror>();

    public void clear() {
        this.libraries.clear();
        this.contextReferences.clear();
        this.languageReferences.clear();
        this.enumValues.clear();
        this.reservedSymbols.clear();
        this.decodeConstants.clear();
        this.encodeConstants.clear();
    }

    public void addElementsTo(CodeElement<Element> element) {
        element.addAll(this.libraries.values());
        element.addAll(this.contextReferences.values());
        element.addAll(this.languageReferences.values());
        element.addAll(this.enumValues.values());
        element.addAll(this.decodeConstants.values());
        element.addAll(this.encodeConstants.values());
    }

    public String reserveSymbol(TypeMirror type, String name) {
        TypeMirror foundType = this.reservedSymbols.get(name);
        if (foundType == null) {
            this.reservedSymbols.put(name, type);
            return name;
        }
        if (ElementUtils.typeEquals(foundType, type)) {
            return name;
        }
        return this.reserveSymbol(type, name + "_");
    }
}

