/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.java;

import com.oracle.truffle.dsl.processor.CompileErrorException;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeMirror;
import com.oracle.truffle.dsl.processor.java.model.GeneratedElement;
import com.oracle.truffle.dsl.processor.model.SpecializationData;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Repeatable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.AbstractAnnotationValueVisitor8;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;

public class ElementUtils {
    public static final int COMPRESSED_POINTER_SIZE = 4;
    public static final int COMPRESSED_HEADER_SIZE = 12;

    public static ExecutableElement findMethod(Class<?> type, String methodName) {
        ProcessorContext context = ProcessorContext.getInstance();
        DeclaredType typeElement = context.getDeclaredType(type);
        return ElementUtils.findMethod(typeElement, methodName);
    }

    public static ExecutableElement findMethod(DeclaredType type, String methodName) {
        ProcessorContext context = ProcessorContext.getInstance();
        TypeElement typeElement = context.getTypeElement(type);
        for (ExecutableElement method : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (!method.getSimpleName().toString().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    public static List<ExecutableElement> findAllPublicMethods(DeclaredType type, String methodName) {
        ProcessorContext context = ProcessorContext.getInstance();
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        TypeElement typeElement = context.getTypeElement(type);
        for (ExecutableElement method : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (!method.getModifiers().contains((Object)Modifier.PUBLIC) || !method.getSimpleName().toString().equals(methodName)) continue;
            methods.add(method);
        }
        return methods;
    }

    public static List<Element> getEnumValues(TypeElement type) {
        ArrayList<Element> values = new ArrayList<Element>();
        for (Element element : type.getEnclosedElements()) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            values.add(element);
        }
        return values;
    }

    public static ExecutableElement findMethod(DeclaredType type, String methodName, int parameterCount) {
        ProcessorContext context = ProcessorContext.getInstance();
        TypeElement typeElement = context.getTypeElement(type);
        for (ExecutableElement method : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (method.getParameters().size() != parameterCount || !method.getSimpleName().toString().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    public static ExecutableElement findStaticMethod(TypeElement type, String methodName) {
        for (ExecutableElement method : ElementFilter.methodsIn(type.getEnclosedElements())) {
            if (!method.getModifiers().contains((Object)Modifier.STATIC) || !method.getSimpleName().toString().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    public static String defaultValue(TypeMirror mirror) {
        switch (mirror.getKind()) {
            case VOID: {
                return "";
            }
            case ARRAY: 
            case DECLARED: 
            case PACKAGE: 
            case NULL: {
                return "null";
            }
            case BOOLEAN: {
                return "false";
            }
            case BYTE: {
                return "(byte) 0";
            }
            case CHAR: {
                return "(char) 0";
            }
            case DOUBLE: {
                return "0.0D";
            }
            case LONG: {
                return "0L";
            }
            case INT: {
                return "0";
            }
            case FLOAT: {
                return "0.0F";
            }
            case SHORT: {
                return "(short) 0";
            }
        }
        throw new AssertionError();
    }

    public static TypeElement getTypeElement(CharSequence typeName) {
        return ProcessorContext.getInstance().getTypeElement(typeName);
    }

    public static ExecutableElement findExecutableElement(DeclaredType type, String name) {
        List<ExecutableElement> elements = ElementFilter.methodsIn(type.asElement().getEnclosedElements());
        for (ExecutableElement executableElement : elements) {
            if (!executableElement.getSimpleName().toString().equals(name) || ElementUtils.isDeprecated(executableElement)) continue;
            return executableElement;
        }
        return null;
    }

    public static ExecutableElement findExecutableElement(DeclaredType type, String name, int argumentCount) {
        List<ExecutableElement> elements = ElementFilter.methodsIn(type.asElement().getEnclosedElements());
        for (ExecutableElement executableElement : elements) {
            if (executableElement.getParameters().size() != argumentCount || !executableElement.getSimpleName().toString().equals(name) || ElementUtils.isDeprecated(executableElement)) continue;
            return executableElement;
        }
        return null;
    }

    public static VariableElement findVariableElement(DeclaredType type, String name) {
        return ElementUtils.findVariableElement(type.asElement(), name);
    }

    public static VariableElement findVariableElement(Element element, String name) {
        List<VariableElement> elements = ElementFilter.fieldsIn(element.getEnclosedElements());
        for (VariableElement variableElement : elements) {
            if (!variableElement.getSimpleName().toString().equals(name)) continue;
            return variableElement;
        }
        return null;
    }

    public static boolean needsCastTo(TypeMirror sourceType, TypeMirror targetType) {
        if (ElementUtils.typeEquals(sourceType, targetType)) {
            return false;
        }
        if (ElementUtils.isObject(targetType)) {
            return false;
        }
        if (ElementUtils.isVoid(targetType)) {
            return false;
        }
        return !ElementUtils.isAssignable(sourceType, targetType);
    }

    public static String createReferenceName(ExecutableElement method) {
        StringBuilder b = new StringBuilder();
        b.append(method.getSimpleName().toString());
        b.append("(");
        String sep = "";
        for (VariableElement variableElement : method.getParameters()) {
            b.append(sep);
            b.append(ElementUtils.getSimpleName(variableElement.asType()));
            sep = ", ";
        }
        b.append(")");
        return b.toString();
    }

    public static TypeMirror boxType(ProcessorContext context, TypeMirror primitiveType) {
        if (primitiveType == null) {
            return null;
        }
        TypeMirror boxedType = primitiveType;
        if (boxedType.getKind().isPrimitive()) {
            boxedType = context.getEnvironment().getTypeUtils().boxedClass((PrimitiveType)boxedType).asType();
        }
        return boxedType;
    }

    public static DeclaredType getDeclaredType(TypeElement typeElem, TypeMirror ... typeArgs) {
        return new CodeTypeMirror.DeclaredCodeTypeMirror(typeElem, Arrays.asList(typeArgs));
    }

    public static List<AnnotationMirror> collectAnnotations(AnnotationMirror markerAnnotation, String elementName, Element element, DeclaredType annotationClass) {
        AnnotationMirror explicit;
        ArrayList<AnnotationMirror> result = new ArrayList<AnnotationMirror>();
        if (markerAnnotation != null) {
            result.addAll(ElementUtils.getAnnotationValueList(AnnotationMirror.class, markerAnnotation, elementName));
        }
        if ((explicit = ElementUtils.findAnnotationMirror(element, (TypeMirror)annotationClass)) != null) {
            result.add(explicit);
        }
        return result;
    }

    public static TypeMirror getCommonSuperType(ProcessorContext context, Collection<TypeMirror> types) {
        if (types.isEmpty()) {
            return context.getType(Object.class);
        }
        Iterator<TypeMirror> typesIterator = types.iterator();
        TypeMirror prev = typesIterator.next();
        while (typesIterator.hasNext()) {
            prev = ElementUtils.getCommonSuperType(context, prev, typesIterator.next());
        }
        return prev;
    }

    private static TypeMirror getCommonSuperType(ProcessorContext context, TypeMirror type1, TypeMirror type2) {
        if (ElementUtils.typeEquals(type1, type2)) {
            return type1;
        }
        if (ElementUtils.isVoid(type1)) {
            return type2;
        }
        if (ElementUtils.isVoid(type2)) {
            return type1;
        }
        if (ElementUtils.isObject(type1)) {
            return type1;
        }
        if (ElementUtils.isObject(type2)) {
            return type2;
        }
        if (ElementUtils.isPrimitive(type1) || ElementUtils.isPrimitive(type2)) {
            return context.getType(Object.class);
        }
        if (ElementUtils.isSubtype(type1, type2)) {
            return type2;
        }
        if (ElementUtils.isSubtype(type2, type1)) {
            return type1;
        }
        TypeElement element1 = ElementUtils.fromTypeMirror(type1);
        TypeElement element2 = ElementUtils.fromTypeMirror(type2);
        if (element1 == null || element2 == null) {
            return context.getType(Object.class);
        }
        List<TypeElement> element1Types = ElementUtils.getSuperTypes(element1);
        List<TypeElement> element2Types = ElementUtils.getSuperTypes(element2);
        for (TypeElement superType1 : element1Types) {
            for (TypeElement superType2 : element2Types) {
                if (!ElementUtils.typeEquals(superType1.asType(), superType2.asType())) continue;
                return superType2.asType();
            }
        }
        return context.getType(Object.class);
    }

    public static String getReadableSignature(ExecutableElement method) {
        StringBuilder builder = new StringBuilder();
        builder.append(method.getSimpleName().toString());
        builder.append("(");
        String sep = "";
        for (VariableElement variableElement : method.getParameters()) {
            builder.append(sep);
            builder.append(ElementUtils.getSimpleName(variableElement.asType()));
            sep = ", ";
        }
        builder.append(")");
        return builder.toString();
    }

    public static boolean hasOverloads(TypeElement enclosingType, ExecutableElement e) {
        String name = e.getSimpleName().toString();
        for (ExecutableElement otherExecutable : ElementFilter.methodsIn(enclosingType.getEnclosedElements())) {
            if (!otherExecutable.getSimpleName().toString().equals(name) || ElementUtils.elementEquals(e, otherExecutable)) continue;
            return true;
        }
        return false;
    }

    public static String getReadableSignature(ExecutableElement method, int highlightParameter) {
        StringBuilder builder = new StringBuilder();
        builder.append(method.getSimpleName().toString());
        builder.append("(");
        VariableElement var = method.getParameters().get(highlightParameter);
        if (highlightParameter > 0) {
            builder.append("..., ");
        }
        builder.append(ElementUtils.getSimpleName(var.asType())).append(" ");
        builder.append(var.getSimpleName().toString());
        if (highlightParameter < method.getParameters().size() - 1) {
            builder.append(", ...");
        }
        builder.append(")");
        return builder.toString();
    }

    public static boolean hasError(TypeMirror mirror) {
        switch (mirror.getKind()) {
            case VOID: 
            case DECLARED: 
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case LONG: 
            case INT: 
            case FLOAT: 
            case SHORT: 
            case TYPEVAR: {
                return false;
            }
            case ARRAY: {
                return ElementUtils.hasError(((ArrayType)mirror).getComponentType());
            }
            case ERROR: {
                return true;
            }
        }
        throw new RuntimeException("Unknown type specified " + String.valueOf((Object)mirror.getKind()) + " mirror: " + String.valueOf(mirror));
    }

    public static boolean isSubtypeBoxed(ProcessorContext context, TypeMirror from, TypeMirror to) {
        return ElementUtils.isSubtype(ElementUtils.boxType(context, from), ElementUtils.boxType(context, to));
    }

    public static boolean isSubtype(TypeMirror type1, TypeMirror type2) {
        if (type1 instanceof CodeTypeMirror || type2 instanceof CodeTypeMirror) {
            return ElementUtils.typeEquals(type1, type2);
        }
        return ProcessorContext.getInstance().getEnvironment().getTypeUtils().isSubtype(type1, type2);
    }

    public static boolean isAssignable(TypeMirror from, TypeMirror to) {
        if (ElementUtils.typeEquals(from, to)) {
            return true;
        }
        if (ElementUtils.isVoid(to)) {
            return true;
        }
        if (ElementUtils.isNone(to)) {
            return false;
        }
        if (ElementUtils.isObject(to)) {
            return true;
        }
        if (ElementUtils.isInvalidType(from) || ElementUtils.isInvalidType(to)) {
            return false;
        }
        ProcessorContext context = ProcessorContext.getInstance();
        if (!(from instanceof CodeTypeMirror) && !(to instanceof CodeTypeMirror)) {
            Types typeUtils = context.getEnvironment().getTypeUtils();
            TypeMirror reloadFrom = context.reloadType(from);
            TypeMirror reloadTo = context.reloadType(to);
            TypeMirror erasedFrom = typeUtils.erasure(reloadFrom);
            TypeMirror erasedTo = typeUtils.erasure(reloadTo);
            return typeUtils.isAssignable(erasedFrom, erasedTo);
        }
        return ElementUtils.isAssignableImpl(from, to);
    }

    private static boolean isInvalidType(TypeMirror reloadFrom) {
        return reloadFrom.getKind() == TypeKind.NONE || reloadFrom.getKind() == TypeKind.ERROR || reloadFrom.getKind() == TypeKind.VOID;
    }

    private static boolean isAssignableImpl(TypeMirror from, TypeMirror to) {
        if (ElementUtils.typeEquals(from, to)) {
            return true;
        }
        if (ElementUtils.isObject(to)) {
            return true;
        }
        if (ElementUtils.isPrimitive(from) && ElementUtils.isPrimitive(to)) {
            TypeKind fromKind = from.getKind();
            TypeKind toKind = to.getKind();
            switch (fromKind) {
                case BYTE: {
                    switch (toKind) {
                        case DOUBLE: 
                        case LONG: 
                        case INT: 
                        case FLOAT: 
                        case SHORT: {
                            return true;
                        }
                    }
                    break;
                }
                case SHORT: {
                    switch (toKind) {
                        case DOUBLE: 
                        case LONG: 
                        case INT: 
                        case FLOAT: {
                            return true;
                        }
                    }
                    break;
                }
                case CHAR: {
                    switch (toKind) {
                        case DOUBLE: 
                        case LONG: 
                        case INT: 
                        case FLOAT: {
                            return true;
                        }
                    }
                    break;
                }
                case INT: {
                    switch (toKind) {
                        case DOUBLE: 
                        case LONG: 
                        case FLOAT: {
                            return true;
                        }
                    }
                    break;
                }
                case LONG: {
                    switch (toKind) {
                        case DOUBLE: 
                        case FLOAT: {
                            return true;
                        }
                    }
                    break;
                }
                case FLOAT: {
                    switch (toKind) {
                        case DOUBLE: {
                            return true;
                        }
                    }
                }
            }
            return false;
        }
        if (ElementUtils.isPrimitive(from) || ElementUtils.isPrimitive(to)) {
            return false;
        }
        if (from.getKind() == TypeKind.ARRAY && to.getKind() == TypeKind.ARRAY) {
            return ElementUtils.isAssignable(((ArrayType)from).getComponentType(), ((ArrayType)to).getComponentType());
        }
        if (from.getKind() == TypeKind.ARRAY || to.getKind() == TypeKind.ARRAY) {
            return false;
        }
        TypeElement fromType = ElementUtils.fromTypeMirror(from);
        TypeElement toType = ElementUtils.fromTypeMirror(to);
        if (fromType == null || toType == null) {
            return false;
        }
        List<TypeElement> superTypes = ElementUtils.getSuperTypes(fromType);
        for (TypeElement superType : superTypes) {
            if (!ElementUtils.typeEquals(superType.asType(), to)) continue;
            return true;
        }
        return false;
    }

    public static Set<Modifier> modifiers(Modifier ... modifier) {
        return new LinkedHashSet<Modifier>(Arrays.asList(modifier));
    }

    public static String getTypeSimpleId(TypeMirror mirror) {
        switch (mirror.getKind()) {
            case BOOLEAN: {
                return "Boolean";
            }
            case BYTE: {
                return "Byte";
            }
            case CHAR: {
                return "Char";
            }
            case DOUBLE: {
                return "Double";
            }
            case FLOAT: {
                return "Float";
            }
            case SHORT: {
                return "Short";
            }
            case INT: {
                return "Int";
            }
            case LONG: {
                return "Long";
            }
            case DECLARED: {
                return ElementUtils.fixECJBinaryNameIssue(((DeclaredType)mirror).asElement().getSimpleName().toString());
            }
            case ARRAY: {
                return ElementUtils.getTypeSimpleId(((ArrayType)mirror).getComponentType()) + "Array";
            }
            case VOID: {
                return "Void";
            }
            case NULL: {
                return "Null";
            }
            case WILDCARD: {
                StringBuilder b = new StringBuilder();
                WildcardType type = (WildcardType)mirror;
                if (type.getExtendsBound() != null) {
                    b.append("Extends").append(ElementUtils.getTypeSimpleId(type.getExtendsBound()));
                } else if (type.getSuperBound() != null) {
                    b.append("Super").append(ElementUtils.getTypeSimpleId(type.getExtendsBound()));
                }
                return b.toString();
            }
            case TYPEVAR: {
                return "Any";
            }
            case ERROR: {
                throw new CompileErrorException("Type error " + String.valueOf(mirror));
            }
        }
        throw new RuntimeException("Unknown type specified " + String.valueOf((Object)mirror.getKind()) + " mirror: " + String.valueOf(mirror));
    }

    public static String getSimpleName(TypeElement element) {
        return ElementUtils.getSimpleName(element.asType());
    }

    public static String getSimpleName(TypeMirror mirror) {
        switch (mirror.getKind()) {
            case BOOLEAN: {
                return "boolean";
            }
            case BYTE: {
                return "byte";
            }
            case CHAR: {
                return "char";
            }
            case DOUBLE: {
                return "double";
            }
            case FLOAT: {
                return "float";
            }
            case SHORT: {
                return "short";
            }
            case INT: {
                return "int";
            }
            case LONG: {
                return "long";
            }
            case DECLARED: {
                return ElementUtils.getDeclaredName((DeclaredType)mirror, true);
            }
            case ARRAY: {
                return ElementUtils.getSimpleName(((ArrayType)mirror).getComponentType()) + "[]";
            }
            case VOID: {
                return "void";
            }
            case NULL: {
                return "null";
            }
            case WILDCARD: {
                return ElementUtils.getWildcardName((WildcardType)mirror);
            }
            case TYPEVAR: {
                return ((TypeVariable)mirror).asElement().getSimpleName().toString();
            }
            case ERROR: {
                throw new CompileErrorException("Type error " + String.valueOf(mirror));
            }
            case NONE: {
                return "None";
            }
        }
        throw new RuntimeException("Unknown type specified " + String.valueOf((Object)mirror.getKind()) + " mirror: " + String.valueOf(mirror));
    }

    private static String getWildcardName(WildcardType type) {
        StringBuilder b = new StringBuilder();
        if (type.getExtendsBound() != null) {
            b.append("? extends ").append(ElementUtils.getSimpleName(type.getExtendsBound()));
        } else if (type.getSuperBound() != null) {
            b.append("? super ").append(ElementUtils.getSimpleName(type.getExtendsBound()));
        }
        return b.toString();
    }

    public static String getDeclaredName(DeclaredType element, boolean includeTypeVariables) {
        String simpleName = ElementUtils.fixECJBinaryNameIssue(element.asElement().getSimpleName().toString());
        if (!includeTypeVariables || element.getTypeArguments().size() == 0) {
            return simpleName;
        }
        StringBuilder b = new StringBuilder(simpleName);
        b.append("<");
        if (element.getTypeArguments().size() > 0) {
            for (int i = 0; i < element.getTypeArguments().size(); ++i) {
                b.append(ElementUtils.getSimpleName(element.getTypeArguments().get(i)));
                if (i >= element.getTypeArguments().size() - 1) continue;
                b.append(", ");
            }
        }
        b.append(">");
        return b.toString();
    }

    public static String fixECJBinaryNameIssue(String name) {
        if (name.contains("$")) {
            int lastIndex = name.lastIndexOf(36);
            return name.substring(lastIndex + 1, name.length());
        }
        return name;
    }

    public static String getClassQualifiedName(TypeElement e) {
        StringBuilder b = new StringBuilder();
        ElementUtils.buildClassQualifiedNameImpl(e, b);
        return b.toString();
    }

    private static void buildClassQualifiedNameImpl(Element e, StringBuilder classNames) {
        if (e == null) {
            return;
        }
        if (e.getKind() == ElementKind.PACKAGE) {
            String packageName = ElementUtils.getPackageName(e);
            if (packageName != null) {
                classNames.append(packageName);
            }
        } else {
            Element enclosingElement = e.getEnclosingElement();
            ElementUtils.buildClassQualifiedNameImpl(enclosingElement, classNames);
            if (enclosingElement.getKind().isClass()) {
                classNames.append("$");
            } else {
                classNames.append(".");
            }
            classNames.append(e.getSimpleName().toString());
        }
    }

    public static String getQualifiedName(TypeElement element) {
        String qualifiedName = element.getQualifiedName().toString();
        if (qualifiedName.contains("$")) {
            qualifiedName = qualifiedName.replace('$', '.');
        }
        return qualifiedName;
    }

    public static String getQualifiedName(TypeMirror mirror) {
        switch (mirror.getKind()) {
            case BOOLEAN: {
                return "boolean";
            }
            case BYTE: {
                return "byte";
            }
            case CHAR: {
                return "char";
            }
            case DOUBLE: {
                return "double";
            }
            case SHORT: {
                return "short";
            }
            case FLOAT: {
                return "float";
            }
            case INT: {
                return "int";
            }
            case LONG: {
                return "long";
            }
            case DECLARED: {
                return ElementUtils.getQualifiedName(ElementUtils.fromTypeMirror(mirror));
            }
            case ARRAY: {
                return ElementUtils.getQualifiedName(((ArrayType)mirror).getComponentType());
            }
            case VOID: {
                return "void";
            }
            case NULL: {
                return "null";
            }
            case TYPEVAR: {
                return ElementUtils.getSimpleName(mirror);
            }
            case ERROR: {
                throw new CompileErrorException("Type error " + String.valueOf(mirror));
            }
            case EXECUTABLE: {
                return ((ExecutableType)mirror).toString();
            }
            case NONE: {
                return "$none";
            }
        }
        throw new RuntimeException("Unknown type specified " + String.valueOf(mirror) + " mirror: " + String.valueOf(mirror));
    }

    public static boolean isNone(TypeMirror mirror) {
        return mirror != null && ElementUtils.isInvalidType(mirror);
    }

    public static boolean isVoid(TypeMirror mirror) {
        return mirror != null && mirror.getKind() == TypeKind.VOID;
    }

    public static boolean isPrimitive(TypeMirror mirror) {
        return mirror != null && mirror.getKind().isPrimitive();
    }

    public static boolean isFinal(TypeMirror mirror) {
        Element element;
        if (ElementUtils.isPrimitive(mirror) || ElementUtils.isVoid(mirror)) {
            return true;
        }
        return mirror.getKind() == TypeKind.DECLARED && (element = ((DeclaredType)mirror).asElement()).getKind().isClass() && element.getModifiers().contains((Object)Modifier.FINAL);
    }

    public static List<String> getQualifiedSuperTypeNames(TypeElement element) {
        List<TypeElement> types = ElementUtils.getSuperTypes(element);
        ArrayList<String> qualifiedNames = new ArrayList<String>();
        for (TypeElement type : types) {
            qualifiedNames.add(ElementUtils.getQualifiedName(type));
        }
        return qualifiedNames;
    }

    public static List<TypeElement> getDeclaredTypes(TypeElement element) {
        return ElementFilter.typesIn(element.getEnclosedElements());
    }

    public static boolean isEnclosedIn(Element enclosedIn, Element element) {
        if (element == null) {
            return false;
        }
        if (ElementUtils.typeEquals(enclosedIn.asType(), element.asType())) {
            return true;
        }
        return ElementUtils.isEnclosedIn(enclosedIn, element.getEnclosingElement());
    }

    public static List<Element> getElementHierarchy(Element e) {
        ArrayList<Element> elements = new ArrayList<Element>();
        Element enclosing = null;
        if (e != null) {
            elements.add(e);
            enclosing = e.getEnclosingElement();
        }
        while (enclosing != null && enclosing.getKind() != ElementKind.PACKAGE) {
            elements.add(enclosing);
            enclosing = enclosing.getEnclosingElement();
        }
        if (enclosing != null) {
            elements.add(enclosing);
        }
        return elements;
    }

    public static Optional<TypeElement> findRootEnclosingType(Element element) {
        TypeElement parentType = ElementUtils.findParentEnclosingType(element).orElse(null);
        if (parentType == null) {
            return ElementUtils.findNearestEnclosingType(element);
        }
        return ElementUtils.findRootEnclosingType(parentType);
    }

    public static Optional<TypeElement> findParentEnclosingType(Element element) {
        if (element == null) {
            return Optional.empty();
        }
        return ElementUtils.findNearestEnclosingType(element.getEnclosingElement());
    }

    public static Optional<TypeElement> findNearestEnclosingType(Element e) {
        if (e != null) {
            if (e.getKind().isInterface() || e.getKind().isClass()) {
                return Optional.of((TypeElement)e);
            }
            Element enclosing = e.getEnclosingElement();
            if (enclosing != null && enclosing.getKind() != ElementKind.PACKAGE) {
                return ElementUtils.findNearestEnclosingType(enclosing);
            }
        }
        return Optional.empty();
    }

    public static List<TypeElement> getDirectSuperTypes(TypeElement element) {
        ArrayList<TypeElement> types = new ArrayList<TypeElement>();
        TypeElement superElement = ElementUtils.getSuperType(element);
        if (superElement != null) {
            types.add(superElement);
            types.addAll(ElementUtils.getDirectSuperTypes(superElement));
        }
        return types;
    }

    public static TypeElement getSuperType(TypeElement element) {
        if (element == null) {
            return null;
        }
        if (element.getSuperclass() != null) {
            return ElementUtils.fromTypeMirror(element.getSuperclass());
        }
        return null;
    }

    public static boolean isDeprecated(TypeMirror baseType) {
        if (baseType != null && baseType.getKind() == TypeKind.DECLARED) {
            return ElementUtils.isDeprecated(((DeclaredType)baseType).asElement());
        }
        return false;
    }

    public static boolean isDeprecated(Element baseType) {
        DeclaredType deprecated = ProcessorContext.getInstance().getDeclaredType(Deprecated.class);
        return ElementUtils.findAnnotationMirror(baseType.getAnnotationMirrors(), (TypeMirror)deprecated) != null;
    }

    public static boolean isPackageDeprecated(TypeElement baseType) {
        DeclaredType deprecated = ProcessorContext.getInstance().getDeclaredType(Deprecated.class);
        List<TypeElement> superTypes = ElementUtils.getSuperTypes(baseType);
        superTypes.add(baseType);
        for (TypeElement type : superTypes) {
            PackageElement pack = ElementUtils.findPackageElement(type);
            if (pack == null || ElementUtils.findAnnotationMirror(pack.getAnnotationMirrors(), (TypeMirror)deprecated) == null) continue;
            return true;
        }
        return false;
    }

    public static List<TypeElement> getSuperTypes(TypeElement element) {
        ArrayList<TypeElement> types = new ArrayList<TypeElement>();
        List<TypeElement> superTypes = null;
        List<TypeElement> superInterfaces = null;
        TypeElement superElement = ElementUtils.getSuperType(element);
        if (superElement != null) {
            types.add(superElement);
            superTypes = ElementUtils.getSuperTypes(superElement);
        }
        for (TypeMirror typeMirror : element.getInterfaces()) {
            TypeElement interfaceElement = ElementUtils.fromTypeMirror(typeMirror);
            if (interfaceElement == null) continue;
            types.add(interfaceElement);
            if (superInterfaces == null) {
                superInterfaces = ElementUtils.getSuperTypes(interfaceElement);
                continue;
            }
            superInterfaces.addAll(ElementUtils.getSuperTypes(interfaceElement));
        }
        if (superTypes != null) {
            types.addAll(superTypes);
        }
        if (superInterfaces != null) {
            types.addAll(superInterfaces);
        }
        return types;
    }

    public static String getPackageName(Element element) {
        PackageElement pack = ElementUtils.findPackageElement(element);
        if (pack == null) {
            return null;
        }
        return pack.getQualifiedName().toString();
    }

    public static String getEnclosedQualifiedName(DeclaredType mirror) {
        Element e = ((TypeElement)mirror.asElement()).getEnclosingElement();
        if (e.getKind() == ElementKind.PACKAGE) {
            return ((PackageElement)e).getQualifiedName().toString();
        }
        if (e.getKind().isInterface() || e.getKind().isClass()) {
            return ElementUtils.getQualifiedName((TypeElement)e);
        }
        return null;
    }

    public static String getPackageName(TypeMirror mirror) {
        switch (mirror.getKind()) {
            case VOID: 
            case NULL: 
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case LONG: 
            case INT: 
            case FLOAT: 
            case SHORT: 
            case TYPEVAR: {
                return null;
            }
            case DECLARED: {
                PackageElement pack = ElementUtils.findPackageElement(ElementUtils.fromTypeMirror(mirror));
                if (pack == null) {
                    throw new IllegalArgumentException("No package element found for declared type " + ElementUtils.getSimpleName(mirror));
                }
                return pack.getQualifiedName().toString();
            }
            case ARRAY: {
                return ElementUtils.getSimpleName(((ArrayType)mirror).getComponentType());
            }
            case EXECUTABLE: {
                return null;
            }
        }
        throw new RuntimeException("Unknown type specified " + String.valueOf((Object)mirror.getKind()));
    }

    public static String createConstantName(String simpleName) {
        StringBuilder b = new StringBuilder(simpleName);
        for (int i = 0; i < b.length(); ++i) {
            char c = b.charAt(i);
            if (Character.isUpperCase(c) && i != 0) {
                b.insert(i, '_');
                ++i;
                continue;
            }
            if (!Character.isLowerCase(c)) continue;
            b.setCharAt(i, Character.toUpperCase(c));
        }
        return b.toString();
    }

    public static TypeElement fromTypeMirror(TypeMirror mirror) {
        switch (mirror.getKind()) {
            case DECLARED: {
                return (TypeElement)((DeclaredType)mirror).asElement();
            }
            case ARRAY: {
                return ElementUtils.fromTypeMirror(((ArrayType)mirror).getComponentType());
            }
        }
        return null;
    }

    public static AnnotationValue getAnnotationValue(AnnotationMirror mirror, String name) {
        return ElementUtils.getAnnotationValue(mirror, name, true);
    }

    public static AnnotationValue getAnnotationValue(AnnotationMirror mirror, String name, boolean resolveDefault) {
        if (mirror instanceof CodeAnnotationMirror) {
            ExecutableElement valueMethod = null;
            for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
                if (!executableElement.getSimpleName().toString().equals(name)) continue;
                valueMethod = executableElement;
                break;
            }
            if (valueMethod == null) {
                return null;
            }
            AnnotationValue value = mirror.getElementValues().get(valueMethod);
            if (resolveDefault && value == null) {
                value = valueMethod.getDefaultValue();
            }
            return value;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> valuesMap = resolveDefault ? ProcessorContext.getInstance().getEnvironment().getElementUtils().getElementValuesWithDefaults(mirror) : mirror.getElementValues();
        for (ExecutableElement executableElement : valuesMap.keySet()) {
            if (!name.contentEquals(executableElement.getSimpleName())) continue;
            return valuesMap.get(executableElement);
        }
        return null;
    }

    public static <T> List<T> getAnnotationValueList(Class<T> expectedListType, AnnotationMirror mirror, String name) {
        List values = ElementUtils.resolveAnnotationValue(List.class, ElementUtils.getAnnotationValue(mirror, name));
        ArrayList<T> result = new ArrayList<T>();
        if (values != null) {
            for (Object value : values) {
                T annotationValue = ElementUtils.resolveAnnotationValue(expectedListType, (AnnotationValue)value);
                if (annotationValue == null) continue;
                result.add(annotationValue);
            }
        }
        return result;
    }

    public static <T> T getAnnotationValue(Class<T> expectedType, AnnotationMirror mirror, String name) {
        return ElementUtils.getAnnotationValue(expectedType, mirror, name, true);
    }

    public static <T> T getAnnotationValue(Class<T> expectedType, AnnotationMirror mirror, String name, boolean resolveDefault) {
        return ElementUtils.resolveAnnotationValue(expectedType, ElementUtils.getAnnotationValue(mirror, name, resolveDefault));
    }

    public static <T> T resolveAnnotationValue(Class<T> expectedType, AnnotationValue value) {
        if (value == null) {
            return null;
        }
        Object unboxedValue = ElementUtils.unboxAnnotationValue(value);
        if (unboxedValue != null) {
            if (expectedType == TypeMirror.class && unboxedValue instanceof String) {
                return null;
            }
            if (!expectedType.isAssignableFrom(unboxedValue.getClass())) {
                throw new ClassCastException(unboxedValue.getClass().getName() + " not assignable from " + expectedType.getName());
            }
        }
        return expectedType.cast(unboxedValue);
    }

    public static Object unboxAnnotationValue(AnnotationValue value) {
        return value.accept(new AnnotationValueVisitorImpl(), null);
    }

    public static String printException(Throwable e) {
        StringWriter string = new StringWriter();
        PrintWriter writer = new PrintWriter(string);
        e.printStackTrace(writer);
        writer.flush();
        string.flush();
        return e.getMessage() + System.lineSeparator() + string.toString();
    }

    public static AnnotationMirror findAnnotationMirror(Element element, Class<?> expectedAnnotationType) {
        return ElementUtils.findAnnotationMirror(element.getAnnotationMirrors(), ProcessorContext.getInstance().getType(expectedAnnotationType));
    }

    public static AnnotationMirror findAnnotationMirror(List<? extends AnnotationMirror> mirrors, TypeMirror expectedAnnotationType) {
        for (AnnotationMirror annotationMirror : mirrors) {
            if (!ElementUtils.typeEquals(annotationMirror.getAnnotationType(), expectedAnnotationType)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static AnnotationMirror findAnnotationMirror(Element element, TypeMirror annotationType) {
        return ElementUtils.findAnnotationMirror(element.getAnnotationMirrors(), annotationType);
    }

    public static PackageElement findPackageElement(Element e) {
        if (e != null) {
            if (e.getKind() == ElementKind.PACKAGE) {
                return (PackageElement)e;
            }
            Element enclosing = e.getEnclosingElement();
            if (enclosing != null) {
                return ElementUtils.findPackageElement(enclosing);
            }
        }
        return null;
    }

    public static String firstLetterUpperCase(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        return Character.toUpperCase(name.charAt(0)) + name.substring(1, name.length());
    }

    public static String firstLetterLowerCase(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1, name.length());
    }

    private static ExecutableElement getDeclaredMethod(TypeElement element, String name, TypeMirror[] params) {
        List<ExecutableElement> methods = ElementFilter.methodsIn(element.getEnclosedElements());
        block0: for (ExecutableElement method : methods) {
            if (!method.getSimpleName().toString().equals(name) || method.getParameters().size() != params.length) continue;
            for (int i = 0; i < params.length; ++i) {
                TypeMirror param1 = params[i];
                TypeMirror param2 = method.getParameters().get(i).asType();
                if (param1 != null && param1.getKind() != TypeKind.TYPEVAR && param2 != null && param2.getKind() != TypeKind.TYPEVAR && !ElementUtils.getQualifiedName(param1).equals(ElementUtils.getQualifiedName(param2))) continue block0;
            }
            return method;
        }
        return null;
    }

    public static boolean isDeclaredMethodInSuperType(TypeElement element, String name, TypeMirror[] params) {
        return !ElementUtils.getDeclaredMethodsInSuperTypes(element, name, params).isEmpty();
    }

    public static List<ExecutableElement> getDeclaredMethodsInSuperTypes(TypeElement declaringElement, String name, TypeMirror ... params) {
        ArrayList<ExecutableElement> superMethods = new ArrayList<ExecutableElement>();
        List<TypeElement> superElements = ElementUtils.getSuperTypes(declaringElement);
        for (TypeElement superElement : superElements) {
            ExecutableElement superMethod = ElementUtils.getDeclaredMethod(superElement, name, params);
            if (superMethod == null) continue;
            superMethods.add(superMethod);
        }
        return superMethods;
    }

    public static boolean isDefaultMethodOverridden(TypeElement declaringElement, String name, TypeMirror ... params) {
        TypeElement element = declaringElement;
        while (element != null) {
            if (ElementUtils.getDeclaredMethod(element, name, params) != null) {
                return true;
            }
            element = ElementUtils.getSuperType(element);
        }
        return false;
    }

    public static boolean typeEquals(TypeMirror type1, TypeMirror type2) {
        if (type1 == type2) {
            return true;
        }
        if (type1 == null || type2 == null) {
            return false;
        }
        if (type1.getKind() == type2.getKind()) {
            return ElementUtils.getUniqueIdentifier(type1).equals(ElementUtils.getUniqueIdentifier(type2));
        }
        return false;
    }

    public static boolean areTypesCompatible(TypeMirror type1, TypeMirror type2) {
        if (ElementUtils.typeEquals(type1, type2)) {
            return true;
        }
        if (ElementUtils.kindIsIntegral(type1.getKind())) {
            return ElementUtils.kindIsIntegral(type2.getKind());
        }
        if (type1.getKind() == TypeKind.NULL) {
            return type2.getKind() != TypeKind.NULL;
        }
        return type2.getKind() == TypeKind.NULL;
    }

    private static boolean kindIsIntegral(TypeKind kind) {
        return kind == TypeKind.BYTE || kind == TypeKind.SHORT || kind == TypeKind.INT || kind == TypeKind.LONG;
    }

    public static List<String> getUniqueIdentifiers(List<TypeMirror> typeMirror) {
        ArrayList<String> ids = new ArrayList<String>();
        for (TypeMirror type : typeMirror) {
            ids.add(ElementUtils.getUniqueIdentifier(type));
        }
        return ids;
    }

    public static String getUniqueIdentifier(TypeMirror typeMirror) {
        if (typeMirror.getKind() == TypeKind.ARRAY) {
            return ElementUtils.getUniqueIdentifier(((ArrayType)typeMirror).getComponentType()) + "[]";
        }
        if (typeMirror.getKind() == TypeKind.TYPEVAR) {
            Element element = ((TypeVariable)typeMirror).asElement();
            String variableName = element.getSimpleName().toString();
            if (element.getEnclosingElement().getKind().isClass()) {
                return ElementUtils.getUniqueIdentifier(element.getEnclosingElement().asType()) + "." + variableName;
            }
            return variableName;
        }
        return ElementUtils.getQualifiedName(typeMirror);
    }

    public static int compareByTypeHierarchy(TypeMirror t1, TypeMirror t2) {
        if (ElementUtils.typeEquals(t1, t2)) {
            return 0;
        }
        HashSet<String> t1SuperSet = new HashSet<String>(ElementUtils.getQualifiedSuperTypeNames(ElementUtils.fromTypeMirror(t1)));
        if (t1SuperSet.contains(ElementUtils.getQualifiedName(t2))) {
            return -1;
        }
        HashSet<String> t2SuperSet = new HashSet<String>(ElementUtils.getQualifiedSuperTypeNames(ElementUtils.fromTypeMirror(t2)));
        if (t2SuperSet.contains(ElementUtils.getQualifiedName(t1))) {
            return 1;
        }
        return 0;
    }

    public static int compareByTypeHierarchy(TypeMirror t1, Set<String> t1SuperSet, TypeMirror t2, Set<String> t2SuperSet) {
        if (ElementUtils.typeEquals(t1, t2)) {
            return 0;
        }
        if (t1SuperSet.contains(ElementUtils.getQualifiedName(t2))) {
            return -1;
        }
        if (t2SuperSet.contains(ElementUtils.getQualifiedName(t1))) {
            return 1;
        }
        return 0;
    }

    public static boolean canThrowTypeExact(List<? extends TypeMirror> thrownTypes, TypeMirror exceptionType) {
        if (ElementUtils.containsType(thrownTypes, exceptionType)) {
            return true;
        }
        return ElementUtils.isRuntimeException(exceptionType);
    }

    public static boolean canThrowType(List<? extends TypeMirror> thrownTypes, TypeMirror exceptionType) {
        if (ElementUtils.canThrowTypeExact(thrownTypes, exceptionType)) {
            return true;
        }
        for (TypeElement typeElement : ElementUtils.getSuperTypes(ElementUtils.fromTypeMirror(exceptionType))) {
            if (!ElementUtils.containsType(thrownTypes, typeElement.asType())) continue;
            return true;
        }
        return false;
    }

    public static void setFinal(Set<Modifier> modifiers, boolean enabled) {
        if (enabled) {
            modifiers.add(Modifier.FINAL);
        } else {
            modifiers.remove((Object)Modifier.FINAL);
        }
    }

    public static void setVisibility(Set<Modifier> modifiers, Modifier visibility) {
        Modifier current = ElementUtils.getVisibility(modifiers);
        if (current != visibility) {
            if (current != null) {
                modifiers.remove((Object)current);
            }
            if (visibility != null) {
                modifiers.add(visibility);
            }
        }
    }

    public static Modifier getVisibility(Set<Modifier> modifier) {
        for (Modifier mod : modifier) {
            if (mod != Modifier.PUBLIC && mod != Modifier.PRIVATE && mod != Modifier.PROTECTED) continue;
            return mod;
        }
        return null;
    }

    private static boolean isRuntimeException(TypeMirror type) {
        HashSet<String> typeSuperSet = new HashSet<String>(ElementUtils.getQualifiedSuperTypeNames(ElementUtils.fromTypeMirror(type)));
        return typeSuperSet.contains(RuntimeException.class.getCanonicalName()) || ElementUtils.getQualifiedName(type).equals(RuntimeException.class.getCanonicalName());
    }

    private static boolean containsType(Collection<? extends TypeMirror> collection, TypeMirror type) {
        for (TypeMirror typeMirror : collection) {
            if (!ElementUtils.typeEquals(typeMirror, type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isObject(TypeMirror actualType) {
        return actualType.getKind() == TypeKind.DECLARED && ElementUtils.getQualifiedName(actualType).equals("java.lang.Object");
    }

    public static TypeMirror fillInGenericWildcards(TypeMirror type) {
        if (type.getKind() != TypeKind.DECLARED) {
            return type;
        }
        DeclaredType declaredType = (DeclaredType)type;
        TypeElement element = (TypeElement)declaredType.asElement();
        if (element == null) {
            return type;
        }
        int typeParameters = element.getTypeParameters().size();
        if (typeParameters > 0 && declaredType.getTypeArguments().size() != typeParameters) {
            return ProcessorContext.getInstance().getEnvironment().getTypeUtils().erasure(type);
        }
        return type;
    }

    public static boolean hasGenericTypes(TypeMirror type) {
        return type.getKind() == TypeKind.DECLARED && !((DeclaredType)type).getTypeArguments().isEmpty();
    }

    public static TypeMirror eraseGenericTypes(TypeMirror type) {
        if (type.getKind() != TypeKind.DECLARED) {
            return type;
        }
        DeclaredType declaredType = (DeclaredType)type;
        if (declaredType.getTypeArguments().size() == 0) {
            return type;
        }
        return new CodeTypeMirror.DeclaredCodeTypeMirror((TypeElement)declaredType.asElement());
    }

    public static boolean variableEquals(VariableElement var1, VariableElement var2) {
        if (var1 == var2) {
            return true;
        }
        if (var1 == null || var2 == null) {
            return false;
        }
        if (!var1.getSimpleName().equals(var2.getSimpleName())) {
            return false;
        }
        if (!ElementUtils.typeEquals(var1.asType(), var2.asType())) {
            return false;
        }
        return ElementUtils.elementEquals(var1.getEnclosingElement(), var2.getEnclosingElement());
    }

    public static boolean signatureEquals(ExecutableElement e1, ExecutableElement e2) {
        if (!e1.getSimpleName().toString().equals(e2.getSimpleName().toString())) {
            return false;
        }
        if (e1.getParameters().size() != e2.getParameters().size()) {
            return false;
        }
        if (!ElementUtils.typeEquals(e1.getReturnType(), e2.getReturnType())) {
            return false;
        }
        for (int i = 0; i < e1.getParameters().size(); ++i) {
            if (ElementUtils.typeEquals(e1.getParameters().get(i).asType(), e2.getParameters().get(i).asType())) continue;
            return false;
        }
        return true;
    }

    public static boolean executableEquals(ExecutableElement e1, ExecutableElement e2) {
        if (!ElementUtils.signatureEquals(e1, e2)) {
            return false;
        }
        return ElementUtils.elementEquals(e1.getEnclosingElement(), e2.getEnclosingElement());
    }

    public static boolean elementEquals(Element element1, Element element2) {
        if (element1 == element2) {
            return true;
        }
        if (element1 == null || element2 == null) {
            return false;
        }
        if (element1.getKind() != element2.getKind()) {
            return false;
        }
        switch (element1.getKind()) {
            case FIELD: 
            case ENUM_CONSTANT: 
            case PARAMETER: 
            case LOCAL_VARIABLE: 
            case EXCEPTION_PARAMETER: 
            case RESOURCE_VARIABLE: {
                return ElementUtils.variableEquals((VariableElement)element1, (VariableElement)element2);
            }
            case CONSTRUCTOR: 
            case METHOD: 
            case INSTANCE_INIT: 
            case STATIC_INIT: {
                return ElementUtils.executableEquals((ExecutableElement)element1, (ExecutableElement)element2);
            }
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case ANNOTATION_TYPE: 
            case RECORD: {
                return ElementUtils.typeEquals(element1.asType(), element2.asType());
            }
            case PACKAGE: {
                return ((PackageElement)element1).getQualifiedName().equals(((PackageElement)element2).getQualifiedName());
            }
            case TYPE_PARAMETER: {
                return element1.getSimpleName().toString().equals(element2.getSimpleName().toString());
            }
        }
        throw new AssertionError((Object)("unsupported element type: " + String.valueOf((Object)element1.getKind())));
    }

    public static List<TypeMirror> sortTypes(List<TypeMirror> list, final boolean reverse) {
        Collections.sort(list, new Comparator<TypeMirror>(){

            @Override
            public int compare(TypeMirror o1, TypeMirror o2) {
                if (reverse) {
                    return ElementUtils.compareType(o2, o1);
                }
                return ElementUtils.compareType(o1, o2);
            }
        });
        return list;
    }

    public static int compareType(TypeMirror signature1, TypeMirror signature2) {
        if (signature1 == null) {
            return 1;
        }
        if (signature2 == null) {
            return -1;
        }
        if (ElementUtils.typeEquals(signature1, signature2)) {
            return 0;
        }
        if (signature1.getKind() == TypeKind.DECLARED && signature2.getKind() == TypeKind.DECLARED) {
            TypeElement element1 = ElementUtils.fromTypeMirror(signature1);
            TypeElement element2 = ElementUtils.fromTypeMirror(signature2);
            if (ElementUtils.getDirectSuperTypes(element1).contains(element2)) {
                return -1;
            }
            if (ElementUtils.getDirectSuperTypes(element2).contains(element1)) {
                return 1;
            }
        }
        return ElementUtils.getSimpleName(signature1).compareTo(ElementUtils.getSimpleName(signature2));
    }

    public static List<TypeMirror> uniqueSortedTypes(Collection<TypeMirror> types, boolean reverse) {
        return ElementUtils.sortTypes(new ArrayList<TypeMirror>(ElementUtils.uniqueTypes(types)), reverse);
    }

    public static Collection<TypeMirror> uniqueTypes(Collection<TypeMirror> types) {
        if (types.isEmpty()) {
            return types;
        }
        if (types.size() <= 1) {
            return types;
        }
        LinkedHashMap<String, TypeMirror> uniqueTypeMap = new LinkedHashMap<String, TypeMirror>();
        for (TypeMirror type : types) {
            uniqueTypeMap.put(ElementUtils.getUniqueIdentifier(type), type);
        }
        return uniqueTypeMap.values();
    }

    public static int compareMethod(ExecutableElement method1, ExecutableElement method2) {
        List<? extends VariableElement> parameters1 = method1.getParameters();
        List<? extends VariableElement> parameters2 = method2.getParameters();
        if (parameters1.size() != parameters2.size()) {
            return Integer.compare(parameters1.size(), parameters2.size());
        }
        int result = 0;
        for (int i = 0; i < parameters1.size(); ++i) {
            VariableElement var1 = parameters1.get(i);
            VariableElement var2 = parameters2.get(i);
            result = ElementUtils.compareType(var1.asType(), var2.asType());
            if (result == 0) continue;
            return result;
        }
        result = method1.getSimpleName().toString().compareTo(method2.getSimpleName().toString());
        if (result == 0) {
            TypeElement enclosingType1 = ElementUtils.findNearestEnclosingType(method1).orElseThrow(AssertionError::new);
            TypeElement enclosingType2 = ElementUtils.findNearestEnclosingType(method2).orElseThrow(AssertionError::new);
            result = enclosingType1.getQualifiedName().toString().compareTo(enclosingType2.getQualifiedName().toString());
        }
        return result;
    }

    public static List<AnnotationMirror> getRepeatedAnnotation(List<? extends AnnotationMirror> mirrors, DeclaredType base) {
        AnnotationMirror baseMirror;
        AnnotationMirror repeatMirror;
        DeclaredType repeatableType = ProcessorContext.getInstance().getDeclaredType(Repeatable.class);
        AnnotationMirror repeatable = ElementUtils.findAnnotationMirror(base.asElement(), (TypeMirror)repeatableType);
        TypeMirror repeat = null;
        if (repeatable != null) {
            repeat = ElementUtils.getAnnotationValue(TypeMirror.class, repeatable, "value");
        }
        ArrayList<AnnotationMirror> annotationMirrors = new ArrayList<AnnotationMirror>();
        AnnotationMirror annotationMirror = repeatMirror = repeat != null ? ElementUtils.findAnnotationMirror(mirrors, repeat) : null;
        if (repeatMirror != null) {
            annotationMirrors.addAll(ElementUtils.getAnnotationValueList(AnnotationMirror.class, repeatMirror, "value"));
        }
        if ((baseMirror = ElementUtils.findAnnotationMirror(mirrors, (TypeMirror)base)) != null) {
            annotationMirrors.add(baseMirror);
        }
        return annotationMirrors;
    }

    public static boolean isVisible(Element accessingElement, Element accessedElement) {
        Modifier visibility = ElementUtils.getVisibility(accessedElement.getModifiers());
        if (accessedElement.getKind() == ElementKind.PARAMETER) {
            Element methodElement = accessedElement.getEnclosingElement();
            if (methodElement == null) {
                return true;
            }
            return ElementUtils.isVisible(accessingElement, methodElement);
        }
        if (visibility == Modifier.PUBLIC) {
            return true;
        }
        if (visibility == Modifier.PRIVATE) {
            return false;
        }
        if (visibility == Modifier.PROTECTED) {
            TypeElement accessedType = ElementUtils.findNearestEnclosingType(accessedElement).orElse(null);
            TypeElement accessingType = ElementUtils.findNearestEnclosingType(accessingElement).orElse(null);
            if (accessedType != null && accessingType != null) {
                if (ElementUtils.typeEquals(accessedType.asType(), accessingType.asType())) {
                    return true;
                }
                if (ElementUtils.isSubtype(accessingType.asType(), accessedType.asType())) {
                    return true;
                }
            }
        }
        String thisPackageElement = ElementUtils.getPackageName(accessingElement);
        String otherPackageElement = ElementUtils.getPackageName(accessedElement);
        if (otherPackageElement != null && !thisPackageElement.equals(otherPackageElement)) {
            return false;
        }
        for (Element enclosing = accessedElement.getEnclosingElement(); enclosing != null && enclosing.getKind() != ElementKind.PACKAGE; enclosing = enclosing.getEnclosingElement()) {
            if (ElementUtils.isVisible(accessingElement, enclosing)) continue;
            return false;
        }
        return true;
    }

    public static TypeElement castTypeElement(TypeMirror mirror) {
        if (mirror.getKind() == TypeKind.DECLARED) {
            return (TypeElement)((DeclaredType)mirror).asElement();
        }
        return null;
    }

    public static String getReadableReference(Element relativeTo, Element element) {
        switch (element.getKind()) {
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                TypeElement type = (TypeElement)element;
                if (ElementUtils.elementEquals(ElementUtils.findPackageElement(relativeTo), ElementUtils.findPackageElement(element))) {
                    Element enclosing;
                    if (!ElementUtils.isDeclaredIn(relativeTo, type) && ((enclosing = element.getEnclosingElement()).getKind().isClass() || enclosing.getKind().isInterface())) {
                        return ElementUtils.getReadableReference(relativeTo, enclosing) + "." + ElementUtils.getSimpleName(type);
                    }
                    return ElementUtils.getSimpleName(type);
                }
                return ElementUtils.getQualifiedName(type);
            }
            case PACKAGE: {
                return ((PackageElement)element).getQualifiedName().toString();
            }
            case CONSTRUCTOR: 
            case METHOD: {
                String parent = ElementUtils.getReadableReference(relativeTo, element.getEnclosingElement());
                return parent + "." + ElementUtils.getReadableSignature((ExecutableElement)element);
            }
            case PARAMETER: {
                ExecutableElement method;
                int highlightIndex;
                Element enclosing = element.getEnclosingElement();
                if (enclosing instanceof ExecutableElement && (highlightIndex = (method = (ExecutableElement)enclosing).getParameters().indexOf(element)) != -1) {
                    String parent = ElementUtils.getReadableReference(relativeTo, method.getEnclosingElement());
                    return parent + "." + ElementUtils.getReadableSignature(method, highlightIndex);
                }
                String parent = ElementUtils.getReadableReference(relativeTo, enclosing);
                return " parameter " + element.getSimpleName().toString() + " in " + parent;
            }
            case FIELD: {
                String parent = ElementUtils.getReadableReference(relativeTo, element.getEnclosingElement());
                return parent + "." + element.getSimpleName().toString();
            }
        }
        return "Unknown Element";
    }

    public static boolean isDeclaredIn(Element search, Element elementHierarchy) {
        for (Element searchEnclosing = search.getEnclosingElement(); searchEnclosing != null; searchEnclosing = searchEnclosing.getEnclosingElement()) {
            if (!ElementUtils.elementEquals(searchEnclosing, elementHierarchy)) continue;
            return true;
        }
        return false;
    }

    public static String getBinaryName(TypeElement provider) {
        if (provider instanceof GeneratedElement) {
            ElementKind kind;
            String packageName = ElementUtils.getPackageName(provider);
            StringBuilder b = new StringBuilder();
            b.append(provider.getSimpleName().toString());
            for (Element enclosing = provider.getEnclosingElement(); enclosing != null && ((kind = enclosing.getKind()).isClass() || kind.isInterface()) && enclosing instanceof TypeElement; enclosing = enclosing.getEnclosingElement()) {
                b.insert(0, enclosing.getSimpleName().toString() + "$");
            }
            b.insert(0, packageName + ".");
            return b.toString();
        }
        return ProcessorContext.getInstance().getEnvironment().getElementUtils().getBinaryName(provider).toString();
    }

    public static int getCompressedReferenceSize(TypeMirror mirror) {
        switch (mirror.getKind()) {
            case BOOLEAN: 
            case BYTE: {
                return 1;
            }
            case CHAR: 
            case SHORT: {
                return 2;
            }
            case INT: 
            case FLOAT: {
                return 4;
            }
            case DOUBLE: 
            case LONG: {
                return 8;
            }
            case ARRAY: 
            case DECLARED: 
            case TYPEVAR: {
                return 4;
            }
            case VOID: 
            case NULL: 
            case EXECUTABLE: {
                return 0;
            }
        }
        throw new RuntimeException("Unknown type specified " + String.valueOf((Object)mirror.getKind()));
    }

    public static SpecializationData.Idempotence getIdempotent(ExecutableElement method) {
        TruffleTypes types = ProcessorContext.types();
        if (ElementUtils.findAnnotationMirror((Element)method, (TypeMirror)types.Idempotent) != null) {
            return SpecializationData.Idempotence.IDEMPOTENT;
        }
        if (ElementUtils.findAnnotationMirror((Element)method, (TypeMirror)types.NonIdempotent) != null) {
            return SpecializationData.Idempotence.NON_IDEMPOTENT;
        }
        if (types.isBuiltinIdempotent(method)) {
            return SpecializationData.Idempotence.IDEMPOTENT;
        }
        if (types.isBuiltinNonIdempotent(method)) {
            return SpecializationData.Idempotence.NON_IDEMPOTENT;
        }
        return SpecializationData.Idempotence.UNKNOWN;
    }

    private static class AnnotationValueVisitorImpl
    extends AbstractAnnotationValueVisitor8<Object, Void> {
        private AnnotationValueVisitorImpl() {
        }

        @Override
        public Object visitBoolean(boolean b, Void p) {
            return b;
        }

        @Override
        public Object visitByte(byte b, Void p) {
            return b;
        }

        @Override
        public Object visitChar(char c, Void p) {
            return Character.valueOf(c);
        }

        @Override
        public Object visitDouble(double d, Void p) {
            return d;
        }

        @Override
        public Object visitFloat(float f, Void p) {
            return Float.valueOf(f);
        }

        @Override
        public Object visitInt(int i, Void p) {
            return i;
        }

        @Override
        public Object visitLong(long i, Void p) {
            return i;
        }

        @Override
        public Object visitShort(short s, Void p) {
            return s;
        }

        @Override
        public Object visitString(String s, Void p) {
            return s;
        }

        @Override
        public Object visitType(TypeMirror t, Void p) {
            return t;
        }

        @Override
        public Object visitEnumConstant(VariableElement c, Void p) {
            return c;
        }

        @Override
        public Object visitAnnotation(AnnotationMirror a, Void p) {
            return a;
        }

        @Override
        public Object visitArray(List<? extends AnnotationValue> vals, Void p) {
            return vals;
        }
    }
}

