/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.api.TruffleOptionDescriptors;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.polyglot.enterprise.EnterpriseEngineOptions;
import java.util.Arrays;
import java.util.Iterator;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionStability;
import org.graalvm.polyglot.SandboxPolicy;

@GeneratedBy(value=EnterpriseEngineOptions.class)
final class EnterpriseEngineOptionsOptionDescriptors
implements TruffleOptionDescriptors {
    EnterpriseEngineOptionsOptionDescriptors() {
    }

    public OptionDescriptor get(String string) {
        if (string.startsWith("engine.IsolateOption.") || string.equals("engine.IsolateOption")) {
            return OptionDescriptor.newBuilder(EnterpriseEngineOptions.IsolateOption, (String)"engine.IsolateOption").deprecated(false).help("Isolate VM options.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
        }
        switch (string) {
            case "engine.HostCallStackHeadRoom": {
                return OptionDescriptor.newBuilder(EnterpriseEngineOptions.HostCallStackHeadRoom, (String)"engine.HostCallStackHeadRoom").deprecated(false).help("Stack space headroom for calls to the host.").usageSyntax("[1, inf)<B>|<KB>|<MB>|<GB>").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            }
            case "engine.IsolateLibrary": {
                return OptionDescriptor.newBuilder(EnterpriseEngineOptions.IsolateLibrary, (String)"engine.IsolateLibrary").deprecated(false).help("Path to the isolate library.").usageSyntax("<path>").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.IsolateMemoryProtection": {
                return OptionDescriptor.newBuilder(EnterpriseEngineOptions.IsolateMemoryProtection, (String)"engine.IsolateMemoryProtection").deprecated(false).help("Enable memory protection for the isolate.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "engine.MaxIsolateMemory": {
                return OptionDescriptor.newBuilder(EnterpriseEngineOptions.MaxIsolateMemory, (String)"engine.MaxIsolateMemory").deprecated(false).help("Set maximum polyglot isolate heap size. This is a hard limit for the size of the isolate heap including both guest applications retained data and data allocated by the runtime.").usageSyntax("[32MB, inf)<B>|<KB>|<MB>|<GB>").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "engine.SpawnIsolate": {
                return OptionDescriptor.newBuilder(EnterpriseEngineOptions.SpawnIsolate, (String)"engine.SpawnIsolate").deprecated(false).help("Spawn an isolate with isolated heap for this engine. Can be set to true or false or to the set of languages that should be initialized.").usageSyntax("true|false|<language>,<language>,...").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "engine.UntrustedCodeMitigation": {
                return OptionDescriptor.newBuilder(EnterpriseEngineOptions.UntrustedCodeMitigation, (String)"engine.UntrustedCodeMitigation").deprecated(false).help("Enable untrusted code execution defenses.").usageSyntax("none|hardware|software").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
        }
        return null;
    }

    public SandboxPolicy getSandboxPolicy(String string) {
        assert (this.get(string) != null) : "Unknown option " + string;
        if (string.startsWith("engine.IsolateOption.") || string.equals("engine.IsolateOption")) {
            return SandboxPolicy.CONSTRAINED;
        }
        return SandboxPolicy.UNTRUSTED;
    }

    public Iterator<OptionDescriptor> iterator() {
        return Arrays.asList(OptionDescriptor.newBuilder(EnterpriseEngineOptions.HostCallStackHeadRoom, (String)"engine.HostCallStackHeadRoom").deprecated(false).help("Stack space headroom for calls to the host.").usageSyntax("[1, inf)<B>|<KB>|<MB>|<GB>").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EnterpriseEngineOptions.IsolateLibrary, (String)"engine.IsolateLibrary").deprecated(false).help("Path to the isolate library.").usageSyntax("<path>").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EnterpriseEngineOptions.IsolateMemoryProtection, (String)"engine.IsolateMemoryProtection").deprecated(false).help("Enable memory protection for the isolate.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EnterpriseEngineOptions.IsolateOption, (String)"engine.IsolateOption").deprecated(false).help("Isolate VM options.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EnterpriseEngineOptions.MaxIsolateMemory, (String)"engine.MaxIsolateMemory").deprecated(false).help("Set maximum polyglot isolate heap size. This is a hard limit for the size of the isolate heap including both guest applications retained data and data allocated by the runtime.").usageSyntax("[32MB, inf)<B>|<KB>|<MB>|<GB>").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EnterpriseEngineOptions.SpawnIsolate, (String)"engine.SpawnIsolate").deprecated(false).help("Spawn an isolate with isolated heap for this engine. Can be set to true or false or to the set of languages that should be initialized.").usageSyntax("true|false|<language>,<language>,...").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EnterpriseEngineOptions.UntrustedCodeMitigation, (String)"engine.UntrustedCodeMitigation").deprecated(false).help("Enable untrusted code execution defenses.").usageSyntax("none|hardware|software").category(OptionCategory.USER).stability(OptionStability.STABLE).build()).iterator();
    }
}

