/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.NativeInputStream;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateGuestFeatureEnabled;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.io.IOException;
import java.io.InputStream;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativebridge.NativeIsolateThread;
import org.graalvm.nativebridge.NativeObject;
import org.graalvm.nativebridge.NativeObjectHandles;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.word.WordFactory;

final class NativeInputStreamGen {
    NativeInputStreamGen() {
    }

    static NativeInputStream createHSToNative(NativeObject nativeObject) {
        return new StartPoint(nativeObject);
    }

    static NativeInputStream createNativeToNative(NativeObject nativeObject) {
        return new StartPoint(nativeObject);
    }

    static NativeInputStream create(NativeObject nativeObject) {
        if (ImageInfo.inImageCode()) {
            return NativeInputStreamGen.createNativeToNative(nativeObject);
        }
        return NativeInputStreamGen.createHSToNative(nativeObject);
    }

    private static final class StartPoint
    extends NativeInputStream {
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        StartPoint(NativeObject nativeObject) {
            super(nativeObject);
        }

        @Override
        public int read() throws IOException {
            NativeIsolateThread nativeIsolateThread = this.isolateInputStream.getIsolate().enter();
            try {
                int n2 = StartPoint.read0(nativeIsolateThread.getIsolateThreadId(), this.isolateInputStream.getHandle());
                return n2;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public byte[] readAllBytes() throws IOException {
            NativeIsolateThread nativeIsolateThread = this.isolateInputStream.getIsolate().enter();
            try {
                byte[] byArray = StartPoint.readAllBytes0(nativeIsolateThread.getIsolateThreadId(), this.isolateInputStream.getHandle());
                return byArray;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public byte[] readNBytes(int n2) throws IOException {
            NativeIsolateThread nativeIsolateThread = this.isolateInputStream.getIsolate().enter();
            try {
                byte[] byArray = StartPoint.readNBytes0(nativeIsolateThread.getIsolateThreadId(), this.isolateInputStream.getHandle(), n2);
                return byArray;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public int readNBytes(byte[] byArray, int n2, int n3) throws IOException {
            NativeIsolateThread nativeIsolateThread = this.isolateInputStream.getIsolate().enter();
            try {
                int n4 = StartPoint.readNBytes0(nativeIsolateThread.getIsolateThreadId(), this.isolateInputStream.getHandle(), byArray, n2, n3);
                return n4;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public long skip(long l2) throws IOException {
            NativeIsolateThread nativeIsolateThread = this.isolateInputStream.getIsolate().enter();
            try {
                long l3 = StartPoint.skip0(nativeIsolateThread.getIsolateThreadId(), this.isolateInputStream.getHandle(), l2);
                return l3;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public void skipNBytes(long l2) throws IOException {
            NativeIsolateThread nativeIsolateThread = this.isolateInputStream.getIsolate().enter();
            try {
                StartPoint.skipNBytes0(nativeIsolateThread.getIsolateThreadId(), this.isolateInputStream.getHandle(), l2);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public int available() throws IOException {
            NativeIsolateThread nativeIsolateThread = this.isolateInputStream.getIsolate().enter();
            try {
                int n2 = StartPoint.available0(nativeIsolateThread.getIsolateThreadId(), this.isolateInputStream.getHandle());
                return n2;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public void close() throws IOException {
            NativeIsolateThread nativeIsolateThread = this.isolateInputStream.getIsolate().enter();
            try {
                StartPoint.close0(nativeIsolateThread.getIsolateThreadId(), this.isolateInputStream.getHandle());
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public void mark(int n2) {
            NativeIsolateThread nativeIsolateThread = this.isolateInputStream.getIsolate().enter();
            try {
                StartPoint.mark0(nativeIsolateThread.getIsolateThreadId(), this.isolateInputStream.getHandle(), n2);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public void reset() throws IOException {
            NativeIsolateThread nativeIsolateThread = this.isolateInputStream.getIsolate().enter();
            try {
                StartPoint.reset0(nativeIsolateThread.getIsolateThreadId(), this.isolateInputStream.getHandle());
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public boolean markSupported() {
            NativeIsolateThread nativeIsolateThread = this.isolateInputStream.getIsolate().enter();
            try {
                boolean bl = StartPoint.markSupported0(nativeIsolateThread.getIsolateThreadId(), this.isolateInputStream.getHandle());
                return bl;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            NativeIsolateThread nativeIsolateThread = this.isolateInputStream.getIsolate().enter();
            try {
                int n4 = StartPoint.read0(nativeIsolateThread.getIsolateThreadId(), this.isolateInputStream.getHandle(), byArray, n2, n3);
                return n4;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        private static native int read0(long var0, long var2) throws IOException;

        private static native byte[] readAllBytes0(long var0, long var2) throws IOException;

        private static native byte[] readNBytes0(long var0, long var2, int var4) throws IOException;

        private static native int readNBytes0(long var0, long var2, byte[] var4, int var5, int var6) throws IOException;

        private static native long skip0(long var0, long var2, long var4) throws IOException;

        private static native void skipNBytes0(long var0, long var2, long var4) throws IOException;

        private static native int available0(long var0, long var2) throws IOException;

        private static native void close0(long var0, long var2) throws IOException;

        private static native void mark0(long var0, long var2, int var4);

        private static native void reset0(long var0, long var2) throws IOException;

        private static native boolean markSupported0(long var0, long var2);

        private static native int read0(long var0, long var2, byte[] var4, int var5, int var6) throws IOException;

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }

    private static final class EndPoint {
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeInputStreamGen_00024StartPoint_read0__JJ", include=PolyglotIsolateGuestFeatureEnabled.class)
        static int read(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            int n2;
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeInputStreamGen::read", jNIEnv);
            try {
                int n3;
                InputStream inputStream = (InputStream)NativeObjectHandles.resolve((long)l3, InputStream.class);
                n2 = n3 = inputStream.read();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jNIMethodScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    ForeignException.forThrowable((Throwable)throwable3, throwableMarshaller).throwUsingJNI(jNIEnv);
                    return 0;
                }
            }
            jNIMethodScope.close();
            return n2;
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeInputStreamGen_00024StartPoint_readAllBytes0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JByteArray readAllBytes(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeInputStreamGen::readAllBytes", jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                InputStream inputStream = (InputStream)NativeObjectHandles.resolve((long)l3, InputStream.class);
                byte[] byArray = inputStream.readAllBytes();
                jNIMethodScope.setObjectResult((JNI.JObject)JNIUtil.createHSArray((JNI.JNIEnv)jNIEnv, (byte[])byArray));
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JByteArray)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeInputStreamGen_00024StartPoint_readNBytes0__JJI", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JByteArray readNBytes(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, int n2) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeInputStreamGen::readNBytes", jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                InputStream inputStream = (InputStream)NativeObjectHandles.resolve((long)l3, InputStream.class);
                byte[] byArray = inputStream.readNBytes(n2);
                jNIMethodScope.setObjectResult((JNI.JObject)JNIUtil.createHSArray((JNI.JNIEnv)jNIEnv, (byte[])byArray));
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JByteArray)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeInputStreamGen_00024StartPoint_readNBytes0__JJ_3BII", include=PolyglotIsolateGuestFeatureEnabled.class)
        static int readNBytes(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, JNI.JByteArray jByteArray, int n2, int n3) {
            int n4;
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeInputStreamGen::readNBytes", jNIEnv);
            try {
                int n5;
                InputStream inputStream = (InputStream)NativeObjectHandles.resolve((long)l3, InputStream.class);
                n4 = n5 = inputStream.readNBytes(JNIUtil.createArray((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray), n2, n3);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jNIMethodScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    ForeignException.forThrowable((Throwable)throwable3, throwableMarshaller).throwUsingJNI(jNIEnv);
                    return 0;
                }
            }
            jNIMethodScope.close();
            return n4;
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeInputStreamGen_00024StartPoint_skip0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static long skip(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, long l4) {
            long l5;
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeInputStreamGen::skip", jNIEnv);
            try {
                long l6;
                InputStream inputStream = (InputStream)NativeObjectHandles.resolve((long)l3, InputStream.class);
                l5 = l6 = inputStream.skip(l4);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jNIMethodScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    ForeignException.forThrowable((Throwable)throwable3, throwableMarshaller).throwUsingJNI(jNIEnv);
                    return 0L;
                }
            }
            jNIMethodScope.close();
            return l5;
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeInputStreamGen_00024StartPoint_skipNBytes0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void skipNBytes(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, long l4) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeInputStreamGen::skipNBytes", jNIEnv);){
                InputStream inputStream = (InputStream)NativeObjectHandles.resolve((long)l3, InputStream.class);
                inputStream.skipNBytes(l4);
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeInputStreamGen_00024StartPoint_available0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static int available(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            int n2;
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeInputStreamGen::available", jNIEnv);
            try {
                int n3;
                InputStream inputStream = (InputStream)NativeObjectHandles.resolve((long)l3, InputStream.class);
                n2 = n3 = inputStream.available();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jNIMethodScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    ForeignException.forThrowable((Throwable)throwable3, throwableMarshaller).throwUsingJNI(jNIEnv);
                    return 0;
                }
            }
            jNIMethodScope.close();
            return n2;
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeInputStreamGen_00024StartPoint_close0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void close(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeInputStreamGen::close", jNIEnv);){
                InputStream inputStream = (InputStream)NativeObjectHandles.resolve((long)l3, InputStream.class);
                inputStream.close();
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeInputStreamGen_00024StartPoint_mark0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void mark(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, int n2) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeInputStreamGen::mark", jNIEnv);){
                InputStream inputStream = (InputStream)NativeObjectHandles.resolve((long)l3, InputStream.class);
                inputStream.mark(n2);
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeInputStreamGen_00024StartPoint_reset0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void reset(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeInputStreamGen::reset", jNIEnv);){
                InputStream inputStream = (InputStream)NativeObjectHandles.resolve((long)l3, InputStream.class);
                inputStream.reset();
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeInputStreamGen_00024StartPoint_markSupported0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static boolean markSupported(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            boolean bl;
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeInputStreamGen::markSupported", jNIEnv);
            try {
                boolean bl2;
                InputStream inputStream = (InputStream)NativeObjectHandles.resolve((long)l3, InputStream.class);
                bl = bl2 = inputStream.markSupported();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jNIMethodScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    ForeignException.forThrowable((Throwable)throwable3, throwableMarshaller).throwUsingJNI(jNIEnv);
                    return false;
                }
            }
            jNIMethodScope.close();
            return bl;
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeInputStreamGen_00024StartPoint_read0__JJ_3BII", include=PolyglotIsolateGuestFeatureEnabled.class)
        static int read(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, JNI.JByteArray jByteArray, int n2, int n3) {
            int n4;
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeInputStreamGen::read", jNIEnv);
            try {
                InputStream inputStream = (InputStream)NativeObjectHandles.resolve((long)l3, InputStream.class);
                byte[] byArray = new byte[n3];
                int n5 = inputStream.read(byArray, 0, n3);
                if (n5 > 0) {
                    JNIUtil.arrayCopy((JNI.JNIEnv)jNIEnv, (byte[])byArray, (int)0, (JNI.JByteArray)jByteArray, (int)n2, (int)n5);
                }
                n4 = n5;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jNIMethodScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    ForeignException.forThrowable((Throwable)throwable3, throwableMarshaller).throwUsingJNI(jNIEnv);
                    return 0;
                }
            }
            jNIMethodScope.close();
            return n4;
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

