/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.BinaryProtocol;
import com.oracle.truffle.polyglot.enterprise.HSContext;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolate;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateGuestFeatureEnabled;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.BinaryOutput;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

final class NativeTruffleObjectEndpoint {
    private static final BinaryMarshaller<Throwable> THROWABLE_MARSHALLER = PolyglotJNIConfig.getInstance().lookupMarshaller(Throwable.class, new Class[0]);

    NativeTruffleObjectEndpoint() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeTruffleObject_guestObjectDispatch", include=PolyglotIsolateGuestFeatureEnabled.class)
    public static JNI.JByteArray guestObjectDispatch(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, long l4, int n2, JNI.JByteArray jByteArray, int n3, int n4) {
        JNIMethodScope jNIMethodScope;
        block26: {
            CCharPointer cCharPointer = (CCharPointer)StackValue.get((int)4096);
            CCharPointer cCharPointer2 = (CCharPointer)WordFactory.nullPointer();
            PolyglotIsolate.Lazy lazy = PolyglotIsolate.lazy;
            jNIMethodScope = new JNIMethodScope("PolyglotIsolate::guestObjectDispatch", jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                Object object;
                Object[] objectArray;
                int n5;
                if (n3 < 4096) {
                    cCharPointer2 = cCharPointer;
                    n5 = 4096;
                } else {
                    cCharPointer2 = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n5 = n3;
                }
                HSContext hSContext = lazy.contextByHandle.get(l3);
                if (n3 != 0) {
                    JNIUtil.GetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n3, (CCharPointer)cCharPointer2);
                    BinaryInput binaryInput = BinaryInput.create((CCharPointer)cCharPointer2, (int)n3);
                    objectArray = (Object[])BinaryProtocol.readGuestTypedValue(binaryInput, hSContext);
                } else {
                    objectArray = null;
                }
                boolean bl = false;
                try {
                    object = hSContext.hostToGuestObjectReferences.dispatch(l3, l4, n2, objectArray);
                    bl = true;
                }
                catch (Throwable throwable) {
                    if (BinaryProtocol.isSupportedException(throwable)) {
                        object = throwable;
                    }
                    throw throwable;
                }
                if (object == null) {
                    jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
                    break block26;
                }
                try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer2, (int)n5, (cCharPointer2 != cCharPointer ? 1 : 0) != 0);){
                    cCharPointer2 = (CCharPointer)WordFactory.nullPointer();
                    cCharPointerBinaryOutput.writeBoolean(bl);
                    BinaryProtocol.writeGuestTypedValue((BinaryOutput)cCharPointerBinaryOutput, object, hSContext.hostToGuestObjectReferences);
                    int n6 = cCharPointerBinaryOutput.getPosition();
                    JNI.JByteArray jByteArray2 = n6 <= n4 ? jByteArray : JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n6);
                    JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray2, (int)0, (int)n6, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    jNIMethodScope.setObjectResult((JNI.JObject)jByteArray2);
                }
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, THROWABLE_MARSHALLER).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            finally {
                if (cCharPointer2 != WordFactory.nullPointer() && cCharPointer2 != cCharPointer) {
                    UnmanagedMemory.free((PointerBase)cCharPointer2);
                }
            }
        }
        return (JNI.JByteArray)jNIMethodScope.getObjectResult();
    }

    @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeTruffleObject_00024CleanupReference_cleanGuestObjectReference", include=PolyglotIsolateGuestFeatureEnabled.class)
    public static void cleanGuestObjectReference(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, long l4) {
        try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeTruffleObjectEndpoint::cleanGuestObjectReference", jNIEnv);){
            HSContext hSContext = PolyglotIsolate.getHSContextByHandle(l3);
            if (hSContext != null) {
                hSContext.hostToGuestObjectReferences.releaseReference(l4);
            }
        }
        catch (Throwable throwable) {
            ForeignException.forThrowable((Throwable)throwable, THROWABLE_MARSHALLER).throwUsingJNI(jNIEnv);
        }
    }
}

