/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.polyglot.enterprise.BinaryProtocol;
import com.oracle.truffle.polyglot.enterprise.NativeContext;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.BinaryOutput;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativebridge.NativeIsolate;
import org.graalvm.nativebridge.NativeIsolateThread;
import org.graalvm.nativebridge.NativeObjectCleaner;

@ExportLibrary(value=ReflectionLibrary.class)
final class NativeTruffleObject
implements TruffleObject {
    private static final Message HAS_LANGUAGE = Message.resolve(InteropLibrary.class, (String)"hasLanguage");
    private static final Message GET_LANGUAGE = Message.resolve(InteropLibrary.class, (String)"getLanguage");
    private static final Message IS_SCOPE = Message.resolve(InteropLibrary.class, (String)"isScope");
    private static final BinaryMarshaller<Throwable> THROWABLE_MARSHALLER = PolyglotJNIConfig.getInstance().lookupMarshaller(Throwable.class, new Class[0]);
    private final long guestReferenceId;
    private final NativeContext context;

    private NativeTruffleObject(long l2, NativeContext nativeContext) {
        this.guestReferenceId = l2;
        this.context = nativeContext;
    }

    long getGuestReferenceId() {
        return this.guestReferenceId;
    }

    static NativeTruffleObject createReference(long l2, NativeContext nativeContext) {
        NativeTruffleObject nativeTruffleObject = new NativeTruffleObject(l2, nativeContext);
        new CleanupReference(nativeTruffleObject, nativeContext.getIsolate(), nativeContext.getHandle(), l2).register();
        return nativeTruffleObject;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object send(Message message, Object[] objectArray) throws UnsupportedMessageException {
        if (HAS_LANGUAGE == message || IS_SCOPE == message) {
            return false;
        }
        if (GET_LANGUAGE == message) {
            throw UnsupportedMessageException.create();
        }
        NativeIsolateThread nativeIsolateThread = this.context.getIsolate().enter();
        try {
            int n2;
            int n3;
            byte[] byArray;
            boolean bl;
            boolean bl2 = bl = objectArray.length > 0;
            if (bl) {
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = BinaryOutput.create();
                BinaryProtocol.writeHostTypedValue((BinaryOutput)byteArrayBinaryOutput, objectArray, this.context.getGuestToHostReceiver());
                byArray = byteArrayBinaryOutput.getArray();
                n3 = byteArrayBinaryOutput.getPosition();
                n2 = byArray.length;
            } else {
                byArray = null;
                n3 = 0;
                n2 = 0;
            }
            long l2 = nativeIsolateThread.getIsolateThreadId();
            long l3 = this.context.getHandle();
            byte[] byArray2 = this.guestObjectDispatch(l2, l3, this.guestReferenceId, message.getId(), byArray, n3, n2);
            if (byArray2 == null) {
                Object var13_13 = null;
                return var13_13;
            }
            BinaryInput binaryInput = BinaryInput.create((byte[])byArray2);
            boolean bl3 = binaryInput.readBoolean();
            Object object = BinaryProtocol.readHostTypedValue(binaryInput, this.context);
            if (bl3) {
                Object object2 = object;
                return object2;
            }
            try {
                throw NativeTruffleObject.throwUnchecked(RuntimeException.class, (Throwable)object);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(THROWABLE_MARSHALLER);
            }
        }
        finally {
            nativeIsolateThread.leave();
        }
    }

    private static <T extends Throwable> T throwUnchecked(Class<T> clazz, Throwable throwable) throws T {
        throw throwable;
    }

    private native byte[] guestObjectDispatch(long var1, long var3, long var5, int var7, byte[] var8, int var9, int var10);

    private static final class CleanupReference
    extends NativeObjectCleaner<Object> {
        private final long contextId;
        private final long guestObjectId;

        CleanupReference(Object object, NativeIsolate nativeIsolate, long l2, long l3) {
            super(object, nativeIsolate);
            this.contextId = l2;
            this.guestObjectId = l3;
        }

        protected void cleanUp(long l2) {
            try {
                this.cleanGuestObjectReference(l2, this.contextId, this.guestObjectId);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(THROWABLE_MARSHALLER);
            }
        }

        public String toString() {
            return "NativeTruffleObject 0x" + Long.toHexString(this.guestObjectId);
        }

        private native void cleanGuestObjectReference(long var1, long var3, long var5);
    }
}

