/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.IsolateSourceCache;
import com.oracle.truffle.polyglot.enterprise.NativeIsolateSourceCache;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateGuestFeatureEnabled;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.BinaryOutput;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativebridge.NativeIsolate;
import org.graalvm.nativebridge.NativeIsolateThread;
import org.graalvm.nativebridge.NativeObjectHandles;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.PointerBase;

final class NativeIsolateSourceCacheGen {
    NativeIsolateSourceCacheGen() {
    }

    static NativeIsolateSourceCache createHSToNative(NativeIsolate nativeIsolate, long l2) {
        return new StartPoint(nativeIsolate, l2);
    }

    static NativeIsolateSourceCache createNativeToNative(NativeIsolate nativeIsolate, long l2) {
        return new StartPoint(nativeIsolate, l2);
    }

    static NativeIsolateSourceCache create(NativeIsolate nativeIsolate, long l2) {
        if (ImageInfo.inImageCode()) {
            return NativeIsolateSourceCacheGen.createNativeToNative(nativeIsolate, l2);
        }
        return NativeIsolateSourceCacheGen.createHSToNative(nativeIsolate, l2);
    }

    private static final class StartPoint
    extends NativeIsolateSourceCache {
        private static final BinaryMarshaller<Object> objectWithSourceByValueMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        StartPoint(NativeIsolate nativeIsolate, long l2) {
            super(nativeIsolate, l2);
        }

        @Override
        public void release(long l2) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                StartPoint.release0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), l2);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        long translateImpl(Object object) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                int n2 = objectWithSourceByValueMarshaller.inferSize(object);
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = BinaryOutput.ByteArrayBinaryOutput.create((int)n2);
                objectWithSourceByValueMarshaller.write((BinaryOutput)byteArrayBinaryOutput, object);
                long l2 = StartPoint.translateImpl0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), byteArrayBinaryOutput.getArray());
                return l2;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        private static native void release0(long var0, long var2, long var4);

        private static native long translateImpl0(long var0, long var2, byte[] var4);

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            objectWithSourceByValueMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.SourceByValue.class});
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }

    private static final class EndPoint {
        private static final BinaryMarshaller<Object> objectWithSourceByValueMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeIsolateSourceCacheGen_00024StartPoint_release0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void release(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, long l4) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeIsolateSourceCacheGen::release", jNIEnv);){
                IsolateSourceCache isolateSourceCache = (IsolateSourceCache)NativeObjectHandles.resolve((long)l3, IsolateSourceCache.class);
                isolateSourceCache.release(l4);
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeIsolateSourceCacheGen_00024StartPoint_translateImpl0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static long translateImpl(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, JNI.JByteArray jByteArray) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeIsolateSourceCacheGen::translateImpl", jNIEnv);){
                long l4;
                block11: {
                    IsolateSourceCache isolateSourceCache = (IsolateSourceCache)NativeObjectHandles.resolve((long)l3, IsolateSourceCache.class);
                    CCharPointer cCharPointer = (CCharPointer)StackValue.get((int)256);
                    int n2 = JNIUtil.GetArrayLength((JNI.JNIEnv)jNIEnv, (JNI.JArray)jByteArray);
                    CCharPointer cCharPointer2 = n2 <= 256 ? cCharPointer : (CCharPointer)UnmanagedMemory.malloc((int)n2);
                    try {
                        long l5;
                        JNIUtil.GetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n2, (CCharPointer)cCharPointer2);
                        BinaryInput binaryInput = BinaryInput.create((CCharPointer)cCharPointer2, (int)n2);
                        Object object = objectWithSourceByValueMarshaller.read(binaryInput);
                        l4 = l5 = isolateSourceCache.translate(object);
                        if (cCharPointer2 == cCharPointer) break block11;
                    }
                    catch (Throwable throwable) {
                        if (cCharPointer2 != cCharPointer) {
                            UnmanagedMemory.free((PointerBase)cCharPointer2);
                        }
                        throw throwable;
                    }
                    UnmanagedMemory.free((PointerBase)cCharPointer2);
                }
                return l4;
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                return 0L;
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            objectWithSourceByValueMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.SourceByValue.class});
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

