/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.NativeExecutionListenerDispatch;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateGuestFeatureEnabled;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativebridge.NativeIsolateThread;
import org.graalvm.nativebridge.NativeObject;
import org.graalvm.nativebridge.NativeObjectHandles;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class NativeExecutionListenerDispatchGen {
    NativeExecutionListenerDispatchGen() {
    }

    static NativeExecutionListenerDispatch createHSToNative(AbstractPolyglotImpl abstractPolyglotImpl) {
        return new StartPoint(abstractPolyglotImpl);
    }

    static NativeExecutionListenerDispatch createNativeToNative(AbstractPolyglotImpl abstractPolyglotImpl) {
        return new StartPoint(abstractPolyglotImpl);
    }

    static NativeExecutionListenerDispatch create(AbstractPolyglotImpl abstractPolyglotImpl) {
        if (ImageInfo.inImageCode()) {
            return NativeExecutionListenerDispatchGen.createNativeToNative(abstractPolyglotImpl);
        }
        return NativeExecutionListenerDispatchGen.createHSToNative(abstractPolyglotImpl);
    }

    private static final class StartPoint
    extends NativeExecutionListenerDispatch {
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        StartPoint(AbstractPolyglotImpl abstractPolyglotImpl) {
            super(abstractPolyglotImpl);
        }

        @Override
        void closeExecutionListenerImpl(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                StartPoint.closeExecutionListenerImpl0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        private static native void closeExecutionListenerImpl0(long var0, long var2);

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }

    private static final class EndPoint {
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeExecutionListenerDispatchGen_00024StartPoint_closeExecutionListenerImpl0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void closeExecutionListenerImpl(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeExecutionListenerDispatchGen::closeExecutionListenerImpl", jNIEnv);){
                Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                AbstractPolyglotImpl.AbstractExecutionListenerDispatch abstractExecutionListenerDispatch = NativeExecutionListenerDispatch.resolveNativeDelegate(object);
                Object object2 = NativeExecutionListenerDispatch.resolveReceiver(object);
                abstractExecutionListenerDispatch.closeExecutionListener(object2);
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

