// CheckStyle: start generated
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.backend.spi.NFIBackendLibrary;
import com.oracle.truffle.nfi.backend.spi.types.NativeSimpleType;
import com.oracle.truffle.nfi.backend.spi.util.ProfiledArrayBuilder.ArrayBuilderFactory;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(LibFFINFIBackend.class)
@SuppressWarnings("javadoc")
final class LibFFINFIBackendGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(LibFFINFIBackend.class, new NFIBackendLibraryExports());
    }

    private LibFFINFIBackendGen() {
    }

    @GeneratedBy(LibFFINFIBackend.class)
    private static final class NFIBackendLibraryExports extends LibraryExport<NFIBackendLibrary> {

        private NFIBackendLibraryExports() {
            super(NFIBackendLibrary.class, LibFFINFIBackend.class, false, false, 0);
        }

        @Override
        protected NFIBackendLibrary createUncached(Object receiver) {
            assert receiver instanceof LibFFINFIBackend;
            NFIBackendLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected NFIBackendLibrary createCached(Object receiver) {
            assert receiver instanceof LibFFINFIBackend;
            return new Cached(receiver);
        }

        @GeneratedBy(LibFFINFIBackend.class)
        private static final class Cached extends NFIBackendLibrary {

            @Child private InteropLibrary receiverInteropLibrary_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link LibFFINFIBackend#createSignatureBuilder(LibFFINFIBackend, NFIBackendLibrary, ArrayBuilderFactory)}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LibFFINFIBackend#createSignatureBuilder(LibFFINFIBackend, NFIBackendLibrary, ArrayBuilderFactory)}
             *   Parameter: {@link ArrayBuilderFactory} builderFactory</pre>
             */
            @CompilationFinal private ArrayBuilderFactory createSignatureBuilderNode__createSignatureBuilder_builderFactory_;

            protected Cached(Object receiver) {
                LibFFINFIBackend castReceiver = ((LibFFINFIBackend) receiver) ;
                this.receiverInteropLibrary_ = INTEROP_LIBRARY_.create((castReceiver));
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof LibFFINFIBackend) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof LibFFINFIBackend)) {
                    return false;
                } else if (!this.receiverInteropLibrary_.accepts((receiver))) {
                    return false;
                } else {
                    return true;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link LibFFINFIBackend#getSimpleType(LibFFINFIBackend, NativeSimpleType, InteropLibrary)}
             *     Activation probability: 0.25000
             *     With/without class size: 7/0 bytes
             * </pre>
             */
            @Override
            public Object getSimpleType(Object arg0Value_, NativeSimpleType arg1Value) {
                assert arg0Value_ instanceof LibFFINFIBackend : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                LibFFINFIBackend arg0Value = ((LibFFINFIBackend) arg0Value_);
                {
                    InteropLibrary self__ = this.receiverInteropLibrary_;
                    return arg0Value.getSimpleType(arg1Value, self__);
                }
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link LibFFINFIBackend#getArrayType(LibFFINFIBackend, NativeSimpleType, InteropLibrary)}
             *     Activation probability: 0.25000
             *     With/without class size: 7/0 bytes
             * </pre>
             */
            @Override
            public Object getArrayType(Object arg0Value_, NativeSimpleType arg1Value) {
                assert arg0Value_ instanceof LibFFINFIBackend : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                LibFFINFIBackend arg0Value = ((LibFFINFIBackend) arg0Value_);
                {
                    InteropLibrary self__ = this.receiverInteropLibrary_;
                    return arg0Value.getArrayType(arg1Value, self__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link LibFFINFIBackend#getEnvType(LibFFINFIBackend, InteropLibrary)}
             *     Activation probability: 0.25000
             *     With/without class size: 7/0 bytes
             * </pre>
             */
            @Override
            public Object getEnvType(Object arg0Value_) {
                assert arg0Value_ instanceof LibFFINFIBackend : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                LibFFINFIBackend arg0Value = ((LibFFINFIBackend) arg0Value_);
                {
                    InteropLibrary self__ = this.receiverInteropLibrary_;
                    return arg0Value.getEnvType(self__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link LibFFINFIBackend#createSignatureBuilder(LibFFINFIBackend, NFIBackendLibrary, ArrayBuilderFactory)}
             *     Activation probability: 0.25000
             *     With/without class size: 8/4 bytes
             * </pre>
             */
            @Override
            public Object createSignatureBuilder(Object arg0Value_) {
                assert arg0Value_ instanceof LibFFINFIBackend : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                LibFFINFIBackend arg0Value = ((LibFFINFIBackend) arg0Value_);
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[LibFFINFIBackend.createSignatureBuilder(LibFFINFIBackend, NFIBackendLibrary, ArrayBuilderFactory)] */) {
                    {
                        ArrayBuilderFactory builderFactory__ = this.createSignatureBuilderNode__createSignatureBuilder_builderFactory_;
                        if (builderFactory__ != null) {
                            NFIBackendLibrary self__ = (this);
                            return arg0Value.createSignatureBuilder(self__, builderFactory__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return createSignatureBuilderNode_AndSpecialize(arg0Value);
            }

            private Object createSignatureBuilderNode_AndSpecialize(LibFFINFIBackend arg0Value) {
                int state_0 = this.state_0_;
                {
                    NFIBackendLibrary self__ = null;
                    self__ = (this);
                    ArrayBuilderFactory builderFactory__ = (ArrayBuilderFactory.create());
                    Objects.requireNonNull(builderFactory__, "Specialization 'createSignatureBuilder(LibFFINFIBackend, NFIBackendLibrary, ArrayBuilderFactory)' cache 'builderFactory' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.createSignatureBuilderNode__createSignatureBuilder_builderFactory_ = builderFactory__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[LibFFINFIBackend.createSignatureBuilder(LibFFINFIBackend, NFIBackendLibrary, ArrayBuilderFactory)] */;
                    this.state_0_ = state_0;
                    return arg0Value.createSignatureBuilder(self__, builderFactory__);
                }
            }

        }
        @GeneratedBy(LibFFINFIBackend.class)
        @DenyReplace
        private static final class Uncached extends NFIBackendLibrary {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof LibFFINFIBackend) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LibFFINFIBackend;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public Object getSimpleType(Object arg0Value_, NativeSimpleType arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LibFFINFIBackend arg0Value = ((LibFFINFIBackend) arg0Value_);
                return arg0Value.getSimpleType(arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value)));
            }

            @TruffleBoundary
            @Override
            public Object getArrayType(Object arg0Value_, NativeSimpleType arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LibFFINFIBackend arg0Value = ((LibFFINFIBackend) arg0Value_);
                return arg0Value.getArrayType(arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value)));
            }

            @TruffleBoundary
            @Override
            public Object getEnvType(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LibFFINFIBackend arg0Value = ((LibFFINFIBackend) arg0Value_);
                return arg0Value.getEnvType(INTEROP_LIBRARY_.getUncached((arg0Value)));
            }

            @TruffleBoundary
            @Override
            public Object createSignatureBuilder(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LibFFINFIBackend arg0Value = ((LibFFINFIBackend) arg0Value_);
                return arg0Value.createSignatureBuilder((this), (ArrayBuilderFactory.getUncached()));
            }

        }
    }
}
