// CheckStyle: start generated
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.provider.EagerExportProvider;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.nfi.backend.spi.BackendNativePointerLibrary;

@GeneratedBy(NativePointer.class)
public final class NativePointerGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(NativePointer.class, new BackendNativePointerLibraryExports());
    }

    private NativePointerGen() {
    }

    private static void init() {
        // This method is intended to ensure class initialization.
    }

    @GeneratedBy(NativePointer.class)
    public static final class BackendNativePointerLibraryEagerProvider implements EagerExportProvider {

        @Override
        public void ensureRegistered() {
            NativePointerGen.init();
        }

        @Override
        public String getLibraryClassName() {
            return "com.oracle.truffle.nfi.backend.spi.BackendNativePointerLibrary";
        }

    }
    @GeneratedBy(NativePointer.class)
    private static final class BackendNativePointerLibraryExports extends LibraryExport<BackendNativePointerLibrary> {

        private static final Uncached UNCACHED = new Uncached();
        private static final Cached CACHE = new Cached();

        private BackendNativePointerLibraryExports() {
            super(BackendNativePointerLibrary.class, NativePointer.class, false, true, 1);
        }

        @Override
        protected BackendNativePointerLibrary createUncached(Object receiver) {
            assert receiver instanceof NativePointer;
            BackendNativePointerLibrary uncached = BackendNativePointerLibraryExports.UNCACHED;
            return uncached;
        }

        @Override
        protected BackendNativePointerLibrary createCached(Object receiver) {
            assert receiver instanceof NativePointer || receiver instanceof LibraryExport<?>;
            return BackendNativePointerLibraryExports.CACHE;
        }

        @GeneratedBy(NativePointer.class)
        private static final class Cached extends BackendNativePointerLibrary implements UnadoptableNode {

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof NativePointer) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NativePointer;
            }

            @Override
            public boolean isPointer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((NativePointer) receiver)).isPointer();
            }

            @Override
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((NativePointer) receiver)).asPointer();
            }

        }
        @GeneratedBy(NativePointer.class)
        @DenyReplace
        private static final class Uncached extends BackendNativePointerLibrary implements UnadoptableNode {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof NativePointer) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NativePointer;
            }

            @TruffleBoundary
            @Override
            public boolean isPointer(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer) receiver) .isPointer();
            }

            @TruffleBoundary
            @Override
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer) receiver) .asPointer();
            }

        }
    }
}
