// CheckStyle: start generated
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.RequiredField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.nfi.backend.libffi.LibFFISignature.CachedSignatureInfo;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link FunctionExecuteNode#cachedSignature}
 *     Activation probability: 0.65000
 *     With/without class size: 22/8 bytes
 *   Specialization {@link FunctionExecuteNode#genericExecute}
 *     Activation probability: 0.35000
 *     With/without class size: 11/4 bytes
 * </pre> */
@GeneratedBy(FunctionExecuteNode.class)
@SuppressWarnings("javadoc")
final class FunctionExecuteNodeGen {

    private static final Uncached UNCACHED = new Uncached();

    @NeverDefault
    public static FunctionExecuteNode getUncached() {
        return FunctionExecuteNodeGen.UNCACHED;
    }

    /**
     * Required Fields: <ul>
     * <li>{@link Inlined#state_0_}
     * <li>{@link Inlined#cachedSignature_cache}
     * <li>{@link Inlined#genericExecute_execute_}
     * </ul> */
    @NeverDefault
    public static FunctionExecuteNode inline(@RequiredField(bits = 3, value = StateField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class) InlineTarget target) {
        return new FunctionExecuteNodeGen.Inlined(target);
    }

    @GeneratedBy(FunctionExecuteNode.class)
    @DenyReplace
    private static final class Inlined extends FunctionExecuteNode implements UnadoptableNode, GenerateAOT.Provider {

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link FunctionExecuteNode#cachedSignature}
         *   2: SpecializationActive {@link FunctionExecuteNode#genericExecute}
         * </pre> */
        private final StateField state_0_;
        private final ReferenceField<CachedSignatureData> cachedSignature_cache;
        private final ReferenceField<IndirectCallNode> genericExecute_execute_;

        @SuppressWarnings("unchecked")
        private Inlined(InlineTarget target) {
            assert target.getTargetClass().isAssignableFrom(FunctionExecuteNode.class);
            this.state_0_ = target.getState(0, 3);
            this.cachedSignature_cache = target.getReference(1, CachedSignatureData.class);
            this.genericExecute_execute_ = target.getReference(2, IndirectCallNode.class);
        }

        @ExplodeLoop
        @Override
        public Object execute(Node arg0Value, long arg1Value, LibFFISignature arg2Value, Object[] arg3Value) throws ArityException, UnsupportedTypeException {
            int state_0 = this.state_0_.get(arg0Value);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[FunctionExecuteNode.cachedSignature(long, LibFFISignature, Object[], CachedSignatureInfo, DirectCallNode)] || SpecializationActive[FunctionExecuteNode.genericExecute(long, LibFFISignature, Object[], IndirectCallNode)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[FunctionExecuteNode.cachedSignature(long, LibFFISignature, Object[], CachedSignatureInfo, DirectCallNode)] */) {
                    CachedSignatureData s0_ = this.cachedSignature_cache.get(arg0Value);
                    while (s0_ != null) {
                        if ((arg2Value.signatureInfo == s0_.cachedInfo_)) {
                            return cachedSignature(arg1Value, arg2Value, arg3Value, s0_.cachedInfo_, s0_.execute_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[FunctionExecuteNode.genericExecute(long, LibFFISignature, Object[], IndirectCallNode)] */) {
                    {
                        IndirectCallNode execute__ = this.genericExecute_execute_.get(arg0Value);
                        if (execute__ != null) {
                            return FunctionExecuteNode.genericExecute(arg1Value, arg2Value, arg3Value, execute__);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        private Object executeAndSpecialize(Node arg0Value, long arg1Value, LibFFISignature arg2Value, Object[] arg3Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_(arg0Value);
                state_0 = this.state_0_.get(arg0Value);
            }
            if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[FunctionExecuteNode.genericExecute(long, LibFFISignature, Object[], IndirectCallNode)] */) {
                while (true) {
                    int count0_ = 0;
                    CachedSignatureData s0_ = this.cachedSignature_cache.getVolatile(arg0Value);
                    CachedSignatureData s0_original = s0_;
                    while (s0_ != null) {
                        if ((arg2Value.signatureInfo == s0_.cachedInfo_)) {
                            break;
                        }
                        count0_++;
                        s0_ = s0_.next_;
                    }
                    if (s0_ == null) {
                        // assert (arg2Value.signatureInfo == s0_.cachedInfo_);
                        if (count0_ < (3)) {
                            s0_ = arg0Value.insert(new CachedSignatureData(s0_original));
                            s0_.cachedInfo_ = (arg2Value.signatureInfo);
                            DirectCallNode execute__1 = s0_.insert((FunctionExecuteNode.createCachedSignatureCall(s0_.cachedInfo_)));
                            Objects.requireNonNull(execute__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s0_.execute_ = execute__1;
                            if (!this.cachedSignature_cache.compareAndSet(arg0Value, s0_original, s0_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b10 /* add SpecializationActive[FunctionExecuteNode.cachedSignature(long, LibFFISignature, Object[], CachedSignatureInfo, DirectCallNode)] */;
                            this.state_0_.set(arg0Value, state_0);
                        }
                    }
                    if (s0_ != null) {
                        return cachedSignature(arg1Value, arg2Value, arg3Value, s0_.cachedInfo_, s0_.execute_);
                    }
                    break;
                }
            }
            VarHandle.storeStoreFence();
            this.genericExecute_execute_.set(arg0Value, arg0Value.insert((IndirectCallNode.create())));
            this.cachedSignature_cache.set(arg0Value, null);
            state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[FunctionExecuteNode.cachedSignature(long, LibFFISignature, Object[], CachedSignatureInfo, DirectCallNode)] */;
            state_0 = state_0 | 0b100 /* add SpecializationActive[FunctionExecuteNode.genericExecute(long, LibFFISignature, Object[], IndirectCallNode)] */;
            this.state_0_.set(arg0Value, state_0);
            return FunctionExecuteNode.genericExecute(arg1Value, arg2Value, arg3Value, this.genericExecute_execute_.get(arg0Value));
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root, Node arg0Value) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_.get(arg0Value) & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                VarHandle.storeStoreFence();
                this.genericExecute_execute_.set(arg0Value, arg0Value.insert((IndirectCallNode.create())));
                this.cachedSignature_cache.set(arg0Value, null);
                this.state_0_.set(arg0Value, state_0_.get(arg0Value) & 0xfffffffd /* remove SpecializationActive[FunctionExecuteNode.cachedSignature(long, LibFFISignature, Object[], CachedSignatureInfo, DirectCallNode)] */);
                this.state_0_.set(arg0Value, state_0_.get(arg0Value) | 0b100 /* add SpecializationActive[FunctionExecuteNode.genericExecute(long, LibFFISignature, Object[], IndirectCallNode)] */);
            }
            int state_0 = this.state_0_.get(arg0Value);
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_.set(arg0Value, state_0);
        }

        private void resetAOT_(Node arg0Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_.set(arg0Value, 0);
            this.genericExecute_execute_.set(arg0Value, null);
        }

    }
    @GeneratedBy(FunctionExecuteNode.class)
    @DenyReplace
    private static final class CachedSignatureData extends Node implements SpecializationDataNode {

        @Child CachedSignatureData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link FunctionExecuteNode#cachedSignature}
         *   Parameter: {@link CachedSignatureInfo} cachedInfo</pre> */
        @CompilationFinal CachedSignatureInfo cachedInfo_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link FunctionExecuteNode#cachedSignature}
         *   Parameter: {@link DirectCallNode} execute</pre> */
        @Child DirectCallNode execute_;

        CachedSignatureData(CachedSignatureData next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(FunctionExecuteNode.class)
    @DenyReplace
    private static final class Uncached extends FunctionExecuteNode implements UnadoptableNode {

        @TruffleBoundary
        @Override
        public Object execute(Node arg0Value, long arg1Value, LibFFISignature arg2Value, Object[] arg3Value) throws ArityException, UnsupportedTypeException {
            return FunctionExecuteNode.genericExecute(arg1Value, arg2Value, arg3Value, (IndirectCallNode.getUncached()));
        }

    }
}
