// CheckStyle: start generated
package com.oracle.truffle.nfi.backend.panama;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.nfi.backend.spi.NFIBackendLibrary;
import com.oracle.truffle.nfi.backend.spi.types.NativeSimpleType;
import com.oracle.truffle.nfi.backend.spi.util.ProfiledArrayBuilder.ArrayBuilderFactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(PanamaNFIBackend.class)
@SuppressWarnings("javadoc")
final class PanamaNFIBackendGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(PanamaNFIBackend.class, new NFIBackendLibraryExports());
    }

    private PanamaNFIBackendGen() {
    }

    @GeneratedBy(PanamaNFIBackend.class)
    private static final class NFIBackendLibraryExports extends LibraryExport<NFIBackendLibrary> {

        private NFIBackendLibraryExports() {
            super(NFIBackendLibrary.class, PanamaNFIBackend.class, false, false, 0);
        }

        @Override
        protected NFIBackendLibrary createUncached(Object receiver) {
            assert receiver instanceof PanamaNFIBackend;
            NFIBackendLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected NFIBackendLibrary createCached(Object receiver) {
            assert receiver instanceof PanamaNFIBackend;
            return new Cached(receiver);
        }

        @GeneratedBy(PanamaNFIBackend.class)
        private static final class Cached extends NFIBackendLibrary {

            private static final StateField STATE_0_CreateSignatureBuilderNode__UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link PanamaNFIBackend#createSignatureBuilder(PanamaNFIBackend, NFIBackendLibrary, Node, InlinedBranchProfile, ArrayBuilderFactory)}
             *   Parameter: {@link InlinedBranchProfile} error
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_CREATE_SIGNATURE_BUILDER_NODE__CREATE_SIGNATURE_BUILDER_ERROR_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_CreateSignatureBuilderNode__UPDATER.subUpdater(1, 1)));

            @Child private InteropLibrary receiverInteropLibrary_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link PanamaNFIBackend#createSignatureBuilder(PanamaNFIBackend, NFIBackendLibrary, Node, InlinedBranchProfile, ArrayBuilderFactory)}
             *   1: InlinedCache
             *        Specialization: {@link PanamaNFIBackend#createSignatureBuilder}
             *        Parameter: {@link InlinedBranchProfile} error
             *        Inline method: {@link InlinedBranchProfile#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link PanamaNFIBackend#createSignatureBuilder(PanamaNFIBackend, NFIBackendLibrary, Node, InlinedBranchProfile, ArrayBuilderFactory)}
             *   Parameter: {@link ArrayBuilderFactory} builderFactory</pre> */
            @CompilationFinal private ArrayBuilderFactory createSignatureBuilderNode__createSignatureBuilder_builderFactory_;

            protected Cached(Object receiver) {
                PanamaNFIBackend castReceiver = ((PanamaNFIBackend) receiver) ;
                this.receiverInteropLibrary_ = INTEROP_LIBRARY_.create((castReceiver));
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof PanamaNFIBackend) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof PanamaNFIBackend)) {
                    return false;
                } else if (!this.receiverInteropLibrary_.accepts((receiver))) {
                    return false;
                } else {
                    return true;
                }
            }

            @Override
            public Object getSimpleType(Object receiver, NativeSimpleType type) {
                assert receiver instanceof PanamaNFIBackend : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (((PanamaNFIBackend) receiver)).getSimpleType(type);
            }

            @Override
            public Object getArrayType(Object receiver, NativeSimpleType type) {
                assert receiver instanceof PanamaNFIBackend : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (((PanamaNFIBackend) receiver)).getArrayType(type);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PanamaNFIBackend#getEnvType(PanamaNFIBackend, InteropLibrary)}
             *     Activation probability: 0.50000
             *     With/without class size: 10/0 bytes
             * </pre> */
            @Override
            public Object getEnvType(Object arg0Value_) {
                assert arg0Value_ instanceof PanamaNFIBackend : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PanamaNFIBackend arg0Value = ((PanamaNFIBackend) arg0Value_);
                {
                    InteropLibrary self__ = this.receiverInteropLibrary_;
                    return arg0Value.getEnvType(self__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PanamaNFIBackend#createSignatureBuilder(PanamaNFIBackend, NFIBackendLibrary, Node, InlinedBranchProfile, ArrayBuilderFactory)}
             *     Activation probability: 0.50000
             *     With/without class size: 16/5 bytes
             * </pre> */
            @Override
            public Object createSignatureBuilder(Object arg0Value_) {
                assert arg0Value_ instanceof PanamaNFIBackend : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PanamaNFIBackend arg0Value = ((PanamaNFIBackend) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[PanamaNFIBackend.createSignatureBuilder(PanamaNFIBackend, NFIBackendLibrary, Node, InlinedBranchProfile, ArrayBuilderFactory)] */) {
                    {
                        ArrayBuilderFactory builderFactory__ = this.createSignatureBuilderNode__createSignatureBuilder_builderFactory_;
                        if (builderFactory__ != null) {
                            NFIBackendLibrary self__ = (this);
                            Node node__ = (this);
                            return arg0Value.createSignatureBuilder(self__, node__, INLINED_CREATE_SIGNATURE_BUILDER_NODE__CREATE_SIGNATURE_BUILDER_ERROR_, builderFactory__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return createSignatureBuilderNode_AndSpecialize(arg0Value);
            }

            private Object createSignatureBuilderNode_AndSpecialize(PanamaNFIBackend arg0Value) {
                int state_0 = this.state_0_;
                {
                    Node node__ = null;
                    NFIBackendLibrary self__ = null;
                    self__ = (this);
                    node__ = (this);
                    ArrayBuilderFactory builderFactory__ = (ArrayBuilderFactory.create());
                    Objects.requireNonNull(builderFactory__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.createSignatureBuilderNode__createSignatureBuilder_builderFactory_ = builderFactory__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[PanamaNFIBackend.createSignatureBuilder(PanamaNFIBackend, NFIBackendLibrary, Node, InlinedBranchProfile, ArrayBuilderFactory)] */;
                    this.state_0_ = state_0;
                    return arg0Value.createSignatureBuilder(self__, node__, INLINED_CREATE_SIGNATURE_BUILDER_NODE__CREATE_SIGNATURE_BUILDER_ERROR_, builderFactory__);
                }
            }

        }
        @GeneratedBy(PanamaNFIBackend.class)
        @DenyReplace
        private static final class Uncached extends NFIBackendLibrary implements UnadoptableNode {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof PanamaNFIBackend) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof PanamaNFIBackend;
            }

            @TruffleBoundary
            @Override
            public Object getSimpleType(Object receiver, NativeSimpleType type) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PanamaNFIBackend) receiver) .getSimpleType(type);
            }

            @TruffleBoundary
            @Override
            public Object getArrayType(Object receiver, NativeSimpleType type) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PanamaNFIBackend) receiver) .getArrayType(type);
            }

            @TruffleBoundary
            @Override
            public Object getEnvType(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PanamaNFIBackend arg0Value = ((PanamaNFIBackend) arg0Value_);
                return arg0Value.getEnvType(INTEROP_LIBRARY_.getUncached((arg0Value)));
            }

            @TruffleBoundary
            @Override
            public Object createSignatureBuilder(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PanamaNFIBackend arg0Value = ((PanamaNFIBackend) arg0Value_);
                return arg0Value.createSignatureBuilder((this), (this), (InlinedBranchProfile.getUncached()), (ArrayBuilderFactory.getUncached()));
            }

        }
    }
}
