package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.ForeignAccess.Factory;
import com.oracle.truffle.api.interop.ForeignAccess.StandardFactory;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.RootNode;

/**
 * This foreign access factory is generated by {@link com.oracle.truffle.nfi.NFILibrary.Keys}.
 * You are supposed to use it for the receiver object {@link com.oracle.truffle.nfi.NFILibrary.Keys}.
 */
final class KeysForeign implements StandardFactory, Factory {
    public static final ForeignAccess ACCESS = ForeignAccess.create(new KeysForeign(), null);
    @Deprecated public static ForeignAccess createAccess() { return ForeignAccess.create(new KeysForeign(), null); }

    private KeysForeign() { }

    @Override
    public boolean canHandle(TruffleObject obj) {
        return com.oracle.truffle.nfi.NFILibrary.Keys.isInstance(obj);
    }

    @Override
    public CallTarget accessIsNull() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsExecutable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsInstantiable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsBoxed() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessHasKeys() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessHasSize() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(true));
    }
    @Override
    public CallTarget accessGetSize() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(GetSizeSubNode.createRoot());
    }
    @Override
    public CallTarget accessUnbox() {
      return null;
    }
    @Override
    public CallTarget accessRead() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(ReadSubNode.createRoot());
    }
    @Override
    public CallTarget accessWrite() {
      return null;
    }
    @Override
    public CallTarget accessRemove() {
      return null;
    }
    @Override
    public CallTarget accessExecute(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessInvoke(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessNew(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessKeyInfo() {
      return null;
    }
    @Override
    public CallTarget accessKeys() {
      return null;
    }
    @Override
    public CallTarget accessIsPointer() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessAsPointer() {
      return null;
    }
    @Override
    public CallTarget accessToNative() {
      return null;
    }
    @Override
    public CallTarget accessMessage(Message unknown) {
      return null;
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.NFILibrary.Keys.Read}.
     */
    abstract static class ReadSubNode extends com.oracle.truffle.nfi.NFILibrary.Keys.Read {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.NFILibrary.Keys receiver, int index) {
            return access(receiver, index);
        }
        private static final class READRootNode extends RootNode {
            protected READRootNode() {
                super(null);
            }

            @Child private ReadSubNode node = com.oracle.truffle.nfi.KeysForeignFactory.ReadSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::READ::" + com.oracle.truffle.nfi.NFILibrary.Keys.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                Object identifier = frame.getArguments()[1];
                try {
                    return node.executeWithTarget(frame, receiver, identifier);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof ReadSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new READRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.NFILibrary.Keys.GetSize}.
     */
    abstract static class GetSizeSubNode extends com.oracle.truffle.nfi.NFILibrary.Keys.GetSize {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.NFILibrary.Keys receiver) {
            return access(receiver);
        }
        private static final class GET_SIZERootNode extends RootNode {
            protected GET_SIZERootNode() {
                super(null);
            }

            @Child private GetSizeSubNode node = com.oracle.truffle.nfi.KeysForeignFactory.GetSizeSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::GET_SIZE::" + com.oracle.truffle.nfi.NFILibrary.Keys.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof GetSizeSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new GET_SIZERootNode();
        }
    }
}
