package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.ForeignAccess.Factory;
import com.oracle.truffle.api.interop.ForeignAccess.StandardFactory;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.RootNode;

/**
 * This foreign access factory is generated by {@link com.oracle.truffle.nfi.NFILibraryMessageResolution}.
 * You are supposed to use it for the receiver object {@link com.oracle.truffle.nfi.NFILibrary}.
 */
final class NFILibraryMessageResolutionForeign implements StandardFactory, Factory {
    public static final ForeignAccess ACCESS = ForeignAccess.create(new NFILibraryMessageResolutionForeign(), CanResolveNFILibrarySubNode.createRoot());
    @Deprecated public static ForeignAccess createAccess() { return ForeignAccess.create(new NFILibraryMessageResolutionForeign(), CanResolveNFILibrarySubNode.createRoot()); }

    private NFILibraryMessageResolutionForeign() { }

    @Override
    @TruffleBoundary
    public boolean canHandle(TruffleObject obj) {
        return (boolean) Truffle.getRuntime().createCallTarget(CanResolveNFILibrarySubNode.createRoot()).call(obj);
    }

    @Override
    public CallTarget accessIsNull() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsExecutable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsInstantiable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsBoxed() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessHasKeys() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(true));
    }
    @Override
    public CallTarget accessHasSize() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessGetSize() {
      return null;
    }
    @Override
    public CallTarget accessUnbox() {
      return null;
    }
    @Override
    public CallTarget accessRead() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(LookupSymbolSubNode.createRoot());
    }
    @Override
    public CallTarget accessWrite() {
      return null;
    }
    @Override
    public CallTarget accessRemove() {
      return null;
    }
    @Override
    public CallTarget accessExecute(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessInvoke(int argumentsLength) {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(InvokeSymbolSubNode.createRoot());
    }
    @Override
    public CallTarget accessNew(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessKeyInfo() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(KeyInfoSubNode.createRoot());
    }
    @Override
    public CallTarget accessKeys() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(KeysSubNode.createRoot());
    }
    @Override
    public CallTarget accessIsPointer() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessAsPointer() {
      return null;
    }
    @Override
    public CallTarget accessToNative() {
      return null;
    }
    @Override
    public CallTarget accessMessage(Message unknown) {
      return null;
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.NFILibraryMessageResolution.InvokeSymbolNode}.
     */
    abstract static class InvokeSymbolSubNode extends com.oracle.truffle.nfi.NFILibraryMessageResolution.InvokeSymbolNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1, Object o2);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.NFILibrary receiver, java.lang.String symbol, java.lang.Object[] args) {
            return access(receiver, symbol, args);
        }
        private static final class INVOKERootNode extends RootNode {
            protected INVOKERootNode() {
                super(null);
            }

            @Child private InvokeSymbolSubNode node = com.oracle.truffle.nfi.NFILibraryMessageResolutionForeignFactory.InvokeSymbolSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::INVOKE::" + com.oracle.truffle.nfi.NFILibrary.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                Object[] arguments = frame.getArguments();
                Object identifier = arguments[1];
                Object[] args = new Object[arguments.length - 2];
                for (int i = 0; i < arguments.length - 2; i++) {
                    args[i] = arguments[i + 2];
                }
                try {
                    return node.executeWithTarget(frame, receiver, identifier, args);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof InvokeSymbolSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }
        }

        public static RootNode createRoot() {
            return new INVOKERootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.NFILibraryMessageResolution.KeyInfoNode}.
     */
    abstract static class KeyInfoSubNode extends com.oracle.truffle.nfi.NFILibraryMessageResolution.KeyInfoNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.NFILibrary receiver, java.lang.Object arg) {
            return access(receiver, arg);
        }
        private static final class KEY_INFORootNode extends RootNode {
            protected KEY_INFORootNode() {
                super(null);
            }

            @Child private KeyInfoSubNode node = com.oracle.truffle.nfi.NFILibraryMessageResolutionForeignFactory.KeyInfoSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::KEY_INFO::" + com.oracle.truffle.nfi.NFILibrary.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                Object identifier = frame.getArguments()[1];
                try {
                    return node.executeWithTarget(frame, receiver, identifier);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof KeyInfoSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new KEY_INFORootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.NFILibraryMessageResolution.LookupSymbolNode}.
     */
    abstract static class LookupSymbolSubNode extends com.oracle.truffle.nfi.NFILibraryMessageResolution.LookupSymbolNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.NFILibrary receiver, java.lang.Object symbol) {
            return access(receiver, symbol);
        }
        private static final class READRootNode extends RootNode {
            protected READRootNode() {
                super(null);
            }

            @Child private LookupSymbolSubNode node = com.oracle.truffle.nfi.NFILibraryMessageResolutionForeignFactory.LookupSymbolSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::READ::" + com.oracle.truffle.nfi.NFILibrary.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                Object identifier = frame.getArguments()[1];
                try {
                    return node.executeWithTarget(frame, receiver, identifier);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof LookupSymbolSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new READRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.NFILibraryMessageResolution.KeysNode}.
     */
    abstract static class KeysSubNode extends com.oracle.truffle.nfi.NFILibraryMessageResolution.KeysNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.NFILibrary receiver) {
            return access(receiver);
        }
        private static final class KEYSRootNode extends RootNode {
            protected KEYSRootNode() {
                super(null);
            }

            @Child private KeysSubNode node = com.oracle.truffle.nfi.NFILibraryMessageResolutionForeignFactory.KeysSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::KEYS::" + com.oracle.truffle.nfi.NFILibrary.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof KeysSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new KEYSRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.NFILibraryMessageResolution.CanResolveNFILibrary}.
     * Generated for {@link com.oracle.truffle.nfi.NFILibrary}.
     */
    abstract static class CanResolveNFILibrarySubNode extends com.oracle.truffle.nfi.NFILibraryMessageResolution.CanResolveNFILibrary {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o);
        @Specialization
        protected Object testWithTarget(com.oracle.truffle.api.interop.TruffleObject receiver) {
            return test(receiver);
        }
        private static final class LanguageCheckRootNode extends RootNode {
            protected LanguageCheckRootNode() {
                super(null);
            }

            @Child private CanResolveNFILibrarySubNode node = com.oracle.truffle.nfi.NFILibraryMessageResolutionForeignFactory.CanResolveNFILibrarySubNodeGen.create();
            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof CanResolveNFILibrarySubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new LanguageCheckRootNode();
        }
    }
}
