package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.ForeignAccess.Factory;
import com.oracle.truffle.api.interop.ForeignAccess.StandardFactory;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.RootNode;

/**
 * This foreign access factory is generated by {@link com.oracle.truffle.nfi.impl.LibFFIClosureMessageResolution}.
 * You are supposed to use it for the receiver object {@link com.oracle.truffle.nfi.impl.LibFFIClosure}.
 */
final class LibFFIClosureMessageResolutionForeign implements StandardFactory, Factory {
    public static final ForeignAccess ACCESS = ForeignAccess.create(new LibFFIClosureMessageResolutionForeign(), CanResolveLibFFIClosureSubNode.createRoot());
    @Deprecated public static ForeignAccess createAccess() { return ForeignAccess.create(new LibFFIClosureMessageResolutionForeign(), CanResolveLibFFIClosureSubNode.createRoot()); }

    private LibFFIClosureMessageResolutionForeign() { }

    @Override
    @TruffleBoundary
    public boolean canHandle(TruffleObject obj) {
        return (boolean) Truffle.getRuntime().createCallTarget(CanResolveLibFFIClosureSubNode.createRoot()).call(obj);
    }

    @Override
    public CallTarget accessIsNull() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsExecutable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsInstantiable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsBoxed() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessHasKeys() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessHasSize() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessGetSize() {
      return null;
    }
    @Override
    public CallTarget accessUnbox() {
      return null;
    }
    @Override
    public CallTarget accessRead() {
      return null;
    }
    @Override
    public CallTarget accessWrite() {
      return null;
    }
    @Override
    public CallTarget accessRemove() {
      return null;
    }
    @Override
    public CallTarget accessExecute(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessInvoke(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessNew(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessKeyInfo() {
      return null;
    }
    @Override
    public CallTarget accessKeys() {
      return null;
    }
    @Override
    public CallTarget accessIsPointer() {
      return Truffle.getRuntime().createCallTarget(IsNativeClosureSubNode.createRoot());
    }
    @Override
    public CallTarget accessAsPointer() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(AsNativeClosureSubNode.createRoot());
    }
    @Override
    public CallTarget accessToNative() {
      return null;
    }
    @Override
    public CallTarget accessMessage(Message unknown) {
      return null;
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.LibFFIClosureMessageResolution.AsNativeClosureNode}.
     */
    abstract static class AsNativeClosureSubNode extends com.oracle.truffle.nfi.impl.LibFFIClosureMessageResolution.AsNativeClosureNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.impl.LibFFIClosure receiver) {
            return access(receiver);
        }
        private static final class AS_POINTERRootNode extends RootNode {
            protected AS_POINTERRootNode() {
                super(null);
            }

            @Child private AsNativeClosureSubNode node = com.oracle.truffle.nfi.impl.LibFFIClosureMessageResolutionForeignFactory.AsNativeClosureSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::AS_POINTER::" + com.oracle.truffle.nfi.impl.LibFFIClosure.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof AsNativeClosureSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new AS_POINTERRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.LibFFIClosureMessageResolution.IsNativeClosureNode}.
     */
    abstract static class IsNativeClosureSubNode extends com.oracle.truffle.nfi.impl.LibFFIClosureMessageResolution.IsNativeClosureNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.impl.LibFFIClosure receiver) {
            return access(receiver);
        }
        private static final class IS_POINTERRootNode extends RootNode {
            protected IS_POINTERRootNode() {
                super(null);
            }

            @Child private IsNativeClosureSubNode node = com.oracle.truffle.nfi.impl.LibFFIClosureMessageResolutionForeignFactory.IsNativeClosureSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::IS_POINTER::" + com.oracle.truffle.nfi.impl.LibFFIClosure.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof IsNativeClosureSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new IS_POINTERRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.LibFFIClosureMessageResolution.CanResolveLibFFIClosureNode}.
     * Generated for {@link com.oracle.truffle.nfi.impl.LibFFIClosure}.
     */
    abstract static class CanResolveLibFFIClosureSubNode extends com.oracle.truffle.nfi.impl.LibFFIClosureMessageResolution.CanResolveLibFFIClosureNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o);
        @Specialization
        protected Object testWithTarget(com.oracle.truffle.api.interop.TruffleObject receiver) {
            return test(receiver);
        }
        private static final class LanguageCheckRootNode extends RootNode {
            protected LanguageCheckRootNode() {
                super(null);
            }

            @Child private CanResolveLibFFIClosureSubNode node = com.oracle.truffle.nfi.impl.LibFFIClosureMessageResolutionForeignFactory.CanResolveLibFFIClosureSubNodeGen.create();
            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof CanResolveLibFFIClosureSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new LanguageCheckRootNode();
        }
    }
}
