// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.NativeString;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary;

@GeneratedBy(NativeString.class)
final class NativeStringGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(NativeString.class, new InteropLibraryExports(), new SerializeArgumentLibraryExports());
    }

    private NativeStringGen() {
    }

    @GeneratedBy(NativeString.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, NativeString.class, false);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof NativeString;
            return new Uncached(receiver);
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof NativeString;
            return new Cached(receiver);
        }

        @GeneratedBy(NativeString.class)
        private static final class Cached extends InteropLibrary {

            private final Class<? extends NativeString> receiverClass_;

            Cached(Object receiver) {
                this.receiverClass_ = ((NativeString) receiver).getClass();
            }

            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.nfi.impl.NativeString'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            public boolean isNull(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (CompilerDirectives.castExact(receiver, receiverClass_)).isNull();
            }

            @Override
            public boolean isString(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (CompilerDirectives.castExact(receiver, receiverClass_)).isString();
            }

            @Override
            public String asString(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (CompilerDirectives.castExact(receiver, receiverClass_)).asString();
            }

            @Override
            public boolean isPointer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (CompilerDirectives.castExact(receiver, receiverClass_)).isPointer();
            }

            @Override
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (CompilerDirectives.castExact(receiver, receiverClass_)).asPointer();
            }

            @Override
            public void toNative(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                (CompilerDirectives.castExact(receiver, receiverClass_)).toNative();
                return;
            }

        }
        @GeneratedBy(NativeString.class)
        private static final class Uncached extends InteropLibrary {

            private final Class<? extends NativeString> receiverClass_;

            Uncached(Object receiver) {
                this.receiverClass_ = ((NativeString) receiver).getClass();
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.nfi.impl.NativeString'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean isNull(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativeString) receiver) .isNull();
            }

            @TruffleBoundary
            @Override
            public boolean isString(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativeString) receiver) .isString();
            }

            @TruffleBoundary
            @Override
            public String asString(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativeString) receiver) .asString();
            }

            @TruffleBoundary
            @Override
            public boolean isPointer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativeString) receiver) .isPointer();
            }

            @TruffleBoundary
            @Override
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativeString) receiver) .asPointer();
            }

            @TruffleBoundary
            @Override
            public void toNative(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                ((NativeString) receiver) .toNative();
                return;
            }

        }
    }
    @GeneratedBy(NativeString.class)
    private static final class SerializeArgumentLibraryExports extends LibraryExport<SerializeArgumentLibrary> {

        private SerializeArgumentLibraryExports() {
            super(SerializeArgumentLibrary.class, NativeString.class, false);
        }

        @Override
        protected SerializeArgumentLibrary createUncached(Object receiver) {
            assert receiver instanceof NativeString;
            return new Uncached(receiver);
        }

        @Override
        protected SerializeArgumentLibrary createCached(Object receiver) {
            assert receiver instanceof NativeString;
            return new Cached(receiver);
        }

        @GeneratedBy(NativeString.class)
        private static final class Cached extends SerializeArgumentLibrary {

            private final Class<? extends NativeString> receiverClass_;

            Cached(Object receiver) {
                this.receiverClass_ = ((NativeString) receiver).getClass();
            }

            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.nfi.impl.NativeString'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            public void putPointer(Object receiver, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                (CompilerDirectives.castExact(receiver, receiverClass_)).putPointer(buffer, ptrSize);
                return;
            }

            @Override
            public void putString(Object receiver, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                (CompilerDirectives.castExact(receiver, receiverClass_)).putPointer(buffer, ptrSize);
                return;
            }

        }
        @GeneratedBy(NativeString.class)
        private static final class Uncached extends SerializeArgumentLibrary {

            private final Class<? extends NativeString> receiverClass_;

            Uncached(Object receiver) {
                this.receiverClass_ = ((NativeString) receiver).getClass();
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.nfi.impl.NativeString'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public void putPointer(Object receiver, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                ((NativeString) receiver) .putPointer(buffer, ptrSize);
                return;
            }

            @TruffleBoundary
            @Override
            public void putString(Object receiver, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                ((NativeString) receiver) .putPointer(buffer, ptrSize);
                return;
            }

        }
    }
}
