// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.ExplodeLoop.LoopExplosionKind;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary.BooleanArrayConversion;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary.ByteArrayConversion;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary.CharArrayConversion;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary.CharConversion;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary.DefaultConversion;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary.DoubleArrayConversion;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary.FloatArrayConversion;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary.IntArrayConversion;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary.LongArrayConversion;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary.ShortArrayConversion;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.locks.Lock;

@GeneratedBy(SerializeArgumentLibrary.class)
final class SerializeArgumentLibraryGen extends LibraryFactory<SerializeArgumentLibrary> {

    private static final Class<SerializeArgumentLibrary> LIBRARY_CLASS = SerializeArgumentLibraryGen.lazyLibraryClass();
    private static final Message PUT_BYTE = new MessageImpl("putByte", 0, void.class, Object.class, NativeArgumentBuffer.class);
    private static final Message PUT_U_BYTE = new MessageImpl("putUByte", 1, void.class, Object.class, NativeArgumentBuffer.class);
    private static final Message PUT_SHORT = new MessageImpl("putShort", 2, void.class, Object.class, NativeArgumentBuffer.class);
    private static final Message PUT_U_SHORT = new MessageImpl("putUShort", 3, void.class, Object.class, NativeArgumentBuffer.class);
    private static final Message PUT_INT = new MessageImpl("putInt", 4, void.class, Object.class, NativeArgumentBuffer.class);
    private static final Message PUT_U_INT = new MessageImpl("putUInt", 5, void.class, Object.class, NativeArgumentBuffer.class);
    private static final Message PUT_LONG = new MessageImpl("putLong", 6, void.class, Object.class, NativeArgumentBuffer.class);
    private static final Message PUT_U_LONG = new MessageImpl("putULong", 7, void.class, Object.class, NativeArgumentBuffer.class);
    private static final Message PUT_FLOAT = new MessageImpl("putFloat", 8, void.class, Object.class, NativeArgumentBuffer.class);
    private static final Message PUT_DOUBLE = new MessageImpl("putDouble", 9, void.class, Object.class, NativeArgumentBuffer.class);
    private static final Message PUT_POINTER = new MessageImpl("putPointer", 10, void.class, Object.class, NativeArgumentBuffer.class, int.class);
    private static final Message PUT_STRING = new MessageImpl("putString", 11, void.class, Object.class, NativeArgumentBuffer.class, int.class);
    private static final SerializeArgumentLibraryGen INSTANCE = new SerializeArgumentLibraryGen();

    static  {
        LibraryFactory.register(SerializeArgumentLibraryGen.LIBRARY_CLASS, INSTANCE);
    }

    private SerializeArgumentLibraryGen() {
        super(SerializeArgumentLibraryGen.LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(SerializeArgumentLibraryGen.PUT_BYTE, SerializeArgumentLibraryGen.PUT_U_BYTE, SerializeArgumentLibraryGen.PUT_SHORT, SerializeArgumentLibraryGen.PUT_U_SHORT, SerializeArgumentLibraryGen.PUT_INT, SerializeArgumentLibraryGen.PUT_U_INT, SerializeArgumentLibraryGen.PUT_LONG, SerializeArgumentLibraryGen.PUT_U_LONG, SerializeArgumentLibraryGen.PUT_FLOAT, SerializeArgumentLibraryGen.PUT_DOUBLE, SerializeArgumentLibraryGen.PUT_POINTER, SerializeArgumentLibraryGen.PUT_STRING)));
    }

    @Override
    protected Class<?> getDefaultClass(Object receiver) {
        if (receiver instanceof Character) {
            return CharConversion.class;
        } else if (receiver instanceof boolean[]) {
            return BooleanArrayConversion.class;
        } else if (receiver instanceof byte[]) {
            return ByteArrayConversion.class;
        } else if (receiver instanceof short[]) {
            return ShortArrayConversion.class;
        } else if (receiver instanceof char[]) {
            return CharArrayConversion.class;
        } else if (receiver instanceof int[]) {
            return IntArrayConversion.class;
        } else if (receiver instanceof long[]) {
            return LongArrayConversion.class;
        } else if (receiver instanceof float[]) {
            return FloatArrayConversion.class;
        } else if (receiver instanceof double[]) {
            return DoubleArrayConversion.class;
        } else {
            return DefaultConversion.class;
        }
    }

    @Override
    protected SerializeArgumentLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    @Override
    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        SerializeArgumentLibrary lib = (SerializeArgumentLibrary) originalLib;
        MessageImpl messageImpl = (MessageImpl) message;
        if (messageImpl.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (messageImpl.index) {
            case 0 :
                lib.putByte(receiver, (NativeArgumentBuffer) args[offset]);
                return null;
            case 1 :
                lib.putUByte(receiver, (NativeArgumentBuffer) args[offset]);
                return null;
            case 2 :
                lib.putShort(receiver, (NativeArgumentBuffer) args[offset]);
                return null;
            case 3 :
                lib.putUShort(receiver, (NativeArgumentBuffer) args[offset]);
                return null;
            case 4 :
                lib.putInt(receiver, (NativeArgumentBuffer) args[offset]);
                return null;
            case 5 :
                lib.putUInt(receiver, (NativeArgumentBuffer) args[offset]);
                return null;
            case 6 :
                lib.putLong(receiver, (NativeArgumentBuffer) args[offset]);
                return null;
            case 7 :
                lib.putULong(receiver, (NativeArgumentBuffer) args[offset]);
                return null;
            case 8 :
                lib.putFloat(receiver, (NativeArgumentBuffer) args[offset]);
                return null;
            case 9 :
                lib.putDouble(receiver, (NativeArgumentBuffer) args[offset]);
                return null;
            case 10 :
                lib.putPointer(receiver, (NativeArgumentBuffer) args[offset], (int) args[offset + 1]);
                return null;
            case 11 :
                lib.putString(receiver, (NativeArgumentBuffer) args[offset], (int) args[offset + 1]);
                return null;
        }
        CompilerDirectives.transferToInterpreter();
        throw new AbstractMethodError(message.toString());
    }

    @Override
    protected SerializeArgumentLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    @Override
    protected SerializeArgumentLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    @SuppressWarnings("unchecked")
    private static Class<SerializeArgumentLibrary> lazyLibraryClass() {
        try {
            return (Class<SerializeArgumentLibrary>) Class.forName("com.oracle.truffle.nfi.impl.SerializeArgumentLibrary", false, SerializeArgumentLibraryGen.class.getClassLoader());
        } catch (ClassNotFoundException e) {
            throw new AssertionError(e);
        }
    }

    @GeneratedBy(SerializeArgumentLibrary.class)
    private static class MessageImpl extends Message {

        final int index;

        MessageImpl(String name, int index, Class<?> returnType, Class<?>... parameters) {
            super(SerializeArgumentLibraryGen.LIBRARY_CLASS, name, returnType, parameters);
            this.index = index;
        }

    }
    @GeneratedBy(SerializeArgumentLibrary.class)
    private static final class Proxy extends SerializeArgumentLibrary {

        @Child private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public void putByte(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            try {
                lib.send(receiver_, SerializeArgumentLibraryGen.PUT_BYTE, buffer);
                return;
            } catch (UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError(e_);
            }
        }

        @Override
        public void putUByte(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            try {
                lib.send(receiver_, SerializeArgumentLibraryGen.PUT_U_BYTE, buffer);
                return;
            } catch (UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError(e_);
            }
        }

        @Override
        public void putShort(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            try {
                lib.send(receiver_, SerializeArgumentLibraryGen.PUT_SHORT, buffer);
                return;
            } catch (UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError(e_);
            }
        }

        @Override
        public void putUShort(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            try {
                lib.send(receiver_, SerializeArgumentLibraryGen.PUT_U_SHORT, buffer);
                return;
            } catch (UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError(e_);
            }
        }

        @Override
        public void putInt(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            try {
                lib.send(receiver_, SerializeArgumentLibraryGen.PUT_INT, buffer);
                return;
            } catch (UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError(e_);
            }
        }

        @Override
        public void putUInt(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            try {
                lib.send(receiver_, SerializeArgumentLibraryGen.PUT_U_INT, buffer);
                return;
            } catch (UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError(e_);
            }
        }

        @Override
        public void putLong(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            try {
                lib.send(receiver_, SerializeArgumentLibraryGen.PUT_LONG, buffer);
                return;
            } catch (UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError(e_);
            }
        }

        @Override
        public void putULong(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            try {
                lib.send(receiver_, SerializeArgumentLibraryGen.PUT_U_LONG, buffer);
                return;
            } catch (UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError(e_);
            }
        }

        @Override
        public void putFloat(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            try {
                lib.send(receiver_, SerializeArgumentLibraryGen.PUT_FLOAT, buffer);
                return;
            } catch (UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError(e_);
            }
        }

        @Override
        public void putDouble(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            try {
                lib.send(receiver_, SerializeArgumentLibraryGen.PUT_DOUBLE, buffer);
                return;
            } catch (UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError(e_);
            }
        }

        @Override
        public void putPointer(Object receiver_, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
            try {
                lib.send(receiver_, SerializeArgumentLibraryGen.PUT_POINTER, buffer, ptrSize);
                return;
            } catch (UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError(e_);
            }
        }

        @Override
        public void putString(Object receiver_, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
            try {
                lib.send(receiver_, SerializeArgumentLibraryGen.PUT_STRING, buffer, ptrSize);
                return;
            } catch (UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError(e_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return lib.accepts(receiver_);
        }

    }
    @GeneratedBy(SerializeArgumentLibrary.class)
    private static final class CachedToUncachedDispatch extends SerializeArgumentLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @TruffleBoundary
        @Override
        public void putByte(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode(getParent());
            try {
                INSTANCE.getUncached(receiver_).putByte(receiver_, buffer);
                return;
            } finally {
                NodeUtil.popEncapsulatingNode(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void putUByte(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode(getParent());
            try {
                INSTANCE.getUncached(receiver_).putUByte(receiver_, buffer);
                return;
            } finally {
                NodeUtil.popEncapsulatingNode(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void putShort(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode(getParent());
            try {
                INSTANCE.getUncached(receiver_).putShort(receiver_, buffer);
                return;
            } finally {
                NodeUtil.popEncapsulatingNode(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void putUShort(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode(getParent());
            try {
                INSTANCE.getUncached(receiver_).putUShort(receiver_, buffer);
                return;
            } finally {
                NodeUtil.popEncapsulatingNode(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void putInt(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode(getParent());
            try {
                INSTANCE.getUncached(receiver_).putInt(receiver_, buffer);
                return;
            } finally {
                NodeUtil.popEncapsulatingNode(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void putUInt(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode(getParent());
            try {
                INSTANCE.getUncached(receiver_).putUInt(receiver_, buffer);
                return;
            } finally {
                NodeUtil.popEncapsulatingNode(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void putLong(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode(getParent());
            try {
                INSTANCE.getUncached(receiver_).putLong(receiver_, buffer);
                return;
            } finally {
                NodeUtil.popEncapsulatingNode(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void putULong(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode(getParent());
            try {
                INSTANCE.getUncached(receiver_).putULong(receiver_, buffer);
                return;
            } finally {
                NodeUtil.popEncapsulatingNode(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void putFloat(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode(getParent());
            try {
                INSTANCE.getUncached(receiver_).putFloat(receiver_, buffer);
                return;
            } finally {
                NodeUtil.popEncapsulatingNode(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void putDouble(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode(getParent());
            try {
                INSTANCE.getUncached(receiver_).putDouble(receiver_, buffer);
                return;
            } finally {
                NodeUtil.popEncapsulatingNode(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void putPointer(Object receiver_, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
            assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode(getParent());
            try {
                INSTANCE.getUncached(receiver_).putPointer(receiver_, buffer, ptrSize);
                return;
            } finally {
                NodeUtil.popEncapsulatingNode(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void putString(Object receiver_, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
            assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode(getParent());
            try {
                INSTANCE.getUncached(receiver_).putString(receiver_, buffer, ptrSize);
                return;
            } finally {
                NodeUtil.popEncapsulatingNode(prev_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(SerializeArgumentLibrary.class)
    private static final class UncachedDispatch extends SerializeArgumentLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @TruffleBoundary
        @Override
        public void putByte(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            INSTANCE.getUncached(receiver_).putByte(receiver_, buffer);
            return;
        }

        @TruffleBoundary
        @Override
        public void putUByte(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            INSTANCE.getUncached(receiver_).putUByte(receiver_, buffer);
            return;
        }

        @TruffleBoundary
        @Override
        public void putShort(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            INSTANCE.getUncached(receiver_).putShort(receiver_, buffer);
            return;
        }

        @TruffleBoundary
        @Override
        public void putUShort(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            INSTANCE.getUncached(receiver_).putUShort(receiver_, buffer);
            return;
        }

        @TruffleBoundary
        @Override
        public void putInt(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            INSTANCE.getUncached(receiver_).putInt(receiver_, buffer);
            return;
        }

        @TruffleBoundary
        @Override
        public void putUInt(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            INSTANCE.getUncached(receiver_).putUInt(receiver_, buffer);
            return;
        }

        @TruffleBoundary
        @Override
        public void putLong(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            INSTANCE.getUncached(receiver_).putLong(receiver_, buffer);
            return;
        }

        @TruffleBoundary
        @Override
        public void putULong(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            INSTANCE.getUncached(receiver_).putULong(receiver_, buffer);
            return;
        }

        @TruffleBoundary
        @Override
        public void putFloat(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            INSTANCE.getUncached(receiver_).putFloat(receiver_, buffer);
            return;
        }

        @TruffleBoundary
        @Override
        public void putDouble(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            INSTANCE.getUncached(receiver_).putDouble(receiver_, buffer);
            return;
        }

        @TruffleBoundary
        @Override
        public void putPointer(Object receiver_, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
            INSTANCE.getUncached(receiver_).putPointer(receiver_, buffer, ptrSize);
            return;
        }

        @TruffleBoundary
        @Override
        public void putString(Object receiver_, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
            INSTANCE.getUncached(receiver_).putString(receiver_, buffer, ptrSize);
            return;
        }

        @TruffleBoundary
        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
    @GeneratedBy(SerializeArgumentLibrary.class)
    private static final class CachedDispatchNext extends CachedDispatch {

        CachedDispatchNext(SerializeArgumentLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw new AssertionError();
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(SerializeArgumentLibrary.class)
    private static final class CachedDispatchFirst extends CachedDispatch {

        private final int limit_;

        CachedDispatchFirst(SerializeArgumentLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        @Override
        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library != null) {
                    count++;
                }
                current = current.next;
            } while (current != null);
            return NodeCost.fromCount(count);
        }

    }
    @GeneratedBy(SerializeArgumentLibrary.class)
    private abstract static class CachedDispatch extends SerializeArgumentLibrary {

        @Child SerializeArgumentLibrary library;
        @Child CachedDispatch next;

        CachedDispatch(SerializeArgumentLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        @Override
        public void putByte(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            do {
                CachedDispatch current = this;
                do {
                    SerializeArgumentLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.putByte(receiver_, buffer);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        @Override
        public void putUByte(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            do {
                CachedDispatch current = this;
                do {
                    SerializeArgumentLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.putUByte(receiver_, buffer);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        @Override
        public void putShort(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            do {
                CachedDispatch current = this;
                do {
                    SerializeArgumentLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.putShort(receiver_, buffer);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        @Override
        public void putUShort(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            do {
                CachedDispatch current = this;
                do {
                    SerializeArgumentLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.putUShort(receiver_, buffer);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        @Override
        public void putInt(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            do {
                CachedDispatch current = this;
                do {
                    SerializeArgumentLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.putInt(receiver_, buffer);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        @Override
        public void putUInt(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            do {
                CachedDispatch current = this;
                do {
                    SerializeArgumentLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.putUInt(receiver_, buffer);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        @Override
        public void putLong(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            do {
                CachedDispatch current = this;
                do {
                    SerializeArgumentLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.putLong(receiver_, buffer);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        @Override
        public void putULong(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            do {
                CachedDispatch current = this;
                do {
                    SerializeArgumentLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.putULong(receiver_, buffer);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        @Override
        public void putFloat(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            do {
                CachedDispatch current = this;
                do {
                    SerializeArgumentLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.putFloat(receiver_, buffer);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        @Override
        public void putDouble(Object receiver_, NativeArgumentBuffer buffer) throws UnsupportedTypeException {
            do {
                CachedDispatch current = this;
                do {
                    SerializeArgumentLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.putDouble(receiver_, buffer);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        @Override
        public void putPointer(Object receiver_, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
            do {
                CachedDispatch current = this;
                do {
                    SerializeArgumentLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.putPointer(receiver_, buffer, ptrSize);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        @Override
        public void putString(Object receiver_, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
            do {
                CachedDispatch current = this;
                do {
                    SerializeArgumentLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.putString(receiver_, buffer, ptrSize);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        private void specialize(Object receiver_) {
            CachedDispatch current = this;
            SerializeArgumentLibrary thisLibrary = current.library;
            if (thisLibrary == null) {
                this.library = insert(INSTANCE.create(receiver_));
            } else {
                Lock lock = getLock();
                lock.lock();
                try {
                    int count = 0;
                    do {
                        SerializeArgumentLibrary currentLibrary = current.library;
                        if (currentLibrary != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        count++;
                        current = current.next;
                    } while (current != null);
                    if (count >= getLimit()) {
                        this.library = insert(new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = insert(new CachedDispatchNext(INSTANCE.create(receiver_), next));
                    }
                } finally {
                    lock.unlock();
                }
            }
        }

    }
}
