// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.ExplodeLoop.LoopExplosionKind;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.nfi.NFILibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(NFILibrary.class)
@SuppressWarnings("unused")
final class NFILibraryGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(NFILibrary.class, new InteropLibraryExports());
    }

    private NFILibraryGen() {
    }

    @GeneratedBy(NFILibrary.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, NFILibrary.class, false);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof NFILibrary;
            return new Uncached();
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof NFILibrary;
            return new Cached();
        }

        @GeneratedBy(NFILibrary.class)
        private static final class Cached extends InteropLibrary {

            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @Child private IsMemberReadableNode_IsMemberReadable0Data isMemberReadableNode__isMemberReadable0_cache;
            @Child private ReadMemberNode_ReadMember0Data readMemberNode__readMember0_cache;
            @Child private InteropLibrary invokeMemberNode__executables_;
            @CompilationFinal private BranchProfile invokeMemberNode__exception_;

            Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof NFILibrary) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.nfi.NFILibrary'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFILibrary;
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFILibrary) receiver).hasMembers();
            }

            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFILibrary) receiver).getMembers(includeInternal);
            }

            @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFILibrary arg0Value = (NFILibrary) arg0Value_;
                int state = state_;
                if ((state & 0b11) != 0 /* is-active isMemberReadable(NFILibrary, String, InteropLibrary) || isMemberReadable(NFILibrary, String, InteropLibrary) */) {
                    if ((state & 0b1) != 0 /* is-active isMemberReadable(NFILibrary, String, InteropLibrary) */) {
                        IsMemberReadableNode_IsMemberReadable0Data s1_ = this.isMemberReadableNode__isMemberReadable0_cache;
                        while (s1_ != null) {
                            if ((s1_.recursive_.accepts(arg0Value.getLibrary()))) {
                                return arg0Value.isMemberReadable(arg1Value, s1_.recursive_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active isMemberReadable(NFILibrary, String, InteropLibrary) */) {
                        return this.isMemberReadable1Boundary(state, arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            @TruffleBoundary
            private boolean isMemberReadable1Boundary(int state, NFILibrary arg0Value, String arg1Value) {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    return arg0Value.isMemberReadable(arg1Value, (INTEROP_LIBRARY_.getUncached(arg0Value.getLibrary())));
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            private boolean isMemberReadableNode_AndSpecialize(NFILibrary arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if (((exclude & 0b1)) == 0 /* is-not-excluded isMemberReadable(NFILibrary, String, InteropLibrary) */) {
                        int count1_ = 0;
                        IsMemberReadableNode_IsMemberReadable0Data s1_ = this.isMemberReadableNode__isMemberReadable0_cache;
                        if ((state & 0b1) != 0 /* is-active isMemberReadable(NFILibrary, String, InteropLibrary) */) {
                            while (s1_ != null) {
                                if ((s1_.recursive_.accepts(arg0Value.getLibrary()))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (s1_.recursive_.accepts(arg0Value.getLibrary()));
                            if (count1_ < (3)) {
                                s1_ = super.insert(new IsMemberReadableNode_IsMemberReadable0Data(isMemberReadableNode__isMemberReadable0_cache));
                                s1_.recursive_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg0Value.getLibrary())));
                                this.isMemberReadableNode__isMemberReadable0_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active isMemberReadable(NFILibrary, String, InteropLibrary) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return arg0Value.isMemberReadable(arg1Value, s1_.recursive_);
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded isMemberReadable(NFILibrary, String, InteropLibrary) */;
                            this.isMemberReadableNode__isMemberReadable0_cache = null;
                            state = state & 0xfffffffe /* remove-active isMemberReadable(NFILibrary, String, InteropLibrary) */;
                            this.state_ = state = state | 0b10 /* add-active isMemberReadable(NFILibrary, String, InteropLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            return arg0Value.isMemberReadable(arg1Value, (INTEROP_LIBRARY_.getUncached(arg0Value.getLibrary())));
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if ((state & 0b11) == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if (((state & 0b11) & ((state & 0b11) - 1)) == 0 /* is-single-active  */) {
                    IsMemberReadableNode_IsMemberReadable0Data s1_ = this.isMemberReadableNode__isMemberReadable0_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFILibrary arg0Value = (NFILibrary) arg0Value_;
                int state = state_;
                if ((state & 0b1100) != 0 /* is-active readMember(NFILibrary, String, InteropLibrary) || readMember(NFILibrary, String, InteropLibrary) */) {
                    if ((state & 0b100) != 0 /* is-active readMember(NFILibrary, String, InteropLibrary) */) {
                        ReadMemberNode_ReadMember0Data s1_ = this.readMemberNode__readMember0_cache;
                        while (s1_ != null) {
                            if ((s1_.recursive_.accepts(arg0Value.getLibrary()))) {
                                return arg0Value.readMember(arg1Value, s1_.recursive_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b1000) != 0 /* is-active readMember(NFILibrary, String, InteropLibrary) */) {
                        return this.readMember1Boundary(state, arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            @TruffleBoundary
            private Object readMember1Boundary(int state, NFILibrary arg0Value, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    return arg0Value.readMember(arg1Value, (INTEROP_LIBRARY_.getUncached(arg0Value.getLibrary())));
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            private Object readMemberNode_AndSpecialize(NFILibrary arg0Value, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if (((exclude & 0b10)) == 0 /* is-not-excluded readMember(NFILibrary, String, InteropLibrary) */) {
                        int count1_ = 0;
                        ReadMemberNode_ReadMember0Data s1_ = this.readMemberNode__readMember0_cache;
                        if ((state & 0b100) != 0 /* is-active readMember(NFILibrary, String, InteropLibrary) */) {
                            while (s1_ != null) {
                                if ((s1_.recursive_.accepts(arg0Value.getLibrary()))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (s1_.recursive_.accepts(arg0Value.getLibrary()));
                            if (count1_ < (3)) {
                                s1_ = super.insert(new ReadMemberNode_ReadMember0Data(readMemberNode__readMember0_cache));
                                s1_.recursive_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg0Value.getLibrary())));
                                this.readMemberNode__readMember0_cache = s1_;
                                this.state_ = state = state | 0b100 /* add-active readMember(NFILibrary, String, InteropLibrary) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return arg0Value.readMember(arg1Value, s1_.recursive_);
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            this.exclude_ = exclude = exclude | 0b10 /* add-excluded readMember(NFILibrary, String, InteropLibrary) */;
                            this.readMemberNode__readMember0_cache = null;
                            state = state & 0xfffffffb /* remove-active readMember(NFILibrary, String, InteropLibrary) */;
                            this.state_ = state = state | 0b1000 /* add-active readMember(NFILibrary, String, InteropLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            return arg0Value.readMember(arg1Value, (INTEROP_LIBRARY_.getUncached(arg0Value.getLibrary())));
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberInvocable(Object receiver, String member) {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFILibrary) receiver).isMemberInvocable(member);
            }

            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFILibrary arg0Value = (NFILibrary) arg0Value_;
                int state = state_;
                if ((state & 0b10000) != 0 /* is-active invokeMember(NFILibrary, String, Object[], InteropLibrary, BranchProfile) */) {
                    return arg0Value.invokeMember(arg1Value, arg2Value, this.invokeMemberNode__executables_, this.invokeMemberNode__exception_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object invokeMemberNode_AndSpecialize(NFILibrary arg0Value, String arg1Value, Object[] arg2Value) throws UnknownIdentifierException, ArityException, UnsupportedTypeException, UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    this.invokeMemberNode__executables_ = super.insert((INTEROP_LIBRARY_.createDispatched(3)));
                    this.invokeMemberNode__exception_ = (BranchProfile.create());
                    this.state_ = state = state | 0b10000 /* add-active invokeMember(NFILibrary, String, Object[], InteropLibrary, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.invokeMember(arg1Value, arg2Value, this.invokeMemberNode__executables_, this.invokeMemberNode__exception_);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            private static final class IsMemberReadableNode_IsMemberReadable0Data extends Node {

                @Child IsMemberReadableNode_IsMemberReadable0Data next_;
                @Child InteropLibrary recursive_;

                IsMemberReadableNode_IsMemberReadable0Data(IsMemberReadableNode_IsMemberReadable0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
            private static final class ReadMemberNode_ReadMember0Data extends Node {

                @Child ReadMemberNode_ReadMember0Data next_;
                @Child InteropLibrary recursive_;

                ReadMemberNode_ReadMember0Data(ReadMemberNode_ReadMember0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
        }
        @GeneratedBy(NFILibrary.class)
        private static final class Uncached extends InteropLibrary {

            Uncached() {
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof NFILibrary) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.nfi.NFILibrary'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFILibrary;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFILibrary) receiver) .hasMembers();
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFILibrary) receiver) .getMembers(includeInternal);
            }

            @TruffleBoundary
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFILibrary arg0Value = (NFILibrary) arg0Value_;
                return arg0Value.isMemberReadable(arg1Value, (INTEROP_LIBRARY_.getUncached(arg0Value.getLibrary())));
            }

            @TruffleBoundary
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFILibrary arg0Value = (NFILibrary) arg0Value_;
                return arg0Value.readMember(arg1Value, (INTEROP_LIBRARY_.getUncached(arg0Value.getLibrary())));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInvocable(Object receiver, String member) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFILibrary) receiver) .isMemberInvocable(member);
            }

            @TruffleBoundary
            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnknownIdentifierException, ArityException, UnsupportedTypeException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFILibrary arg0Value = (NFILibrary) arg0Value_;
                return arg0Value.invokeMember(arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached()), (BranchProfile.getUncached()));
            }

        }
    }
}
