// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary.ByteArrayConversion;

@GeneratedBy(ByteArrayConversion.class)
final class ByteArrayConversionGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(ByteArrayConversion.class, new SerializeArgumentLibraryExports());
    }

    private ByteArrayConversionGen() {
    }

    @GeneratedBy(ByteArrayConversion.class)
    private static final class SerializeArgumentLibraryExports extends LibraryExport<SerializeArgumentLibrary> {

        private static final Uncached UNCACHED = new Uncached();
        private static final Cached CACHE = new Cached();

        private SerializeArgumentLibraryExports() {
            super(SerializeArgumentLibrary.class, byte[].class, true);
        }

        @Override
        protected SerializeArgumentLibrary createUncached(Object receiver) {
            assert receiver instanceof byte[];
            return SerializeArgumentLibraryExports.UNCACHED;
        }

        @Override
        protected SerializeArgumentLibrary createCached(Object receiver) {
            assert receiver instanceof byte[];
            return SerializeArgumentLibraryExports.CACHE;
        }

        @GeneratedBy(ByteArrayConversion.class)
        private static final class Cached extends SerializeArgumentLibrary {

            Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof byte[]) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.nfi.impl.SerializeArgumentLibrary.ByteArrayConversion'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof byte[];
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public void putPointer(Object receiver, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                ByteArrayConversion.putPointer(((byte[]) receiver), buffer, ptrSize);
                return;
            }

        }
        @GeneratedBy(ByteArrayConversion.class)
        private static final class Uncached extends SerializeArgumentLibrary {

            Uncached() {
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof byte[]) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.nfi.impl.SerializeArgumentLibrary.ByteArrayConversion'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof byte[];
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public void putPointer(Object receiver, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                ByteArrayConversion.putPointer(((byte[]) receiver) , buffer, ptrSize);
                return;
            }

        }
    }
}
