// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary.DefaultConversion;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary.DefaultConversion.PutPointer;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary.DefaultConversion.PutString;
import java.util.concurrent.locks.Lock;

@GeneratedBy(DefaultConversion.class)
final class DefaultConversionGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(DefaultConversion.class, new SerializeArgumentLibraryExports());
    }

    private DefaultConversionGen() {
    }

    @GeneratedBy(DefaultConversion.class)
    private static final class SerializeArgumentLibraryExports extends LibraryExport<SerializeArgumentLibrary> {

        private SerializeArgumentLibraryExports() {
            super(SerializeArgumentLibrary.class, Object.class, true);
        }

        @Override
        protected SerializeArgumentLibrary createUncached(Object receiver) {
            return new Uncached(receiver);
        }

        @Override
        protected SerializeArgumentLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(DefaultConversion.class)
        private static final class Cached extends SerializeArgumentLibrary {

            @Child private InteropLibrary receiverInteropLibrary;
            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;
            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @CompilationFinal private BranchProfile exception;

            Cached(Object receiver) {
                this.receiverInteropLibrary = insert(INTEROP_LIBRARY_.create((receiver)));
                this.dynamicDispatch_ = insert(DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver).dispatch(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                if (!(dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_)) {
                    return false;
                } else if (!this.receiverInteropLibrary.accepts((receiver))) {
                    return false;
                } else {
                    return true;
                }
            }

            @Override
            public void putPointer(Object arg0Value, NativeArgumentBuffer arg1Value, int arg2Value) throws UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = state_;
                if ((state & 0b111) != 0 /* is-active putPointer(Object, NativeArgumentBuffer, int, InteropLibrary) || putNull(Object, NativeArgumentBuffer, int, InteropLibrary) || putGeneric(Object, NativeArgumentBuffer, int, InteropLibrary, BranchProfile) */) {
                    if ((state & 0b1) != 0 /* is-active putPointer(Object, NativeArgumentBuffer, int, InteropLibrary) */) {
                        if ((this.receiverInteropLibrary.isPointer(arg0Value))) {
                            try {
                                PutPointer.putPointer(arg0Value, arg1Value, arg2Value, this.receiverInteropLibrary);
                                return;
                            } catch (UnsupportedMessageException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                Lock lock = getLock();
                                lock.lock();
                                try {
                                    this.exclude_ = this.exclude_ | 0b1 /* add-excluded putPointer(Object, NativeArgumentBuffer, int, InteropLibrary), putPointer(Object, NativeArgumentBuffer, int, InteropLibrary) */;
                                    this.state_ = this.state_ & 0xfffffffe /* remove-active putPointer(Object, NativeArgumentBuffer, int, InteropLibrary), putPointer(Object, NativeArgumentBuffer, int, InteropLibrary) */;
                                } finally {
                                    lock.unlock();
                                }
                                putPointerAndSpecialize(arg0Value, arg1Value, arg2Value);
                                return;
                            }
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active putNull(Object, NativeArgumentBuffer, int, InteropLibrary) */) {
                        if ((!(this.receiverInteropLibrary.isPointer(arg0Value))) && (this.receiverInteropLibrary.isNull(arg0Value))) {
                            PutPointer.putNull(arg0Value, arg1Value, arg2Value, this.receiverInteropLibrary);
                            return;
                        }
                    }
                    if ((state & 0b100) != 0 /* is-active putGeneric(Object, NativeArgumentBuffer, int, InteropLibrary, BranchProfile) */) {
                        PutPointer.putGeneric(arg0Value, arg1Value, arg2Value, this.receiverInteropLibrary, this.exception);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                putPointerAndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void putPointerAndSpecialize(Object arg0Value, NativeArgumentBuffer arg1Value, int arg2Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if (((exclude & 0b1)) == 0 /* is-not-excluded putPointer(Object, NativeArgumentBuffer, int, InteropLibrary) */) {
                        {
                            InteropLibrary putPointer_putPointer_interop__ = this.receiverInteropLibrary;
                            if ((putPointer_putPointer_interop__.isPointer(arg0Value))) {
                                this.state_ = state = state | 0b1 /* add-active putPointer(Object, NativeArgumentBuffer, int, InteropLibrary) */;
                                try {
                                    lock.unlock();
                                    hasLock = false;
                                    PutPointer.putPointer(arg0Value, arg1Value, arg2Value, putPointer_putPointer_interop__);
                                    return;
                                } catch (UnsupportedMessageException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    lock.lock();
                                    try {
                                        this.exclude_ = this.exclude_ | 0b1 /* add-excluded putPointer(Object, NativeArgumentBuffer, int, InteropLibrary), putPointer(Object, NativeArgumentBuffer, int, InteropLibrary) */;
                                        this.state_ = this.state_ & 0xfffffffe /* remove-active putPointer(Object, NativeArgumentBuffer, int, InteropLibrary), putPointer(Object, NativeArgumentBuffer, int, InteropLibrary) */;
                                    } finally {
                                        lock.unlock();
                                    }
                                    putPointerAndSpecialize(arg0Value, arg1Value, arg2Value);
                                    return;
                                }
                            }
                        }
                    }
                    if (((exclude & 0b10)) == 0 /* is-not-excluded putNull(Object, NativeArgumentBuffer, int, InteropLibrary) */) {
                        {
                            InteropLibrary putPointer_putNull_interop__ = this.receiverInteropLibrary;
                            if ((!(putPointer_putNull_interop__.isPointer(arg0Value))) && (putPointer_putNull_interop__.isNull(arg0Value))) {
                                this.state_ = state = state | 0b10 /* add-active putNull(Object, NativeArgumentBuffer, int, InteropLibrary) */;
                                lock.unlock();
                                hasLock = false;
                                PutPointer.putNull(arg0Value, arg1Value, arg2Value, putPointer_putNull_interop__);
                                return;
                            }
                        }
                    }
                    if (this.exception == null) {
                        this.exception = (BranchProfile.create());
                    }
                    this.exclude_ = exclude = exclude | 0b11 /* add-excluded putPointer(Object, NativeArgumentBuffer, int, InteropLibrary), putNull(Object, NativeArgumentBuffer, int, InteropLibrary) */;
                    state = state & 0xfffffffc /* remove-active putPointer(Object, NativeArgumentBuffer, int, InteropLibrary), putNull(Object, NativeArgumentBuffer, int, InteropLibrary) */;
                    this.state_ = state = state | 0b100 /* add-active putGeneric(Object, NativeArgumentBuffer, int, InteropLibrary, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    PutPointer.putGeneric(arg0Value, arg1Value, arg2Value, this.receiverInteropLibrary, this.exception);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if ((state & 0b111) == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if (((state & 0b111) & ((state & 0b111) - 1)) == 0 /* is-single-active  */) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public void putString(Object arg0Value, NativeArgumentBuffer arg1Value, int arg2Value) throws UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = state_;
                if ((state & 0b111000) != 0 /* is-active putString(Object, NativeArgumentBuffer, int, InteropLibrary) || putNull(Object, NativeArgumentBuffer, int, InteropLibrary) || putGeneric(Object, NativeArgumentBuffer, int, InteropLibrary, BranchProfile) */) {
                    if ((state & 0b1000) != 0 /* is-active putString(Object, NativeArgumentBuffer, int, InteropLibrary) */) {
                        if ((this.receiverInteropLibrary.isString(arg0Value))) {
                            try {
                                PutString.putString(arg0Value, arg1Value, arg2Value, this.receiverInteropLibrary);
                                return;
                            } catch (UnsupportedMessageException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                Lock lock = getLock();
                                lock.lock();
                                try {
                                    this.exclude_ = this.exclude_ | 0b100 /* add-excluded putString(Object, NativeArgumentBuffer, int, InteropLibrary), putString(Object, NativeArgumentBuffer, int, InteropLibrary) */;
                                    this.state_ = this.state_ & 0xfffffff7 /* remove-active putString(Object, NativeArgumentBuffer, int, InteropLibrary), putString(Object, NativeArgumentBuffer, int, InteropLibrary) */;
                                } finally {
                                    lock.unlock();
                                }
                                putStringAndSpecialize(arg0Value, arg1Value, arg2Value);
                                return;
                            }
                        }
                    }
                    if ((state & 0b10000) != 0 /* is-active putNull(Object, NativeArgumentBuffer, int, InteropLibrary) */) {
                        if ((!(this.receiverInteropLibrary.isString(arg0Value))) && (this.receiverInteropLibrary.isNull(arg0Value))) {
                            PutString.putNull(arg0Value, arg1Value, arg2Value, this.receiverInteropLibrary);
                            return;
                        }
                    }
                    if ((state & 0b100000) != 0 /* is-active putGeneric(Object, NativeArgumentBuffer, int, InteropLibrary, BranchProfile) */) {
                        PutString.putGeneric(arg0Value, arg1Value, arg2Value, this.receiverInteropLibrary, this.exception);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                putStringAndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void putStringAndSpecialize(Object arg0Value, NativeArgumentBuffer arg1Value, int arg2Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if (((exclude & 0b100)) == 0 /* is-not-excluded putString(Object, NativeArgumentBuffer, int, InteropLibrary) */) {
                        {
                            InteropLibrary putString_putString_interop__ = this.receiverInteropLibrary;
                            if ((putString_putString_interop__.isString(arg0Value))) {
                                this.state_ = state = state | 0b1000 /* add-active putString(Object, NativeArgumentBuffer, int, InteropLibrary) */;
                                try {
                                    lock.unlock();
                                    hasLock = false;
                                    PutString.putString(arg0Value, arg1Value, arg2Value, putString_putString_interop__);
                                    return;
                                } catch (UnsupportedMessageException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    lock.lock();
                                    try {
                                        this.exclude_ = this.exclude_ | 0b100 /* add-excluded putString(Object, NativeArgumentBuffer, int, InteropLibrary), putString(Object, NativeArgumentBuffer, int, InteropLibrary) */;
                                        this.state_ = this.state_ & 0xfffffff7 /* remove-active putString(Object, NativeArgumentBuffer, int, InteropLibrary), putString(Object, NativeArgumentBuffer, int, InteropLibrary) */;
                                    } finally {
                                        lock.unlock();
                                    }
                                    putStringAndSpecialize(arg0Value, arg1Value, arg2Value);
                                    return;
                                }
                            }
                        }
                    }
                    if (((exclude & 0b1000)) == 0 /* is-not-excluded putNull(Object, NativeArgumentBuffer, int, InteropLibrary) */) {
                        {
                            InteropLibrary putString_putNull_interop__ = this.receiverInteropLibrary;
                            if ((!(putString_putNull_interop__.isString(arg0Value))) && (putString_putNull_interop__.isNull(arg0Value))) {
                                this.state_ = state = state | 0b10000 /* add-active putNull(Object, NativeArgumentBuffer, int, InteropLibrary) */;
                                lock.unlock();
                                hasLock = false;
                                PutString.putNull(arg0Value, arg1Value, arg2Value, putString_putNull_interop__);
                                return;
                            }
                        }
                    }
                    if (this.exception == null) {
                        this.exception = (BranchProfile.create());
                    }
                    this.exclude_ = exclude = exclude | 0b1100 /* add-excluded putString(Object, NativeArgumentBuffer, int, InteropLibrary), putNull(Object, NativeArgumentBuffer, int, InteropLibrary) */;
                    state = state & 0xffffffe7 /* remove-active putString(Object, NativeArgumentBuffer, int, InteropLibrary), putNull(Object, NativeArgumentBuffer, int, InteropLibrary) */;
                    this.state_ = state = state | 0b100000 /* add-active putGeneric(Object, NativeArgumentBuffer, int, InteropLibrary, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    PutString.putGeneric(arg0Value, arg1Value, arg2Value, this.receiverInteropLibrary, this.exception);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void putByte(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = state_;
                if ((state & 0b1000000) != 0 /* is-active putByte(Object, NativeArgumentBuffer, BranchProfile, InteropLibrary) */) {
                    DefaultConversion.putByte(arg0Value, arg1Value, this.exception, this.receiverInteropLibrary);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                putByteNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void putByteNode_AndSpecialize(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.exception == null) {
                        this.exception = (BranchProfile.create());
                    }
                    this.state_ = state = state | 0b1000000 /* add-active putByte(Object, NativeArgumentBuffer, BranchProfile, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    DefaultConversion.putByte(arg0Value, arg1Value, this.exception, this.receiverInteropLibrary);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void putUByte(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = state_;
                if ((state & 0b10000000) != 0 /* is-active putUByte(Object, NativeArgumentBuffer, BranchProfile, InteropLibrary) */) {
                    DefaultConversion.putUByte(arg0Value, arg1Value, this.exception, this.receiverInteropLibrary);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                putUByteNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void putUByteNode_AndSpecialize(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.exception == null) {
                        this.exception = (BranchProfile.create());
                    }
                    this.state_ = state = state | 0b10000000 /* add-active putUByte(Object, NativeArgumentBuffer, BranchProfile, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    DefaultConversion.putUByte(arg0Value, arg1Value, this.exception, this.receiverInteropLibrary);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void putShort(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = state_;
                if ((state & 0b100000000) != 0 /* is-active putShort(Object, NativeArgumentBuffer, BranchProfile, InteropLibrary) */) {
                    DefaultConversion.putShort(arg0Value, arg1Value, this.exception, this.receiverInteropLibrary);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                putShortNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void putShortNode_AndSpecialize(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.exception == null) {
                        this.exception = (BranchProfile.create());
                    }
                    this.state_ = state = state | 0b100000000 /* add-active putShort(Object, NativeArgumentBuffer, BranchProfile, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    DefaultConversion.putShort(arg0Value, arg1Value, this.exception, this.receiverInteropLibrary);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void putUShort(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = state_;
                if ((state & 0b1000000000) != 0 /* is-active putUShort(Object, NativeArgumentBuffer, BranchProfile, InteropLibrary) */) {
                    DefaultConversion.putUShort(arg0Value, arg1Value, this.exception, this.receiverInteropLibrary);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                putUShortNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void putUShortNode_AndSpecialize(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.exception == null) {
                        this.exception = (BranchProfile.create());
                    }
                    this.state_ = state = state | 0b1000000000 /* add-active putUShort(Object, NativeArgumentBuffer, BranchProfile, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    DefaultConversion.putUShort(arg0Value, arg1Value, this.exception, this.receiverInteropLibrary);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void putInt(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = state_;
                if ((state & 0b10000000000) != 0 /* is-active putInt(Object, NativeArgumentBuffer, BranchProfile, InteropLibrary) */) {
                    DefaultConversion.putInt(arg0Value, arg1Value, this.exception, this.receiverInteropLibrary);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                putIntNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void putIntNode_AndSpecialize(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.exception == null) {
                        this.exception = (BranchProfile.create());
                    }
                    this.state_ = state = state | 0b10000000000 /* add-active putInt(Object, NativeArgumentBuffer, BranchProfile, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    DefaultConversion.putInt(arg0Value, arg1Value, this.exception, this.receiverInteropLibrary);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void putUInt(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = state_;
                if ((state & 0b100000000000) != 0 /* is-active putUInt(Object, NativeArgumentBuffer, BranchProfile, InteropLibrary) */) {
                    DefaultConversion.putUInt(arg0Value, arg1Value, this.exception, this.receiverInteropLibrary);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                putUIntNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void putUIntNode_AndSpecialize(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.exception == null) {
                        this.exception = (BranchProfile.create());
                    }
                    this.state_ = state = state | 0b100000000000 /* add-active putUInt(Object, NativeArgumentBuffer, BranchProfile, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    DefaultConversion.putUInt(arg0Value, arg1Value, this.exception, this.receiverInteropLibrary);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void putLong(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = state_;
                if ((state & 0b1000000000000) != 0 /* is-active putLong(Object, NativeArgumentBuffer, BranchProfile, InteropLibrary) */) {
                    DefaultConversion.putLong(arg0Value, arg1Value, this.exception, this.receiverInteropLibrary);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                putLongNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void putLongNode_AndSpecialize(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.exception == null) {
                        this.exception = (BranchProfile.create());
                    }
                    this.state_ = state = state | 0b1000000000000 /* add-active putLong(Object, NativeArgumentBuffer, BranchProfile, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    DefaultConversion.putLong(arg0Value, arg1Value, this.exception, this.receiverInteropLibrary);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void putULong(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = state_;
                if ((state & 0b1000000000000) != 0 /* is-active putLong(Object, NativeArgumentBuffer, BranchProfile, InteropLibrary) */) {
                    DefaultConversion.putLong(arg0Value, arg1Value, this.exception, this.receiverInteropLibrary);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                putLongNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            @Override
            public void putFloat(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = state_;
                if ((state & 0b10000000000000) != 0 /* is-active putFloat(Object, NativeArgumentBuffer, BranchProfile, InteropLibrary) */) {
                    DefaultConversion.putFloat(arg0Value, arg1Value, this.exception, this.receiverInteropLibrary);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                putFloatNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void putFloatNode_AndSpecialize(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.exception == null) {
                        this.exception = (BranchProfile.create());
                    }
                    this.state_ = state = state | 0b10000000000000 /* add-active putFloat(Object, NativeArgumentBuffer, BranchProfile, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    DefaultConversion.putFloat(arg0Value, arg1Value, this.exception, this.receiverInteropLibrary);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void putDouble(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = state_;
                if ((state & 0b100000000000000) != 0 /* is-active putDouble(Object, NativeArgumentBuffer, BranchProfile, InteropLibrary) */) {
                    DefaultConversion.putDouble(arg0Value, arg1Value, this.exception, this.receiverInteropLibrary);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                putDoubleNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void putDoubleNode_AndSpecialize(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.exception == null) {
                        this.exception = (BranchProfile.create());
                    }
                    this.state_ = state = state | 0b100000000000000 /* add-active putDouble(Object, NativeArgumentBuffer, BranchProfile, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    DefaultConversion.putDouble(arg0Value, arg1Value, this.exception, this.receiverInteropLibrary);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

        }
        @GeneratedBy(DefaultConversion.class)
        private static final class Uncached extends SerializeArgumentLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            Uncached(Object receiver) {
                this.dynamicDispatch_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = dynamicDispatch_.dispatch(receiver);
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public void putPointer(Object arg0Value, NativeArgumentBuffer arg1Value, int arg2Value) throws UnsupportedTypeException {
                PutPointer.putGeneric(arg0Value, arg1Value, arg2Value, INTEROP_LIBRARY_.getUncached((arg0Value)), (BranchProfile.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public void putString(Object arg0Value, NativeArgumentBuffer arg1Value, int arg2Value) throws UnsupportedTypeException {
                PutString.putGeneric(arg0Value, arg1Value, arg2Value, INTEROP_LIBRARY_.getUncached((arg0Value)), (BranchProfile.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public void putByte(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                DefaultConversion.putByte(arg0Value, arg1Value, (BranchProfile.getUncached()), INTEROP_LIBRARY_.getUncached((arg0Value)));
                return;
            }

            @TruffleBoundary
            @Override
            public void putUByte(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                DefaultConversion.putUByte(arg0Value, arg1Value, (BranchProfile.getUncached()), INTEROP_LIBRARY_.getUncached((arg0Value)));
                return;
            }

            @TruffleBoundary
            @Override
            public void putShort(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                DefaultConversion.putShort(arg0Value, arg1Value, (BranchProfile.getUncached()), INTEROP_LIBRARY_.getUncached((arg0Value)));
                return;
            }

            @TruffleBoundary
            @Override
            public void putUShort(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                DefaultConversion.putUShort(arg0Value, arg1Value, (BranchProfile.getUncached()), INTEROP_LIBRARY_.getUncached((arg0Value)));
                return;
            }

            @TruffleBoundary
            @Override
            public void putInt(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                DefaultConversion.putInt(arg0Value, arg1Value, (BranchProfile.getUncached()), INTEROP_LIBRARY_.getUncached((arg0Value)));
                return;
            }

            @TruffleBoundary
            @Override
            public void putUInt(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                DefaultConversion.putUInt(arg0Value, arg1Value, (BranchProfile.getUncached()), INTEROP_LIBRARY_.getUncached((arg0Value)));
                return;
            }

            @TruffleBoundary
            @Override
            public void putLong(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                DefaultConversion.putLong(arg0Value, arg1Value, (BranchProfile.getUncached()), INTEROP_LIBRARY_.getUncached((arg0Value)));
                return;
            }

            @TruffleBoundary
            @Override
            public void putULong(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                DefaultConversion.putLong(arg0Value, arg1Value, (BranchProfile.getUncached()), INTEROP_LIBRARY_.getUncached((arg0Value)));
                return;
            }

            @TruffleBoundary
            @Override
            public void putFloat(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                DefaultConversion.putFloat(arg0Value, arg1Value, (BranchProfile.getUncached()), INTEROP_LIBRARY_.getUncached((arg0Value)));
                return;
            }

            @TruffleBoundary
            @Override
            public void putDouble(Object arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                DefaultConversion.putDouble(arg0Value, arg1Value, (BranchProfile.getUncached()), INTEROP_LIBRARY_.getUncached((arg0Value)));
                return;
            }

        }
    }
}
