/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.impl.LibFFIType;
import com.oracle.truffle.nfi.impl.NFILanguageImpl;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.NativeArgumentLibrary;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary;
import com.oracle.truffle.nfi.spi.types.NativeSimpleType;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LibFFIType.BasicType.class)
final class BasicTypeGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<SerializeArgumentLibrary> SERIALIZE_ARGUMENT_LIBRARY_ = LibraryFactory.resolve(SerializeArgumentLibrary.class);

    private BasicTypeGen() {
    }

    static {
        LibraryExport.register(LibFFIType.BasicType.class, (LibraryExport[])new LibraryExport[]{new NativeArgumentLibraryExports()});
    }

    @GeneratedBy(value=LibFFIType.BasicType.class)
    private static final class NativeArgumentLibraryExports
    extends LibraryExport<NativeArgumentLibrary> {
        private NativeArgumentLibraryExports() {
            super(NativeArgumentLibrary.class, LibFFIType.BasicType.class, false);
        }

        protected NativeArgumentLibrary createUncached(Object receiver) {
            assert (receiver instanceof LibFFIType.BasicType);
            return new Uncached(receiver);
        }

        protected NativeArgumentLibrary createCached(Object receiver) {
            assert (receiver instanceof LibFFIType.BasicType);
            return new Cached(receiver);
        }

        @GeneratedBy(value=LibFFIType.BasicType.class)
        private static final class Uncached
        extends NativeArgumentLibrary {
            private final Class<? extends LibFFIType.BasicType> receiverClass_;
            private final TruffleLanguage.LanguageReference<NFILanguageImpl> nFILanguageImplReference_ = this.lookupLanguageReference(NFILanguageImpl.class);

            Uncached(Object receiver) {
                this.receiverClass_ = ((LibFFIType.BasicType)receiver).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.nfi.impl.LibFFIType.BasicType'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_ && Uncached.accepts_(receiver);
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void serialize(LibFFIType arg0Value_, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LibFFIType.BasicType arg0Value = (LibFFIType.BasicType)arg0Value_;
                arg0Value.serialize(arg1Value, arg2Value, arg0Value.simpleType, (SerializeArgumentLibrary)SERIALIZE_ARGUMENT_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object deserialize(LibFFIType arg0Value_, NativeArgumentBuffer arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LibFFIType.BasicType arg0Value = (LibFFIType.BasicType)arg0Value_;
                return arg0Value.deserialize(arg1Value, arg0Value.simpleType, (NFILanguageImpl)this.nFILanguageImplReference_.get());
            }

            @CompilerDirectives.TruffleBoundary
            private static boolean accepts_(Object arg0Value_) {
                LibFFIType.BasicType arg0Value = (LibFFIType.BasicType)arg0Value_;
                return arg0Value.accepts(arg0Value.simpleType);
            }
        }

        @GeneratedBy(value=LibFFIType.BasicType.class)
        private static final class Cached
        extends NativeArgumentLibrary {
            private final Class<? extends LibFFIType.BasicType> receiverClass_;
            @CompilerDirectives.CompilationFinal
            private int state_;
            @CompilerDirectives.CompilationFinal
            private NativeSimpleType cachedType;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.LanguageReference<NFILanguageImpl> nFILanguageImplReference_;
            @Node.Child
            private SerializeArgumentLibrary serializeNode__serialize_;

            Cached(Object receiver) {
                this.receiverClass_ = ((LibFFIType.BasicType)receiver).getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.nfi.impl.LibFFIType.BasicType'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_ && this.accepts_(receiver);
            }

            private boolean accepts_(Object arg0Value_) {
                LibFFIType.BasicType arg0Value = (LibFFIType.BasicType)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_);
                int state = this.state_;
                if ((state & 1) != 0) {
                    return arg0Value.accepts(this.cachedType);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.acceptsNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean acceptsNode_AndSpecialize(LibFFIType.BasicType arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.cachedType == null) {
                        this.cachedType = arg0Value.simpleType;
                    }
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = arg0Value.accepts(this.cachedType);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if ((state & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public void serialize(LibFFIType arg0Value_, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LibFFIType.BasicType arg0Value = (LibFFIType.BasicType)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_);
                int state = this.state_;
                if ((state & 2) != 0) {
                    arg0Value.serialize(arg1Value, arg2Value, this.cachedType, this.serializeNode__serialize_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.serializeNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void serializeNode_AndSpecialize(LibFFIType.BasicType arg0Value, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.cachedType == null) {
                        this.cachedType = arg0Value.simpleType;
                    }
                    this.serializeNode__serialize_ = (SerializeArgumentLibrary)super.insert((Node)SERIALIZE_ARGUMENT_LIBRARY_.createDispatched(3));
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    arg0Value.serialize(arg1Value, arg2Value, this.cachedType, this.serializeNode__serialize_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object deserialize(LibFFIType arg0Value_, NativeArgumentBuffer arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LibFFIType.BasicType arg0Value = (LibFFIType.BasicType)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_);
                int state = this.state_;
                if ((state & 4) != 0) {
                    return arg0Value.deserialize(arg1Value, this.cachedType, (NFILanguageImpl)this.nFILanguageImplReference_.get());
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.deserializeNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object deserializeNode_AndSpecialize(LibFFIType.BasicType arg0Value, NativeArgumentBuffer arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    TruffleLanguage.LanguageReference nFILanguageImplReference__;
                    if (this.cachedType == null) {
                        this.cachedType = arg0Value.simpleType;
                    }
                    if ((nFILanguageImplReference__ = this.nFILanguageImplReference_) == null) {
                        this.nFILanguageImplReference_ = nFILanguageImplReference__ = super.lookupLanguageReference(NFILanguageImpl.class);
                    }
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.deserialize(arg1Value, this.cachedType, (NFILanguageImpl)nFILanguageImplReference__.get());
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }
        }
    }
}

