/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.nfi.impl.ClosureArgumentNode;
import com.oracle.truffle.nfi.impl.ClosureNativePointer;
import com.oracle.truffle.nfi.impl.LibFFIClosureFactory;
import com.oracle.truffle.nfi.impl.LibFFISignature;
import com.oracle.truffle.nfi.impl.LibFFIType;
import com.oracle.truffle.nfi.impl.NFIContext;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.NativeArgumentLibrary;
import com.oracle.truffle.nfi.impl.NativeString;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary;
import java.nio.ByteBuffer;

@ExportLibrary(value=InteropLibrary.class)
final class LibFFIClosure
implements TruffleObject {
    final ClosureNativePointer nativePointer;

    static LibFFIClosure create(LibFFISignature signature, Object executable, TruffleLanguage.ContextReference<NFIContext> ctxRef) {
        CompilerAsserts.neverPartOfCompilation();
        LibFFIClosure ret = new LibFFIClosure((NFIContext)ctxRef.get(), signature, executable);
        ret.nativePointer.registerManagedRef(ret);
        return ret;
    }

    static LibFFIClosure newClosureWrapper(ClosureNativePointer nativePointer) {
        LibFFIClosure ret = new LibFFIClosure(nativePointer);
        ret.nativePointer.registerManagedRef(ret);
        return ret;
    }

    private LibFFIClosure(NFIContext context, LibFFISignature signature, Object executable) {
        LibFFIType retType = signature.getRetType();
        if (retType instanceof LibFFIType.ObjectType) {
            RootCallTarget executeCallTarget = Truffle.getRuntime().createCallTarget((RootNode)new ObjectRetClosureRootNode(signature, executable));
            this.nativePointer = context.allocateClosureObjectRet(signature, (CallTarget)executeCallTarget);
        } else if (retType instanceof LibFFIType.StringType) {
            RootCallTarget executeCallTarget = Truffle.getRuntime().createCallTarget((RootNode)new StringRetClosureRootNode(signature, executable));
            this.nativePointer = context.allocateClosureStringRet(signature, (CallTarget)executeCallTarget);
        } else if (retType instanceof LibFFIType.VoidType) {
            RootCallTarget executeCallTarget = Truffle.getRuntime().createCallTarget((RootNode)new ObjectRetClosureRootNode(signature, executable));
            this.nativePointer = context.allocateClosureVoidRet(signature, (CallTarget)executeCallTarget);
        } else {
            RootCallTarget executeCallTarget = Truffle.getRuntime().createCallTarget((RootNode)new BufferRetClosureRootNode(signature, executable));
            this.nativePointer = context.allocateClosureBufferRet(signature, (CallTarget)executeCallTarget);
        }
    }

    private LibFFIClosure(ClosureNativePointer nativePointer) {
        this.nativePointer = nativePointer;
    }

    @ExportMessage
    boolean isPointer() {
        return true;
    }

    @ExportMessage
    long asPointer() {
        return this.nativePointer.getCodePointer();
    }

    @ExportMessage
    LibFFIClosure toNative() {
        return this;
    }

    private static final class StringRetClosureRootNode
    extends RootNode {
        @Node.Child
        private CallClosureNode callClosure;
        @Node.Child
        private UnboxStringNode unboxString;

        private StringRetClosureRootNode(LibFFISignature signature, Object receiver) {
            super(null);
            this.callClosure = new CallClosureNode(signature, receiver);
            this.unboxString = LibFFIClosureFactory.UnboxStringNodeGen.create();
        }

        public Object execute(VirtualFrame frame) {
            Object ret = this.callClosure.execute(frame.getArguments());
            try {
                return this.unboxString.execute(ret);
            }
            catch (UnsupportedTypeException ex) {
                return null;
            }
        }
    }

    static abstract class UnboxStringNode
    extends Node {
        UnboxStringNode() {
        }

        protected abstract Object execute(Object var1) throws UnsupportedTypeException;

        @Specialization(limit="3")
        protected Object nativeString(Object str, @CachedLibrary(value="str") SerializeArgumentLibrary serialize) throws UnsupportedTypeException {
            RetStringBuffer retBuffer = new RetStringBuffer();
            CompilerDirectives.ensureVirtualized((Object)retBuffer);
            serialize.putString(str, retBuffer, 0);
            return retBuffer.ret;
        }
    }

    static final class RetStringBuffer
    extends NativeArgumentBuffer {
        Object ret;

        RetStringBuffer() {
            super(0);
        }

        @Override
        protected ByteBuffer getPrimBuffer() {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("should not reach here");
        }

        @Override
        public void putPointer(long ptr, int size) {
            this.ret = new NativeString(ptr);
        }

        @Override
        public void putObject(NativeArgumentBuffer.TypeTag tag, Object o, int size) {
            assert (tag == NativeArgumentBuffer.TypeTag.STRING);
            this.ret = o;
        }
    }

    private static final class ObjectRetClosureRootNode
    extends RootNode {
        @Node.Child
        CallClosureNode callClosure;

        private ObjectRetClosureRootNode(LibFFISignature signature, Object receiver) {
            super(null);
            this.callClosure = new CallClosureNode(signature, receiver);
        }

        public Object execute(VirtualFrame frame) {
            return this.callClosure.execute(frame.getArguments());
        }
    }

    private static final class BufferRetClosureRootNode
    extends RootNode {
        @Node.Child
        CallClosureNode callClosure;
        @Node.Child
        EncodeRetNode encodeRet;

        private BufferRetClosureRootNode(LibFFISignature signature, Object receiver) {
            super(null);
            this.callClosure = new CallClosureNode(signature, receiver);
            this.encodeRet = new EncodeRetNode(signature.getRetType());
        }

        public Object execute(VirtualFrame frame) {
            ByteBuffer retBuffer = (ByteBuffer)frame.getArguments()[frame.getArguments().length - 1];
            Object ret = this.callClosure.execute(frame.getArguments());
            return this.encodeRet.execute(ret, retBuffer);
        }
    }

    private static final class EncodeRetNode
    extends Node {
        private final LibFFIType retType;
        @Node.Child
        NativeArgumentLibrary nativeArguments;

        private EncodeRetNode(LibFFIType retType) {
            this.retType = retType.overrideClosureRetType();
            this.nativeArguments = (NativeArgumentLibrary)NativeArgumentLibrary.getFactory().create((Object)this.retType);
        }

        RetPatches execute(Object ret, ByteBuffer retBuffer) {
            NativeArgumentBuffer.Direct nativeRetBuffer = new NativeArgumentBuffer.Direct(retBuffer, this.retType.objectCount);
            try {
                this.nativeArguments.serialize(this.retType, nativeRetBuffer, ret);
                if (nativeRetBuffer.getPatchCount() > 0) {
                    return new RetPatches(nativeRetBuffer.getPatchCount(), nativeRetBuffer.patches, nativeRetBuffer.objects);
                }
            }
            catch (UnsupportedTypeException unsupportedTypeException) {
                // empty catch block
            }
            return null;
        }
    }

    private static final class CallClosureNode
    extends Node {
        private final Object receiver;
        @Node.Child
        InteropLibrary interop;
        @Node.Children
        final ClosureArgumentNode[] argNodes;

        private CallClosureNode(LibFFISignature signature, Object receiver) {
            this.receiver = receiver;
            this.interop = (InteropLibrary)InteropLibrary.getFactory().create(receiver);
            LibFFIType[] args = signature.getArgTypes();
            this.argNodes = new ClosureArgumentNode[signature.getRealArgCount()];
            int nodeIdx = 0;
            for (LibFFIType arg : args) {
                if (arg.injectedArgument) continue;
                this.argNodes[nodeIdx++] = arg.createClosureArgumentNode();
            }
        }

        @ExplodeLoop
        Object execute(Object[] argBuffers) {
            Object[] args = new Object[this.argNodes.length];
            for (int i = 0; i < this.argNodes.length; ++i) {
                args[i] = this.argNodes[i].execute(argBuffers[i]);
            }
            try {
                return this.interop.execute(this.receiver, args);
            }
            catch (InteropException ex) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(ex);
            }
        }
    }

    static final class RetPatches {
        final int count;
        final int[] patches;
        final Object[] objects;

        RetPatches(int count, int[] patches, Object[] objects) {
            this.count = count;
            this.patches = patches;
            this.objects = objects;
        }
    }
}

