/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.nfi.impl.ClosureArgumentNode;
import com.oracle.truffle.nfi.impl.LibFFIClosure;
import com.oracle.truffle.nfi.impl.LibFFISignature;
import com.oracle.truffle.nfi.impl.LibFFITypeFactory;
import com.oracle.truffle.nfi.impl.NFIContext;
import com.oracle.truffle.nfi.impl.NFILanguageImpl;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.NativeArgumentLibrary;
import com.oracle.truffle.nfi.impl.NativePointer;
import com.oracle.truffle.nfi.impl.NativeString;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary;
import com.oracle.truffle.nfi.spi.types.NativeSimpleType;
import java.lang.reflect.Array;
import java.nio.ByteOrder;

abstract class LibFFIType {
    protected final int size;
    protected final int alignment;
    protected final int objectCount;
    protected final long type;
    protected final Direction allowedDataFlowDirection;
    protected final boolean injectedArgument;

    static LibFFIType createSimpleType(NFIContext ctx, NativeSimpleType simpleType, int size, int alignment, long ffiType) {
        switch (simpleType) {
            case VOID: {
                return new VoidType(ctx, size, alignment, ffiType);
            }
            case UINT8: 
            case SINT8: 
            case UINT16: 
            case SINT16: 
            case UINT32: 
            case SINT32: 
            case UINT64: 
            case SINT64: 
            case FLOAT: 
            case DOUBLE: 
            case POINTER: {
                return new SimpleType(ctx, simpleType, size, alignment, ffiType);
            }
            case STRING: {
                return new StringType(ctx, size, alignment, ffiType);
            }
            case OBJECT: {
                return new ObjectType(ctx, size, alignment, ffiType);
            }
        }
        throw new AssertionError((Object)simpleType.name());
    }

    static LibFFIType createArrayType(NFIContext ctx, NativeSimpleType simpleType) {
        switch (simpleType) {
            case UINT8: 
            case SINT8: 
            case UINT16: 
            case SINT16: 
            case UINT32: 
            case SINT32: 
            case UINT64: 
            case SINT64: 
            case FLOAT: 
            case DOUBLE: {
                return new ArrayType(ctx.lookupSimpleType(NativeSimpleType.POINTER), simpleType);
            }
        }
        return null;
    }

    protected LibFFIType(int size, int alignment, int objectCount, long type, Direction direction, boolean injectedArgument) {
        this.size = size;
        this.alignment = alignment;
        this.objectCount = objectCount;
        this.type = type;
        this.allowedDataFlowDirection = direction;
        this.injectedArgument = injectedArgument;
    }

    public abstract ClosureArgumentNode createClosureArgumentNode();

    public abstract Object deserializeRet(NativeArgumentBuffer var1, NFILanguageImpl var2);

    public LibFFIType overrideClosureRetType() {
        return this;
    }

    static enum Direction {
        JAVA_TO_NATIVE_ONLY,
        NATIVE_TO_JAVA_ONLY,
        BOTH;


        Direction reverse() {
            switch (this) {
                case JAVA_TO_NATIVE_ONLY: {
                    return NATIVE_TO_JAVA_ONLY;
                }
                case NATIVE_TO_JAVA_ONLY: {
                    return JAVA_TO_NATIVE_ONLY;
                }
                case BOTH: {
                    return BOTH;
                }
            }
            return null;
        }
    }

    @ExportLibrary(value=NativeArgumentLibrary.class)
    static final class EnvType
    extends BasePointerType {
        EnvType(LibFFIType pointerType) {
            super(pointerType, Direction.BOTH, true);
        }

        @ExportMessage
        protected void serialize(NativeArgumentBuffer buffer, Object value) {
            buffer.putObject(NativeArgumentBuffer.TypeTag.ENV, null, this.size);
        }

        @Override
        @ExportMessage(name="deserialize")
        public Object deserializeRet(NativeArgumentBuffer buffer, @CachedLanguage NFILanguageImpl language) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError((Object)"environment pointer can not be used as return type");
        }

        @Override
        public ClosureArgumentNode createClosureArgumentNode() {
            throw new AssertionError((Object)"createClosureArgumentNode should not be called on injected argument");
        }
    }

    @ExportLibrary(value=NativeArgumentLibrary.class)
    static final class ClosureType
    extends BasePointerType {
        final LibFFISignature signature;
        final boolean asRetType;

        ClosureType(LibFFIType pointerType, LibFFISignature signature, boolean asRetType) {
            super(pointerType, signature.getAllowedCallDirection().reverse(), false);
            this.signature = signature;
            this.asRetType = asRetType;
        }

        @Override
        @ExportMessage(name="deserialize")
        public Object deserializeRet(NativeArgumentBuffer buffer, @CachedLanguage NFILanguageImpl language) {
            long functionPointer = buffer.getPointer(this.size);
            if (functionPointer == 0L) {
                return NativePointer.create(language, 0L);
            }
            return NativePointer.createBound(language, functionPointer, this.signature);
        }

        @Override
        public ClosureArgumentNode createClosureArgumentNode() {
            return new ClosureArgumentNode.BufferClosureArgumentNode(this);
        }

        @ExportMessage
        static class Serialize {
            Serialize() {
            }

            @Specialization
            static void doClosure(ClosureType type, NativeArgumentBuffer buffer, LibFFIClosure closure) {
                buffer.align(type.alignment);
                if (type.asRetType) {
                    closure.nativePointer.addRef();
                } else {
                    buffer.putObject(NativeArgumentBuffer.TypeTag.CLOSURE, closure, 0);
                }
                buffer.putPointer(closure.nativePointer.getCodePointer(), type.size);
            }

            static boolean isOther(Object value) {
                return !(value instanceof LibFFIClosure);
            }

            @Specialization(limit="3", guards={"value == cachedValue", "isOther(cachedValue)", "interop.isExecutable(cachedValue)"})
            static void doExecutableCached(ClosureType type, NativeArgumentBuffer buffer, Object value, @Cached(value="value") Object cachedValue, @CachedLibrary(value="cachedValue") InteropLibrary interop, @CachedContext(value=NFILanguageImpl.class) TruffleLanguage.ContextReference<NFIContext> ctxRef, @Cached(value="create(type.signature, value, ctxRef)") LibFFIClosure cachedClosure) {
                Serialize.doClosure(type, buffer, cachedClosure);
            }

            @CompilerDirectives.TruffleBoundary
            @Specialization(limit="0", replaces={"doExecutableCached"}, guards={"isOther(value)", "interop.isExecutable(value)"})
            static void doExecutableSlowPath(ClosureType type, NativeArgumentBuffer buffer, Object value, @CachedContext(value=NFILanguageImpl.class) TruffleLanguage.ContextReference<NFIContext> ctxRef, @CachedLibrary(value="value") InteropLibrary interop) {
                LibFFIClosure closure = LibFFIClosure.create(type.signature, value, ctxRef);
                Serialize.doClosure(type, buffer, closure);
            }

            @Specialization(limit="3", guards={"isOther(value)", "!interop.isExecutable(value)"})
            static void doPointer(ClosureType type, NativeArgumentBuffer buffer, Object value, @CachedLibrary(value="value") InteropLibrary interop, @CachedLibrary(value="value") SerializeArgumentLibrary serialize) throws UnsupportedTypeException {
                buffer.align(type.alignment);
                serialize.putPointer(value, buffer, type.size);
            }
        }
    }

    @ExportLibrary(value=NativeArgumentLibrary.class)
    static final class ArrayType
    extends BasePointerType {
        final NativeSimpleType elementType;
        final HostObjectHelperNode uncachedHelper;

        ArrayType(LibFFIType pointerType, NativeSimpleType elementType) {
            super(pointerType, Direction.JAVA_TO_NATIVE_ONLY, false);
            switch (elementType) {
                case UINT8: 
                case SINT8: 
                case UINT16: 
                case SINT16: 
                case UINT32: 
                case SINT32: 
                case UINT64: 
                case SINT64: 
                case FLOAT: 
                case DOUBLE: {
                    this.elementType = elementType;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("only primitive array types are supported, got [%s]", new Object[]{elementType}));
                }
            }
            this.uncachedHelper = new UncachedHostObjectHelperNode(this.size, elementType);
        }

        @ExportMessage
        boolean accepts(@Cached(value="this.elementType") NativeSimpleType cachedType) {
            return cachedType == this.elementType;
        }

        @ExportMessage
        void serialize(NativeArgumentBuffer buffer, Object value, @Cached SerializeHelperNode serializeHelper) throws UnsupportedTypeException {
            buffer.align(this.alignment);
            serializeHelper.execute(this, buffer, value);
        }

        @Override
        @ExportMessage(name="deserialize")
        public Object deserializeRet(NativeArgumentBuffer buffer, @CachedLanguage NFILanguageImpl language) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError((Object)"Arrays can only be passed from Java to native");
        }

        @Override
        public ClosureArgumentNode createClosureArgumentNode() {
            throw new AssertionError((Object)"Arrays can only be passed from Java to native");
        }

        static final class UncachedHostObjectHelperNode
        extends HostObjectHelperNode {
            private final SerializeArgumentLibrary uncachedLib1;
            private final SerializeArgumentLibrary uncachedLib2;

            UncachedHostObjectHelperNode(int size, NativeSimpleType elementType) {
                super(size, elementType);
                this.uncachedLib1 = this.arrayClass1 != null ? (SerializeArgumentLibrary)SerializeArgumentLibrary.getFactory().getUncached(Array.newInstance(this.arrayClass1.getComponentType(), 0)) : null;
                this.uncachedLib2 = this.arrayClass2 != null ? (SerializeArgumentLibrary)SerializeArgumentLibrary.getFactory().getUncached(Array.newInstance(this.arrayClass2.getComponentType(), 0)) : null;
            }

            @Override
            void execute(NativeArgumentBuffer buffer, Object value) throws UnsupportedTypeException, HostObjectHelperNode.WrongTypeException {
                if (this.arrayClass1 == value.getClass()) {
                    assert (this.uncachedLib1.accepts(value));
                    this.uncachedLib1.putPointer(CompilerDirectives.castExact((Object)value, (Class)this.arrayClass1), buffer, this.size);
                } else if (this.arrayClass2 == value.getClass()) {
                    assert (this.uncachedLib2.accepts(value));
                    this.uncachedLib2.putPointer(CompilerDirectives.castExact((Object)value, (Class)this.arrayClass2), buffer, this.size);
                } else {
                    throw new HostObjectHelperNode.WrongTypeException();
                }
            }
        }

        static abstract class CachedHostObjectHelperNode
        extends HostObjectHelperNode {
            protected CachedHostObjectHelperNode(int size, NativeSimpleType elementType) {
                super(size, elementType);
            }

            @Specialization(guards={"arrayClass1 == value.getClass()"}, limit="1")
            void doHostArray1(NativeArgumentBuffer buffer, Object value, @Cached.Exclusive @CachedLibrary(value="value") SerializeArgumentLibrary lib) throws UnsupportedTypeException {
                lib.putPointer(CompilerDirectives.castExact((Object)value, (Class)this.arrayClass1), buffer, this.size);
            }

            @Specialization(guards={"arrayClass2 == value.getClass()"}, limit="1")
            void doHostArray2(NativeArgumentBuffer buffer, Object value, @Cached.Exclusive @CachedLibrary(value="value") SerializeArgumentLibrary lib) throws UnsupportedTypeException {
                lib.putPointer(CompilerDirectives.castExact((Object)value, (Class)this.arrayClass2), buffer, this.size);
            }

            @Fallback
            void doOther(NativeArgumentBuffer buffer, Object value) throws HostObjectHelperNode.WrongTypeException {
                throw new HostObjectHelperNode.WrongTypeException();
            }
        }

        static abstract class HostObjectHelperNode
        extends Node {
            final int size;
            final Class<?> arrayClass1;
            final Class<?> arrayClass2;

            static HostObjectHelperNode create(ArrayType type) {
                return LibFFITypeFactory.ArrayTypeFactory.CachedHostObjectHelperNodeGen.create(type.size, type.elementType);
            }

            static HostObjectHelperNode getUncached(ArrayType type) {
                return type.uncachedHelper;
            }

            protected HostObjectHelperNode(int size, NativeSimpleType elementType) {
                this.size = size;
                switch (elementType) {
                    case UINT8: 
                    case SINT8: {
                        this.arrayClass1 = byte[].class;
                        this.arrayClass2 = boolean[].class;
                        break;
                    }
                    case UINT16: 
                    case SINT16: {
                        this.arrayClass1 = short[].class;
                        this.arrayClass2 = char[].class;
                        break;
                    }
                    case UINT32: 
                    case SINT32: {
                        this.arrayClass1 = int[].class;
                        this.arrayClass2 = null;
                        break;
                    }
                    case UINT64: 
                    case SINT64: {
                        this.arrayClass1 = long[].class;
                        this.arrayClass2 = null;
                        break;
                    }
                    case FLOAT: {
                        this.arrayClass1 = float[].class;
                        this.arrayClass2 = null;
                        break;
                    }
                    case DOUBLE: {
                        this.arrayClass1 = double[].class;
                        this.arrayClass2 = null;
                        break;
                    }
                    default: {
                        this.arrayClass1 = null;
                        this.arrayClass2 = null;
                    }
                }
            }

            abstract void execute(NativeArgumentBuffer var1, Object var2) throws UnsupportedTypeException, WrongTypeException;

            final class WrongTypeException
            extends ControlFlowException {
                private static final long serialVersionUID = 1L;

                WrongTypeException() {
                }
            }
        }

        @ImportStatic(value={NFILanguageImpl.class})
        @GenerateUncached
        static abstract class SerializeHelperNode
        extends Node {
            SerializeHelperNode() {
            }

            abstract void execute(ArrayType var1, NativeArgumentBuffer var2, Object var3) throws UnsupportedTypeException;

            static boolean isHostObject(NFIContext ctx, Object value) {
                return ctx.env.isHostObject(value) && ctx.env.asHostObject(value) != null;
            }

            @Specialization(guards={"isHostObject(ctx, value)"}, rewriteOn={HostObjectHelperNode.WrongTypeException.class})
            static void doHostObject(ArrayType type, NativeArgumentBuffer buffer, Object value, @CachedContext(value=NFILanguageImpl.class) NFIContext ctx, @Cached(parameters={"type"}) HostObjectHelperNode helper) throws UnsupportedTypeException, HostObjectHelperNode.WrongTypeException {
                Object hostObject = ctx.env.asHostObject(value);
                helper.execute(buffer, hostObject);
            }

            @Specialization(guards={"!isHostObject(ctx, value)"}, limit="3")
            static void doInteropObject(ArrayType type, NativeArgumentBuffer buffer, Object value, @CachedContext(value=NFILanguageImpl.class) NFIContext ctx, @CachedLibrary(value="value") SerializeArgumentLibrary serialize) throws UnsupportedTypeException {
                serialize.putPointer(value, buffer, type.size);
            }

            @Specialization(limit="3", replaces={"doHostObject", "doInteropObject"})
            static void doGeneric(ArrayType type, NativeArgumentBuffer buffer, Object value, @CachedContext(value=NFILanguageImpl.class) NFIContext ctx, @CachedLibrary(value="value") SerializeArgumentLibrary serialize, @Cached(parameters={"type"}) HostObjectHelperNode helper) throws UnsupportedTypeException {
                if (SerializeHelperNode.isHostObject(ctx, value)) {
                    try {
                        SerializeHelperNode.doHostObject(type, buffer, value, ctx, helper);
                        return;
                    }
                    catch (HostObjectHelperNode.WrongTypeException wrongTypeException) {
                        // empty catch block
                    }
                }
                SerializeHelperNode.doInteropObject(type, buffer, value, ctx, serialize);
            }
        }
    }

    static abstract class BasePointerType
    extends LibFFIType {
        protected BasePointerType(LibFFIType pointerType, Direction direction, boolean injectedArgument) {
            super(pointerType.size, pointerType.alignment, 1, pointerType.type, direction, injectedArgument);
        }
    }

    static final class ObjectType
    extends BasicType {
        ObjectType(NFIContext ctx, int size, int alignment, long ffiType) {
            super(ctx, NativeSimpleType.OBJECT, size, alignment, 1, ffiType);
        }

        @Override
        public ClosureArgumentNode createClosureArgumentNode() {
            return new ClosureArgumentNode.ObjectClosureArgumentNode();
        }
    }

    static final class StringType
    extends BasicType {
        private StringType(NFIContext ctx, int size, int alignment, long ffiType) {
            super(ctx, NativeSimpleType.STRING, size, alignment, 1, ffiType);
        }

        @Override
        public ClosureArgumentNode createClosureArgumentNode() {
            return new ClosureArgumentNode.StringClosureArgumentNode();
        }
    }

    static final class VoidType
    extends BasicType {
        private VoidType(NFIContext ctx, int size, int alignment, long ffiType) {
            super(ctx, NativeSimpleType.VOID, size, alignment, 0, ffiType);
        }

        @Override
        public ClosureArgumentNode createClosureArgumentNode() {
            throw new AssertionError((Object)"invalid argument type VOID");
        }

        @Override
        public Object deserializeRet(NativeArgumentBuffer buffer, NFILanguageImpl language) {
            return NativePointer.create(language, 0L);
        }
    }

    static final class SimpleType
    extends BasicType {
        SimpleType(NFIContext ctx, NativeSimpleType simpleType, int size, int alignment, long ffiType) {
            super(ctx, simpleType, size, alignment, 0, ffiType);
        }

        public Object fromPrimitive(long primitive) {
            switch (this.simpleType) {
                case VOID: {
                    return NativePointer.create(this.ctx.language, 0L);
                }
                case UINT8: {
                    return primitive & 0xFFL;
                }
                case SINT8: {
                    return (byte)primitive;
                }
                case UINT16: {
                    return primitive & 0xFFFFL;
                }
                case SINT16: {
                    return (short)primitive;
                }
                case UINT32: {
                    return primitive & 0xFFFFFFFFL;
                }
                case SINT32: {
                    return (int)primitive;
                }
                case UINT64: 
                case SINT64: {
                    return primitive;
                }
                case FLOAT: {
                    int ret = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? (int)(primitive >>> 32) : (int)primitive;
                    return Float.valueOf(Float.intBitsToFloat(ret));
                }
                case DOUBLE: {
                    return Double.longBitsToDouble(primitive);
                }
                case POINTER: {
                    return NativePointer.create(this.ctx.language, primitive);
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError((Object)this.simpleType.name());
        }

        @Override
        public ClosureArgumentNode createClosureArgumentNode() {
            return new ClosureArgumentNode.BufferClosureArgumentNode(this);
        }

        @Override
        public LibFFIType overrideClosureRetType() {
            switch (this.simpleType) {
                case UINT8: 
                case UINT16: 
                case UINT32: {
                    return this.ctx.lookupSimpleType(NativeSimpleType.UINT64);
                }
                case SINT8: 
                case SINT16: 
                case SINT32: {
                    return this.ctx.lookupSimpleType(NativeSimpleType.SINT64);
                }
            }
            return this;
        }
    }

    @ExportLibrary(value=NativeArgumentLibrary.class)
    static abstract class BasicType
    extends LibFFIType {
        final NFIContext ctx;
        final NativeSimpleType simpleType;

        BasicType(NFIContext ctx, NativeSimpleType simpleType, int size, int alignment, int objectCount, long ffiType) {
            super(size, alignment, objectCount, ffiType, Direction.BOTH, false);
            this.ctx = ctx;
            this.simpleType = simpleType;
        }

        @ExportMessage
        boolean accepts(@Cached.Shared(value="cachedType") @Cached(value="this.simpleType") NativeSimpleType cachedType) {
            return cachedType == this.simpleType;
        }

        @ExportMessage
        void serialize(NativeArgumentBuffer buffer, Object value, @Cached.Shared(value="cachedType") @Cached(value="this.simpleType") NativeSimpleType cachedType, @CachedLibrary(limit="3") SerializeArgumentLibrary serialize) throws UnsupportedTypeException {
            buffer.align(this.alignment);
            switch (cachedType) {
                case UINT8: {
                    serialize.putUByte(value, buffer);
                    break;
                }
                case SINT8: {
                    serialize.putByte(value, buffer);
                    break;
                }
                case UINT16: {
                    serialize.putUShort(value, buffer);
                    break;
                }
                case SINT16: {
                    serialize.putShort(value, buffer);
                    break;
                }
                case UINT32: {
                    serialize.putUInt(value, buffer);
                    break;
                }
                case SINT32: {
                    serialize.putInt(value, buffer);
                    break;
                }
                case UINT64: {
                    serialize.putULong(value, buffer);
                    break;
                }
                case SINT64: {
                    serialize.putLong(value, buffer);
                    break;
                }
                case FLOAT: {
                    serialize.putFloat(value, buffer);
                    break;
                }
                case DOUBLE: {
                    serialize.putDouble(value, buffer);
                    break;
                }
                case POINTER: {
                    serialize.putPointer(value, buffer, this.size);
                    break;
                }
                case STRING: {
                    serialize.putString(value, buffer, this.size);
                    break;
                }
                case OBJECT: {
                    buffer.putObject(NativeArgumentBuffer.TypeTag.OBJECT, value, this.size);
                    break;
                }
                default: {
                    CompilerDirectives.transferToInterpreter();
                    throw new AssertionError((Object)this.simpleType.name());
                }
            }
        }

        @ExportMessage
        Object deserialize(NativeArgumentBuffer buffer, @Cached.Shared(value="cachedType") @Cached(value="this.simpleType") NativeSimpleType cachedType, @CachedLanguage NFILanguageImpl language) {
            buffer.align(this.alignment);
            switch (cachedType) {
                case VOID: {
                    return null;
                }
                case UINT8: {
                    return buffer.getInt8() & 0xFF;
                }
                case SINT8: {
                    return buffer.getInt8();
                }
                case UINT16: {
                    return buffer.getInt16() & 0xFFFF;
                }
                case SINT16: {
                    return buffer.getInt16();
                }
                case UINT32: {
                    return (long)buffer.getInt32() & 0xFFFFFFFFL;
                }
                case SINT32: {
                    return buffer.getInt32();
                }
                case UINT64: 
                case SINT64: {
                    return buffer.getInt64();
                }
                case FLOAT: {
                    return Float.valueOf(buffer.getFloat());
                }
                case DOUBLE: {
                    return buffer.getDouble();
                }
                case POINTER: {
                    return NativePointer.create(language, buffer.getPointer(this.size));
                }
                case STRING: {
                    return new NativeString(buffer.getPointer(this.size));
                }
                case OBJECT: {
                    Object ret = buffer.getObject(this.size);
                    if (ret == null) {
                        return NativePointer.create(language, 0L);
                    }
                    return ret;
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError((Object)this.simpleType.name());
        }

        @Override
        public Object deserializeRet(NativeArgumentBuffer buffer, NFILanguageImpl language) {
            return this.deserialize(buffer, this.simpleType, language);
        }
    }
}

