/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.nfi.impl.FunctionExecuteNode;
import com.oracle.truffle.nfi.impl.LibFFILibrary;
import com.oracle.truffle.nfi.impl.NFIContext;
import com.oracle.truffle.nfi.impl.NFIUnsatisfiedLinkError;
import com.oracle.truffle.nfi.impl.NativePointer;
import com.oracle.truffle.nfi.impl.NativeString;
import com.oracle.truffle.nfi.spi.NFIBackend;
import com.oracle.truffle.nfi.spi.NFIBackendFactory;
import com.oracle.truffle.nfi.spi.NFIBackendTools;
import com.oracle.truffle.nfi.spi.types.NativeLibraryDescriptor;
import java.util.Iterator;

@TruffleLanguage.Registration(id="internal/nfi-native", name="nfi-native", version="0.1", characterMimeTypes={"trufflenfi/native"}, internal=true, services={NFIBackendFactory.class})
public class NFILanguageImpl
extends TruffleLanguage<NFIContext> {
    public static final String MIME_TYPE = "trufflenfi/native";
    @CompilerDirectives.CompilationFinal
    private CallTarget slowPathCall;
    @CompilerDirectives.CompilationFinal
    private NFIBackendImpl backend;

    CallTarget getSlowPathCall() {
        if (this.slowPathCall == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.slowPathCall = Truffle.getRuntime().createCallTarget((RootNode)new FunctionExecuteNode.SlowPathExecuteNode(this));
        }
        return this.slowPathCall;
    }

    NFIBackendTools getTools() {
        return this.backend.tools;
    }

    protected NFIContext createContext(TruffleLanguage.Env env) {
        env.registerService((Object)new NFIBackendFactory(){

            @Override
            public String getBackendId() {
                return "native";
            }

            @Override
            public NFIBackend createBackend(NFIBackendTools tools) {
                if (NFILanguageImpl.this.backend == null) {
                    NFILanguageImpl.this.backend = new NFIBackendImpl(tools);
                }
                return NFILanguageImpl.this.backend;
            }
        });
        return new NFIContext(this, env);
    }

    protected void initializeContext(NFIContext context) throws Exception {
        context.initialize();
    }

    protected boolean patchContext(NFIContext context, TruffleLanguage.Env newEnv) {
        context.patchEnv(newEnv);
        context.initialize();
        return true;
    }

    protected void disposeContext(NFIContext context) {
        context.dispose();
    }

    protected boolean isThreadAccessAllowed(Thread thread, boolean singleThreaded) {
        return true;
    }

    protected CallTarget parse(TruffleLanguage.ParsingRequest request) throws Exception {
        return Truffle.getRuntime().createCallTarget(new RootNode(this){

            public Object execute(VirtualFrame frame) {
                throw new UnsupportedOperationException("illegal access to internal language");
            }
        });
    }

    protected boolean isObjectOfLanguage(Object object) {
        return object instanceof LibFFILibrary || object instanceof NativePointer || object instanceof NativeString;
    }

    private final class NFIBackendImpl
    implements NFIBackend {
        final NFIBackendTools tools;

        NFIBackendImpl(NFIBackendTools tools) {
            this.tools = tools;
        }

        @Override
        public CallTarget parse(NativeLibraryDescriptor descriptor) {
            RootNode root;
            NFIContext ctx = (NFIContext)NFILanguageImpl.this.getContextReference().get();
            if (descriptor.isDefaultLibrary()) {
                root = new GetDefaultLibraryNode(NFILanguageImpl.this);
            } else {
                int flags = 0;
                boolean lazyOrNow = false;
                if (descriptor.getFlags() != null) {
                    Iterator<String> iterator = descriptor.getFlags().iterator();
                    while (iterator.hasNext()) {
                        String flag;
                        switch (flag = iterator.next()) {
                            case "RTLD_GLOBAL": {
                                flags |= ctx.RTLD_GLOBAL;
                                break;
                            }
                            case "RTLD_LOCAL": {
                                flags |= ctx.RTLD_LOCAL;
                                break;
                            }
                            case "RTLD_LAZY": {
                                flags |= ctx.RTLD_LAZY;
                                lazyOrNow = true;
                                break;
                            }
                            case "RTLD_NOW": {
                                flags |= ctx.RTLD_NOW;
                                lazyOrNow = true;
                            }
                        }
                    }
                }
                if (!lazyOrNow) {
                    flags |= ctx.RTLD_NOW;
                }
                root = new LoadLibraryNode(NFILanguageImpl.this, descriptor.getFilename(), flags);
            }
            return Truffle.getRuntime().createCallTarget(root);
        }
    }

    private static class GetDefaultLibraryNode
    extends RootNode {
        private final TruffleLanguage.ContextReference<NFIContext> ctxRef = this.lookupContextReference(NFILanguageImpl.class);

        GetDefaultLibraryNode(NFILanguageImpl language) {
            super((TruffleLanguage)language);
        }

        public boolean isInternal() {
            return true;
        }

        public Object execute(VirtualFrame frame) {
            if (!((NFIContext)this.ctxRef.get()).env.isNativeAccessAllowed()) {
                CompilerDirectives.transferToInterpreter();
                throw new NFIUnsatisfiedLinkError("Access to native code is not allowed by the host environment.", (Node)this);
            }
            return LibFFILibrary.createDefault();
        }
    }

    private static class LoadLibraryNode
    extends RootNode {
        private final String name;
        private final int flags;
        @CompilerDirectives.CompilationFinal
        private LibFFILibrary cached;
        private final TruffleLanguage.ContextReference<NFIContext> ctxRef;

        LoadLibraryNode(NFILanguageImpl language, String name, int flags) {
            super((TruffleLanguage)language);
            this.name = name;
            this.flags = flags;
            this.ctxRef = this.lookupContextReference(NFILanguageImpl.class);
        }

        public boolean isInternal() {
            return true;
        }

        public Object execute(VirtualFrame frame) {
            if (!((NFIContext)this.ctxRef.get()).env.isNativeAccessAllowed()) {
                CompilerDirectives.transferToInterpreter();
                throw new NFIUnsatisfiedLinkError("Access to native code is not allowed by the host environment.", (Node)this);
            }
            if (this.cached == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.cached = ((NFIContext)this.ctxRef.get()).loadLibrary(this.name, this.flags);
            }
            return this.cached;
        }
    }
}

