/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.impl.FunctionExecuteNode;
import com.oracle.truffle.nfi.impl.FunctionExecuteNodeGen;
import com.oracle.truffle.nfi.impl.NFIContext;
import com.oracle.truffle.nfi.impl.NFILanguageImpl;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.NativePointer;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary;
import com.oracle.truffle.nfi.spi.NativeSymbolLibrary;
import com.oracle.truffle.nfi.spi.types.NativeSignature;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=NativePointer.class)
final class NativePointerGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private NativePointerGen() {
    }

    static {
        LibraryExport.register(NativePointer.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports(), new SerializeArgumentLibraryExports(), new NativeSymbolLibraryExports()});
    }

    @GeneratedBy(value=NativePointer.class)
    private static final class NativeSymbolLibraryExports
    extends LibraryExport<NativeSymbolLibrary> {
        private NativeSymbolLibraryExports() {
            super(NativeSymbolLibrary.class, NativePointer.class, false);
        }

        protected NativeSymbolLibrary createUncached(Object receiver) {
            assert (receiver instanceof NativePointer);
            return new Uncached(receiver);
        }

        protected NativeSymbolLibrary createCached(Object receiver) {
            assert (receiver instanceof NativePointer);
            return new Cached(receiver);
        }

        @GeneratedBy(value=NativePointer.class)
        private static final class Uncached
        extends NativeSymbolLibrary {
            private final Class<? extends NativePointer> receiverClass_;
            private final TruffleLanguage.ContextReference<NFIContext> nFILanguageImplContextReference_ = this.lookupContextReference(NFILanguageImpl.class);

            Uncached(Object receiver) {
                this.receiverClass_ = ((NativePointer)receiver).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.nfi.impl.NativePointer'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isBindable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer)receiver).isBindable();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object prepareSignature(Object arg0Value_, NativeSignature arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NativePointer arg0Value = (NativePointer)arg0Value_;
                return arg0Value.prepareSignature(arg1Value, (NFIContext)this.nFILanguageImplContextReference_.get());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object call(Object arg0Value_, Object arg1Value, Object ... arg2Value) throws ArityException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NativePointer arg0Value = (NativePointer)arg0Value_;
                return arg0Value.call(arg1Value, arg2Value, FunctionExecuteNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=NativePointer.class)
        private static final class Cached
        extends NativeSymbolLibrary {
            private final Class<? extends NativePointer> receiverClass_;
            @CompilerDirectives.CompilationFinal
            private int state_;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.ContextReference<NFIContext> nFILanguageImplContextReference_;
            @Node.Child
            private FunctionExecuteNode callNode__execute_;

            Cached(Object receiver) {
                this.receiverClass_ = ((NativePointer)receiver).getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.nfi.impl.NativePointer'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            public boolean isBindable(Object receiver) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isBindable();
            }

            @Override
            public Object prepareSignature(Object arg0Value_, NativeSignature arg1Value) throws UnsupportedMessageException, UnsupportedTypeException {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NativePointer arg0Value = (NativePointer)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_);
                int state = this.state_;
                if ((state & 1) != 0) {
                    return arg0Value.prepareSignature(arg1Value, (NFIContext)this.nFILanguageImplContextReference_.get());
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.prepareSignatureNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object prepareSignatureNode_AndSpecialize(NativePointer arg0Value, NativeSignature arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    TruffleLanguage.ContextReference nFILanguageImplContextReference__ = this.nFILanguageImplContextReference_;
                    if (nFILanguageImplContextReference__ == null) {
                        this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__ = super.lookupContextReference(NFILanguageImpl.class);
                    }
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.prepareSignature(arg1Value, (NFIContext)nFILanguageImplContextReference__.get());
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if ((state & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object call(Object arg0Value_, Object arg1Value, Object ... arg2Value) throws ArityException, UnsupportedMessageException, UnsupportedTypeException {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NativePointer arg0Value = (NativePointer)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_);
                int state = this.state_;
                if ((state & 2) != 0) {
                    return arg0Value.call(arg1Value, arg2Value, this.callNode__execute_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.callNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object callNode_AndSpecialize(NativePointer arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.callNode__execute_ = (FunctionExecuteNode)super.insert((Node)FunctionExecuteNodeGen.create());
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.call(arg1Value, arg2Value, this.callNode__execute_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }
        }
    }

    @GeneratedBy(value=NativePointer.class)
    private static final class SerializeArgumentLibraryExports
    extends LibraryExport<SerializeArgumentLibrary> {
        private SerializeArgumentLibraryExports() {
            super(SerializeArgumentLibrary.class, NativePointer.class, false);
        }

        protected SerializeArgumentLibrary createUncached(Object receiver) {
            assert (receiver instanceof NativePointer);
            return new Uncached(receiver);
        }

        protected SerializeArgumentLibrary createCached(Object receiver) {
            assert (receiver instanceof NativePointer);
            return new Cached(receiver);
        }

        @GeneratedBy(value=NativePointer.class)
        private static final class Uncached
        extends SerializeArgumentLibrary {
            private final Class<? extends NativePointer> receiverClass_;

            Uncached(Object receiver) {
                this.receiverClass_ = ((NativePointer)receiver).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.nfi.impl.NativePointer'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void putPointer(Object receiver, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((NativePointer)receiver).putPointer(buffer, ptrSize);
            }
        }

        @GeneratedBy(value=NativePointer.class)
        private static final class Cached
        extends SerializeArgumentLibrary {
            private final Class<? extends NativePointer> receiverClass_;

            Cached(Object receiver) {
                this.receiverClass_ = ((NativePointer)receiver).getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.nfi.impl.NativePointer'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            public void putPointer(Object receiver, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((NativePointer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).putPointer(buffer, ptrSize);
            }
        }
    }

    @GeneratedBy(value=NativePointer.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, NativePointer.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof NativePointer);
            return new Uncached(receiver);
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof NativePointer);
            return new Cached(receiver);
        }

        @GeneratedBy(value=NativePointer.class)
        private static final class Uncached
        extends InteropLibrary {
            private final Class<? extends NativePointer> receiverClass_;

            Uncached(Object receiver) {
                this.receiverClass_ = ((NativePointer)receiver).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.nfi.impl.NativePointer'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer)receiver).isPointer();
            }

            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer)receiver).asPointer();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isNull(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer)receiver).isNull();
            }
        }

        @GeneratedBy(value=NativePointer.class)
        private static final class Cached
        extends InteropLibrary {
            private final Class<? extends NativePointer> receiverClass_;

            Cached(Object receiver) {
                this.receiverClass_ = ((NativePointer)receiver).getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.nfi.impl.NativePointer'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isPointer();
            }

            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).asPointer();
            }

            public boolean isNull(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isNull();
            }
        }
    }
}

