/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.nfi.impl.FunctionExecuteNode;
import com.oracle.truffle.nfi.impl.LibFFISignature;
import com.oracle.truffle.nfi.impl.LibFFIType;
import com.oracle.truffle.nfi.impl.NFIContext;
import com.oracle.truffle.nfi.impl.NFILanguageImpl;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary;
import com.oracle.truffle.nfi.spi.NativeSymbolLibrary;
import com.oracle.truffle.nfi.spi.types.NativeSignature;

@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class), @ExportLibrary(value=SerializeArgumentLibrary.class), @ExportLibrary(value=NativeSymbolLibrary.class)})
class NativePointer
implements TruffleObject {
    final long nativePointer;

    static Object create(NFILanguageImpl language, long nativePointer) {
        return language.getTools().createBindableSymbol(new NativePointer(nativePointer));
    }

    static Object createBound(NFILanguageImpl language, long nativePointer, LibFFISignature signature) {
        return language.getTools().createBoundSymbol(new NativePointer(nativePointer), signature);
    }

    NativePointer(long nativePointer) {
        this.nativePointer = nativePointer;
    }

    public String toString() {
        return String.valueOf(this.nativePointer);
    }

    @ExportMessage
    boolean isPointer() {
        return true;
    }

    @ExportMessage
    long asPointer() {
        return this.nativePointer;
    }

    @ExportMessage
    boolean isNull() {
        return this.nativePointer == 0L;
    }

    @ExportMessage
    void putPointer(NativeArgumentBuffer buffer, int ptrSize) {
        buffer.putPointer(this.nativePointer, ptrSize);
    }

    @ExportMessage
    boolean isBindable() {
        return this.nativePointer != 0L;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object prepareSignature(NativeSignature signature, @CachedContext(value=NFILanguageImpl.class) NFIContext ctx) {
        LibFFISignature ret = LibFFISignature.create(ctx, signature);
        if (ret.getAllowedCallDirection() == LibFFIType.Direction.NATIVE_TO_JAVA_ONLY) {
            throw new IllegalArgumentException("signature is only valid for native to Java callbacks");
        }
        return ret;
    }

    @ExportMessage
    Object call(Object signature, Object[] args, @Cached FunctionExecuteNode execute) throws ArityException, UnsupportedTypeException {
        if (!(signature instanceof LibFFISignature)) {
            CompilerDirectives.transferToInterpreter();
            throw UnsupportedTypeException.create((Object[])new Object[]{signature});
        }
        return execute.execute(this, (LibFFISignature)signature, args);
    }
}

