/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.nfi.NFILibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=NFILibrary.Keys.class)
final class KeysGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private KeysGen() {
    }

    static {
        LibraryExport.register(NFILibrary.Keys.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=NFILibrary.Keys.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, NFILibrary.Keys.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof NFILibrary.Keys);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof NFILibrary.Keys);
            return new Cached();
        }

        @GeneratedBy(value=NFILibrary.Keys.class)
        private static final class Uncached
        extends InteropLibrary {
            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof NFILibrary.Keys) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.nfi.NFILibrary.Keys'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFILibrary.Keys;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFILibrary.Keys)receiver).hasArrayElements();
            }

            @CompilerDirectives.TruffleBoundary
            public long getArraySize(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFILibrary.Keys)receiver).getArraySize();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementReadable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFILibrary.Keys)receiver).isArrayElementReadable(index);
            }

            @CompilerDirectives.TruffleBoundary
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFILibrary.Keys arg0Value = (NFILibrary.Keys)arg0Value_;
                return arg0Value.readArrayElement(arg1Value, BranchProfile.getUncached());
            }
        }

        @GeneratedBy(value=NFILibrary.Keys.class)
        private static final class Cached
        extends InteropLibrary {
            @CompilerDirectives.CompilationFinal
            private int state_;
            @CompilerDirectives.CompilationFinal
            private BranchProfile exception_;

            Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof NFILibrary.Keys) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.nfi.NFILibrary.Keys'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFILibrary.Keys;
            }

            public boolean hasArrayElements(Object receiver) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFILibrary.Keys)receiver).hasArrayElements();
            }

            public long getArraySize(Object receiver) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFILibrary.Keys)receiver).getArraySize();
            }

            public boolean isArrayElementReadable(Object receiver, long index) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFILibrary.Keys)receiver).isArrayElementReadable(index);
            }

            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFILibrary.Keys arg0Value = (NFILibrary.Keys)arg0Value_;
                int state = this.state_;
                if (state != 0) {
                    return arg0Value.readArrayElement(arg1Value, this.exception_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(NFILibrary.Keys arg0Value, long arg1Value) throws InvalidArrayIndexException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.exception_ = BranchProfile.create();
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.readArrayElement(arg1Value, this.exception_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if (state == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }
}

