// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.TruffleLanguage.LanguageReference;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.impl.LibFFIType;
import com.oracle.truffle.nfi.impl.NFILanguageImpl;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.NativeArgumentLibrary;
import com.oracle.truffle.nfi.impl.LibFFIType.EnvType;
import java.util.concurrent.locks.Lock;

@GeneratedBy(EnvType.class)
final class EnvTypeGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(EnvType.class, new NativeArgumentLibraryExports());
    }

    private EnvTypeGen() {
    }

    @GeneratedBy(EnvType.class)
    private static final class NativeArgumentLibraryExports extends LibraryExport<NativeArgumentLibrary> {

        private NativeArgumentLibraryExports() {
            super(NativeArgumentLibrary.class, EnvType.class, false);
        }

        @Override
        protected NativeArgumentLibrary createUncached(Object receiver) {
            assert receiver instanceof EnvType;
            NativeArgumentLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected NativeArgumentLibrary createCached(Object receiver) {
            assert receiver instanceof EnvType;
            return new Cached();
        }

        @GeneratedBy(EnvType.class)
        private static final class Cached extends NativeArgumentLibrary {

            @CompilationFinal private volatile int state_;
            @CompilationFinal private LanguageReference<NFILanguageImpl> nFILanguageImplReference_;

            Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof EnvType) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof EnvType;
            }

            @Override
            public void serialize(LibFFIType receiver, NativeArgumentBuffer buffer, Object value) throws UnsupportedTypeException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                (((EnvType) receiver)).serialize(buffer, value);
                return;
            }

            @Override
            public Object deserialize(LibFFIType arg0Value_, NativeArgumentBuffer arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                EnvType arg0Value = ((EnvType) arg0Value_);
                int state = state_;
                if (state != 0 /* is-active deserializeRet(EnvType, NativeArgumentBuffer, NFILanguageImpl) */) {
                    {
                        LanguageReference<NFILanguageImpl> nFILanguageImplReference__ = this.nFILanguageImplReference_;
                        NFILanguageImpl language__ = nFILanguageImplReference__.get();
                        return arg0Value.deserializeRet(arg1Value, language__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(EnvType arg0Value, NativeArgumentBuffer arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    {
                        NFILanguageImpl language__ = null;
                        LanguageReference<NFILanguageImpl> nFILanguageImplReference__1 = this.nFILanguageImplReference_;
                        if (nFILanguageImplReference__1 == null) {
                            this.nFILanguageImplReference_ = nFILanguageImplReference__1 = super.lookupLanguageReference(NFILanguageImpl.class);
                        }
                        language__ = nFILanguageImplReference__1.get();
                        this.state_ = state = state | 0b1 /* add-active deserializeRet(EnvType, NativeArgumentBuffer, NFILanguageImpl) */;
                        lock.unlock();
                        hasLock = false;
                        return arg0Value.deserializeRet(arg1Value, language__);
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
        @GeneratedBy(EnvType.class)
        private static final class Uncached extends NativeArgumentLibrary {

            private final LanguageReference<NFILanguageImpl> nFILanguageImplReference_ = lookupLanguageReference(NFILanguageImpl.class);

            Uncached() {
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof EnvType) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof EnvType;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public void serialize(LibFFIType receiver, NativeArgumentBuffer buffer, Object value) throws UnsupportedTypeException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                ((EnvType) receiver) .serialize(buffer, value);
                return;
            }

            @TruffleBoundary
            @Override
            public Object deserialize(LibFFIType arg0Value_, NativeArgumentBuffer arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                EnvType arg0Value = ((EnvType) arg0Value_);
                return arg0Value.deserializeRet(arg1Value, this.nFILanguageImplReference_.get());
            }

        }
    }
}
