// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary.LongArrayConversion;

@GeneratedBy(LongArrayConversion.class)
final class LongArrayConversionGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(LongArrayConversion.class, new SerializeArgumentLibraryExports());
    }

    private LongArrayConversionGen() {
    }

    @GeneratedBy(LongArrayConversion.class)
    private static final class SerializeArgumentLibraryExports extends LibraryExport<SerializeArgumentLibrary> {

        private static final Uncached UNCACHED = new Uncached();
        private static final Cached CACHE = new Cached();

        private SerializeArgumentLibraryExports() {
            super(SerializeArgumentLibrary.class, long[].class, true);
        }

        @Override
        protected SerializeArgumentLibrary createUncached(Object receiver) {
            assert receiver instanceof long[];
            SerializeArgumentLibrary uncached = SerializeArgumentLibraryExports.UNCACHED;
            return uncached;
        }

        @Override
        protected SerializeArgumentLibrary createCached(Object receiver) {
            assert receiver instanceof long[];
            return SerializeArgumentLibraryExports.CACHE;
        }

        @GeneratedBy(LongArrayConversion.class)
        private static final class Cached extends SerializeArgumentLibrary {

            Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof long[]) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof long[];
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public void putPointer(Object receiver, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                LongArrayConversion.putPointer((((long[]) receiver)), buffer, ptrSize);
                return;
            }

        }
        @GeneratedBy(LongArrayConversion.class)
        private static final class Uncached extends SerializeArgumentLibrary {

            Uncached() {
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof long[]) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof long[];
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public void putPointer(Object receiver, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                LongArrayConversion.putPointer(((long[]) receiver) , buffer, ptrSize);
                return;
            }

        }
    }
}
