// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.nfi.impl.LibFFIType;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.NativeArgumentLibrary;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.locks.Lock;

@GeneratedBy(NativeArgumentLibrary.class)
final class NativeArgumentLibraryGen extends LibraryFactory<NativeArgumentLibrary> {

    private static final Class<NativeArgumentLibrary> LIBRARY_CLASS = NativeArgumentLibraryGen.lazyLibraryClass();
    private static final Message SERIALIZE = new MessageImpl("serialize", 0, void.class, LibFFIType.class, NativeArgumentBuffer.class, Object.class);
    private static final Message DESERIALIZE = new MessageImpl("deserialize", 1, Object.class, LibFFIType.class, NativeArgumentBuffer.class);
    private static final NativeArgumentLibraryGen INSTANCE = new NativeArgumentLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(NativeArgumentLibraryGen.LIBRARY_CLASS, new Default());
        LibraryFactory.register(NativeArgumentLibraryGen.LIBRARY_CLASS, INSTANCE);
    }

    private NativeArgumentLibraryGen() {
        super(NativeArgumentLibraryGen.LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(NativeArgumentLibraryGen.SERIALIZE, NativeArgumentLibraryGen.DESERIALIZE)));
    }

    @Override
    protected Class<?> getDefaultClass(Object receiver) {
        return NativeArgumentLibrary.class;
    }

    @Override
    protected NativeArgumentLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    @Override
    protected FinalBitSet createMessageBitSet(Message... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(((MessageImpl) message).index);
        }
        return FinalBitSet.valueOf(bitSet);
    }

    @Override
    protected NativeArgumentLibrary createDelegate(NativeArgumentLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    @Override
    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        NativeArgumentLibrary lib = (NativeArgumentLibrary) originalLib;
        MessageImpl messageImpl = (MessageImpl) message;
        if (messageImpl.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (messageImpl.index) {
            case 0 :
                lib.serialize((LibFFIType) receiver, (NativeArgumentBuffer) args[offset], args[offset + 1]);
                return null;
            case 1 :
                return lib.deserialize((LibFFIType) receiver, (NativeArgumentBuffer) args[offset]);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    @Override
    protected NativeArgumentLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    @Override
    protected NativeArgumentLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    @SuppressWarnings("unchecked")
    private static Class<NativeArgumentLibrary> lazyLibraryClass() {
        try {
            return (Class<NativeArgumentLibrary>) Class.forName("com.oracle.truffle.nfi.impl.NativeArgumentLibrary", false, NativeArgumentLibraryGen.class.getClassLoader());
        } catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    @GeneratedBy(NativeArgumentLibrary.class)
    private static final class Default extends LibraryExport<NativeArgumentLibrary> {

        private Default() {
            super(NativeArgumentLibrary.class, LibFFIType.class, false);
        }

        @Override
        protected NativeArgumentLibrary createUncached(Object receiver) {
            assert receiver instanceof LibFFIType;
            NativeArgumentLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected NativeArgumentLibrary createCached(Object receiver) {
            assert receiver instanceof LibFFIType;
            return new Cached(receiver);
        }

        @GeneratedBy(NativeArgumentLibrary.class)
        private static final class Cached extends NativeArgumentLibrary {

            private final Class<? extends LibFFIType> receiverClass_;

            Cached(Object originalReceiver) {
                LibFFIType receiver = ((LibFFIType) originalReceiver) ;
                this.receiverClass_ = receiver.getClass();
            }

            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @TruffleBoundary
            @Override
            public void serialize(LibFFIType receiver, NativeArgumentBuffer buffer, Object value) throws UnsupportedTypeException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public Object deserialize(LibFFIType receiver, NativeArgumentBuffer buffer) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

        }
        @GeneratedBy(NativeArgumentLibrary.class)
        private static final class Uncached extends NativeArgumentLibrary {

            private final Class<? extends LibFFIType> receiverClass_;

            Uncached(Object receiver) {
                this.receiverClass_ = ((LibFFIType) receiver).getClass();
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public void serialize(LibFFIType receiver, NativeArgumentBuffer buffer, Object value) throws UnsupportedTypeException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public Object deserialize(LibFFIType receiver, NativeArgumentBuffer buffer) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

        }
    }
    @GeneratedBy(NativeArgumentLibrary.class)
    private static class MessageImpl extends Message {

        final int index;

        MessageImpl(String name, int index, Class<?> returnType, Class<?>... parameters) {
            super(NativeArgumentLibraryGen.LIBRARY_CLASS, name, returnType, parameters);
            this.index = index;
        }

    }
    @GeneratedBy(NativeArgumentLibrary.class)
    private static final class Proxy extends NativeArgumentLibrary {

        @Child private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public void serialize(LibFFIType receiver_, NativeArgumentBuffer buffer, Object value) throws UnsupportedTypeException {
            try {
                lib.send(receiver_, NativeArgumentLibraryGen.SERIALIZE, buffer, value);
                return;
            } catch (UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public Object deserialize(LibFFIType receiver_, NativeArgumentBuffer buffer) {
            try {
                return lib.send(receiver_, NativeArgumentLibraryGen.DESERIALIZE, buffer);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return lib.accepts(receiver_);
        }

    }
    @GeneratedBy(NativeArgumentLibrary.class)
    private static final class Delegate extends NativeArgumentLibrary {

        @Child private NativeArgumentLibrary delegateLibrary;

        Delegate(NativeArgumentLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public void serialize(LibFFIType receiver_, NativeArgumentBuffer buffer, Object value) throws UnsupportedTypeException {
            if (LibraryFactory.isDelegated(delegateLibrary, 0)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).serialize((LibFFIType) delegate, buffer, value);
                return;
            } else {
                this.delegateLibrary.serialize(receiver_, buffer, value);
                return;
            }
        }

        @Override
        public Object deserialize(LibFFIType receiver_, NativeArgumentBuffer buffer) {
            if (LibraryFactory.isDelegated(delegateLibrary, 1)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).deserialize((LibFFIType) delegate, buffer);
            } else {
                return this.delegateLibrary.deserialize(receiver_, buffer);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return delegateLibrary.accepts(receiver_);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        @Override
        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }

    }
    @GeneratedBy(NativeArgumentLibrary.class)
    private static final class CachedToUncachedDispatch extends NativeArgumentLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @TruffleBoundary
        @Override
        public void serialize(LibFFIType receiver_, NativeArgumentBuffer buffer, Object value) throws UnsupportedTypeException {
            assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).serialize(receiver_, buffer, value);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public Object deserialize(LibFFIType receiver_, NativeArgumentBuffer buffer) {
            assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).deserialize(receiver_, buffer);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(NativeArgumentLibrary.class)
    private static final class UncachedDispatch extends NativeArgumentLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @TruffleBoundary
        @Override
        public void serialize(LibFFIType receiver_, NativeArgumentBuffer buffer, Object value) throws UnsupportedTypeException {
            INSTANCE.getUncached(receiver_).serialize(receiver_, buffer, value);
            return;
        }

        @TruffleBoundary
        @Override
        public Object deserialize(LibFFIType receiver_, NativeArgumentBuffer buffer) {
            return INSTANCE.getUncached(receiver_).deserialize(receiver_, buffer);
        }

        @TruffleBoundary
        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
    @GeneratedBy(NativeArgumentLibrary.class)
    private static final class CachedDispatchNext extends CachedDispatch {

        CachedDispatchNext(NativeArgumentLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(NativeArgumentLibrary.class)
    private static final class CachedDispatchFirst extends CachedDispatch {

        private final int limit_;

        CachedDispatchFirst(NativeArgumentLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        @Override
        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library != null) {
                    count++;
                }
                current = current.next;
            } while (current != null);
            return NodeCost.fromCount(count);
        }

    }
    @GeneratedBy(NativeArgumentLibrary.class)
    private abstract static class CachedDispatch extends NativeArgumentLibrary {

        @Child NativeArgumentLibrary library;
        @Child CachedDispatch next;

        CachedDispatch(NativeArgumentLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @ExplodeLoop
        @Override
        public void serialize(LibFFIType receiver_, NativeArgumentBuffer buffer, Object value) throws UnsupportedTypeException {
            do {
                CachedDispatch current = this;
                do {
                    NativeArgumentLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.serialize(receiver_, buffer, value);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public Object deserialize(LibFFIType receiver_, NativeArgumentBuffer buffer) {
            do {
                CachedDispatch current = this;
                do {
                    NativeArgumentLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.deserialize(receiver_, buffer);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        private void specialize(LibFFIType receiver_) {
            CachedDispatch current = this;
            NativeArgumentLibrary thisLibrary = current.library;
            if (thisLibrary == null) {
                this.library = insert(INSTANCE.create(receiver_));
            } else {
                Lock lock = getLock();
                lock.lock();
                try {
                    int count = 0;
                    do {
                        NativeArgumentLibrary currentLibrary = current.library;
                        if (currentLibrary != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        count++;
                        current = current.next;
                    } while (current != null);
                    if (count >= getLimit()) {
                        this.library = insert(new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = insert(new CachedDispatchNext(INSTANCE.create(receiver_), next));
                    }
                } finally {
                    lock.unlock();
                }
            }
        }

    }
}
