// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.spi.NativeSymbolLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(BindSignatureNode.class)
@SuppressWarnings("unused")
final class BindSignatureNodeGen extends BindSignatureNode {

    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<NativeSymbolLibrary> NATIVE_SYMBOL_LIBRARY_ = LibraryFactory.resolve(NativeSymbolLibrary.class);

    @CompilationFinal private volatile int state_;
    @CompilationFinal private volatile int exclude_;
    @Child private CachedSignatureData cachedSignature_cache;
    @Child private CachedSignatureStringData cachedSignatureString_cache;
    @Child private Generic0Data generic0_cache;

    private BindSignatureNodeGen() {
    }

    @ExplodeLoop
    @Override
    Object execute(Object arg0Value, Object arg1Value) throws UnsupportedMessageException, UnsupportedTypeException {
        int state = state_;
        if (state != 0 /* is-active doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object) || doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object) || doGeneric(Object, Object, InteropLibrary, NativeSymbolLibrary) || doGeneric(Object, Object, InteropLibrary, NativeSymbolLibrary) */) {
            if ((state & 0b1) != 0 /* is-active doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object) */) {
                CachedSignatureData s1_ = this.cachedSignature_cache;
                while (s1_ != null) {
                    assert (s1_.interop_.accepts(s1_.cachedSignature_));
                    if ((s1_.symbolLibrary_.accepts(arg0Value)) && (arg1Value == s1_.cachedSignature_)) {
                        return BindSignatureNode.doCachedSignature(arg0Value, arg1Value, s1_.cachedSignature_, s1_.interop_, s1_.symbolLibrary_, s1_.parsedSignature_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 0b10) != 0 /* is-active doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object) */) {
                CachedSignatureStringData s2_ = this.cachedSignatureString_cache;
                while (s2_ != null) {
                    if ((s2_.interop_.accepts(arg1Value)) && (s2_.symbolLibrary_.accepts(arg0Value)) && (s2_.cachedSignature_.equals(BindSignatureNode.asString(s2_.interop_, arg1Value)))) {
                        return BindSignatureNode.doCachedSignatureString(arg0Value, arg1Value, s2_.interop_, s2_.cachedSignature_, s2_.symbolLibrary_, s2_.parsedSignature_);
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state & 0b100) != 0 /* is-active doGeneric(Object, Object, InteropLibrary, NativeSymbolLibrary) */) {
                Generic0Data s3_ = this.generic0_cache;
                while (s3_ != null) {
                    if ((s3_.interop_.accepts(arg1Value)) && (s3_.symbolLibrary_.accepts(arg0Value))) {
                        return BindSignatureNode.doGeneric(arg0Value, arg1Value, s3_.interop_, s3_.symbolLibrary_);
                    }
                    s3_ = s3_.next_;
                }
            }
            if ((state & 0b1000) != 0 /* is-active doGeneric(Object, Object, InteropLibrary, NativeSymbolLibrary) */) {
                return this.generic1Boundary(state, arg0Value, arg1Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private Object generic1Boundary(int state, Object arg0Value, Object arg1Value) throws UnsupportedMessageException, UnsupportedTypeException {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                InteropLibrary generic1_interop__ = (INTEROP_LIBRARY_.getUncached(arg1Value));
                NativeSymbolLibrary generic1_symbolLibrary__ = (NATIVE_SYMBOL_LIBRARY_.getUncached(arg0Value));
                return BindSignatureNode.doGeneric(arg0Value, arg1Value, generic1_interop__, generic1_symbolLibrary__);
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    private Object executeAndSpecialize(Object arg0Value, Object arg1Value) throws UnsupportedMessageException, UnsupportedTypeException {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        int exclude = exclude_;
        try {
            if (((exclude & 0b1)) == 0 /* is-not-excluded doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object) */) {
                int count1_ = 0;
                CachedSignatureData s1_ = this.cachedSignature_cache;
                if ((state & 0b1) != 0 /* is-active doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object) */) {
                    while (s1_ != null) {
                        assert (s1_.interop_.accepts(s1_.cachedSignature_));
                        if ((s1_.symbolLibrary_.accepts(arg0Value)) && (arg1Value == s1_.cachedSignature_)) {
                            break;
                        }
                        s1_ = s1_.next_;
                        count1_++;
                    }
                }
                if (s1_ == null) {
                    // assert (s1_.interop_.accepts(s1_.cachedSignature_));
                    // assert (s1_.symbolLibrary_.accepts(arg0Value));
                    // assert (arg1Value == s1_.cachedSignature_);
                    if (count1_ < (5)) {
                        s1_ = super.insert(new CachedSignatureData(cachedSignature_cache));
                        s1_.cachedSignature_ = (arg1Value);
                        s1_.interop_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(s1_.cachedSignature_)));
                        s1_.symbolLibrary_ = s1_.insertAccessor((NATIVE_SYMBOL_LIBRARY_.create(arg0Value)));
                        s1_.parsedSignature_ = (BindSignatureNode.parseSignature(arg0Value, s1_.cachedSignature_, s1_.interop_, s1_.symbolLibrary_));
                        this.cachedSignature_cache = s1_;
                        this.state_ = state = state | 0b1 /* add-active doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object) */;
                    }
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return BindSignatureNode.doCachedSignature(arg0Value, arg1Value, s1_.cachedSignature_, s1_.interop_, s1_.symbolLibrary_, s1_.parsedSignature_);
                }
            }
            if (((exclude & 0b10)) == 0 /* is-not-excluded doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object) */) {
                int count2_ = 0;
                CachedSignatureStringData s2_ = this.cachedSignatureString_cache;
                if ((state & 0b10) != 0 /* is-active doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object) */) {
                    while (s2_ != null) {
                        if ((s2_.interop_.accepts(arg1Value)) && (s2_.symbolLibrary_.accepts(arg0Value)) && (s2_.cachedSignature_.equals(BindSignatureNode.asString(s2_.interop_, arg1Value)))) {
                            break;
                        }
                        s2_ = s2_.next_;
                        count2_++;
                    }
                }
                if (s2_ == null) {
                    {
                        InteropLibrary interop__ = super.insert((INTEROP_LIBRARY_.create(arg1Value)));
                        String cachedSignature__ = (BindSignatureNode.asString(interop__, arg1Value));
                        // assert (s2_.interop_.accepts(arg1Value));
                        // assert (s2_.symbolLibrary_.accepts(arg0Value));
                        if ((cachedSignature__.equals(BindSignatureNode.asString(interop__, arg1Value))) && count2_ < (5)) {
                            s2_ = super.insert(new CachedSignatureStringData(cachedSignatureString_cache));
                            s2_.interop_ = s2_.insertAccessor(interop__);
                            s2_.cachedSignature_ = cachedSignature__;
                            s2_.symbolLibrary_ = s2_.insertAccessor((NATIVE_SYMBOL_LIBRARY_.create(arg0Value)));
                            s2_.parsedSignature_ = (BindSignatureNode.parseSignature(arg0Value, arg1Value, interop__, s2_.symbolLibrary_));
                            this.cachedSignatureString_cache = s2_;
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object) */;
                            this.cachedSignature_cache = null;
                            state = state & 0xfffffffe /* remove-active doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object) */;
                            this.state_ = state = state | 0b10 /* add-active doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object) */;
                        }
                    }
                }
                if (s2_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return BindSignatureNode.doCachedSignatureString(arg0Value, arg1Value, s2_.interop_, s2_.cachedSignature_, s2_.symbolLibrary_, s2_.parsedSignature_);
                }
            }
            if (((exclude & 0b100)) == 0 /* is-not-excluded doGeneric(Object, Object, InteropLibrary, NativeSymbolLibrary) */) {
                int count3_ = 0;
                Generic0Data s3_ = this.generic0_cache;
                if ((state & 0b100) != 0 /* is-active doGeneric(Object, Object, InteropLibrary, NativeSymbolLibrary) */) {
                    while (s3_ != null) {
                        if ((s3_.interop_.accepts(arg1Value)) && (s3_.symbolLibrary_.accepts(arg0Value))) {
                            break;
                        }
                        s3_ = s3_.next_;
                        count3_++;
                    }
                }
                if (s3_ == null) {
                    // assert (s3_.interop_.accepts(arg1Value));
                    // assert (s3_.symbolLibrary_.accepts(arg0Value));
                    if (count3_ < (3)) {
                        s3_ = super.insert(new Generic0Data(generic0_cache));
                        s3_.interop_ = s3_.insertAccessor((INTEROP_LIBRARY_.create(arg1Value)));
                        s3_.symbolLibrary_ = s3_.insertAccessor((NATIVE_SYMBOL_LIBRARY_.create(arg0Value)));
                        this.generic0_cache = s3_;
                        this.exclude_ = exclude = exclude | 0b11 /* add-excluded doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object), doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object) */;
                        this.cachedSignature_cache = null;
                        this.cachedSignatureString_cache = null;
                        state = state & 0xfffffffc /* remove-active doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object), doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object) */;
                        this.state_ = state = state | 0b100 /* add-active doGeneric(Object, Object, InteropLibrary, NativeSymbolLibrary) */;
                    }
                }
                if (s3_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return BindSignatureNode.doGeneric(arg0Value, arg1Value, s3_.interop_, s3_.symbolLibrary_);
                }
            }
            {
                NativeSymbolLibrary generic1_symbolLibrary__ = null;
                InteropLibrary generic1_interop__ = null;
                {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        generic1_interop__ = (INTEROP_LIBRARY_.getUncached(arg1Value));
                        generic1_symbolLibrary__ = (NATIVE_SYMBOL_LIBRARY_.getUncached(arg0Value));
                        this.exclude_ = exclude = exclude | 0b111 /* add-excluded doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object), doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object), doGeneric(Object, Object, InteropLibrary, NativeSymbolLibrary) */;
                        this.cachedSignature_cache = null;
                        this.cachedSignatureString_cache = null;
                        this.generic0_cache = null;
                        state = state & 0xfffffff8 /* remove-active doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object), doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object), doGeneric(Object, Object, InteropLibrary, NativeSymbolLibrary) */;
                        this.state_ = state = state | 0b1000 /* add-active doGeneric(Object, Object, InteropLibrary, NativeSymbolLibrary) */;
                        lock.unlock();
                        hasLock = false;
                        return BindSignatureNode.doGeneric(arg0Value, arg1Value, generic1_interop__, generic1_symbolLibrary__);
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            CachedSignatureData s1_ = this.cachedSignature_cache;
            CachedSignatureStringData s2_ = this.cachedSignatureString_cache;
            Generic0Data s3_ = this.generic0_cache;
            if ((s1_ == null || s1_.next_ == null) && (s2_ == null || s2_.next_ == null) && (s3_ == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static BindSignatureNode create() {
        return new BindSignatureNodeGen();
    }

    public static BindSignatureNode getUncached() {
        return BindSignatureNodeGen.UNCACHED;
    }

    @GeneratedBy(BindSignatureNode.class)
    private static final class CachedSignatureData extends Node {

        @Child CachedSignatureData next_;
        @CompilationFinal Object cachedSignature_;
        @Child InteropLibrary interop_;
        @Child NativeSymbolLibrary symbolLibrary_;
        @CompilationFinal Object parsedSignature_;

        CachedSignatureData(CachedSignatureData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
    @GeneratedBy(BindSignatureNode.class)
    private static final class CachedSignatureStringData extends Node {

        @Child CachedSignatureStringData next_;
        @Child InteropLibrary interop_;
        @CompilationFinal String cachedSignature_;
        @Child NativeSymbolLibrary symbolLibrary_;
        @CompilationFinal Object parsedSignature_;

        CachedSignatureStringData(CachedSignatureStringData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
    @GeneratedBy(BindSignatureNode.class)
    private static final class Generic0Data extends Node {

        @Child Generic0Data next_;
        @Child InteropLibrary interop_;
        @Child NativeSymbolLibrary symbolLibrary_;

        Generic0Data(Generic0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
    @GeneratedBy(BindSignatureNode.class)
    private static final class Uncached extends BindSignatureNode {

        @TruffleBoundary
        @Override
        Object execute(Object arg0Value, Object arg1Value) throws UnsupportedMessageException, UnsupportedTypeException {
            return BindSignatureNode.doGeneric(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), (NATIVE_SYMBOL_LIBRARY_.getUncached(arg0Value)));
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
