// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.NFIRootNode.LookupAndBindNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(NFIRootNode.class)
@SuppressWarnings("unused")
final class NFIRootNodeFactory {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @GeneratedBy(LookupAndBindNode.class)
    static final class LookupAndBindNodeGen extends LookupAndBindNode {

        @CompilationFinal private volatile int state_;
        @CompilationFinal private volatile int exclude_;
        @Child private InteropLibrary symInterop;
        @Child private InteropLibrary lookupAndBind0_libInterop_;

        private LookupAndBindNodeGen(String name, String signature) {
            super(name, signature);
        }

        @Override
        Object execute(Object arg0Value) {
            int state = state_;
            if (state != 0 /* is-active doLookupAndBind(Object, InteropLibrary, InteropLibrary) || doLookupAndBind(Object, InteropLibrary, InteropLibrary) */) {
                if ((state & 0b1) != 0 /* is-active doLookupAndBind(Object, InteropLibrary, InteropLibrary) */) {
                    if ((this.lookupAndBind0_libInterop_.accepts(arg0Value))) {
                        return doLookupAndBind(arg0Value, this.lookupAndBind0_libInterop_, this.symInterop);
                    }
                }
                if ((state & 0b10) != 0 /* is-active doLookupAndBind(Object, InteropLibrary, InteropLibrary) */) {
                    return this.lookupAndBind1Boundary(state, arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object lookupAndBind1Boundary(int state, Object arg0Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary lookupAndBind1_libInterop__ = (INTEROP_LIBRARY_.getUncached(arg0Value));
                    return doLookupAndBind(arg0Value, lookupAndBind1_libInterop__, this.symInterop);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private Object executeAndSpecialize(Object arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-excluded doLookupAndBind(Object, InteropLibrary, InteropLibrary) */) {
                    boolean LookupAndBind0_duplicateFound_ = false;
                    if ((state & 0b1) != 0 /* is-active doLookupAndBind(Object, InteropLibrary, InteropLibrary) */) {
                        if ((this.lookupAndBind0_libInterop_.accepts(arg0Value))) {
                            LookupAndBind0_duplicateFound_ = true;
                        }
                    }
                    if (!LookupAndBind0_duplicateFound_) {
                        // assert (this.lookupAndBind0_libInterop_.accepts(arg0Value));
                        if (((state & 0b1)) == 0 /* is-not-active doLookupAndBind(Object, InteropLibrary, InteropLibrary) */) {
                            this.lookupAndBind0_libInterop_ = super.insert((INTEROP_LIBRARY_.create(arg0Value)));
                            if (this.symInterop == null) {
                                this.symInterop = super.insert((INTEROP_LIBRARY_.createDispatched(1)));
                            }
                            this.state_ = state = state | 0b1 /* add-active doLookupAndBind(Object, InteropLibrary, InteropLibrary) */;
                            LookupAndBind0_duplicateFound_ = true;
                        }
                    }
                    if (LookupAndBind0_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        return doLookupAndBind(arg0Value, this.lookupAndBind0_libInterop_, this.symInterop);
                    }
                }
                {
                    InteropLibrary lookupAndBind1_libInterop__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            lookupAndBind1_libInterop__ = (INTEROP_LIBRARY_.getUncached(arg0Value));
                            if (this.symInterop == null) {
                                this.symInterop = super.insert((INTEROP_LIBRARY_.createDispatched(1)));
                            }
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doLookupAndBind(Object, InteropLibrary, InteropLibrary) */;
                            state = state & 0xfffffffe /* remove-active doLookupAndBind(Object, InteropLibrary, InteropLibrary) */;
                            this.state_ = state = state | 0b10 /* add-active doLookupAndBind(Object, InteropLibrary, InteropLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            return doLookupAndBind(arg0Value, lookupAndBind1_libInterop__, this.symInterop);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LookupAndBindNode create(String name, String signature) {
            return new LookupAndBindNodeGen(name, signature);
        }

    }
}
