// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.nfi.spi.NativeSymbolLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(NFISymbol.class)
final class NFISymbolGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<NativeSymbolLibrary> NATIVE_SYMBOL_LIBRARY_ = LibraryFactory.resolve(NativeSymbolLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(NFISymbol.class, new InteropLibraryExports());
    }

    private NFISymbolGen() {
    }

    @GeneratedBy(NFISymbol.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, NFISymbol.class, false);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof NFISymbol;
            InteropLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof NFISymbol;
            return new Cached(receiver);
        }

        @GeneratedBy(NFISymbol.class)
        private static final class Cached extends InteropLibrary {

            @Child private NativeSymbolLibrary receiverNativeSymbolNativeSymbolLibrary_;
            @Child private InteropLibrary receiverNativeSymbolInteropLibrary_;
            @CompilationFinal private volatile int state_;
            @CompilationFinal private BranchProfile executeNode__exception_;
            @Child private BindSignatureNode invokeMemberNode__bind_;
            @CompilationFinal private ConditionProfile invokeMemberNode__isCallable_;
            @CompilationFinal private BranchProfile invokeMemberNode__exception_;

            Cached(Object originalReceiver) {
                NFISymbol receiver = ((NFISymbol) originalReceiver) ;
                this.receiverNativeSymbolNativeSymbolLibrary_ = super.insert(NATIVE_SYMBOL_LIBRARY_.create((receiver.nativeSymbol)));
                this.receiverNativeSymbolInteropLibrary_ = super.insert(INTEROP_LIBRARY_.create((receiver.nativeSymbol)));
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof NFISymbol) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof NFISymbol)) {
                    return false;
                } else if (!this.receiverNativeSymbolNativeSymbolLibrary_.accepts((((NFISymbol) receiver).nativeSymbol))) {
                    return false;
                } else if (!this.receiverNativeSymbolInteropLibrary_.accepts((((NFISymbol) receiver).nativeSymbol))) {
                    return false;
                } else {
                    return true;
                }
            }

            @Override
            public boolean isExecutable(Object receiver) {
                assert receiver instanceof NFISymbol : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((NFISymbol) receiver)).isExecutable();
            }

            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert arg0Value_ instanceof NFISymbol : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                NFISymbol arg0Value = ((NFISymbol) arg0Value_);
                int state = state_;
                if ((state & 0b1) != 0 /* is-active execute(NFISymbol, Object[], NativeSymbolLibrary, BranchProfile) */) {
                    {
                        NativeSymbolLibrary executeNode__library__ = this.receiverNativeSymbolNativeSymbolLibrary_;
                        return arg0Value.execute(arg1Value, executeNode__library__, this.executeNode__exception_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object executeNode_AndSpecialize(NFISymbol arg0Value, Object[] arg1Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    {
                        NativeSymbolLibrary executeNode__library__ = null;
                        executeNode__library__ = this.receiverNativeSymbolNativeSymbolLibrary_;
                        this.executeNode__exception_ = (BranchProfile.create());
                        this.state_ = state = state | 0b1 /* add-active execute(NFISymbol, Object[], NativeSymbolLibrary, BranchProfile) */;
                        lock.unlock();
                        hasLock = false;
                        return arg0Value.execute(arg1Value, executeNode__library__, this.executeNode__exception_);
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if ((state & 0b1) == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert receiver instanceof NFISymbol : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((NFISymbol) receiver)).hasMembers();
            }

            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert receiver instanceof NFISymbol : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((NFISymbol) receiver)).getMembers(includeInternal);
            }

            @Override
            public boolean isMemberInvocable(Object receiver, String member) {
                assert receiver instanceof NFISymbol : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((NFISymbol) receiver)).isMemberInvocable(member);
            }

            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert arg0Value_ instanceof NFISymbol : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                NFISymbol arg0Value = ((NFISymbol) arg0Value_);
                int state = state_;
                if ((state & 0b10) != 0 /* is-active invokeMember(NFISymbol, String, Object[], BindSignatureNode, NativeSymbolLibrary, ConditionProfile, BranchProfile) */) {
                    {
                        NativeSymbolLibrary invokeMemberNode__symbolLibrary__ = this.receiverNativeSymbolNativeSymbolLibrary_;
                        return arg0Value.invokeMember(arg1Value, arg2Value, this.invokeMemberNode__bind_, invokeMemberNode__symbolLibrary__, this.invokeMemberNode__isCallable_, this.invokeMemberNode__exception_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object invokeMemberNode_AndSpecialize(NFISymbol arg0Value, String arg1Value, Object[] arg2Value) throws ArityException, UnknownIdentifierException, UnsupportedTypeException, UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    {
                        NativeSymbolLibrary invokeMemberNode__symbolLibrary__ = null;
                        this.invokeMemberNode__bind_ = super.insert((BindSignatureNodeGen.create()));
                        invokeMemberNode__symbolLibrary__ = this.receiverNativeSymbolNativeSymbolLibrary_;
                        this.invokeMemberNode__isCallable_ = (ConditionProfile.create());
                        this.invokeMemberNode__exception_ = (BranchProfile.create());
                        this.state_ = state = state | 0b10 /* add-active invokeMember(NFISymbol, String, Object[], BindSignatureNode, NativeSymbolLibrary, ConditionProfile, BranchProfile) */;
                        lock.unlock();
                        hasLock = false;
                        return arg0Value.invokeMember(arg1Value, arg2Value, this.invokeMemberNode__bind_, invokeMemberNode__symbolLibrary__, this.invokeMemberNode__isCallable_, this.invokeMemberNode__exception_);
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isNull(Object arg0Value_) {
                assert arg0Value_ instanceof NFISymbol : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                NFISymbol arg0Value = ((NFISymbol) arg0Value_);
                {
                    InteropLibrary isNullNode__library__ = this.receiverNativeSymbolInteropLibrary_;
                    return arg0Value.isNull(isNullNode__library__);
                }
            }

            @Override
            public boolean isPointer(Object arg0Value_) {
                assert arg0Value_ instanceof NFISymbol : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                NFISymbol arg0Value = ((NFISymbol) arg0Value_);
                {
                    InteropLibrary isPointerNode__library__ = this.receiverNativeSymbolInteropLibrary_;
                    return arg0Value.isPointer(isPointerNode__library__);
                }
            }

            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert arg0Value_ instanceof NFISymbol : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                NFISymbol arg0Value = ((NFISymbol) arg0Value_);
                {
                    InteropLibrary asPointerNode__library__ = this.receiverNativeSymbolInteropLibrary_;
                    return arg0Value.asPointer(asPointerNode__library__);
                }
            }

            @Override
            public void toNative(Object arg0Value_) {
                assert arg0Value_ instanceof NFISymbol : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                NFISymbol arg0Value = ((NFISymbol) arg0Value_);
                {
                    InteropLibrary toNativeNode__library__ = this.receiverNativeSymbolInteropLibrary_;
                    arg0Value.toNative(toNativeNode__library__);
                    return;
                }
            }

            @Override
            public boolean hasLanguage(Object receiver) {
                assert receiver instanceof NFISymbol : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((NFISymbol) receiver)).hasLanguage();
            }

            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert receiver instanceof NFISymbol : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((NFISymbol) receiver)).getLanguage();
            }

            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert receiver instanceof NFISymbol : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((NFISymbol) receiver)).toDisplayString(allowSideEffects);
            }

        }
        @GeneratedBy(NFISymbol.class)
        private static final class Uncached extends InteropLibrary {

            Uncached() {
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof NFISymbol) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFISymbol;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean isExecutable(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol) receiver) .isExecutable();
            }

            @TruffleBoundary
            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = ((NFISymbol) arg0Value_);
                return arg0Value.execute(arg1Value, NATIVE_SYMBOL_LIBRARY_.getUncached((arg0Value.nativeSymbol)), (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol) receiver) .hasMembers();
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol) receiver) .getMembers(includeInternal);
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInvocable(Object receiver, String member) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol) receiver) .isMemberInvocable(member);
            }

            @TruffleBoundary
            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws ArityException, UnknownIdentifierException, UnsupportedTypeException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = ((NFISymbol) arg0Value_);
                return arg0Value.invokeMember(arg1Value, arg2Value, (BindSignatureNodeGen.getUncached()), NATIVE_SYMBOL_LIBRARY_.getUncached((arg0Value.nativeSymbol)), (ConditionProfile.getUncached()), (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isNull(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = ((NFISymbol) arg0Value_);
                return arg0Value.isNull(INTEROP_LIBRARY_.getUncached((arg0Value.nativeSymbol)));
            }

            @TruffleBoundary
            @Override
            public boolean isPointer(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = ((NFISymbol) arg0Value_);
                return arg0Value.isPointer(INTEROP_LIBRARY_.getUncached((arg0Value.nativeSymbol)));
            }

            @TruffleBoundary
            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = ((NFISymbol) arg0Value_);
                return arg0Value.asPointer(INTEROP_LIBRARY_.getUncached((arg0Value.nativeSymbol)));
            }

            @TruffleBoundary
            @Override
            public void toNative(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = ((NFISymbol) arg0Value_);
                arg0Value.toNative(INTEROP_LIBRARY_.getUncached((arg0Value.nativeSymbol)));
                return;
            }

            @TruffleBoundary
            @Override
            public boolean hasLanguage(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol) receiver) .hasLanguage();
            }

            @TruffleBoundary
            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol) receiver) .getLanguage();
            }

            @TruffleBoundary
            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol) receiver) .toDisplayString(allowSideEffects);
            }

        }
    }
}
