// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.TruffleLanguage.ContextReference;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.nfi.impl.LibFFILibrary.ReadMember;
import java.util.concurrent.locks.Lock;

@GeneratedBy(LibFFILibrary.class)
final class LibFFILibraryGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(LibFFILibrary.class, new InteropLibraryExports());
    }

    private LibFFILibraryGen() {
    }

    @GeneratedBy(LibFFILibrary.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, LibFFILibrary.class, false);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof LibFFILibrary;
            InteropLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof LibFFILibrary;
            return new Cached();
        }

        @GeneratedBy(LibFFILibrary.class)
        private static final class Cached extends InteropLibrary {

            @CompilationFinal private volatile int state_;
            @CompilationFinal private volatile int exclude_;
            @CompilationFinal private ContextReference<NFIContext> nFILanguageImplContextReference_;
            @CompilationFinal private CachedData cached_cache;
            @CompilationFinal private BranchProfile generic_exception_;

            Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof LibFFILibrary) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LibFFILibrary;
            }

            @ExplodeLoop
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                LibFFILibrary arg0Value = ((LibFFILibrary) arg0Value_);
                int state = state_;
                if (state != 0 /* is-active doCached(LibFFILibrary, String, LibFFILibrary, String, ContextReference<NFIContext>, Object) || doGeneric(LibFFILibrary, String, BranchProfile, NFIContext) */) {
                    if ((state & 0b1) != 0 /* is-active doCached(LibFFILibrary, String, LibFFILibrary, String, ContextReference<NFIContext>, Object) */) {
                        CachedData s1_ = this.cached_cache;
                        while (s1_ != null) {
                            if ((arg0Value == s1_.cachedReceiver_) && (arg1Value.equals(s1_.cachedSymbol_))) {
                                ContextReference<NFIContext> nFILanguageImplContextReference__ = this.nFILanguageImplContextReference_;
                                ContextReference<NFIContext> ctxRef__ = nFILanguageImplContextReference__;
                                return ReadMember.doCached(arg0Value, arg1Value, s1_.cachedReceiver_, s1_.cachedSymbol_, ctxRef__, s1_.cachedRet_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doGeneric(LibFFILibrary, String, BranchProfile, NFIContext) */) {
                        {
                            ContextReference<NFIContext> nFILanguageImplContextReference__1 = this.nFILanguageImplContextReference_;
                            NFIContext generic_ctx__ = nFILanguageImplContextReference__1.get();
                            return ReadMember.doGeneric(arg0Value, arg1Value, this.generic_exception_, generic_ctx__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(LibFFILibrary arg0Value, String arg1Value) throws UnknownIdentifierException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    {
                        ContextReference<NFIContext> ctxRef__ = null;
                        if ((exclude) == 0 /* is-not-excluded doCached(LibFFILibrary, String, LibFFILibrary, String, ContextReference<NFIContext>, Object) */) {
                            int count1_ = 0;
                            CachedData s1_ = this.cached_cache;
                            if ((state & 0b1) != 0 /* is-active doCached(LibFFILibrary, String, LibFFILibrary, String, ContextReference<NFIContext>, Object) */) {
                                while (s1_ != null) {
                                    if ((arg0Value == s1_.cachedReceiver_) && (arg1Value.equals(s1_.cachedSymbol_))) {
                                        ContextReference<NFIContext> nFILanguageImplContextReference__2 = this.nFILanguageImplContextReference_;
                                        if (nFILanguageImplContextReference__2 == null) {
                                            this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__2 = super.lookupContextReference(NFILanguageImpl.class);
                                        }
                                        ctxRef__ = nFILanguageImplContextReference__2;
                                        break;
                                    }
                                    s1_ = s1_.next_;
                                    count1_++;
                                }
                            }
                            if (s1_ == null) {
                                // assert (arg0Value == s1_.cachedReceiver_);
                                // assert (arg1Value.equals(s1_.cachedSymbol_));
                                if (count1_ < (3)) {
                                    s1_ = new CachedData(cached_cache);
                                    s1_.cachedReceiver_ = (arg0Value);
                                    s1_.cachedSymbol_ = (arg1Value);
                                    ContextReference<NFIContext> nFILanguageImplContextReference__3 = this.nFILanguageImplContextReference_;
                                    if (nFILanguageImplContextReference__3 == null) {
                                        this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__3 = super.lookupContextReference(NFILanguageImpl.class);
                                    }
                                    ctxRef__ = nFILanguageImplContextReference__3;
                                    s1_.cachedRet_ = (ReadMember.lookupCached(s1_.cachedReceiver_, s1_.cachedSymbol_, ctxRef__));
                                    this.cached_cache = s1_;
                                    this.state_ = state = state | 0b1 /* add-active doCached(LibFFILibrary, String, LibFFILibrary, String, ContextReference<NFIContext>, Object) */;
                                }
                            }
                            if (s1_ != null) {
                                lock.unlock();
                                hasLock = false;
                                return ReadMember.doCached(arg0Value, arg1Value, s1_.cachedReceiver_, s1_.cachedSymbol_, ctxRef__, s1_.cachedRet_);
                            }
                        }
                    }
                    {
                        NFIContext generic_ctx__ = null;
                        this.generic_exception_ = (BranchProfile.create());
                        ContextReference<NFIContext> nFILanguageImplContextReference__4 = this.nFILanguageImplContextReference_;
                        if (nFILanguageImplContextReference__4 == null) {
                            this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__4 = super.lookupContextReference(NFILanguageImpl.class);
                        }
                        generic_ctx__ = nFILanguageImplContextReference__4.get();
                        this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(LibFFILibrary, String, LibFFILibrary, String, ContextReference<NFIContext>, Object) */;
                        this.cached_cache = null;
                        state = state & 0xfffffffe /* remove-active doCached(LibFFILibrary, String, LibFFILibrary, String, ContextReference<NFIContext>, Object) */;
                        this.state_ = state = state | 0b10 /* add-active doGeneric(LibFFILibrary, String, BranchProfile, NFIContext) */;
                        lock.unlock();
                        hasLock = false;
                        return ReadMember.doGeneric(arg0Value, arg1Value, this.generic_exception_, generic_ctx__);
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                    CachedData s1_ = this.cached_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((LibFFILibrary) receiver)).hasMembers();
            }

            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((LibFFILibrary) receiver)).getMembers(includeInternal);
            }

            @Override
            public boolean isMemberReadable(Object receiver, String member) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((LibFFILibrary) receiver)).isMemberReadable(member);
            }

            @Override
            public boolean hasLanguage(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((LibFFILibrary) receiver)).hasLanguage();
            }

            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((LibFFILibrary) receiver)).getLanguage();
            }

            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((LibFFILibrary) receiver)).toDisplayString(allowSideEffects);
            }

            @GeneratedBy(LibFFILibrary.class)
            private static final class CachedData {

                @CompilationFinal CachedData next_;
                @CompilationFinal LibFFILibrary cachedReceiver_;
                @CompilationFinal String cachedSymbol_;
                @CompilationFinal Object cachedRet_;

                CachedData(CachedData next_) {
                    this.next_ = next_;
                }

            }
        }
        @GeneratedBy(LibFFILibrary.class)
        private static final class Uncached extends InteropLibrary {

            private final ContextReference<NFIContext> nFILanguageImplContextReference_ = lookupContextReference(NFILanguageImpl.class);

            Uncached() {
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof LibFFILibrary) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LibFFILibrary;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LibFFILibrary arg0Value = ((LibFFILibrary) arg0Value_);
                return ReadMember.doGeneric(arg0Value, arg1Value, (BranchProfile.getUncached()), this.nFILanguageImplContextReference_.get());
            }

            @TruffleBoundary
            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LibFFILibrary) receiver) .hasMembers();
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LibFFILibrary) receiver) .getMembers(includeInternal);
            }

            @TruffleBoundary
            @Override
            public boolean isMemberReadable(Object receiver, String member) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LibFFILibrary) receiver) .isMemberReadable(member);
            }

            @TruffleBoundary
            @Override
            public boolean hasLanguage(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LibFFILibrary) receiver) .hasLanguage();
            }

            @TruffleBoundary
            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LibFFILibrary) receiver) .getLanguage();
            }

            @TruffleBoundary
            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((LibFFILibrary) receiver) .toDisplayString(allowSideEffects);
            }

        }
    }
}
