// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.TruffleLanguage.ContextReference;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.impl.LibFFIType.ArrayType;
import com.oracle.truffle.nfi.impl.LibFFIType.ArrayType.CachedHostObjectHelperNode;
import com.oracle.truffle.nfi.impl.LibFFIType.ArrayType.HostObjectHelperNode;
import com.oracle.truffle.nfi.impl.LibFFIType.ArrayType.SerializeHelperNode;
import com.oracle.truffle.nfi.impl.LibFFIType.ArrayType.HostObjectHelperNode.WrongTypeException;
import com.oracle.truffle.nfi.spi.types.NativeSimpleType;
import java.util.concurrent.locks.Lock;

@GeneratedBy(LibFFIType.class)
@SuppressWarnings("unused")
final class LibFFITypeFactory {

    private static final LibraryFactory<SerializeArgumentLibrary> SERIALIZE_ARGUMENT_LIBRARY_ = LibraryFactory.resolve(SerializeArgumentLibrary.class);

    @GeneratedBy(ArrayType.class)
    static final class ArrayTypeFactory {

        @GeneratedBy(SerializeHelperNode.class)
        static final class SerializeHelperNodeGen extends SerializeHelperNode {

            private static final Uncached UNCACHED = new Uncached();

            @CompilationFinal private volatile int state_;
            @CompilationFinal private volatile int exclude_;
            @CompilationFinal private ContextReference<NFIContext> nFILanguageImplContextReference_;
            @Child private HostObjectHelperNode hostObject_helper_;
            @Child private InteropObjectData interopObject_cache;
            @Child private Generic0Data generic0_cache;
            @Child private HostObjectHelperNode generic1_helper_;

            private SerializeHelperNodeGen() {
            }

            @ExplodeLoop
            @Override
            void execute(ArrayType arg0Value, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                int state = state_;
                if (state != 0 /* is-active doHostObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, HostObjectHelperNode) || doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary) || doGeneric(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary, HostObjectHelperNode) || doGeneric(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary, HostObjectHelperNode) */) {
                    if ((state & 0b1) != 0 /* is-active doHostObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, HostObjectHelperNode) */) {
                        {
                            ContextReference<NFIContext> nFILanguageImplContextReference__ = this.nFILanguageImplContextReference_;
                            NFIContext hostObject_ctx__ = nFILanguageImplContextReference__.get();
                            if ((SerializeHelperNode.isHostObject(hostObject_ctx__, arg2Value))) {
                                try {
                                    SerializeHelperNode.doHostObject(arg0Value, arg1Value, arg2Value, hostObject_ctx__, this.hostObject_helper_);
                                    return;
                                } catch (WrongTypeException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    Lock lock = getLock();
                                    lock.lock();
                                    try {
                                        this.exclude_ = this.exclude_ | 0b1 /* add-excluded doHostObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, HostObjectHelperNode) */;
                                        this.state_ = this.state_ & 0xfffffffe /* remove-active doHostObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, HostObjectHelperNode) */;
                                    } finally {
                                        lock.unlock();
                                    }
                                    executeAndSpecialize(arg0Value, arg1Value, arg2Value);
                                    return;
                                }
                            }
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary) */) {
                        InteropObjectData s2_ = this.interopObject_cache;
                        while (s2_ != null) {
                            if ((s2_.serialize_.accepts(arg2Value))) {
                                ContextReference<NFIContext> nFILanguageImplContextReference__1 = this.nFILanguageImplContextReference_;
                                NFIContext ctx__ = nFILanguageImplContextReference__1.get();
                                if ((!(SerializeHelperNode.isHostObject(ctx__, arg2Value)))) {
                                    SerializeHelperNode.doInteropObject(arg0Value, arg1Value, arg2Value, ctx__, s2_.serialize_);
                                    return;
                                }
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state & 0b100) != 0 /* is-active doGeneric(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary, HostObjectHelperNode) */) {
                        Generic0Data s3_ = this.generic0_cache;
                        while (s3_ != null) {
                            if ((s3_.serialize_.accepts(arg2Value))) {
                                ContextReference<NFIContext> nFILanguageImplContextReference__2 = this.nFILanguageImplContextReference_;
                                NFIContext ctx__1 = nFILanguageImplContextReference__2.get();
                                SerializeHelperNode.doGeneric(arg0Value, arg1Value, arg2Value, ctx__1, s3_.serialize_, s3_.helper_);
                                return;
                            }
                            s3_ = s3_.next_;
                        }
                    }
                    if ((state & 0b1000) != 0 /* is-active doGeneric(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary, HostObjectHelperNode) */) {
                        this.generic1Boundary(state, arg0Value, arg1Value, arg2Value);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private void generic1Boundary(int state, ArrayType arg0Value, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    {
                        ContextReference<NFIContext> nFILanguageImplContextReference__3 = this.nFILanguageImplContextReference_;
                        NFIContext generic1_ctx__ = nFILanguageImplContextReference__3.get();
                        SerializeArgumentLibrary generic1_serialize__ = (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(arg2Value));
                        SerializeHelperNode.doGeneric(arg0Value, arg1Value, arg2Value, generic1_ctx__, generic1_serialize__, this.generic1_helper_);
                        return;
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }

            private void executeAndSpecialize(ArrayType arg0Value, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    {
                        NFIContext hostObject_ctx__ = null;
                        if (((exclude & 0b1)) == 0 /* is-not-excluded doHostObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, HostObjectHelperNode) */) {
                            {
                                ContextReference<NFIContext> nFILanguageImplContextReference__4 = this.nFILanguageImplContextReference_;
                                if (nFILanguageImplContextReference__4 == null) {
                                    this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__4 = super.lookupContextReference(NFILanguageImpl.class);
                                }
                                hostObject_ctx__ = nFILanguageImplContextReference__4.get();
                                if ((SerializeHelperNode.isHostObject(hostObject_ctx__, arg2Value))) {
                                    this.hostObject_helper_ = super.insert((HostObjectHelperNode.create(arg0Value)));
                                    this.state_ = state = state | 0b1 /* add-active doHostObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, HostObjectHelperNode) */;
                                    try {
                                        lock.unlock();
                                        hasLock = false;
                                        SerializeHelperNode.doHostObject(arg0Value, arg1Value, arg2Value, hostObject_ctx__, this.hostObject_helper_);
                                        return;
                                    } catch (WrongTypeException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        lock.lock();
                                        try {
                                            this.exclude_ = this.exclude_ | 0b1 /* add-excluded doHostObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, HostObjectHelperNode) */;
                                            this.state_ = this.state_ & 0xfffffffe /* remove-active doHostObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, HostObjectHelperNode) */;
                                        } finally {
                                            lock.unlock();
                                        }
                                        executeAndSpecialize(arg0Value, arg1Value, arg2Value);
                                        return;
                                    }
                                }
                            }
                        }
                    }
                    {
                        NFIContext ctx__ = null;
                        if (((exclude & 0b10)) == 0 /* is-not-excluded doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary) */) {
                            int count2_ = 0;
                            InteropObjectData s2_ = this.interopObject_cache;
                            if ((state & 0b10) != 0 /* is-active doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary) */) {
                                while (s2_ != null) {
                                    if ((s2_.serialize_.accepts(arg2Value))) {
                                        ContextReference<NFIContext> nFILanguageImplContextReference__5 = this.nFILanguageImplContextReference_;
                                        if (nFILanguageImplContextReference__5 == null) {
                                            this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__5 = super.lookupContextReference(NFILanguageImpl.class);
                                        }
                                        ctx__ = nFILanguageImplContextReference__5.get();
                                        if ((!(SerializeHelperNode.isHostObject(ctx__, arg2Value)))) {
                                            break;
                                        }
                                    }
                                    s2_ = s2_.next_;
                                    count2_++;
                                }
                            }
                            if (s2_ == null) {
                                {
                                    ContextReference<NFIContext> nFILanguageImplContextReference__6 = this.nFILanguageImplContextReference_;
                                    if (nFILanguageImplContextReference__6 == null) {
                                        this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__6 = super.lookupContextReference(NFILanguageImpl.class);
                                    }
                                    ctx__ = nFILanguageImplContextReference__6.get();
                                    // assert (s2_.serialize_.accepts(arg2Value));
                                    if ((!(SerializeHelperNode.isHostObject(ctx__, arg2Value))) && count2_ < (3)) {
                                        s2_ = super.insert(new InteropObjectData(interopObject_cache));
                                        s2_.serialize_ = s2_.insertAccessor((SERIALIZE_ARGUMENT_LIBRARY_.create(arg2Value)));
                                        this.interopObject_cache = s2_;
                                        this.state_ = state = state | 0b10 /* add-active doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary) */;
                                    }
                                }
                            }
                            if (s2_ != null) {
                                lock.unlock();
                                hasLock = false;
                                SerializeHelperNode.doInteropObject(arg0Value, arg1Value, arg2Value, ctx__, s2_.serialize_);
                                return;
                            }
                        }
                    }
                    {
                        NFIContext ctx__1 = null;
                        if (((exclude & 0b100)) == 0 /* is-not-excluded doGeneric(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary, HostObjectHelperNode) */) {
                            int count3_ = 0;
                            Generic0Data s3_ = this.generic0_cache;
                            if ((state & 0b100) != 0 /* is-active doGeneric(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary, HostObjectHelperNode) */) {
                                while (s3_ != null) {
                                    if ((s3_.serialize_.accepts(arg2Value))) {
                                        ContextReference<NFIContext> nFILanguageImplContextReference__7 = this.nFILanguageImplContextReference_;
                                        if (nFILanguageImplContextReference__7 == null) {
                                            this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__7 = super.lookupContextReference(NFILanguageImpl.class);
                                        }
                                        ctx__1 = nFILanguageImplContextReference__7.get();
                                        break;
                                    }
                                    s3_ = s3_.next_;
                                    count3_++;
                                }
                            }
                            if (s3_ == null) {
                                // assert (s3_.serialize_.accepts(arg2Value));
                                if (count3_ < (3)) {
                                    s3_ = super.insert(new Generic0Data(generic0_cache));
                                    ContextReference<NFIContext> nFILanguageImplContextReference__8 = this.nFILanguageImplContextReference_;
                                    if (nFILanguageImplContextReference__8 == null) {
                                        this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__8 = super.lookupContextReference(NFILanguageImpl.class);
                                    }
                                    ctx__1 = nFILanguageImplContextReference__8.get();
                                    s3_.serialize_ = s3_.insertAccessor((SERIALIZE_ARGUMENT_LIBRARY_.create(arg2Value)));
                                    s3_.helper_ = s3_.insertAccessor((HostObjectHelperNode.create(arg0Value)));
                                    this.generic0_cache = s3_;
                                    this.exclude_ = exclude = exclude | 0b11 /* add-excluded doHostObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, HostObjectHelperNode), doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary) */;
                                    this.interopObject_cache = null;
                                    state = state & 0xfffffffc /* remove-active doHostObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, HostObjectHelperNode), doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary) */;
                                    this.state_ = state = state | 0b100 /* add-active doGeneric(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary, HostObjectHelperNode) */;
                                }
                            }
                            if (s3_ != null) {
                                lock.unlock();
                                hasLock = false;
                                SerializeHelperNode.doGeneric(arg0Value, arg1Value, arg2Value, ctx__1, s3_.serialize_, s3_.helper_);
                                return;
                            }
                        }
                    }
                    {
                        SerializeArgumentLibrary generic1_serialize__ = null;
                        NFIContext generic1_ctx__ = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                ContextReference<NFIContext> nFILanguageImplContextReference__9 = this.nFILanguageImplContextReference_;
                                if (nFILanguageImplContextReference__9 == null) {
                                    this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__9 = super.lookupContextReference(NFILanguageImpl.class);
                                }
                                generic1_ctx__ = nFILanguageImplContextReference__9.get();
                                generic1_serialize__ = (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(arg2Value));
                                this.generic1_helper_ = super.insert((HostObjectHelperNode.create(arg0Value)));
                                this.exclude_ = exclude = exclude | 0b111 /* add-excluded doHostObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, HostObjectHelperNode), doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary), doGeneric(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary, HostObjectHelperNode) */;
                                this.interopObject_cache = null;
                                this.generic0_cache = null;
                                state = state & 0xfffffff8 /* remove-active doHostObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, HostObjectHelperNode), doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary), doGeneric(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary, HostObjectHelperNode) */;
                                this.state_ = state = state | 0b1000 /* add-active doGeneric(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary, HostObjectHelperNode) */;
                                lock.unlock();
                                hasLock = false;
                                SerializeHelperNode.doGeneric(arg0Value, arg1Value, arg2Value, generic1_ctx__, generic1_serialize__, this.generic1_helper_);
                                return;
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                    InteropObjectData s2_ = this.interopObject_cache;
                    Generic0Data s3_ = this.generic0_cache;
                    if ((s2_ == null || s2_.next_ == null) && (s3_ == null || s3_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            public static SerializeHelperNode create() {
                return new SerializeHelperNodeGen();
            }

            public static SerializeHelperNode getUncached() {
                return SerializeHelperNodeGen.UNCACHED;
            }

            @GeneratedBy(SerializeHelperNode.class)
            private static final class InteropObjectData extends Node {

                @Child InteropObjectData next_;
                @Child SerializeArgumentLibrary serialize_;

                InteropObjectData(InteropObjectData next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
            @GeneratedBy(SerializeHelperNode.class)
            private static final class Generic0Data extends Node {

                @Child Generic0Data next_;
                @Child SerializeArgumentLibrary serialize_;
                @Child HostObjectHelperNode helper_;

                Generic0Data(Generic0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
            @GeneratedBy(SerializeHelperNode.class)
            private static final class Uncached extends SerializeHelperNode {

                private final ContextReference<NFIContext> nFILanguageImplContextReference_ = lookupContextReference(NFILanguageImpl.class);

                @TruffleBoundary
                @Override
                void execute(ArrayType arg0Value, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                    SerializeHelperNode.doGeneric(arg0Value, arg1Value, arg2Value, this.nFILanguageImplContextReference_.get(), (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(arg2Value)), (HostObjectHelperNode.getUncached(arg0Value)));
                    return;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.MEGAMORPHIC;
                }

                @Override
                public boolean isAdoptable() {
                    return false;
                }

            }
        }
        @GeneratedBy(CachedHostObjectHelperNode.class)
        static final class CachedHostObjectHelperNodeGen extends CachedHostObjectHelperNode {

            @CompilationFinal private volatile int state_;
            @CompilationFinal private volatile int exclude_;
            @Child private SerializeArgumentLibrary hostArray10_lib_;
            @Child private SerializeArgumentLibrary hostArray20_lib_;

            private CachedHostObjectHelperNodeGen(int size, NativeSimpleType elementType) {
                super(size, elementType);
            }

            private boolean fallbackGuard_(int state, NativeArgumentBuffer arg0Value, Object arg1Value) {
                if (((state & 0b10)) == 0 /* is-not-active doHostArray1(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */ && (arrayClass1 == arg1Value.getClass())) {
                    return false;
                }
                if (((state & 0b1000)) == 0 /* is-not-active doHostArray2(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */ && (arrayClass2 == arg1Value.getClass())) {
                    return false;
                }
                return true;
            }

            @Override
            void execute(NativeArgumentBuffer arg0Value, Object arg1Value) throws UnsupportedTypeException, WrongTypeException {
                int state = state_;
                if (state != 0 /* is-active doHostArray1(NativeArgumentBuffer, Object, SerializeArgumentLibrary) || doHostArray1(NativeArgumentBuffer, Object, SerializeArgumentLibrary) || doHostArray2(NativeArgumentBuffer, Object, SerializeArgumentLibrary) || doHostArray2(NativeArgumentBuffer, Object, SerializeArgumentLibrary) || doOther(NativeArgumentBuffer, Object) */) {
                    if ((state & 0b1) != 0 /* is-active doHostArray1(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */) {
                        if ((this.hostArray10_lib_.accepts(arg1Value)) && (arrayClass1 == arg1Value.getClass())) {
                            doHostArray1(arg0Value, arg1Value, this.hostArray10_lib_);
                            return;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doHostArray1(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */) {
                        if ((arrayClass1 == arg1Value.getClass())) {
                            this.hostArray11Boundary(state, arg0Value, arg1Value);
                            return;
                        }
                    }
                    if ((state & 0b100) != 0 /* is-active doHostArray2(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */) {
                        if ((this.hostArray20_lib_.accepts(arg1Value)) && (arrayClass2 == arg1Value.getClass())) {
                            doHostArray2(arg0Value, arg1Value, this.hostArray20_lib_);
                            return;
                        }
                    }
                    if ((state & 0b1000) != 0 /* is-active doHostArray2(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */) {
                        if ((arrayClass2 == arg1Value.getClass())) {
                            this.hostArray21Boundary(state, arg0Value, arg1Value);
                            return;
                        }
                    }
                    if ((state & 0b10000) != 0 /* is-active doOther(NativeArgumentBuffer, Object) */) {
                        if (fallbackGuard_(state, arg0Value, arg1Value)) {
                            doOther(arg0Value, arg1Value);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(arg0Value, arg1Value);
                return;
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private void hostArray11Boundary(int state, NativeArgumentBuffer arg0Value, Object arg1Value) throws UnsupportedTypeException, WrongTypeException {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    {
                        SerializeArgumentLibrary hostArray11_lib__ = (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(arg1Value));
                        doHostArray1(arg0Value, arg1Value, hostArray11_lib__);
                        return;
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private void hostArray21Boundary(int state, NativeArgumentBuffer arg0Value, Object arg1Value) throws UnsupportedTypeException, WrongTypeException {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    {
                        SerializeArgumentLibrary hostArray21_lib__ = (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(arg1Value));
                        doHostArray2(arg0Value, arg1Value, hostArray21_lib__);
                        return;
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }

            private void executeAndSpecialize(NativeArgumentBuffer arg0Value, Object arg1Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if (((exclude & 0b1)) == 0 /* is-not-excluded doHostArray1(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */) {
                        boolean HostArray10_duplicateFound_ = false;
                        if ((state & 0b1) != 0 /* is-active doHostArray1(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */) {
                            if ((this.hostArray10_lib_.accepts(arg1Value)) && (arrayClass1 == arg1Value.getClass())) {
                                HostArray10_duplicateFound_ = true;
                            }
                        }
                        if (!HostArray10_duplicateFound_) {
                            if ((arrayClass1 == arg1Value.getClass()) && ((state & 0b1)) == 0 /* is-not-active doHostArray1(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */) {
                                // assert (this.hostArray10_lib_.accepts(arg1Value));
                                this.hostArray10_lib_ = super.insert((SERIALIZE_ARGUMENT_LIBRARY_.create(arg1Value)));
                                this.state_ = state = state | 0b1 /* add-active doHostArray1(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */;
                                HostArray10_duplicateFound_ = true;
                            }
                        }
                        if (HostArray10_duplicateFound_) {
                            lock.unlock();
                            hasLock = false;
                            doHostArray1(arg0Value, arg1Value, this.hostArray10_lib_);
                            return;
                        }
                    }
                    {
                        SerializeArgumentLibrary hostArray11_lib__ = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                if ((arrayClass1 == arg1Value.getClass())) {
                                    hostArray11_lib__ = (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(arg1Value));
                                    this.exclude_ = exclude = exclude | 0b1 /* add-excluded doHostArray1(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */;
                                    state = state & 0xfffffffe /* remove-active doHostArray1(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */;
                                    this.state_ = state = state | 0b10 /* add-active doHostArray1(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */;
                                    lock.unlock();
                                    hasLock = false;
                                    doHostArray1(arg0Value, arg1Value, hostArray11_lib__);
                                    return;
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                    if (((exclude & 0b10)) == 0 /* is-not-excluded doHostArray2(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */) {
                        boolean HostArray20_duplicateFound_ = false;
                        if ((state & 0b100) != 0 /* is-active doHostArray2(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */) {
                            if ((this.hostArray20_lib_.accepts(arg1Value)) && (arrayClass2 == arg1Value.getClass())) {
                                HostArray20_duplicateFound_ = true;
                            }
                        }
                        if (!HostArray20_duplicateFound_) {
                            if ((arrayClass2 == arg1Value.getClass()) && ((state & 0b100)) == 0 /* is-not-active doHostArray2(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */) {
                                // assert (this.hostArray20_lib_.accepts(arg1Value));
                                this.hostArray20_lib_ = super.insert((SERIALIZE_ARGUMENT_LIBRARY_.create(arg1Value)));
                                this.state_ = state = state | 0b100 /* add-active doHostArray2(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */;
                                HostArray20_duplicateFound_ = true;
                            }
                        }
                        if (HostArray20_duplicateFound_) {
                            lock.unlock();
                            hasLock = false;
                            doHostArray2(arg0Value, arg1Value, this.hostArray20_lib_);
                            return;
                        }
                    }
                    {
                        SerializeArgumentLibrary hostArray21_lib__ = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                if ((arrayClass2 == arg1Value.getClass())) {
                                    hostArray21_lib__ = (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(arg1Value));
                                    this.exclude_ = exclude = exclude | 0b10 /* add-excluded doHostArray2(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */;
                                    state = state & 0xfffffffb /* remove-active doHostArray2(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */;
                                    this.state_ = state = state | 0b1000 /* add-active doHostArray2(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */;
                                    lock.unlock();
                                    hasLock = false;
                                    doHostArray2(arg0Value, arg1Value, hostArray21_lib__);
                                    return;
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                    this.state_ = state = state | 0b10000 /* add-active doOther(NativeArgumentBuffer, Object) */;
                    lock.unlock();
                    hasLock = false;
                    doOther(arg0Value, arg1Value);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            public static CachedHostObjectHelperNode create(int size, NativeSimpleType elementType) {
                return new CachedHostObjectHelperNodeGen(size, elementType);
            }

        }
    }
}
