/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.nfi.impl.LibFFIType;
import com.oracle.truffle.nfi.impl.NFIContext;
import com.oracle.truffle.nfi.impl.NativeAllocation;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.NativePointer;
import com.oracle.truffle.nfi.spi.types.NativeArrayTypeMirror;
import com.oracle.truffle.nfi.spi.types.NativeSignature;
import com.oracle.truffle.nfi.spi.types.NativeTypeMirror;
import java.util.List;

final class LibFFISignature {
    private final LibFFIType retType;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final LibFFIType[] argTypes;
    private final int primitiveSize;
    private final int objectCount;
    private final int realArgCount;
    private final long cif;
    private final LibFFIType.Direction allowedCallDirection;

    public static LibFFISignature create(NFIContext context, NativeSignature signature) {
        LibFFISignature ret = new LibFFISignature(context, signature);
        NativeAllocation.getGlobalQueue().registerNativeAllocation(ret, new NativeAllocation.FreeDestructor(ret.cif));
        return ret;
    }

    private LibFFISignature(NFIContext context, NativeSignature signature) {
        if (signature.getRetType() instanceof NativeArrayTypeMirror) {
            throw new IllegalArgumentException("array type as return value is not supported");
        }
        boolean allowJavaToNativeCall = true;
        boolean allowNativeToJavaCall = true;
        this.retType = context.lookupRetType(signature.getRetType());
        switch (this.retType.allowedDataFlowDirection) {
            case JAVA_TO_NATIVE_ONLY: {
                allowJavaToNativeCall = false;
                break;
            }
            case NATIVE_TO_JAVA_ONLY: {
                allowNativeToJavaCall = false;
            }
        }
        List<NativeTypeMirror> args = signature.getArgTypes();
        this.argTypes = new LibFFIType[args.size()];
        for (int i = 0; i < this.argTypes.length; ++i) {
            LibFFIType argType = context.lookupArgType(args.get(i));
            if (argType instanceof LibFFIType.VoidType) {
                throw new IllegalArgumentException("void is not a valid argument type");
            }
            switch (argType.allowedDataFlowDirection) {
                case JAVA_TO_NATIVE_ONLY: {
                    allowNativeToJavaCall = false;
                    break;
                }
                case NATIVE_TO_JAVA_ONLY: {
                    allowJavaToNativeCall = false;
                }
            }
            this.argTypes[i] = argType;
        }
        if (allowNativeToJavaCall) {
            this.allowedCallDirection = allowJavaToNativeCall ? LibFFIType.Direction.BOTH : LibFFIType.Direction.NATIVE_TO_JAVA_ONLY;
        } else if (allowJavaToNativeCall) {
            this.allowedCallDirection = LibFFIType.Direction.JAVA_TO_NATIVE_ONLY;
        } else {
            throw new IllegalArgumentException("invalid signature");
        }
        this.cif = signature.isVarargs() ? context.prepareSignatureVarargs(this.retType, signature.getFixedArgCount(), this.argTypes) : context.prepareSignature(this.retType, this.argTypes);
        int primSize = 0;
        int objCount = 0;
        int argCount = 0;
        for (LibFFIType type : this.argTypes) {
            int align = type.alignment;
            if (primSize % align != 0) {
                primSize += align - primSize % align;
            }
            primSize += type.size;
            objCount += type.objectCount;
            if (type.injectedArgument) continue;
            ++argCount;
        }
        this.primitiveSize = primSize;
        this.objectCount = objCount;
        this.realArgCount = argCount;
    }

    public NativeArgumentBuffer.Array prepareBuffer() {
        return new NativeArgumentBuffer.Array(this.primitiveSize, this.objectCount);
    }

    public LibFFIType[] getArgTypes() {
        return this.argTypes;
    }

    public LibFFIType getRetType() {
        return this.retType;
    }

    public LibFFIType.Direction getAllowedCallDirection() {
        return this.allowedCallDirection;
    }

    public int getRealArgCount() {
        return this.realArgCount;
    }

    public Object execute(NFIContext ctx, long functionPointer, NativeArgumentBuffer.Array argBuffer) {
        CompilerAsserts.partialEvaluationConstant((Object)this.retType);
        if (this.retType instanceof LibFFIType.ObjectType) {
            Object ret = ctx.executeObject(this.cif, functionPointer, argBuffer.prim, argBuffer.getPatchCount(), argBuffer.patches, argBuffer.objects);
            if (ret == null) {
                return NativePointer.create(ctx.language, 0L);
            }
            return ret;
        }
        if (this.retType instanceof LibFFIType.SimpleType) {
            LibFFIType.SimpleType simpleType = (LibFFIType.SimpleType)this.retType;
            long ret = ctx.executePrimitive(this.cif, functionPointer, argBuffer.prim, argBuffer.getPatchCount(), argBuffer.patches, argBuffer.objects);
            return simpleType.fromPrimitive(ret);
        }
        NativeArgumentBuffer.Array retBuffer = new NativeArgumentBuffer.Array(this.retType.size, this.retType.objectCount);
        ctx.executeNative(this.cif, functionPointer, argBuffer.prim, argBuffer.getPatchCount(), argBuffer.patches, argBuffer.objects, retBuffer.prim);
        return this.retType.deserializeRet(retBuffer, ctx.language);
    }
}

