// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.TruffleLanguage.ContextReference;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.source.Source;
import java.util.concurrent.locks.Lock;

@GeneratedBy(BindSignatureNode.class)
final class BindSignatureNodeGen extends BindSignatureNode {

    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @CompilationFinal private volatile int state_0_;
    @CompilationFinal private volatile int exclude_;
    @CompilationFinal private ContextReference<NFIContext> nFILanguageContextReference_;
    @CompilationFinal private CachedSignatureData cachedSignature_cache;
    @Child private CachedSignatureStringData cachedSignatureString_cache;

    private BindSignatureNodeGen() {
    }

    @ExplodeLoop
    @Override
    Object execute(NFISymbol arg0Value, Object arg1Value) throws UnsupportedMessageException, UnsupportedTypeException {
        int state_0 = state_0_;
        if (state_0 != 0 /* is-state_0 doCachedSignature(NFISymbol, Object, String, Object, ContextReference<NFIContext>, NFISignature) || doCachedSignatureString(NFISymbol, Object, InteropLibrary, String, Source, NFIContext, IndirectCallNode) || doGeneric(NFISymbol, Object, ContextReference<NFIContext>) */) {
            if ((state_0 & 0b1) != 0 /* is-state_0 doCachedSignature(NFISymbol, Object, String, Object, ContextReference<NFIContext>, NFISignature) */) {
                CachedSignatureData s1_ = this.cachedSignature_cache;
                while (s1_ != null) {
                    if (!Assumption.isValidAssumption(s1_.assumption0_)) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        removeCachedSignature_(s1_);
                        return executeAndSpecialize(arg0Value, arg1Value);
                    }
                    if ((arg0Value.backend == s1_.cachedBackend_) && (arg1Value == s1_.cachedSignature_)) {
                        ContextReference<NFIContext> nFILanguageContextReference__ = this.nFILanguageContextReference_;
                        ContextReference<NFIContext> ctxRef__ = nFILanguageContextReference__;
                        return BindSignatureNode.doCachedSignature(arg0Value, arg1Value, s1_.cachedBackend_, s1_.cachedSignature_, ctxRef__, s1_.parsedSignature_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state_0 & 0b10) != 0 /* is-state_0 doCachedSignatureString(NFISymbol, Object, InteropLibrary, String, Source, NFIContext, IndirectCallNode) */) {
                CachedSignatureStringData s2_ = this.cachedSignatureString_cache;
                while (s2_ != null) {
                    if ((s2_.interop_.accepts(arg1Value)) && (s2_.cachedSignature_.equals(BindSignatureNode.asString(s2_.interop_, arg1Value)))) {
                        ContextReference<NFIContext> nFILanguageContextReference__1 = this.nFILanguageContextReference_;
                        NFIContext ctx__ = nFILanguageContextReference__1.get();
                        return BindSignatureNode.doCachedSignatureString(arg0Value, arg1Value, s2_.interop_, s2_.cachedSignature_, s2_.signatureSource_, ctx__, s2_.call_);
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state_0 & 0b100) != 0 /* is-state_0 doGeneric(NFISymbol, Object, ContextReference<NFIContext>) */) {
                {
                    ContextReference<NFIContext> nFILanguageContextReference__2 = this.nFILanguageContextReference_;
                    ContextReference<NFIContext> generic_ctxRef__ = nFILanguageContextReference__2;
                    return BindSignatureNode.doGeneric(arg0Value, arg1Value, generic_ctxRef__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value);
    }

    private Object executeAndSpecialize(NFISymbol arg0Value, Object arg1Value) throws UnsupportedTypeException {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = state_0_;
        int exclude = exclude_;
        try {
            {
                ContextReference<NFIContext> ctxRef__ = null;
                if (((exclude & 0b1)) == 0 /* is-not-exclude doCachedSignature(NFISymbol, Object, String, Object, ContextReference<NFIContext>, NFISignature) */) {
                    int count1_ = 0;
                    CachedSignatureData s1_ = this.cachedSignature_cache;
                    if ((state_0 & 0b1) != 0 /* is-state_0 doCachedSignature(NFISymbol, Object, String, Object, ContextReference<NFIContext>, NFISignature) */) {
                        while (s1_ != null) {
                            if ((arg0Value.backend == s1_.cachedBackend_) && (arg1Value == s1_.cachedSignature_) && (s1_.assumption0_ == null || Assumption.isValidAssumption(s1_.assumption0_))) {
                                ContextReference<NFIContext> nFILanguageContextReference__3 = this.nFILanguageContextReference_;
                                if (nFILanguageContextReference__3 == null) {
                                    this.nFILanguageContextReference_ = nFILanguageContextReference__3 = super.lookupContextReference(NFILanguage.class);
                                }
                                ctxRef__ = nFILanguageContextReference__3;
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        // assert (arg0Value.backend == s1_.cachedBackend_);
                        // assert (arg1Value == s1_.cachedSignature_);
                        {
                            Assumption assumption0 = (NFILanguage.getSingleContextAssumption());
                            if (Assumption.isValidAssumption(assumption0)) {
                                if (count1_ < (5)) {
                                    s1_ = new CachedSignatureData(cachedSignature_cache);
                                    s1_.cachedBackend_ = (arg0Value.backend);
                                    s1_.cachedSignature_ = (arg1Value);
                                    ContextReference<NFIContext> nFILanguageContextReference__4 = this.nFILanguageContextReference_;
                                    if (nFILanguageContextReference__4 == null) {
                                        this.nFILanguageContextReference_ = nFILanguageContextReference__4 = super.lookupContextReference(NFILanguage.class);
                                    }
                                    ctxRef__ = nFILanguageContextReference__4;
                                    s1_.parsedSignature_ = (BindSignatureNode.parseSignature(s1_.cachedBackend_, s1_.cachedSignature_, ctxRef__));
                                    s1_.assumption0_ = assumption0;
                                    this.cachedSignature_cache = s1_;
                                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doCachedSignature(NFISymbol, Object, String, Object, ContextReference<NFIContext>, NFISignature) */;
                                }
                            }
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return BindSignatureNode.doCachedSignature(arg0Value, arg1Value, s1_.cachedBackend_, s1_.cachedSignature_, ctxRef__, s1_.parsedSignature_);
                    }
                }
            }
            {
                NFIContext ctx__ = null;
                if (((exclude & 0b10)) == 0 /* is-not-exclude doCachedSignatureString(NFISymbol, Object, InteropLibrary, String, Source, NFIContext, IndirectCallNode) */) {
                    int count2_ = 0;
                    CachedSignatureStringData s2_ = this.cachedSignatureString_cache;
                    if ((state_0 & 0b10) != 0 /* is-state_0 doCachedSignatureString(NFISymbol, Object, InteropLibrary, String, Source, NFIContext, IndirectCallNode) */) {
                        while (s2_ != null) {
                            if ((s2_.interop_.accepts(arg1Value)) && (s2_.cachedSignature_.equals(BindSignatureNode.asString(s2_.interop_, arg1Value)))) {
                                ContextReference<NFIContext> nFILanguageContextReference__5 = this.nFILanguageContextReference_;
                                if (nFILanguageContextReference__5 == null) {
                                    this.nFILanguageContextReference_ = nFILanguageContextReference__5 = super.lookupContextReference(NFILanguage.class);
                                }
                                ctx__ = nFILanguageContextReference__5.get();
                                break;
                            }
                            s2_ = s2_.next_;
                            count2_++;
                        }
                    }
                    if (s2_ == null) {
                        {
                            InteropLibrary interop__ = super.insert((INTEROP_LIBRARY_.create(arg1Value)));
                            String cachedSignature__ = (BindSignatureNode.asString(interop__, arg1Value));
                            // assert (s2_.interop_.accepts(arg1Value));
                            if ((cachedSignature__.equals(BindSignatureNode.asString(interop__, arg1Value))) && count2_ < (5)) {
                                s2_ = super.insert(new CachedSignatureStringData(cachedSignatureString_cache));
                                s2_.interop_ = s2_.insertAccessor(interop__);
                                s2_.cachedSignature_ = cachedSignature__;
                                s2_.signatureSource_ = (BindSignatureNode.createSignatureSource(arg0Value.backend, cachedSignature__));
                                ContextReference<NFIContext> nFILanguageContextReference__6 = this.nFILanguageContextReference_;
                                if (nFILanguageContextReference__6 == null) {
                                    this.nFILanguageContextReference_ = nFILanguageContextReference__6 = super.lookupContextReference(NFILanguage.class);
                                }
                                ctx__ = nFILanguageContextReference__6.get();
                                s2_.call_ = s2_.insertAccessor((IndirectCallNode.create()));
                                this.cachedSignatureString_cache = s2_;
                                this.exclude_ = exclude = exclude | 0b1 /* add-exclude doCachedSignature(NFISymbol, Object, String, Object, ContextReference<NFIContext>, NFISignature) */;
                                this.cachedSignature_cache = null;
                                state_0 = state_0 & 0xfffffffe /* remove-state_0 doCachedSignature(NFISymbol, Object, String, Object, ContextReference<NFIContext>, NFISignature) */;
                                this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 doCachedSignatureString(NFISymbol, Object, InteropLibrary, String, Source, NFIContext, IndirectCallNode) */;
                            }
                        }
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return BindSignatureNode.doCachedSignatureString(arg0Value, arg1Value, s2_.interop_, s2_.cachedSignature_, s2_.signatureSource_, ctx__, s2_.call_);
                    }
                }
            }
            {
                ContextReference<NFIContext> generic_ctxRef__ = null;
                ContextReference<NFIContext> nFILanguageContextReference__7 = this.nFILanguageContextReference_;
                if (nFILanguageContextReference__7 == null) {
                    this.nFILanguageContextReference_ = nFILanguageContextReference__7 = super.lookupContextReference(NFILanguage.class);
                }
                generic_ctxRef__ = nFILanguageContextReference__7;
                this.exclude_ = exclude = exclude | 0b11 /* add-exclude doCachedSignature(NFISymbol, Object, String, Object, ContextReference<NFIContext>, NFISignature), doCachedSignatureString(NFISymbol, Object, InteropLibrary, String, Source, NFIContext, IndirectCallNode) */;
                this.cachedSignature_cache = null;
                this.cachedSignatureString_cache = null;
                state_0 = state_0 & 0xfffffffc /* remove-state_0 doCachedSignature(NFISymbol, Object, String, Object, ContextReference<NFIContext>, NFISignature), doCachedSignatureString(NFISymbol, Object, InteropLibrary, String, Source, NFIContext, IndirectCallNode) */;
                this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 doGeneric(NFISymbol, Object, ContextReference<NFIContext>) */;
                lock.unlock();
                hasLock = false;
                return BindSignatureNode.doGeneric(arg0Value, arg1Value, generic_ctxRef__);
            }
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state_0 = state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                CachedSignatureData s1_ = this.cachedSignature_cache;
                CachedSignatureStringData s2_ = this.cachedSignatureString_cache;
                if ((s1_ == null || s1_.next_ == null) && (s2_ == null || s2_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    void removeCachedSignature_(Object s1_) {
        Lock lock = getLock();
        lock.lock();
        try {
            CachedSignatureData prev = null;
            CachedSignatureData cur = this.cachedSignature_cache;
            while (cur != null) {
                if (cur == s1_) {
                    if (prev == null) {
                        this.cachedSignature_cache = cur.next_;
                    } else {
                        prev.next_ = cur.next_;
                    }
                    break;
                }
                prev = cur;
                cur = cur.next_;
            }
            if (this.cachedSignature_cache == null) {
                this.state_0_ = this.state_0_ & 0xfffffffe /* remove-state_0 doCachedSignature(NFISymbol, Object, String, Object, ContextReference<NFIContext>, NFISignature) */;
            }
        } finally {
            lock.unlock();
        }
    }

    public static BindSignatureNode create() {
        return new BindSignatureNodeGen();
    }

    public static BindSignatureNode getUncached() {
        return BindSignatureNodeGen.UNCACHED;
    }

    @GeneratedBy(BindSignatureNode.class)
    private static final class CachedSignatureData {

        @CompilationFinal CachedSignatureData next_;
        @CompilationFinal String cachedBackend_;
        @CompilationFinal Object cachedSignature_;
        @CompilationFinal NFISignature parsedSignature_;
        @CompilationFinal Assumption assumption0_;

        CachedSignatureData(CachedSignatureData next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(BindSignatureNode.class)
    private static final class CachedSignatureStringData extends Node {

        @Child CachedSignatureStringData next_;
        @Child InteropLibrary interop_;
        @CompilationFinal String cachedSignature_;
        @CompilationFinal Source signatureSource_;
        @Child IndirectCallNode call_;

        CachedSignatureStringData(CachedSignatureStringData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
    @GeneratedBy(BindSignatureNode.class)
    private static final class Uncached extends BindSignatureNode {

        private final ContextReference<NFIContext> nFILanguageContextReference_ = lookupContextReference(NFILanguage.class);

        @TruffleBoundary
        @Override
        Object execute(NFISymbol arg0Value, Object arg1Value) throws UnsupportedMessageException, UnsupportedTypeException {
            return BindSignatureNode.doGeneric(arg0Value, arg1Value, this.nFILanguageContextReference_);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
