// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.NFIType.ClosureTypeCachedState;
import com.oracle.truffle.nfi.NFIType.TypeCachedState;
import com.oracle.truffle.nfi.NFIType.ClosureTypeCachedState.ConvertFromNative;
import com.oracle.truffle.nfi.NFIType.ClosureTypeCachedState.ConvertToNative;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(ClosureTypeCachedState.class)
@SuppressWarnings("unused")
final class ClosureTypeCachedStateGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<SignatureLibrary> SIGNATURE_LIBRARY_ = LibraryFactory.resolve(SignatureLibrary.class);

    static  {
        LibraryExport.register(ClosureTypeCachedState.class, new NFITypeLibraryExports());
    }

    private ClosureTypeCachedStateGen() {
    }

    @GeneratedBy(ClosureTypeCachedState.class)
    private static final class NFITypeLibraryExports extends LibraryExport<NFITypeLibrary> {

        private NFITypeLibraryExports() {
            super(NFITypeLibrary.class, ClosureTypeCachedState.class, false);
        }

        @Override
        protected NFITypeLibrary createUncached(Object receiver) {
            assert receiver instanceof ClosureTypeCachedState;
            NFITypeLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected NFITypeLibrary createCached(Object receiver) {
            assert receiver instanceof ClosureTypeCachedState;
            return new Cached();
        }

        @GeneratedBy(ClosureTypeCachedState.class)
        private static final class Cached extends NFITypeLibrary {

            @CompilationFinal private volatile int state_0_;
            @CompilationFinal private volatile int exclude_;
            @Child private ConvertToNativeConvertToNative0Data convertToNative_convertToNative0_cache;
            @Child private ConvertFromNativeNull0Data convertFromNative_null0_cache;
            @Child private ConvertFromNativeBind0Data convertFromNative_bind0_cache;

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof ClosureTypeCachedState) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof ClosureTypeCachedState;
            }

            @ExplodeLoop
            @Override
            public Object convertToNative(TypeCachedState arg0Value_, NFIType arg1Value, Object arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                ClosureTypeCachedState arg0Value = ((ClosureTypeCachedState) arg0Value_);
                int state_0 = state_0_;
                if ((state_0 & 0b111) != 0 /* is-state_0 convertToNative(ClosureTypeCachedState, NFIType, Object, InteropLibrary, SignatureLibrary) || convertToNative(ClosureTypeCachedState, NFIType, Object, InteropLibrary, SignatureLibrary) || convertToNative(ClosureTypeCachedState, NFIType, Object) */) {
                    if ((state_0 & 0b1) != 0 /* is-state_0 convertToNative(ClosureTypeCachedState, NFIType, Object, InteropLibrary, SignatureLibrary) */) {
                        ConvertToNativeConvertToNative0Data s1_ = this.convertToNative_convertToNative0_cache;
                        while (s1_ != null) {
                            if ((s1_.interop_.accepts(arg2Value)) && (s1_.library_.accepts(arg1Value.runtimeData)) && (s1_.interop_.isExecutable(arg2Value))) {
                                return ConvertToNative.convertToNative(arg0Value, arg1Value, arg2Value, s1_.interop_, s1_.library_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is-state_0 convertToNative(ClosureTypeCachedState, NFIType, Object, InteropLibrary, SignatureLibrary) */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                InteropLibrary convertToNative_convertToNative1_interop__ = (INTEROP_LIBRARY_.getUncached());
                                if ((convertToNative_convertToNative1_interop__.isExecutable(arg2Value))) {
                                    return this.convertToNative1Boundary(state_0, arg0Value, arg1Value, arg2Value);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is-state_0 convertToNative(ClosureTypeCachedState, NFIType, Object) */) {
                        if (convertToNativeFallbackGuard_(state_0, arg0Value, arg1Value, arg2Value)) {
                            return ConvertToNative.convertToNative(arg0Value, arg1Value, arg2Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return convertToNativeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object convertToNative1Boundary(int state_0, ClosureTypeCachedState arg0Value, NFIType arg1Value, Object arg2Value) {
                {
                    InteropLibrary convertToNative_convertToNative1_interop__ = (INTEROP_LIBRARY_.getUncached());
                    SignatureLibrary convertToNative_convertToNative1_library__ = (SIGNATURE_LIBRARY_.getUncached());
                    return ConvertToNative.convertToNative(arg0Value, arg1Value, arg2Value, convertToNative_convertToNative1_interop__, convertToNative_convertToNative1_library__);
                }
            }

            private Object convertToNativeAndSpecialize(ClosureTypeCachedState arg0Value, NFIType arg1Value, Object arg2Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = state_0_;
                int exclude = exclude_;
                try {
                    if (((exclude & 0b1)) == 0 /* is-not-exclude convertToNative(ClosureTypeCachedState, NFIType, Object, InteropLibrary, SignatureLibrary) */) {
                        int count1_ = 0;
                        ConvertToNativeConvertToNative0Data s1_ = this.convertToNative_convertToNative0_cache;
                        if ((state_0 & 0b1) != 0 /* is-state_0 convertToNative(ClosureTypeCachedState, NFIType, Object, InteropLibrary, SignatureLibrary) */) {
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(arg2Value)) && (s1_.library_.accepts(arg1Value.runtimeData)) && (s1_.interop_.isExecutable(arg2Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            {
                                InteropLibrary interop__ = super.insert((INTEROP_LIBRARY_.create(arg2Value)));
                                // assert (s1_.interop_.accepts(arg2Value));
                                // assert (s1_.library_.accepts(arg1Value.runtimeData));
                                if ((interop__.isExecutable(arg2Value)) && count1_ < (3)) {
                                    s1_ = super.insert(new ConvertToNativeConvertToNative0Data(convertToNative_convertToNative0_cache));
                                    s1_.interop_ = s1_.insertAccessor(interop__);
                                    s1_.library_ = s1_.insertAccessor((SIGNATURE_LIBRARY_.create(arg1Value.runtimeData)));
                                    this.convertToNative_convertToNative0_cache = s1_;
                                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 convertToNative(ClosureTypeCachedState, NFIType, Object, InteropLibrary, SignatureLibrary) */;
                                }
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return ConvertToNative.convertToNative(arg0Value, arg1Value, arg2Value, s1_.interop_, s1_.library_);
                        }
                    }
                    {
                        SignatureLibrary convertToNative_convertToNative1_library__ = null;
                        InteropLibrary convertToNative_convertToNative1_interop__ = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                {
                                    convertToNative_convertToNative1_interop__ = (INTEROP_LIBRARY_.getUncached());
                                    if ((convertToNative_convertToNative1_interop__.isExecutable(arg2Value))) {
                                        convertToNative_convertToNative1_library__ = (SIGNATURE_LIBRARY_.getUncached());
                                        this.exclude_ = exclude = exclude | 0b1 /* add-exclude convertToNative(ClosureTypeCachedState, NFIType, Object, InteropLibrary, SignatureLibrary) */;
                                        this.convertToNative_convertToNative0_cache = null;
                                        state_0 = state_0 & 0xfffffffe /* remove-state_0 convertToNative(ClosureTypeCachedState, NFIType, Object, InteropLibrary, SignatureLibrary) */;
                                        this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 convertToNative(ClosureTypeCachedState, NFIType, Object, InteropLibrary, SignatureLibrary) */;
                                        lock.unlock();
                                        hasLock = false;
                                        return ConvertToNative.convertToNative(arg0Value, arg1Value, arg2Value, convertToNative_convertToNative1_interop__, convertToNative_convertToNative1_library__);
                                    }
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                    this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 convertToNative(ClosureTypeCachedState, NFIType, Object) */;
                    lock.unlock();
                    hasLock = false;
                    return ConvertToNative.convertToNative(arg0Value, arg1Value, arg2Value);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state_0 = state_0_;
                if ((state_0 & 0b111) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b111) & ((state_0 & 0b111) - 1)) == 0 /* is-single-state_0  */) {
                        ConvertToNativeConvertToNative0Data s1_ = this.convertToNative_convertToNative0_cache;
                        if ((s1_ == null || s1_.next_ == null)) {
                            return NodeCost.MONOMORPHIC;
                        }
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @ExplodeLoop
            @Override
            public Object convertFromNative(TypeCachedState arg0Value_, NFIType arg1Value, Object arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                ClosureTypeCachedState arg0Value = ((ClosureTypeCachedState) arg0Value_);
                int state_0 = state_0_;
                if ((state_0 & 0b1111000) != 0 /* is-state_0 doNull(ClosureTypeCachedState, NFIType, Object, InteropLibrary) || doNull(ClosureTypeCachedState, NFIType, Object, InteropLibrary) || doBind(ClosureTypeCachedState, NFIType, Object, InteropLibrary, SignatureLibrary) || doBind(ClosureTypeCachedState, NFIType, Object, InteropLibrary, SignatureLibrary) */) {
                    if ((state_0 & 0b1000) != 0 /* is-state_0 doNull(ClosureTypeCachedState, NFIType, Object, InteropLibrary) */) {
                        ConvertFromNativeNull0Data s1_ = this.convertFromNative_null0_cache;
                        while (s1_ != null) {
                            if ((s1_.interop_.accepts(arg2Value)) && (s1_.interop_.isNull(arg2Value))) {
                                return ConvertFromNative.doNull(arg0Value, arg1Value, arg2Value, s1_.interop_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is-state_0 doNull(ClosureTypeCachedState, NFIType, Object, InteropLibrary) */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                InteropLibrary convertFromNative_null1_interop__ = (INTEROP_LIBRARY_.getUncached());
                                if ((convertFromNative_null1_interop__.isNull(arg2Value))) {
                                    return this.null1Boundary(state_0, arg0Value, arg1Value, arg2Value);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is-state_0 doBind(ClosureTypeCachedState, NFIType, Object, InteropLibrary, SignatureLibrary) */) {
                        ConvertFromNativeBind0Data s3_ = this.convertFromNative_bind0_cache;
                        while (s3_ != null) {
                            if ((s3_.interop_.accepts(arg2Value)) && (s3_.library_.accepts(arg1Value.runtimeData)) && (!(s3_.interop_.isNull(arg2Value)))) {
                                return ConvertFromNative.doBind(arg0Value, arg1Value, arg2Value, s3_.interop_, s3_.library_);
                            }
                            s3_ = s3_.next_;
                        }
                    }
                    if ((state_0 & 0b1000000) != 0 /* is-state_0 doBind(ClosureTypeCachedState, NFIType, Object, InteropLibrary, SignatureLibrary) */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                InteropLibrary convertFromNative_bind1_interop__ = (INTEROP_LIBRARY_.getUncached());
                                if ((!(convertFromNative_bind1_interop__.isNull(arg2Value)))) {
                                    return this.bind1Boundary(state_0, arg0Value, arg1Value, arg2Value);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return convertFromNativeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object null1Boundary(int state_0, ClosureTypeCachedState arg0Value, NFIType arg1Value, Object arg2Value) {
                {
                    InteropLibrary convertFromNative_null1_interop__ = (INTEROP_LIBRARY_.getUncached());
                    return ConvertFromNative.doNull(arg0Value, arg1Value, arg2Value, convertFromNative_null1_interop__);
                }
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object bind1Boundary(int state_0, ClosureTypeCachedState arg0Value, NFIType arg1Value, Object arg2Value) {
                {
                    InteropLibrary convertFromNative_bind1_interop__ = (INTEROP_LIBRARY_.getUncached());
                    SignatureLibrary convertFromNative_bind1_library__ = (SIGNATURE_LIBRARY_.getUncached());
                    return ConvertFromNative.doBind(arg0Value, arg1Value, arg2Value, convertFromNative_bind1_interop__, convertFromNative_bind1_library__);
                }
            }

            private Object convertFromNativeAndSpecialize(ClosureTypeCachedState arg0Value, NFIType arg1Value, Object arg2Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = state_0_;
                int exclude = exclude_;
                try {
                    if (((exclude & 0b10)) == 0 /* is-not-exclude doNull(ClosureTypeCachedState, NFIType, Object, InteropLibrary) */) {
                        int count1_ = 0;
                        ConvertFromNativeNull0Data s1_ = this.convertFromNative_null0_cache;
                        if ((state_0 & 0b1000) != 0 /* is-state_0 doNull(ClosureTypeCachedState, NFIType, Object, InteropLibrary) */) {
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(arg2Value)) && (s1_.interop_.isNull(arg2Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            {
                                InteropLibrary interop__ = super.insert((INTEROP_LIBRARY_.create(arg2Value)));
                                // assert (s1_.interop_.accepts(arg2Value));
                                if ((interop__.isNull(arg2Value)) && count1_ < (3)) {
                                    s1_ = super.insert(new ConvertFromNativeNull0Data(convertFromNative_null0_cache));
                                    s1_.interop_ = s1_.insertAccessor(interop__);
                                    this.convertFromNative_null0_cache = s1_;
                                    this.state_0_ = state_0 = state_0 | 0b1000 /* add-state_0 doNull(ClosureTypeCachedState, NFIType, Object, InteropLibrary) */;
                                }
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return ConvertFromNative.doNull(arg0Value, arg1Value, arg2Value, s1_.interop_);
                        }
                    }
                    {
                        InteropLibrary convertFromNative_null1_interop__ = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                {
                                    convertFromNative_null1_interop__ = (INTEROP_LIBRARY_.getUncached());
                                    if ((convertFromNative_null1_interop__.isNull(arg2Value))) {
                                        this.exclude_ = exclude = exclude | 0b10 /* add-exclude doNull(ClosureTypeCachedState, NFIType, Object, InteropLibrary) */;
                                        this.convertFromNative_null0_cache = null;
                                        state_0 = state_0 & 0xfffffff7 /* remove-state_0 doNull(ClosureTypeCachedState, NFIType, Object, InteropLibrary) */;
                                        this.state_0_ = state_0 = state_0 | 0b10000 /* add-state_0 doNull(ClosureTypeCachedState, NFIType, Object, InteropLibrary) */;
                                        lock.unlock();
                                        hasLock = false;
                                        return ConvertFromNative.doNull(arg0Value, arg1Value, arg2Value, convertFromNative_null1_interop__);
                                    }
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                    if (((exclude & 0b100)) == 0 /* is-not-exclude doBind(ClosureTypeCachedState, NFIType, Object, InteropLibrary, SignatureLibrary) */) {
                        int count3_ = 0;
                        ConvertFromNativeBind0Data s3_ = this.convertFromNative_bind0_cache;
                        if ((state_0 & 0b100000) != 0 /* is-state_0 doBind(ClosureTypeCachedState, NFIType, Object, InteropLibrary, SignatureLibrary) */) {
                            while (s3_ != null) {
                                if ((s3_.interop_.accepts(arg2Value)) && (s3_.library_.accepts(arg1Value.runtimeData)) && (!(s3_.interop_.isNull(arg2Value)))) {
                                    break;
                                }
                                s3_ = s3_.next_;
                                count3_++;
                            }
                        }
                        if (s3_ == null) {
                            {
                                InteropLibrary interop__1 = super.insert((INTEROP_LIBRARY_.create(arg2Value)));
                                // assert (s3_.interop_.accepts(arg2Value));
                                // assert (s3_.library_.accepts(arg1Value.runtimeData));
                                if ((!(interop__1.isNull(arg2Value))) && count3_ < (3)) {
                                    s3_ = super.insert(new ConvertFromNativeBind0Data(convertFromNative_bind0_cache));
                                    s3_.interop_ = s3_.insertAccessor(interop__1);
                                    s3_.library_ = s3_.insertAccessor((SIGNATURE_LIBRARY_.create(arg1Value.runtimeData)));
                                    this.convertFromNative_bind0_cache = s3_;
                                    this.state_0_ = state_0 = state_0 | 0b100000 /* add-state_0 doBind(ClosureTypeCachedState, NFIType, Object, InteropLibrary, SignatureLibrary) */;
                                }
                            }
                        }
                        if (s3_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return ConvertFromNative.doBind(arg0Value, arg1Value, arg2Value, s3_.interop_, s3_.library_);
                        }
                    }
                    {
                        SignatureLibrary convertFromNative_bind1_library__ = null;
                        InteropLibrary convertFromNative_bind1_interop__ = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                {
                                    convertFromNative_bind1_interop__ = (INTEROP_LIBRARY_.getUncached());
                                    if ((!(convertFromNative_bind1_interop__.isNull(arg2Value)))) {
                                        convertFromNative_bind1_library__ = (SIGNATURE_LIBRARY_.getUncached());
                                        this.exclude_ = exclude = exclude | 0b100 /* add-exclude doBind(ClosureTypeCachedState, NFIType, Object, InteropLibrary, SignatureLibrary) */;
                                        this.convertFromNative_bind0_cache = null;
                                        state_0 = state_0 & 0xffffffdf /* remove-state_0 doBind(ClosureTypeCachedState, NFIType, Object, InteropLibrary, SignatureLibrary) */;
                                        this.state_0_ = state_0 = state_0 | 0b1000000 /* add-state_0 doBind(ClosureTypeCachedState, NFIType, Object, InteropLibrary, SignatureLibrary) */;
                                        lock.unlock();
                                        hasLock = false;
                                        return ConvertFromNative.doBind(arg0Value, arg1Value, arg2Value, convertFromNative_bind1_interop__, convertFromNative_bind1_library__);
                                    }
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                    throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            private static boolean convertToNativeFallbackGuard_(int state_0, ClosureTypeCachedState arg0Value, NFIType arg1Value, Object arg2Value) {
                if (((state_0 & 0b10)) == 0 /* is-not-state_0 convertToNative(ClosureTypeCachedState, NFIType, Object, InteropLibrary, SignatureLibrary) */ && ((INTEROP_LIBRARY_.getUncached()).isExecutable(arg2Value))) {
                    return false;
                }
                return true;
            }

            @GeneratedBy(ClosureTypeCachedState.class)
            private static final class ConvertToNativeConvertToNative0Data extends Node {

                @Child ConvertToNativeConvertToNative0Data next_;
                @Child InteropLibrary interop_;
                @Child SignatureLibrary library_;

                ConvertToNativeConvertToNative0Data(ConvertToNativeConvertToNative0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
            @GeneratedBy(ClosureTypeCachedState.class)
            private static final class ConvertFromNativeNull0Data extends Node {

                @Child ConvertFromNativeNull0Data next_;
                @Child InteropLibrary interop_;

                ConvertFromNativeNull0Data(ConvertFromNativeNull0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
            @GeneratedBy(ClosureTypeCachedState.class)
            private static final class ConvertFromNativeBind0Data extends Node {

                @Child ConvertFromNativeBind0Data next_;
                @Child InteropLibrary interop_;
                @Child SignatureLibrary library_;

                ConvertFromNativeBind0Data(ConvertFromNativeBind0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
        }
        @GeneratedBy(ClosureTypeCachedState.class)
        private static final class Uncached extends NFITypeLibrary {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof ClosureTypeCachedState) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof ClosureTypeCachedState;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public Object convertToNative(TypeCachedState arg0Value_, NFIType arg1Value, Object arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                ClosureTypeCachedState arg0Value = ((ClosureTypeCachedState) arg0Value_);
                if (((INTEROP_LIBRARY_.getUncached(arg2Value)).isExecutable(arg2Value))) {
                    return ConvertToNative.convertToNative(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg2Value)), (SIGNATURE_LIBRARY_.getUncached(arg1Value.runtimeData)));
                }
                return ConvertToNative.convertToNative(arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            @Override
            public Object convertFromNative(TypeCachedState arg0Value_, NFIType arg1Value, Object arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                ClosureTypeCachedState arg0Value = ((ClosureTypeCachedState) arg0Value_);
                if (((INTEROP_LIBRARY_.getUncached(arg2Value)).isNull(arg2Value))) {
                    return ConvertFromNative.doNull(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg2Value)));
                }
                if ((!((INTEROP_LIBRARY_.getUncached(arg2Value)).isNull(arg2Value)))) {
                    return ConvertFromNative.doBind(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg2Value)), (SIGNATURE_LIBRARY_.getUncached(arg1Value.runtimeData)));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

        }
    }
}
