// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.CallSignatureNode.CachedCallSignatureNode;
import com.oracle.truffle.nfi.CallSignatureNodeFactory.CachedCallSignatureNodeGen;
import com.oracle.truffle.nfi.NFISignature.Bind;
import com.oracle.truffle.nfi.NFISignature.CreateClosure;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import com.oracle.truffle.nfi.spi.NFIBackendSignatureLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(NFISignature.class)
@SuppressWarnings("unused")
final class NFISignatureGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<NFIBackendSignatureLibrary> N_F_I_BACKEND_SIGNATURE_LIBRARY_ = LibraryFactory.resolve(NFIBackendSignatureLibrary.class);

    static  {
        LibraryExport.register(NFISignature.class, new SignatureLibraryExports());
    }

    private NFISignatureGen() {
    }

    @GeneratedBy(NFISignature.class)
    private static final class SignatureLibraryExports extends LibraryExport<SignatureLibrary> {

        private SignatureLibraryExports() {
            super(SignatureLibrary.class, NFISignature.class, false);
        }

        @Override
        protected SignatureLibrary createUncached(Object receiver) {
            assert receiver instanceof NFISignature;
            SignatureLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected SignatureLibrary createCached(Object receiver) {
            assert receiver instanceof NFISignature;
            return new Cached(receiver);
        }

        @GeneratedBy(NFISignature.class)
        private static final class Cached extends SignatureLibrary {

            @Child private NFIBackendSignatureLibrary receiverNativeSignatureNFIBackendSignatureLibrary_;
            @CompilationFinal private volatile int state_0_;
            @CompilationFinal private volatile int exclude_;
            @Child private CreateClosureCachedData createClosure_cached_cache;
            @Child private CachedCallSignatureNode callNode__call_;

            protected Cached(Object receiver) {
                NFISignature castReceiver = ((NFISignature) receiver) ;
                this.receiverNativeSignatureNFIBackendSignatureLibrary_ = super.insert(N_F_I_BACKEND_SIGNATURE_LIBRARY_.create((castReceiver.nativeSignature)));
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof NFISignature) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof NFISignature)) {
                    return false;
                } else if (!this.receiverNativeSignatureNFIBackendSignatureLibrary_.accepts((((NFISignature) receiver).nativeSignature))) {
                    return false;
                } else {
                    return true;
                }
            }

            @Override
            public Object bind(Object arg0Value_, Object arg1Value) {
                assert arg0Value_ instanceof NFISignature : "Invalid library usage. Library does not accept given receiver.";
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                NFISignature arg0Value = ((NFISignature) arg0Value_);
                int state_0 = state_0_;
                if ((state_0 & 0b11) != 0 /* is-state_0 doSymbol(NFISignature, NFISymbol) || doOther(NFISignature, Object) */) {
                    if ((state_0 & 0b1) != 0 /* is-state_0 doSymbol(NFISignature, NFISymbol) */ && arg1Value instanceof NFISymbol) {
                        NFISymbol arg1Value_ = (NFISymbol) arg1Value;
                        return Bind.doSymbol(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0b10) != 0 /* is-state_0 doOther(NFISignature, Object) */) {
                        if (bindFallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return Bind.doOther(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return bindAndSpecialize(arg0Value, arg1Value);
            }

            private Object bindAndSpecialize(NFISignature arg0Value, Object arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = state_0_;
                try {
                    if (arg1Value instanceof NFISymbol) {
                        NFISymbol arg1Value_ = (NFISymbol) arg1Value;
                        this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doSymbol(NFISignature, NFISymbol) */;
                        lock.unlock();
                        hasLock = false;
                        return Bind.doSymbol(arg0Value, arg1Value_);
                    }
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 doOther(NFISignature, Object) */;
                    lock.unlock();
                    hasLock = false;
                    return Bind.doOther(arg0Value, arg1Value);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state_0 = state_0_;
                if ((state_0 & 0b11) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b11) & ((state_0 & 0b11) - 1)) == 0 /* is-single-state_0  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @ExplodeLoop
            @Override
            public Object createClosure(Object arg0Value_, Object arg1Value) {
                assert arg0Value_ instanceof NFISignature : "Invalid library usage. Library does not accept given receiver.";
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                NFISignature arg0Value = ((NFISignature) arg0Value_);
                int state_0 = state_0_;
                if ((state_0 & 0b1100) != 0 /* is-state_0 doCached(NFISignature, Object, NFIClosure, NFIBackendSignatureLibrary, Object) || doCreate(NFISignature, Object, NFIBackendSignatureLibrary) */) {
                    if ((state_0 & 0b100) != 0 /* is-state_0 doCached(NFISignature, Object, NFIClosure, NFIBackendSignatureLibrary, Object) */) {
                        CreateClosureCachedData s1_ = this.createClosure_cached_cache;
                        while (s1_ != null) {
                            if (!Assumption.isValidAssumption(s1_.assumption0_)) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                removeCached_(s1_);
                                return createClosureAndSpecialize(arg0Value, arg1Value);
                            }
                            assert (s1_.lib_.accepts(s1_.cachedClosure_.signature.nativeSignature));
                            if ((arg1Value == s1_.cachedClosure_.executable) && (arg0Value == s1_.cachedClosure_.signature)) {
                                return CreateClosure.doCached(arg0Value, arg1Value, s1_.cachedClosure_, s1_.lib_, s1_.cachedRet_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is-state_0 doCreate(NFISignature, Object, NFIBackendSignatureLibrary) */) {
                        {
                            NFIBackendSignatureLibrary createClosure_create_lib__ = this.receiverNativeSignatureNFIBackendSignatureLibrary_;
                            return CreateClosure.doCreate(arg0Value, arg1Value, createClosure_create_lib__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return createClosureAndSpecialize(arg0Value, arg1Value);
            }

            private Object createClosureAndSpecialize(NFISignature arg0Value, Object arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = state_0_;
                int exclude = exclude_;
                try {
                    if ((exclude) == 0 /* is-not-exclude doCached(NFISignature, Object, NFIClosure, NFIBackendSignatureLibrary, Object) */) {
                        int count1_ = 0;
                        CreateClosureCachedData s1_ = this.createClosure_cached_cache;
                        if ((state_0 & 0b100) != 0 /* is-state_0 doCached(NFISignature, Object, NFIClosure, NFIBackendSignatureLibrary, Object) */) {
                            while (s1_ != null) {
                                assert (s1_.lib_.accepts(s1_.cachedClosure_.signature.nativeSignature));
                                if ((arg1Value == s1_.cachedClosure_.executable) && (arg0Value == s1_.cachedClosure_.signature) && (s1_.assumption0_ == null || Assumption.isValidAssumption(s1_.assumption0_))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            {
                                NFIClosure cachedClosure__ = (CreateClosure.createClosure(arg1Value, arg0Value));
                                // assert (s1_.lib_.accepts(s1_.cachedClosure_.signature.nativeSignature));
                                if ((arg1Value == cachedClosure__.executable) && (arg0Value == cachedClosure__.signature)) {
                                    Assumption assumption0 = (NFILanguage.getSingleContextAssumption());
                                    if (Assumption.isValidAssumption(assumption0)) {
                                        if (count1_ < (3)) {
                                            s1_ = super.insert(new CreateClosureCachedData(createClosure_cached_cache));
                                            s1_.cachedClosure_ = cachedClosure__;
                                            s1_.lib_ = s1_.insertAccessor((N_F_I_BACKEND_SIGNATURE_LIBRARY_.create(cachedClosure__.signature.nativeSignature)));
                                            s1_.cachedRet_ = (s1_.lib_.createClosure(cachedClosure__.signature.nativeSignature, cachedClosure__));
                                            s1_.assumption0_ = assumption0;
                                            this.createClosure_cached_cache = s1_;
                                            this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 doCached(NFISignature, Object, NFIClosure, NFIBackendSignatureLibrary, Object) */;
                                        }
                                    }
                                }
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return CreateClosure.doCached(arg0Value, arg1Value, s1_.cachedClosure_, s1_.lib_, s1_.cachedRet_);
                        }
                    }
                    {
                        NFIBackendSignatureLibrary createClosure_create_lib__ = null;
                        createClosure_create_lib__ = this.receiverNativeSignatureNFIBackendSignatureLibrary_;
                        this.exclude_ = exclude = exclude | 0b1 /* add-exclude doCached(NFISignature, Object, NFIClosure, NFIBackendSignatureLibrary, Object) */;
                        this.createClosure_cached_cache = null;
                        state_0 = state_0 & 0xfffffffb /* remove-state_0 doCached(NFISignature, Object, NFIClosure, NFIBackendSignatureLibrary, Object) */;
                        this.state_0_ = state_0 = state_0 | 0b1000 /* add-state_0 doCreate(NFISignature, Object, NFIBackendSignatureLibrary) */;
                        lock.unlock();
                        hasLock = false;
                        return CreateClosure.doCreate(arg0Value, arg1Value, createClosure_create_lib__);
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            void removeCached_(Object s1_) {
                Lock lock = getLock();
                lock.lock();
                try {
                    CreateClosureCachedData prev = null;
                    CreateClosureCachedData cur = this.createClosure_cached_cache;
                    while (cur != null) {
                        if (cur == s1_) {
                            if (prev == null) {
                                this.createClosure_cached_cache = cur.next_;
                                this.adoptChildren();
                            } else {
                                prev.next_ = cur.next_;
                                prev.adoptChildren();
                            }
                            break;
                        }
                        prev = cur;
                        cur = cur.next_;
                    }
                    if (this.createClosure_cached_cache == null) {
                        this.state_0_ = this.state_0_ & 0xfffffffb /* remove-state_0 doCached(NFISignature, Object, NFIClosure, NFIBackendSignatureLibrary, Object) */;
                    }
                } finally {
                    lock.unlock();
                }
            }

            @Override
            public Object call(Object arg0Value_, Object arg1Value, Object... arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                assert arg0Value_ instanceof NFISignature : "Invalid library usage. Library does not accept given receiver.";
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                NFISignature arg0Value = ((NFISignature) arg0Value_);
                int state_0 = state_0_;
                if ((state_0 & 0b10000) != 0 /* is-state_0 call(NFISignature, Object, Object[], CachedCallSignatureNode) */) {
                    return arg0Value.call(arg1Value, arg2Value, this.callNode__call_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return callNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object callNode_AndSpecialize(NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = state_0_;
                try {
                    this.callNode__call_ = super.insert((CachedCallSignatureNodeGen.create()));
                    this.state_0_ = state_0 = state_0 | 0b10000 /* add-state_0 call(NFISignature, Object, Object[], CachedCallSignatureNode) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.call(arg1Value, arg2Value, this.callNode__call_);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            private static boolean bindFallbackGuard_(int state_0, NFISignature arg0Value, Object arg1Value) {
                if (((state_0 & 0b1)) == 0 /* is-not-state_0 doSymbol(NFISignature, NFISymbol) */ && arg1Value instanceof NFISymbol) {
                    return false;
                }
                return true;
            }

            @GeneratedBy(NFISignature.class)
            private static final class CreateClosureCachedData extends Node {

                @Child CreateClosureCachedData next_;
                @CompilationFinal NFIClosure cachedClosure_;
                @Child NFIBackendSignatureLibrary lib_;
                @CompilationFinal Object cachedRet_;
                @CompilationFinal Assumption assumption0_;

                CreateClosureCachedData(CreateClosureCachedData next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
        }
        @GeneratedBy(NFISignature.class)
        private static final class Uncached extends SignatureLibrary {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof NFISignature) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFISignature;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public Object bind(Object arg0Value_, Object arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISignature arg0Value = ((NFISignature) arg0Value_);
                if (arg1Value instanceof NFISymbol) {
                    NFISymbol arg1Value_ = (NFISymbol) arg1Value;
                    return Bind.doSymbol(arg0Value, arg1Value_);
                }
                return Bind.doOther(arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public Object createClosure(Object arg0Value_, Object arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISignature arg0Value = ((NFISignature) arg0Value_);
                return CreateClosure.doCreate(arg0Value, arg1Value, N_F_I_BACKEND_SIGNATURE_LIBRARY_.getUncached((arg0Value.nativeSignature)));
            }

            @TruffleBoundary
            @Override
            public Object call(Object arg0Value_, Object arg1Value, Object... arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISignature arg0Value = ((NFISignature) arg0Value_);
                return arg0Value.call(arg1Value, arg2Value, (CachedCallSignatureNodeGen.getUncached()));
            }

        }
    }
}
