// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.SignatureRootNode.AddArgumentNode;
import com.oracle.truffle.nfi.SignatureRootNode.ArgumentBuilderNode;
import com.oracle.truffle.nfi.SignatureRootNode.BuildSignatureNode;
import com.oracle.truffle.nfi.SignatureRootNode.GetArrayTypeNode;
import com.oracle.truffle.nfi.SignatureRootNode.GetEnvTypeNode;
import com.oracle.truffle.nfi.SignatureRootNode.GetSignatureTypeNode;
import com.oracle.truffle.nfi.SignatureRootNode.GetSimpleTypeNode;
import com.oracle.truffle.nfi.SignatureRootNode.GetTypeNode;
import com.oracle.truffle.nfi.SignatureRootNode.MakeVarargs;
import com.oracle.truffle.nfi.SignatureRootNode.SetRetTypeNode;
import com.oracle.truffle.nfi.spi.NFIBackendLibrary;
import com.oracle.truffle.nfi.spi.NFIBackendSignatureBuilderLibrary;
import com.oracle.truffle.nfi.spi.types.NativeSimpleType;
import com.oracle.truffle.nfi.util.ProfiledArrayBuilder.ArrayBuilderFactory;
import java.util.concurrent.locks.Lock;

@GeneratedBy(SignatureRootNode.class)
@SuppressWarnings("unused")
final class SignatureRootNodeFactory {

    private static final LibraryFactory<NFIBackendLibrary> N_F_I_BACKEND_LIBRARY_ = LibraryFactory.resolve(NFIBackendLibrary.class);
    private static final LibraryFactory<NFIBackendSignatureBuilderLibrary> N_F_I_BACKEND_SIGNATURE_BUILDER_LIBRARY_ = LibraryFactory.resolve(NFIBackendSignatureBuilderLibrary.class);

    @GeneratedBy(BuildSignatureNode.class)
    static final class BuildSignatureNodeGen extends BuildSignatureNode {

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private volatile int exclude_;
        @Child private Build0Data build0_cache;
        @Child private NFIBackendSignatureBuilderLibrary build1_sigBuilderLibrary_;
        @CompilationFinal private ArrayBuilderFactory build1_factory_;

        private BuildSignatureNodeGen(ArgumentBuilderNode[] argBuilders) {
            super(argBuilders);
        }

        @ExplodeLoop
        @Override
        Object execute(API arg0Value) {
            int state_0 = state_0_;
            if (state_0 != 0 /* is-state_0 doBuild(API, NFIBackendLibrary, NFIBackendSignatureBuilderLibrary, ArrayBuilderFactory) || doBuild(API, NFIBackendLibrary, NFIBackendSignatureBuilderLibrary, ArrayBuilderFactory) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 doBuild(API, NFIBackendLibrary, NFIBackendSignatureBuilderLibrary, ArrayBuilderFactory) */) {
                    Build0Data s1_ = this.build0_cache;
                    while (s1_ != null) {
                        if ((s1_.backendLibrary_.accepts(arg0Value.backend))) {
                            return doBuild(arg0Value, s1_.backendLibrary_, s1_.sigBuilderLibrary_, s1_.factory_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 doBuild(API, NFIBackendLibrary, NFIBackendSignatureBuilderLibrary, ArrayBuilderFactory) */) {
                    return this.build1Boundary(state_0, arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object build1Boundary(int state_0, API arg0Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    NFIBackendLibrary build1_backendLibrary__ = (N_F_I_BACKEND_LIBRARY_.getUncached(arg0Value.backend));
                    return doBuild(arg0Value, build1_backendLibrary__, this.build1_sigBuilderLibrary_, this.build1_factory_);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private Object executeAndSpecialize(API arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = state_0_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-exclude doBuild(API, NFIBackendLibrary, NFIBackendSignatureBuilderLibrary, ArrayBuilderFactory) */) {
                    int count1_ = 0;
                    Build0Data s1_ = this.build0_cache;
                    if ((state_0 & 0b1) != 0 /* is-state_0 doBuild(API, NFIBackendLibrary, NFIBackendSignatureBuilderLibrary, ArrayBuilderFactory) */) {
                        while (s1_ != null) {
                            if ((s1_.backendLibrary_.accepts(arg0Value.backend))) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        // assert (s1_.backendLibrary_.accepts(arg0Value.backend));
                        if (count1_ < (3)) {
                            s1_ = super.insert(new Build0Data(build0_cache));
                            s1_.backendLibrary_ = s1_.insertAccessor((N_F_I_BACKEND_LIBRARY_.create(arg0Value.backend)));
                            s1_.sigBuilderLibrary_ = s1_.insertAccessor((N_F_I_BACKEND_SIGNATURE_BUILDER_LIBRARY_.createDispatched(1)));
                            s1_.factory_ = (ArrayBuilderFactory.create());
                            this.build0_cache = s1_;
                            this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doBuild(API, NFIBackendLibrary, NFIBackendSignatureBuilderLibrary, ArrayBuilderFactory) */;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return doBuild(arg0Value, s1_.backendLibrary_, s1_.sigBuilderLibrary_, s1_.factory_);
                    }
                }
                {
                    NFIBackendLibrary build1_backendLibrary__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            build1_backendLibrary__ = (N_F_I_BACKEND_LIBRARY_.getUncached(arg0Value.backend));
                            this.build1_sigBuilderLibrary_ = super.insert((N_F_I_BACKEND_SIGNATURE_BUILDER_LIBRARY_.createDispatched(1)));
                            this.build1_factory_ = (ArrayBuilderFactory.create());
                            this.exclude_ = exclude = exclude | 0b1 /* add-exclude doBuild(API, NFIBackendLibrary, NFIBackendSignatureBuilderLibrary, ArrayBuilderFactory) */;
                            this.build0_cache = null;
                            state_0 = state_0 & 0xfffffffe /* remove-state_0 doBuild(API, NFIBackendLibrary, NFIBackendSignatureBuilderLibrary, ArrayBuilderFactory) */;
                            this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 doBuild(API, NFIBackendLibrary, NFIBackendSignatureBuilderLibrary, ArrayBuilderFactory) */;
                            lock.unlock();
                            hasLock = false;
                            return doBuild(arg0Value, build1_backendLibrary__, this.build1_sigBuilderLibrary_, this.build1_factory_);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    Build0Data s1_ = this.build0_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static BuildSignatureNode create(ArgumentBuilderNode[] argBuilders) {
            return new BuildSignatureNodeGen(argBuilders);
        }

        @GeneratedBy(BuildSignatureNode.class)
        private static final class Build0Data extends Node {

            @Child Build0Data next_;
            @Child NFIBackendLibrary backendLibrary_;
            @Child NFIBackendSignatureBuilderLibrary sigBuilderLibrary_;
            @CompilationFinal ArrayBuilderFactory factory_;

            Build0Data(Build0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
    }
    @GeneratedBy(SetRetTypeNode.class)
    static final class SetRetTypeNodeGen extends SetRetTypeNode {

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private volatile int exclude_;
        @Child private NFIBackendSignatureBuilderLibrary setRetType0_sigBuilderLib_;

        private SetRetTypeNodeGen(GetTypeNode retType) {
            super(retType);
        }

        @Override
        void execute(API arg0Value, Object arg1Value) {
            int state_0 = state_0_;
            if (state_0 != 0 /* is-state_0 setRetType(API, Object, NFIBackendSignatureBuilderLibrary) || setRetType(API, Object, NFIBackendSignatureBuilderLibrary) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 setRetType(API, Object, NFIBackendSignatureBuilderLibrary) */) {
                    if ((this.setRetType0_sigBuilderLib_.accepts(arg1Value))) {
                        setRetType(arg0Value, arg1Value, this.setRetType0_sigBuilderLib_);
                        return;
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 setRetType(API, Object, NFIBackendSignatureBuilderLibrary) */) {
                    this.setRetType1Boundary(state_0, arg0Value, arg1Value);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value);
            return;
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void setRetType1Boundary(int state_0, API arg0Value, Object arg1Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    NFIBackendSignatureBuilderLibrary setRetType1_sigBuilderLib__ = (N_F_I_BACKEND_SIGNATURE_BUILDER_LIBRARY_.getUncached(arg1Value));
                    setRetType(arg0Value, arg1Value, setRetType1_sigBuilderLib__);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private void executeAndSpecialize(API arg0Value, Object arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = state_0_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-exclude setRetType(API, Object, NFIBackendSignatureBuilderLibrary) */) {
                    boolean SetRetType0_duplicateFound_ = false;
                    if ((state_0 & 0b1) != 0 /* is-state_0 setRetType(API, Object, NFIBackendSignatureBuilderLibrary) */) {
                        if ((this.setRetType0_sigBuilderLib_.accepts(arg1Value))) {
                            SetRetType0_duplicateFound_ = true;
                        }
                    }
                    if (!SetRetType0_duplicateFound_) {
                        // assert (this.setRetType0_sigBuilderLib_.accepts(arg1Value));
                        if (((state_0 & 0b1)) == 0 /* is-not-state_0 setRetType(API, Object, NFIBackendSignatureBuilderLibrary) */) {
                            this.setRetType0_sigBuilderLib_ = super.insert((N_F_I_BACKEND_SIGNATURE_BUILDER_LIBRARY_.create(arg1Value)));
                            this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 setRetType(API, Object, NFIBackendSignatureBuilderLibrary) */;
                            SetRetType0_duplicateFound_ = true;
                        }
                    }
                    if (SetRetType0_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        setRetType(arg0Value, arg1Value, this.setRetType0_sigBuilderLib_);
                        return;
                    }
                }
                {
                    NFIBackendSignatureBuilderLibrary setRetType1_sigBuilderLib__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            setRetType1_sigBuilderLib__ = (N_F_I_BACKEND_SIGNATURE_BUILDER_LIBRARY_.getUncached(arg1Value));
                            this.exclude_ = exclude = exclude | 0b1 /* add-exclude setRetType(API, Object, NFIBackendSignatureBuilderLibrary) */;
                            state_0 = state_0 & 0xfffffffe /* remove-state_0 setRetType(API, Object, NFIBackendSignatureBuilderLibrary) */;
                            this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 setRetType(API, Object, NFIBackendSignatureBuilderLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            setRetType(arg0Value, arg1Value, setRetType1_sigBuilderLib__);
                            return;
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static SetRetTypeNode create(GetTypeNode retType) {
            return new SetRetTypeNodeGen(retType);
        }

    }
    @GeneratedBy(AddArgumentNode.class)
    static final class AddArgumentNodeGen extends AddArgumentNode {

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private volatile int exclude_;
        @Child private NFIBackendSignatureBuilderLibrary addArgument0_sigBuilderLib_;

        private AddArgumentNodeGen(GetTypeNode argType) {
            super(argType);
        }

        @Override
        void execute(API arg0Value, Object arg1Value) {
            int state_0 = state_0_;
            if (state_0 != 0 /* is-state_0 addArgument(API, Object, NFIBackendSignatureBuilderLibrary) || addArgument(API, Object, NFIBackendSignatureBuilderLibrary) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 addArgument(API, Object, NFIBackendSignatureBuilderLibrary) */) {
                    if ((this.addArgument0_sigBuilderLib_.accepts(arg1Value))) {
                        addArgument(arg0Value, arg1Value, this.addArgument0_sigBuilderLib_);
                        return;
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 addArgument(API, Object, NFIBackendSignatureBuilderLibrary) */) {
                    this.addArgument1Boundary(state_0, arg0Value, arg1Value);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value);
            return;
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void addArgument1Boundary(int state_0, API arg0Value, Object arg1Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    NFIBackendSignatureBuilderLibrary addArgument1_sigBuilderLib__ = (N_F_I_BACKEND_SIGNATURE_BUILDER_LIBRARY_.getUncached(arg1Value));
                    addArgument(arg0Value, arg1Value, addArgument1_sigBuilderLib__);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private void executeAndSpecialize(API arg0Value, Object arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = state_0_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-exclude addArgument(API, Object, NFIBackendSignatureBuilderLibrary) */) {
                    boolean AddArgument0_duplicateFound_ = false;
                    if ((state_0 & 0b1) != 0 /* is-state_0 addArgument(API, Object, NFIBackendSignatureBuilderLibrary) */) {
                        if ((this.addArgument0_sigBuilderLib_.accepts(arg1Value))) {
                            AddArgument0_duplicateFound_ = true;
                        }
                    }
                    if (!AddArgument0_duplicateFound_) {
                        // assert (this.addArgument0_sigBuilderLib_.accepts(arg1Value));
                        if (((state_0 & 0b1)) == 0 /* is-not-state_0 addArgument(API, Object, NFIBackendSignatureBuilderLibrary) */) {
                            this.addArgument0_sigBuilderLib_ = super.insert((N_F_I_BACKEND_SIGNATURE_BUILDER_LIBRARY_.create(arg1Value)));
                            this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 addArgument(API, Object, NFIBackendSignatureBuilderLibrary) */;
                            AddArgument0_duplicateFound_ = true;
                        }
                    }
                    if (AddArgument0_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        addArgument(arg0Value, arg1Value, this.addArgument0_sigBuilderLib_);
                        return;
                    }
                }
                {
                    NFIBackendSignatureBuilderLibrary addArgument1_sigBuilderLib__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            addArgument1_sigBuilderLib__ = (N_F_I_BACKEND_SIGNATURE_BUILDER_LIBRARY_.getUncached(arg1Value));
                            this.exclude_ = exclude = exclude | 0b1 /* add-exclude addArgument(API, Object, NFIBackendSignatureBuilderLibrary) */;
                            state_0 = state_0 & 0xfffffffe /* remove-state_0 addArgument(API, Object, NFIBackendSignatureBuilderLibrary) */;
                            this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 addArgument(API, Object, NFIBackendSignatureBuilderLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            addArgument(arg0Value, arg1Value, addArgument1_sigBuilderLib__);
                            return;
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static AddArgumentNode create(GetTypeNode argType) {
            return new AddArgumentNodeGen(argType);
        }

    }
    @GeneratedBy(MakeVarargs.class)
    static final class MakeVarargsNodeGen extends MakeVarargs {

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private volatile int exclude_;
        @Child private NFIBackendSignatureBuilderLibrary makeVarargs0_sigBuilderLib_;

        private MakeVarargsNodeGen() {
        }

        @Override
        void execute(API arg0Value, Object arg1Value) {
            int state_0 = state_0_;
            if (state_0 != 0 /* is-state_0 makeVarargs(API, Object, NFIBackendSignatureBuilderLibrary) || makeVarargs(API, Object, NFIBackendSignatureBuilderLibrary) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 makeVarargs(API, Object, NFIBackendSignatureBuilderLibrary) */) {
                    if ((this.makeVarargs0_sigBuilderLib_.accepts(arg1Value))) {
                        makeVarargs(arg0Value, arg1Value, this.makeVarargs0_sigBuilderLib_);
                        return;
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 makeVarargs(API, Object, NFIBackendSignatureBuilderLibrary) */) {
                    this.makeVarargs1Boundary(state_0, arg0Value, arg1Value);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value);
            return;
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private void makeVarargs1Boundary(int state_0, API arg0Value, Object arg1Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    NFIBackendSignatureBuilderLibrary makeVarargs1_sigBuilderLib__ = (N_F_I_BACKEND_SIGNATURE_BUILDER_LIBRARY_.getUncached(arg1Value));
                    makeVarargs(arg0Value, arg1Value, makeVarargs1_sigBuilderLib__);
                    return;
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private void executeAndSpecialize(API arg0Value, Object arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = state_0_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-exclude makeVarargs(API, Object, NFIBackendSignatureBuilderLibrary) */) {
                    boolean MakeVarargs0_duplicateFound_ = false;
                    if ((state_0 & 0b1) != 0 /* is-state_0 makeVarargs(API, Object, NFIBackendSignatureBuilderLibrary) */) {
                        if ((this.makeVarargs0_sigBuilderLib_.accepts(arg1Value))) {
                            MakeVarargs0_duplicateFound_ = true;
                        }
                    }
                    if (!MakeVarargs0_duplicateFound_) {
                        // assert (this.makeVarargs0_sigBuilderLib_.accepts(arg1Value));
                        if (((state_0 & 0b1)) == 0 /* is-not-state_0 makeVarargs(API, Object, NFIBackendSignatureBuilderLibrary) */) {
                            this.makeVarargs0_sigBuilderLib_ = super.insert((N_F_I_BACKEND_SIGNATURE_BUILDER_LIBRARY_.create(arg1Value)));
                            this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 makeVarargs(API, Object, NFIBackendSignatureBuilderLibrary) */;
                            MakeVarargs0_duplicateFound_ = true;
                        }
                    }
                    if (MakeVarargs0_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        makeVarargs(arg0Value, arg1Value, this.makeVarargs0_sigBuilderLib_);
                        return;
                    }
                }
                {
                    NFIBackendSignatureBuilderLibrary makeVarargs1_sigBuilderLib__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            makeVarargs1_sigBuilderLib__ = (N_F_I_BACKEND_SIGNATURE_BUILDER_LIBRARY_.getUncached(arg1Value));
                            this.exclude_ = exclude = exclude | 0b1 /* add-exclude makeVarargs(API, Object, NFIBackendSignatureBuilderLibrary) */;
                            state_0 = state_0 & 0xfffffffe /* remove-state_0 makeVarargs(API, Object, NFIBackendSignatureBuilderLibrary) */;
                            this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 makeVarargs(API, Object, NFIBackendSignatureBuilderLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            makeVarargs(arg0Value, arg1Value, makeVarargs1_sigBuilderLib__);
                            return;
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static MakeVarargs create() {
            return new MakeVarargsNodeGen();
        }

    }
    @GeneratedBy(GetSimpleTypeNode.class)
    static final class GetSimpleTypeNodeGen extends GetSimpleTypeNode {

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private volatile int exclude_;
        @Child private NFIBackendLibrary getType0_backendLibrary_;

        private GetSimpleTypeNodeGen(NativeSimpleType type) {
            super(type);
        }

        @Override
        Object execute(API arg0Value) {
            int state_0 = state_0_;
            if (state_0 != 0 /* is-state_0 getType(API, NFIBackendLibrary) || getType(API, NFIBackendLibrary) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 getType(API, NFIBackendLibrary) */) {
                    if ((this.getType0_backendLibrary_.accepts(arg0Value.backend))) {
                        return getType(arg0Value, this.getType0_backendLibrary_);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 getType(API, NFIBackendLibrary) */) {
                    return this.getType1Boundary(state_0, arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object getType1Boundary(int state_0, API arg0Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    NFIBackendLibrary getType1_backendLibrary__ = (N_F_I_BACKEND_LIBRARY_.getUncached(arg0Value.backend));
                    return getType(arg0Value, getType1_backendLibrary__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private Object executeAndSpecialize(API arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = state_0_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-exclude getType(API, NFIBackendLibrary) */) {
                    boolean GetType0_duplicateFound_ = false;
                    if ((state_0 & 0b1) != 0 /* is-state_0 getType(API, NFIBackendLibrary) */) {
                        if ((this.getType0_backendLibrary_.accepts(arg0Value.backend))) {
                            GetType0_duplicateFound_ = true;
                        }
                    }
                    if (!GetType0_duplicateFound_) {
                        // assert (this.getType0_backendLibrary_.accepts(arg0Value.backend));
                        if (((state_0 & 0b1)) == 0 /* is-not-state_0 getType(API, NFIBackendLibrary) */) {
                            this.getType0_backendLibrary_ = super.insert((N_F_I_BACKEND_LIBRARY_.create(arg0Value.backend)));
                            this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 getType(API, NFIBackendLibrary) */;
                            GetType0_duplicateFound_ = true;
                        }
                    }
                    if (GetType0_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        return getType(arg0Value, this.getType0_backendLibrary_);
                    }
                }
                {
                    NFIBackendLibrary getType1_backendLibrary__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            getType1_backendLibrary__ = (N_F_I_BACKEND_LIBRARY_.getUncached(arg0Value.backend));
                            this.exclude_ = exclude = exclude | 0b1 /* add-exclude getType(API, NFIBackendLibrary) */;
                            state_0 = state_0 & 0xfffffffe /* remove-state_0 getType(API, NFIBackendLibrary) */;
                            this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 getType(API, NFIBackendLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            return getType(arg0Value, getType1_backendLibrary__);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static GetSimpleTypeNode create(NativeSimpleType type) {
            return new GetSimpleTypeNodeGen(type);
        }

    }
    @GeneratedBy(GetArrayTypeNode.class)
    static final class GetArrayTypeNodeGen extends GetArrayTypeNode {

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private volatile int exclude_;
        @Child private NFIBackendLibrary getType0_backendLibrary_;

        private GetArrayTypeNodeGen(NativeSimpleType type) {
            super(type);
        }

        @Override
        Object execute(API arg0Value) {
            int state_0 = state_0_;
            if (state_0 != 0 /* is-state_0 getType(API, NFIBackendLibrary) || getType(API, NFIBackendLibrary) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 getType(API, NFIBackendLibrary) */) {
                    if ((this.getType0_backendLibrary_.accepts(arg0Value.backend))) {
                        return getType(arg0Value, this.getType0_backendLibrary_);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 getType(API, NFIBackendLibrary) */) {
                    return this.getType1Boundary(state_0, arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object getType1Boundary(int state_0, API arg0Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    NFIBackendLibrary getType1_backendLibrary__ = (N_F_I_BACKEND_LIBRARY_.getUncached(arg0Value.backend));
                    return getType(arg0Value, getType1_backendLibrary__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private Object executeAndSpecialize(API arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = state_0_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-exclude getType(API, NFIBackendLibrary) */) {
                    boolean GetType0_duplicateFound_ = false;
                    if ((state_0 & 0b1) != 0 /* is-state_0 getType(API, NFIBackendLibrary) */) {
                        if ((this.getType0_backendLibrary_.accepts(arg0Value.backend))) {
                            GetType0_duplicateFound_ = true;
                        }
                    }
                    if (!GetType0_duplicateFound_) {
                        // assert (this.getType0_backendLibrary_.accepts(arg0Value.backend));
                        if (((state_0 & 0b1)) == 0 /* is-not-state_0 getType(API, NFIBackendLibrary) */) {
                            this.getType0_backendLibrary_ = super.insert((N_F_I_BACKEND_LIBRARY_.create(arg0Value.backend)));
                            this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 getType(API, NFIBackendLibrary) */;
                            GetType0_duplicateFound_ = true;
                        }
                    }
                    if (GetType0_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        return getType(arg0Value, this.getType0_backendLibrary_);
                    }
                }
                {
                    NFIBackendLibrary getType1_backendLibrary__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            getType1_backendLibrary__ = (N_F_I_BACKEND_LIBRARY_.getUncached(arg0Value.backend));
                            this.exclude_ = exclude = exclude | 0b1 /* add-exclude getType(API, NFIBackendLibrary) */;
                            state_0 = state_0 & 0xfffffffe /* remove-state_0 getType(API, NFIBackendLibrary) */;
                            this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 getType(API, NFIBackendLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            return getType(arg0Value, getType1_backendLibrary__);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static GetArrayTypeNode create(NativeSimpleType type) {
            return new GetArrayTypeNodeGen(type);
        }

    }
    @GeneratedBy(GetEnvTypeNode.class)
    static final class GetEnvTypeNodeGen extends GetEnvTypeNode {

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private volatile int exclude_;
        @Child private NFIBackendLibrary getType0_backend_;

        private GetEnvTypeNodeGen() {
        }

        @Override
        Object execute(API arg0Value) {
            int state_0 = state_0_;
            if (state_0 != 0 /* is-state_0 getType(API, NFIBackendLibrary) || getType(API, NFIBackendLibrary) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 getType(API, NFIBackendLibrary) */) {
                    if ((this.getType0_backend_.accepts(arg0Value.backend))) {
                        return getType(arg0Value, this.getType0_backend_);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 getType(API, NFIBackendLibrary) */) {
                    return this.getType1Boundary(state_0, arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object getType1Boundary(int state_0, API arg0Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    NFIBackendLibrary getType1_backend__ = (N_F_I_BACKEND_LIBRARY_.getUncached(arg0Value.backend));
                    return getType(arg0Value, getType1_backend__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private Object executeAndSpecialize(API arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = state_0_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-exclude getType(API, NFIBackendLibrary) */) {
                    boolean GetType0_duplicateFound_ = false;
                    if ((state_0 & 0b1) != 0 /* is-state_0 getType(API, NFIBackendLibrary) */) {
                        if ((this.getType0_backend_.accepts(arg0Value.backend))) {
                            GetType0_duplicateFound_ = true;
                        }
                    }
                    if (!GetType0_duplicateFound_) {
                        // assert (this.getType0_backend_.accepts(arg0Value.backend));
                        if (((state_0 & 0b1)) == 0 /* is-not-state_0 getType(API, NFIBackendLibrary) */) {
                            this.getType0_backend_ = super.insert((N_F_I_BACKEND_LIBRARY_.create(arg0Value.backend)));
                            this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 getType(API, NFIBackendLibrary) */;
                            GetType0_duplicateFound_ = true;
                        }
                    }
                    if (GetType0_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        return getType(arg0Value, this.getType0_backend_);
                    }
                }
                {
                    NFIBackendLibrary getType1_backend__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            getType1_backend__ = (N_F_I_BACKEND_LIBRARY_.getUncached(arg0Value.backend));
                            this.exclude_ = exclude = exclude | 0b1 /* add-exclude getType(API, NFIBackendLibrary) */;
                            state_0 = state_0 & 0xfffffffe /* remove-state_0 getType(API, NFIBackendLibrary) */;
                            this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 getType(API, NFIBackendLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            return getType(arg0Value, getType1_backend__);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static GetEnvTypeNode create() {
            return new GetEnvTypeNodeGen();
        }

    }
    @GeneratedBy(GetSignatureTypeNode.class)
    static final class GetSignatureTypeNodeGen extends GetSignatureTypeNode {

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private volatile int exclude_;
        @Child private NFIBackendLibrary getType0_backend_;

        private GetSignatureTypeNodeGen(BuildSignatureNode buildSignature) {
            super(buildSignature);
        }

        @Override
        Object execute(API arg0Value) {
            int state_0 = state_0_;
            if (state_0 != 0 /* is-state_0 getType(API, NFIBackendLibrary) || getType(API, NFIBackendLibrary) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 getType(API, NFIBackendLibrary) */) {
                    if ((this.getType0_backend_.accepts(arg0Value.backend))) {
                        return getType(arg0Value, this.getType0_backend_);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 getType(API, NFIBackendLibrary) */) {
                    return this.getType1Boundary(state_0, arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object getType1Boundary(int state_0, API arg0Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    NFIBackendLibrary getType1_backend__ = (N_F_I_BACKEND_LIBRARY_.getUncached(arg0Value.backend));
                    return getType(arg0Value, getType1_backend__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private Object executeAndSpecialize(API arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = state_0_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-exclude getType(API, NFIBackendLibrary) */) {
                    boolean GetType0_duplicateFound_ = false;
                    if ((state_0 & 0b1) != 0 /* is-state_0 getType(API, NFIBackendLibrary) */) {
                        if ((this.getType0_backend_.accepts(arg0Value.backend))) {
                            GetType0_duplicateFound_ = true;
                        }
                    }
                    if (!GetType0_duplicateFound_) {
                        // assert (this.getType0_backend_.accepts(arg0Value.backend));
                        if (((state_0 & 0b1)) == 0 /* is-not-state_0 getType(API, NFIBackendLibrary) */) {
                            this.getType0_backend_ = super.insert((N_F_I_BACKEND_LIBRARY_.create(arg0Value.backend)));
                            this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 getType(API, NFIBackendLibrary) */;
                            GetType0_duplicateFound_ = true;
                        }
                    }
                    if (GetType0_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        return getType(arg0Value, this.getType0_backend_);
                    }
                }
                {
                    NFIBackendLibrary getType1_backend__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            getType1_backend__ = (N_F_I_BACKEND_LIBRARY_.getUncached(arg0Value.backend));
                            this.exclude_ = exclude = exclude | 0b1 /* add-exclude getType(API, NFIBackendLibrary) */;
                            state_0 = state_0 & 0xfffffffe /* remove-state_0 getType(API, NFIBackendLibrary) */;
                            this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 getType(API, NFIBackendLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            return getType(arg0Value, getType1_backend__);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static GetSignatureTypeNode create(BuildSignatureNode buildSignature) {
            return new GetSignatureTypeNodeGen(buildSignature);
        }

    }
}
