// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.TruffleLanguage.LanguageReference;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.impl.LibFFIType.ArrayType;
import com.oracle.truffle.nfi.impl.LibFFIType.CachedTypeInfo;
import com.oracle.truffle.nfi.impl.LibFFIType.ArrayType.SerializeHelperNode;
import com.oracle.truffle.nfi.impl.LibFFITypeFactory.ArrayTypeFactory.SerializeHelperNodeGen;
import com.oracle.truffle.nfi.spi.types.NativeSimpleType;
import java.util.concurrent.locks.Lock;

@GeneratedBy(ArrayType.class)
final class ArrayTypeGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(ArrayType.class, new NativeArgumentLibraryExports());
    }

    private ArrayTypeGen() {
    }

    @GeneratedBy(ArrayType.class)
    private static final class NativeArgumentLibraryExports extends LibraryExport<NativeArgumentLibrary> {

        private NativeArgumentLibraryExports() {
            super(NativeArgumentLibrary.class, ArrayType.class, false);
        }

        @Override
        protected NativeArgumentLibrary createUncached(Object receiver) {
            assert receiver instanceof ArrayType;
            NativeArgumentLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected NativeArgumentLibrary createCached(Object receiver) {
            assert receiver instanceof ArrayType;
            return new Cached(receiver);
        }

        @GeneratedBy(ArrayType.class)
        private static final class Cached extends NativeArgumentLibrary {

            @CompilationFinal private volatile int state_0_;
            @CompilationFinal private LanguageReference<NFILanguageImpl> nFILanguageImplReference_;
            @CompilationFinal private NativeSimpleType acceptsNode__cachedType_;
            @Child private SerializeHelperNode serializeNode__serializeHelper_;

            protected Cached(Object receiver) {
                ArrayType castReceiver = ((ArrayType) receiver) ;
                this.acceptsNode__cachedType_ = (castReceiver.elementType);
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof ArrayType) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof ArrayType && accepts_(receiver);
            }

            private boolean accepts_(Object arg0Value_) {
                ArrayType arg0Value = ((ArrayType) arg0Value_);
                return arg0Value.accepts(this.acceptsNode__cachedType_);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public void serialize(CachedTypeInfo arg0Value_, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                ArrayType arg0Value = ((ArrayType) arg0Value_);
                int state_0 = state_0_;
                if ((state_0 & 0b1) != 0 /* is-state_0 serialize(ArrayType, NativeArgumentBuffer, Object, SerializeHelperNode) */) {
                    arg0Value.serialize(arg1Value, arg2Value, this.serializeNode__serializeHelper_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                serializeNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void serializeNode_AndSpecialize(ArrayType arg0Value, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = state_0_;
                try {
                    this.serializeNode__serializeHelper_ = super.insert((SerializeHelperNodeGen.create()));
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 serialize(ArrayType, NativeArgumentBuffer, Object, SerializeHelperNode) */;
                    lock.unlock();
                    hasLock = false;
                    arg0Value.serialize(arg1Value, arg2Value, this.serializeNode__serializeHelper_);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object deserialize(CachedTypeInfo arg0Value_, NativeArgumentBuffer arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                ArrayType arg0Value = ((ArrayType) arg0Value_);
                int state_0 = state_0_;
                if ((state_0 & 0b10) != 0 /* is-state_0 deserializeRet(ArrayType, NativeArgumentBuffer, NFILanguageImpl) */) {
                    {
                        LanguageReference<NFILanguageImpl> nFILanguageImplReference__ = this.nFILanguageImplReference_;
                        NFILanguageImpl deserializeRetNode__language__ = nFILanguageImplReference__.get();
                        return arg0Value.deserializeRet(arg1Value, deserializeRetNode__language__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return deserializeRetNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object deserializeRetNode_AndSpecialize(ArrayType arg0Value, NativeArgumentBuffer arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = state_0_;
                try {
                    {
                        NFILanguageImpl deserializeRetNode__language__ = null;
                        LanguageReference<NFILanguageImpl> nFILanguageImplReference__1 = this.nFILanguageImplReference_;
                        if (nFILanguageImplReference__1 == null) {
                            this.nFILanguageImplReference_ = nFILanguageImplReference__1 = super.lookupLanguageReference(NFILanguageImpl.class);
                        }
                        deserializeRetNode__language__ = nFILanguageImplReference__1.get();
                        this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 deserializeRet(ArrayType, NativeArgumentBuffer, NFILanguageImpl) */;
                        lock.unlock();
                        hasLock = false;
                        return arg0Value.deserializeRet(arg1Value, deserializeRetNode__language__);
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

        }
        @GeneratedBy(ArrayType.class)
        private static final class Uncached extends NativeArgumentLibrary {

            private final LanguageReference<NFILanguageImpl> nFILanguageImplReference_ = lookupLanguageReference(NFILanguageImpl.class);

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof ArrayType) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof ArrayType && accepts_(receiver);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public void serialize(CachedTypeInfo arg0Value_, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                ArrayType arg0Value = ((ArrayType) arg0Value_);
                arg0Value.serialize(arg1Value, arg2Value, (SerializeHelperNodeGen.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public Object deserialize(CachedTypeInfo arg0Value_, NativeArgumentBuffer arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                ArrayType arg0Value = ((ArrayType) arg0Value_);
                return arg0Value.deserializeRet(arg1Value, this.nFILanguageImplReference_.get());
            }

            @TruffleBoundary
            private static boolean accepts_(Object arg0Value_) {
                ArrayType arg0Value = ((ArrayType) arg0Value_);
                return arg0Value.accepts((arg0Value.elementType));
            }

        }
    }
}
