// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.TruffleLanguage.ContextReference;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.spi.NFIBackendLibrary;
import com.oracle.truffle.nfi.spi.types.NativeSimpleType;
import com.oracle.truffle.nfi.util.ProfiledArrayBuilder.ArrayBuilderFactory;
import java.util.concurrent.locks.Lock;

@GeneratedBy(NFIBackendImpl.class)
final class NFIBackendImplGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(NFIBackendImpl.class, new NFIBackendLibraryExports());
    }

    private NFIBackendImplGen() {
    }

    @GeneratedBy(NFIBackendImpl.class)
    private static final class NFIBackendLibraryExports extends LibraryExport<NFIBackendLibrary> {

        private NFIBackendLibraryExports() {
            super(NFIBackendLibrary.class, NFIBackendImpl.class, false);
        }

        @Override
        protected NFIBackendLibrary createUncached(Object receiver) {
            assert receiver instanceof NFIBackendImpl;
            NFIBackendLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected NFIBackendLibrary createCached(Object receiver) {
            assert receiver instanceof NFIBackendImpl;
            return new Cached();
        }

        @GeneratedBy(NFIBackendImpl.class)
        private static final class Cached extends NFIBackendLibrary {

            @CompilationFinal private volatile int state_0_;
            @CompilationFinal private ContextReference<NFIContext> nFILanguageImplContextReference_;
            @CompilationFinal private ArrayBuilderFactory createSignatureBuilderNode__builderFactory_;

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof NFIBackendImpl) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFIBackendImpl;
            }

            @Override
            public Object getSimpleType(Object arg0Value_, NativeSimpleType arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                NFIBackendImpl arg0Value = ((NFIBackendImpl) arg0Value_);
                int state_0 = state_0_;
                if ((state_0 & 0b1) != 0 /* is-state_0 getSimpleType(NFIBackendImpl, NativeSimpleType, NFIContext) */) {
                    {
                        ContextReference<NFIContext> nFILanguageImplContextReference__ = this.nFILanguageImplContextReference_;
                        NFIContext getSimpleTypeNode__ctx__ = nFILanguageImplContextReference__.get();
                        return arg0Value.getSimpleType(arg1Value, getSimpleTypeNode__ctx__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getSimpleTypeNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object getSimpleTypeNode_AndSpecialize(NFIBackendImpl arg0Value, NativeSimpleType arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = state_0_;
                try {
                    {
                        NFIContext getSimpleTypeNode__ctx__ = null;
                        ContextReference<NFIContext> nFILanguageImplContextReference__1 = this.nFILanguageImplContextReference_;
                        if (nFILanguageImplContextReference__1 == null) {
                            this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__1 = super.lookupContextReference(NFILanguageImpl.class);
                        }
                        getSimpleTypeNode__ctx__ = nFILanguageImplContextReference__1.get();
                        this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 getSimpleType(NFIBackendImpl, NativeSimpleType, NFIContext) */;
                        lock.unlock();
                        hasLock = false;
                        return arg0Value.getSimpleType(arg1Value, getSimpleTypeNode__ctx__);
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state_0 = state_0_;
                if ((state_0 & 0b1) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

            @Override
            public Object getArrayType(Object arg0Value_, NativeSimpleType arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                NFIBackendImpl arg0Value = ((NFIBackendImpl) arg0Value_);
                int state_0 = state_0_;
                if ((state_0 & 0b10) != 0 /* is-state_0 getArrayType(NFIBackendImpl, NativeSimpleType, NFIContext) */) {
                    {
                        ContextReference<NFIContext> nFILanguageImplContextReference__ = this.nFILanguageImplContextReference_;
                        NFIContext getArrayTypeNode__ctx__ = nFILanguageImplContextReference__.get();
                        return arg0Value.getArrayType(arg1Value, getArrayTypeNode__ctx__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getArrayTypeNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object getArrayTypeNode_AndSpecialize(NFIBackendImpl arg0Value, NativeSimpleType arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = state_0_;
                try {
                    {
                        NFIContext getArrayTypeNode__ctx__ = null;
                        ContextReference<NFIContext> nFILanguageImplContextReference__1 = this.nFILanguageImplContextReference_;
                        if (nFILanguageImplContextReference__1 == null) {
                            this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__1 = super.lookupContextReference(NFILanguageImpl.class);
                        }
                        getArrayTypeNode__ctx__ = nFILanguageImplContextReference__1.get();
                        this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 getArrayType(NFIBackendImpl, NativeSimpleType, NFIContext) */;
                        lock.unlock();
                        hasLock = false;
                        return arg0Value.getArrayType(arg1Value, getArrayTypeNode__ctx__);
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object getEnvType(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                NFIBackendImpl arg0Value = ((NFIBackendImpl) arg0Value_);
                int state_0 = state_0_;
                if ((state_0 & 0b100) != 0 /* is-state_0 getEnvType(NFIBackendImpl, NFIContext) */) {
                    {
                        ContextReference<NFIContext> nFILanguageImplContextReference__ = this.nFILanguageImplContextReference_;
                        NFIContext getEnvTypeNode__ctx__ = nFILanguageImplContextReference__.get();
                        return arg0Value.getEnvType(getEnvTypeNode__ctx__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getEnvTypeNode_AndSpecialize(arg0Value);
            }

            private Object getEnvTypeNode_AndSpecialize(NFIBackendImpl arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = state_0_;
                try {
                    {
                        NFIContext getEnvTypeNode__ctx__ = null;
                        ContextReference<NFIContext> nFILanguageImplContextReference__1 = this.nFILanguageImplContextReference_;
                        if (nFILanguageImplContextReference__1 == null) {
                            this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__1 = super.lookupContextReference(NFILanguageImpl.class);
                        }
                        getEnvTypeNode__ctx__ = nFILanguageImplContextReference__1.get();
                        this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 getEnvType(NFIBackendImpl, NFIContext) */;
                        lock.unlock();
                        hasLock = false;
                        return arg0Value.getEnvType(getEnvTypeNode__ctx__);
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object createSignatureBuilder(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                NFIBackendImpl arg0Value = ((NFIBackendImpl) arg0Value_);
                int state_0 = state_0_;
                if ((state_0 & 0b1000) != 0 /* is-state_0 createSignatureBuilder(NFIBackendImpl, NFIBackendLibrary, NFIContext, ArrayBuilderFactory) */) {
                    {
                        NFIBackendLibrary createSignatureBuilderNode__self__ = (this);
                        ContextReference<NFIContext> nFILanguageImplContextReference__ = this.nFILanguageImplContextReference_;
                        NFIContext createSignatureBuilderNode__ctx__ = nFILanguageImplContextReference__.get();
                        return arg0Value.createSignatureBuilder(createSignatureBuilderNode__self__, createSignatureBuilderNode__ctx__, this.createSignatureBuilderNode__builderFactory_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return createSignatureBuilderNode_AndSpecialize(arg0Value);
            }

            private Object createSignatureBuilderNode_AndSpecialize(NFIBackendImpl arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = state_0_;
                try {
                    {
                        NFIContext createSignatureBuilderNode__ctx__ = null;
                        NFIBackendLibrary createSignatureBuilderNode__self__ = null;
                        createSignatureBuilderNode__self__ = (this);
                        ContextReference<NFIContext> nFILanguageImplContextReference__1 = this.nFILanguageImplContextReference_;
                        if (nFILanguageImplContextReference__1 == null) {
                            this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__1 = super.lookupContextReference(NFILanguageImpl.class);
                        }
                        createSignatureBuilderNode__ctx__ = nFILanguageImplContextReference__1.get();
                        this.createSignatureBuilderNode__builderFactory_ = (ArrayBuilderFactory.create());
                        this.state_0_ = state_0 = state_0 | 0b1000 /* add-state_0 createSignatureBuilder(NFIBackendImpl, NFIBackendLibrary, NFIContext, ArrayBuilderFactory) */;
                        lock.unlock();
                        hasLock = false;
                        return arg0Value.createSignatureBuilder(createSignatureBuilderNode__self__, createSignatureBuilderNode__ctx__, this.createSignatureBuilderNode__builderFactory_);
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

        }
        @GeneratedBy(NFIBackendImpl.class)
        private static final class Uncached extends NFIBackendLibrary {

            private final ContextReference<NFIContext> nFILanguageImplContextReference_ = lookupContextReference(NFILanguageImpl.class);

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof NFIBackendImpl) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFIBackendImpl;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public Object getSimpleType(Object arg0Value_, NativeSimpleType arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFIBackendImpl arg0Value = ((NFIBackendImpl) arg0Value_);
                return arg0Value.getSimpleType(arg1Value, this.nFILanguageImplContextReference_.get());
            }

            @TruffleBoundary
            @Override
            public Object getArrayType(Object arg0Value_, NativeSimpleType arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFIBackendImpl arg0Value = ((NFIBackendImpl) arg0Value_);
                return arg0Value.getArrayType(arg1Value, this.nFILanguageImplContextReference_.get());
            }

            @TruffleBoundary
            @Override
            public Object getEnvType(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFIBackendImpl arg0Value = ((NFIBackendImpl) arg0Value_);
                return arg0Value.getEnvType(this.nFILanguageImplContextReference_.get());
            }

            @TruffleBoundary
            @Override
            public Object createSignatureBuilder(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFIBackendImpl arg0Value = ((NFIBackendImpl) arg0Value_);
                return arg0Value.createSignatureBuilder((this), this.nFILanguageImplContextReference_.get(), (ArrayBuilderFactory.getUncached()));
            }

        }
    }
}
