/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.nfi.impl.LibFFILibrary;
import com.oracle.truffle.nfi.impl.LibFFISignature;
import com.oracle.truffle.nfi.impl.NFIContext;
import com.oracle.truffle.nfi.impl.NFILanguageImpl;
import com.oracle.truffle.nfi.impl.NFIUnsatisfiedLinkError;
import com.oracle.truffle.nfi.spi.NFIBackend;
import com.oracle.truffle.nfi.spi.NFIBackendLibrary;
import com.oracle.truffle.nfi.spi.NFIBackendTools;
import com.oracle.truffle.nfi.spi.types.NativeLibraryDescriptor;
import com.oracle.truffle.nfi.spi.types.NativeSimpleType;
import com.oracle.truffle.nfi.util.ProfiledArrayBuilder;
import java.util.Iterator;

@ExportLibrary(value=NFIBackendLibrary.class)
final class NFIBackendImpl
implements NFIBackend {
    private final NFILanguageImpl language;
    final NFIBackendTools tools;

    NFIBackendImpl(NFILanguageImpl language, NFIBackendTools tools) {
        this.language = language;
        this.tools = tools;
    }

    @Override
    public CallTarget parse(NativeLibraryDescriptor descriptor) {
        RootNode root;
        NFIContext ctx = NFILanguageImpl.getCurrentContext();
        if (descriptor.isDefaultLibrary()) {
            root = new GetDefaultLibraryNode(this.language);
        } else {
            int flags = 0;
            boolean lazyOrNow = false;
            if (descriptor.getFlags() != null) {
                Iterator<String> iterator = descriptor.getFlags().iterator();
                while (iterator.hasNext()) {
                    String flag;
                    switch (flag = iterator.next()) {
                        case "RTLD_GLOBAL": {
                            flags |= ctx.RTLD_GLOBAL;
                            break;
                        }
                        case "RTLD_LOCAL": {
                            flags |= ctx.RTLD_LOCAL;
                            break;
                        }
                        case "RTLD_LAZY": {
                            flags |= ctx.RTLD_LAZY;
                            lazyOrNow = true;
                            break;
                        }
                        case "RTLD_NOW": {
                            flags |= ctx.RTLD_NOW;
                            lazyOrNow = true;
                            break;
                        }
                        case "ISOLATED_NAMESPACE": {
                            if (ctx.ISOLATED_NAMESPACE == 0) {
                                throw new IllegalArgumentException("isolated namespace not supported");
                            }
                            flags |= ctx.ISOLATED_NAMESPACE;
                        }
                    }
                }
            }
            if (!lazyOrNow) {
                flags |= ctx.RTLD_NOW;
            }
            root = new LoadLibraryNode(this.language, descriptor.getFilename(), flags);
        }
        return Truffle.getRuntime().createCallTarget(root);
    }

    @ExportMessage
    Object getSimpleType(NativeSimpleType type, @CachedContext(value=NFILanguageImpl.class) NFIContext ctx) {
        return ctx.lookupSimpleType(type);
    }

    @ExportMessage
    Object getArrayType(NativeSimpleType type, @CachedContext(value=NFILanguageImpl.class) NFIContext ctx) {
        return ctx.lookupArrayType(type);
    }

    @ExportMessage
    Object getEnvType(@CachedContext(value=NFILanguageImpl.class) NFIContext ctx) {
        return ctx.lookupEnvType();
    }

    @ExportMessage
    Object createSignatureBuilder(@CachedLibrary(value="this") NFIBackendLibrary self, @CachedContext(value=NFILanguageImpl.class) NFIContext ctx, @Cached ProfiledArrayBuilder.ArrayBuilderFactory builderFactory) {
        if (!ctx.env.isNativeAccessAllowed()) {
            CompilerDirectives.transferToInterpreter();
            throw new NFIUnsatisfiedLinkError("Access to native code is not allowed by the host environment.", (Node)self);
        }
        return new LibFFISignature.SignatureBuilder(builderFactory);
    }

    private static class GetDefaultLibraryNode
    extends RootNode {
        private final TruffleLanguage.ContextReference<NFIContext> ctxRef = this.lookupContextReference(NFILanguageImpl.class);

        GetDefaultLibraryNode(NFILanguageImpl language) {
            super((TruffleLanguage)language);
        }

        public boolean isInternal() {
            return true;
        }

        public Object execute(VirtualFrame frame) {
            if (!((NFIContext)this.ctxRef.get()).env.isNativeAccessAllowed()) {
                CompilerDirectives.transferToInterpreter();
                throw new NFIUnsatisfiedLinkError("Access to native code is not allowed by the host environment.", (Node)this);
            }
            return LibFFILibrary.createDefault();
        }
    }

    private static class LoadLibraryNode
    extends RootNode {
        private final String name;
        private final int flags;
        private final TruffleLanguage.ContextReference<NFIContext> ctxRef;

        LoadLibraryNode(NFILanguageImpl language, String name, int flags) {
            super((TruffleLanguage)language);
            this.name = name;
            this.flags = flags;
            this.ctxRef = this.lookupContextReference(NFILanguageImpl.class);
        }

        public boolean isInternal() {
            return true;
        }

        public Object execute(VirtualFrame frame) {
            if (!((NFIContext)this.ctxRef.get()).env.isNativeAccessAllowed()) {
                CompilerDirectives.transferToInterpreter();
                throw new NFIUnsatisfiedLinkError("Access to native code is not allowed by the host environment.", (Node)this);
            }
            return ((NFIContext)this.ctxRef.get()).loadLibrary(this.name, this.flags);
        }
    }
}

