/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.memory.ByteArraySupport;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import sun.misc.Unsafe;

abstract class NativeArgumentBuffer {
    final int[] patches;
    final Object[] objects;
    private int objIdx;

    int getPatchCount() {
        return this.objIdx;
    }

    protected NativeArgumentBuffer(int objCount) {
        if (objCount > 0) {
            this.patches = new int[objCount];
            this.objects = new Object[objCount];
        } else {
            this.patches = null;
            this.objects = null;
        }
        this.objIdx = 0;
    }

    public void align(int alignment) {
        assert (alignment >= 1);
        int pos = this.position();
        if (pos % alignment != 0) {
            pos += alignment - pos % alignment;
            this.position(pos);
        }
    }

    public abstract int position();

    public abstract void position(int var1);

    public abstract byte getInt8();

    public abstract void putInt8(byte var1);

    public abstract short getInt16();

    public abstract void putInt16(short var1);

    public abstract int getInt32();

    public abstract void putInt32(int var1);

    public abstract long getInt64();

    public abstract void putInt64(long var1);

    public abstract float getFloat();

    public abstract void putFloat(float var1);

    public abstract double getDouble();

    public abstract void putDouble(double var1);

    public long getPointer(int size) {
        switch (size) {
            case 4: {
                return this.getInt32();
            }
            case 8: {
                return this.getInt64();
            }
        }
        CompilerDirectives.transferToInterpreter();
        throw new AssertionError((Object)("unexpected pointer size " + size));
    }

    public void putPointer(long ptr, int size) {
        switch (size) {
            case 4: {
                this.putInt32((int)ptr);
                break;
            }
            case 8: {
                this.putInt64(ptr);
                break;
            }
            default: {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)("unexpected pointer size " + size));
            }
        }
    }

    public Object getObject(int size) {
        int pos = this.position();
        this.position(pos + size);
        throw CompilerDirectives.shouldNotReachHere((String)"passing TruffleObject from native back to Truffle not yet supported");
    }

    public void putObject(TypeTag tag, Object o, int size) {
        int pos = this.position();
        int idx = this.objIdx++;
        this.patches[idx] = tag.encode(pos);
        this.objects[idx] = o;
        this.position(pos + size);
    }

    public void putPointerKeepalive(Object o, long ptr, int size) {
        this.putObject(TypeTag.KEEPALIVE, o, 0);
        this.putPointer(ptr, size);
    }

    static final class Direct
    extends NativeArgumentBuffer {
        private static final Unsafe UNSAFE;
        private static final long BUFFER_ADDR_FIELD_OFFSET;
        private long buffer;
        private int position;
        private int size;

        Direct(ByteBuffer primBuffer, int objCount) {
            super(objCount);
            this.buffer = UNSAFE.getLong(primBuffer, BUFFER_ADDR_FIELD_OFFSET);
            this.position = primBuffer.position();
            this.size = primBuffer.limit();
        }

        @Override
        public int position() {
            return this.position;
        }

        @Override
        public void position(int newPosition) {
            this.position = newPosition;
        }

        private void checkBounds(int startIndex, int length) {
            if (length < 1 || startIndex < 0 || startIndex > this.size - length) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        @Override
        public byte getInt8() {
            this.checkBounds(this.position, 1);
            byte v = UNSAFE.getByte(this.buffer + (long)this.position);
            ++this.position;
            return v;
        }

        @Override
        public void putInt8(byte b) {
            this.checkBounds(this.position, 1);
            UNSAFE.putByte(this.buffer + (long)this.position, b);
            ++this.position;
        }

        @Override
        public short getInt16() {
            this.checkBounds(this.position, 2);
            short v = UNSAFE.getShort(this.buffer + (long)this.position);
            this.position += 2;
            return v;
        }

        @Override
        public void putInt16(short s) {
            this.checkBounds(this.position, 2);
            UNSAFE.putShort(this.buffer + (long)this.position, s);
            this.position += 2;
        }

        @Override
        public int getInt32() {
            this.checkBounds(this.position, 4);
            int v = UNSAFE.getInt(this.buffer + (long)this.position);
            this.position += 4;
            return v;
        }

        @Override
        public void putInt32(int i) {
            this.checkBounds(this.position, 4);
            UNSAFE.putInt(this.buffer + (long)this.position, i);
            this.position += 4;
        }

        @Override
        public long getInt64() {
            this.checkBounds(this.position, 8);
            long v = UNSAFE.getLong(this.buffer + (long)this.position);
            this.position += 8;
            return v;
        }

        @Override
        public void putInt64(long l) {
            this.checkBounds(this.position, 8);
            UNSAFE.putLong(this.buffer + (long)this.position, l);
            this.position += 8;
        }

        @Override
        public float getFloat() {
            this.checkBounds(this.position, 4);
            float v = UNSAFE.getFloat(this.buffer + (long)this.position);
            this.position += 4;
            return v;
        }

        @Override
        public void putFloat(float f) {
            this.checkBounds(this.position, 4);
            UNSAFE.putFloat(this.buffer + (long)this.position, f);
            this.position += 4;
        }

        @Override
        public double getDouble() {
            this.checkBounds(this.position, 8);
            double v = UNSAFE.getDouble(this.buffer + (long)this.position);
            this.position += 8;
            return v;
        }

        @Override
        public void putDouble(double d) {
            this.checkBounds(this.position, 8);
            UNSAFE.putDouble(this.buffer + (long)this.position, d);
            this.position += 8;
        }

        static {
            Field unsafeField;
            try {
                unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
                unsafeField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            try {
                UNSAFE = (Unsafe)unsafeField.get(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            try {
                Field bufferAddrField = Buffer.class.getDeclaredField("address");
                BUFFER_ADDR_FIELD_OFFSET = UNSAFE.objectFieldOffset(bufferAddrField);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class Array
    extends NativeArgumentBuffer {
        private static final ByteArraySupport byteArraySupport = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteArraySupport.bigEndian() : ByteArraySupport.littleEndian();
        final byte[] prim;
        private int position;

        Array(int primSize, int objCount) {
            super(objCount);
            this.prim = new byte[primSize];
            this.position = 0;
        }

        @Override
        public int position() {
            return this.position;
        }

        @Override
        public void position(int newPosition) {
            this.position = newPosition;
        }

        @Override
        public byte getInt8() {
            byte v = byteArraySupport.getByte(this.prim, this.position);
            ++this.position;
            return v;
        }

        @Override
        public void putInt8(byte b) {
            byteArraySupport.putByte(this.prim, this.position, b);
            ++this.position;
        }

        @Override
        public short getInt16() {
            short v = byteArraySupport.getShort(this.prim, this.position);
            this.position += 2;
            return v;
        }

        @Override
        public void putInt16(short s) {
            byteArraySupport.putShort(this.prim, this.position, s);
            this.position += 2;
        }

        @Override
        public int getInt32() {
            int v = byteArraySupport.getInt(this.prim, this.position);
            this.position += 4;
            return v;
        }

        @Override
        public void putInt32(int i) {
            byteArraySupport.putInt(this.prim, this.position, i);
            this.position += 4;
        }

        @Override
        public long getInt64() {
            long v = byteArraySupport.getLong(this.prim, this.position);
            this.position += 8;
            return v;
        }

        @Override
        public void putInt64(long l) {
            byteArraySupport.putLong(this.prim, this.position, l);
            this.position += 8;
        }

        @Override
        public float getFloat() {
            float v = byteArraySupport.getFloat(this.prim, this.position);
            this.position += 4;
            return v;
        }

        @Override
        public void putFloat(float f) {
            byteArraySupport.putFloat(this.prim, this.position, f);
            this.position += 4;
        }

        @Override
        public double getDouble() {
            double v = byteArraySupport.getDouble(this.prim, this.position);
            this.position += 8;
            return v;
        }

        @Override
        public void putDouble(double d) {
            byteArraySupport.putDouble(this.prim, this.position, d);
            this.position += 8;
        }
    }

    static final class TypeTag
    extends Enum<TypeTag> {
        public static final /* enum */ TypeTag OBJECT = new TypeTag();
        public static final /* enum */ TypeTag STRING = new TypeTag();
        public static final /* enum */ TypeTag KEEPALIVE = new TypeTag();
        public static final /* enum */ TypeTag ENV = new TypeTag();
        public static final /* enum */ TypeTag BOOLEAN_ARRAY = new TypeTag();
        public static final /* enum */ TypeTag BYTE_ARRAY = new TypeTag();
        public static final /* enum */ TypeTag CHAR_ARRAY = new TypeTag();
        public static final /* enum */ TypeTag SHORT_ARRAY = new TypeTag();
        public static final /* enum */ TypeTag INT_ARRAY = new TypeTag();
        public static final /* enum */ TypeTag LONG_ARRAY = new TypeTag();
        public static final /* enum */ TypeTag FLOAT_ARRAY = new TypeTag();
        public static final /* enum */ TypeTag DOUBLE_ARRAY = new TypeTag();
        private static final TypeTag[] VALUES;
        private static final /* synthetic */ TypeTag[] $VALUES;

        public static TypeTag[] values() {
            return (TypeTag[])$VALUES.clone();
        }

        public static TypeTag valueOf(String name) {
            return Enum.valueOf(TypeTag.class, name);
        }

        int encode(int offset) {
            int encoded = offset << 4 | this.ordinal() & 0xF;
            assert (TypeTag.getTag(encoded) == this && TypeTag.getOffset(encoded) == offset) : "error encoding type tag, maybe offset is too big?";
            return encoded;
        }

        static TypeTag getTag(int encoded) {
            return VALUES[encoded & 0xF];
        }

        static int getOffset(int encoded) {
            return encoded >>> 4;
        }

        static {
            $VALUES = new TypeTag[]{OBJECT, STRING, KEEPALIVE, ENV, BOOLEAN_ARRAY, BYTE_ARRAY, CHAR_ARRAY, SHORT_ARRAY, INT_ARRAY, LONG_ARRAY, FLOAT_ARRAY, DOUBLE_ARRAY};
            VALUES = TypeTag.values();
        }
    }
}

