/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.nfi.ConvertTypeNode;
import com.oracle.truffle.nfi.NFIPointer;
import com.oracle.truffle.nfi.NFIType;
import com.oracle.truffle.nfi.SignatureTypeCachedStateFactory;
import com.oracle.truffle.nfi.api.SignatureLibrary;

final class SignatureTypeCachedState {
    static final NFIType.TypeCachedState INSTANCE = new NFIType.TypeCachedState(1, SignatureTypeCachedStateFactory.ClosureToNativeFactory.getInstance(), SignatureTypeCachedStateFactory.FunctionPtrFromNativeFactory.getInstance());

    SignatureTypeCachedState() {
    }

    @GenerateUncached
    @GenerateNodeFactory
    @GenerateInline(value=false)
    static abstract class FunctionPtrFromNative
    extends ConvertTypeNode {
        FunctionPtrFromNative() {
        }

        @Specialization(guards={"nullValue == 0"})
        static Object doNull(NFIType type, long nullValue) {
            return NFIPointer.nullPtr();
        }

        @Specialization(guards={"nullValue == null"})
        static Object doNull(NFIType type, Object nullValue) {
            return NFIPointer.nullPtr();
        }

        @Specialization(limit="3", guards={"interop.isNull(nullValue)"})
        @GenerateAOT.Exclude
        static Object doNull(NFIType type, Object nullValue, @CachedLibrary(value="nullValue") InteropLibrary interop) {
            return nullValue;
        }

        @Specialization(limit="3", guards={"ptr != 0"})
        @GenerateAOT.Exclude
        static Object doBind(NFIType type, long ptr, @CachedLibrary(value="type.runtimeData") SignatureLibrary library) {
            return library.bind(type.runtimeData, NFIPointer.create(ptr));
        }

        @Specialization(limit="3", guards={"!interop.isNull(value)"})
        @GenerateAOT.Exclude
        static Object doBind(NFIType type, Object value, @CachedLibrary(value="value") InteropLibrary interop, @CachedLibrary(value="type.runtimeData") SignatureLibrary library) {
            return library.bind(type.runtimeData, value);
        }
    }

    @GenerateUncached
    @GenerateNodeFactory
    @GenerateInline(value=false)
    static abstract class ClosureToNative
    extends ConvertTypeNode {
        ClosureToNative() {
        }

        @Specialization(limit="3", guards={"interop.isExecutable(value)"})
        @GenerateAOT.Exclude
        static Object convertToNative(NFIType type, Object value, @CachedLibrary(value="value") InteropLibrary interop, @CachedLibrary(value="type.runtimeData") SignatureLibrary library) {
            return library.createClosure(type.runtimeData, value);
        }

        @Fallback
        static Object convertToNative(NFIType type, Object value) {
            return value;
        }
    }
}

